/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.layout.elements;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;
import org.eclipse.epf.common.utils.StrUtil;
import org.eclipse.epf.common.utils.Timer;
import org.eclipse.epf.diagram.model.util.DiagramInfo;
import org.eclipse.epf.library.LibraryPlugin;
import org.eclipse.epf.library.LibraryResources;
import org.eclipse.epf.library.configuration.ConfigurationHelper;
import org.eclipse.epf.library.edit.IFilter;
import org.eclipse.epf.library.edit.process.IBSItemProvider;
import org.eclipse.epf.library.edit.util.ConfigurableComposedAdapterFactory;
import org.eclipse.epf.library.edit.util.PredecessorList;
import org.eclipse.epf.library.edit.util.ProcessUtil;
import org.eclipse.epf.library.edit.util.Suppression;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.library.layout.ElementLayoutManager;
import org.eclipse.epf.library.layout.IElementLayout;
import org.eclipse.epf.library.layout.LayoutInfo;
import org.eclipse.epf.library.layout.diagram.IActivityDiagramService;
import org.eclipse.epf.library.layout.elements.AbstractElementLayout;
import org.eclipse.epf.library.layout.elements.AbstractProcessElementLayout;
import org.eclipse.epf.library.layout.elements.ActivityLayoutData;
import org.eclipse.epf.library.layout.elements.GeneralLayout;
import org.eclipse.epf.library.layout.elements.ProcessElementItem;
import org.eclipse.epf.library.layout.elements.ProcessLayoutData;
import org.eclipse.epf.library.layout.util.XmlElement;
import org.eclipse.epf.library.prefs.BSColumn;
import org.eclipse.epf.library.prefs.PreferenceUtil;
import org.eclipse.epf.library.util.LibraryUtil;
import org.eclipse.epf.library.util.ResourceHelper;
import org.eclipse.epf.uma.Activity;
import org.eclipse.epf.uma.BreakdownElement;
import org.eclipse.epf.uma.CompositeRole;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.Process;
import org.eclipse.epf.uma.Role;
import org.eclipse.epf.uma.RoleDescriptor;
import org.eclipse.epf.uma.SupportingMaterial;
import org.eclipse.epf.uma.Task;
import org.eclipse.epf.uma.TaskDescriptor;
import org.eclipse.epf.uma.TeamProfile;
import org.eclipse.epf.uma.UmaPackage;
import org.eclipse.epf.uma.WorkBreakdownElement;
import org.eclipse.epf.uma.WorkProductDescriptor;
import org.eclipse.epf.uma.util.AssociationHelper;

public class ActivityLayout
extends AbstractProcessElementLayout {
    DiagramInfo userDiagramInfo = null;
    boolean debug = LibraryPlugin.getDefault().isDebugging();
    private TBSItemDetail itemDetail = new TBSItemDetail();
    private static final int ACTIVITY_SHOW_LEVEL = 1;
    private static int supCount = 0;
    static /* synthetic */ Class class$0;

    public void init(ElementLayoutManager layoutManager, MethodElement element) {
        super.__init(layoutManager, element);
        this.userDiagramInfo = new DiagramInfo((Activity)element);
        String file = String.valueOf(StrUtil.makeValidFileName((String)this.element.getName())) + this.element.getGuid();
        file = file.replace('\'', ' ').replace('\"', ' ');
        this.setLayoutInfo(new LayoutInfo("Description", "activity.xsl", String.valueOf(file) + "_desc" + ".html", true));
        this.setLayoutInfo(new LayoutInfo("WPBS", "activity_wpbs.xsl", String.valueOf(file) + "_wpbs" + ".html", false));
        this.setLayoutInfo(new LayoutInfo("TBS", "activity_tbs.xsl", String.valueOf(file) + "_tbs" + ".html", false));
        this.setLayoutInfo(new LayoutInfo("WBS", "activity_wbs.xsl", String.valueOf(file) + "_wbs" + ".html", false));
    }

    protected Suppression getSuppression(Process proc) {
        return this.layoutManager.getSuppression(proc);
    }

    protected boolean acceptFeatureValue(EStructuralFeature feature, Object value) {
        if (value instanceof SupportingMaterial) {
            return !this.userDiagramInfo.isDiagram((SupportingMaterial)value);
        }
        if (value instanceof List) {
            List items = (List)value;
            int i = 0;
            while (i < items.size()) {
                Object o = items.get(i);
                if (o instanceof SupportingMaterial && this.userDiagramInfo.isDiagram((SupportingMaterial)o)) {
                    items.remove(i);
                    continue;
                }
                ++i;
            }
        }
        return true;
    }

    public XmlElement getXmlElement(boolean includeReferences) {
        Class<?> clazz;
        String msg;
        Timer t = null;
        if (this.debug) {
            t = new Timer();
            msg = "Generating layout xml for " + LibraryUtil.getTypeName(this.element) + ", includeReferences = " + includeReferences;
            System.out.println(msg);
        }
        XmlElement elementXml = super.getXmlElement();
        this.loadAttributes(elementXml);
        Process proc = this.getOwningProcess();
        Suppression sup = this.getSuppression(proc);
        ConfigurableComposedAdapterFactory adapterFactory = this.layoutManager.getCBSAdapterFactory();
        Object wrapper = sup.getObjectByPath(this.paths, (AdapterFactory)adapterFactory);
        if (wrapper == null) {
            wrapper = this.element;
        }
        if ((clazz = class$0) == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.emf.edit.provider.ITreeItemContentProvider");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        IBSItemProvider adapter = (IBSItemProvider)adapterFactory.adapt(wrapper, (Object)clazz);
        String displayName = ProcessUtil.getAttribute((Object)this.element, (String)"presentation_name", (Object)adapter);
        elementXml.setAttribute("DisplayName", displayName);
        if (!includeReferences) {
            return elementXml;
        }
        XmlElement tabsXml = elementXml.newChild("tabs");
        Iterator it = this.layouts.iterator();
        while (it.hasNext()) {
            LayoutInfo info = (LayoutInfo)it.next();
            tabsXml.newChild("tab").setAttribute("name", info.name).setAttribute("url", String.valueOf(this.elementPath) + info.fileName);
        }
        if (!this.getLayoutMgr().isPublishingMode() || this.element instanceof Process) {
            this.getLayoutMgr().prepareAdaptorFactoriesForProcess(proc);
        }
        this.loadCopyright(elementXml);
        List properties = this.element.getInstanceProperties();
        if (properties != null) {
            int i = 0;
            while (i < properties.size()) {
                EClassifier type;
                EStructuralFeature feature = (EStructuralFeature)properties.get(i);
                if (feature != UmaPackage.eINSTANCE.getActivity_BreakdownElements() && (type = feature.getEType()) instanceof EClass) {
                    this.loadFeature(feature, elementXml, false);
                }
                ++i;
            }
        }
        if (this.debug) {
            t.stop();
            msg = String.valueOf(t.getTime()) + " mini seconds building Activity Descriotion xml for " + LibraryUtil.getTypeName(this.element);
            System.out.println(msg);
            t.start();
        }
        this.buildWBS(elementXml, sup);
        if (this.debug) {
            t.stop();
            msg = String.valueOf(t.getTime()) + " mini seconds building WBS for " + LibraryUtil.getTypeName(this.element);
            System.out.println(msg);
            t.start();
        }
        this.buildTBS(elementXml, sup);
        if (this.debug) {
            t.stop();
            msg = String.valueOf(t.getTime()) + " mini seconds building TBS for " + LibraryUtil.getTypeName(this.element);
            System.out.println(msg);
            t.start();
        }
        this.buildWPBS(elementXml, sup);
        if (this.debug) {
            t.stop();
            msg = String.valueOf(t.getTime()) + " mini seconds building WPBS for " + LibraryUtil.getTypeName(this.element);
            System.out.println(msg);
            msg = String.valueOf(t.getTotalTime()) + " mini seconds building layout xml for " + LibraryUtil.getTypeName(this.element);
            System.out.println(msg);
        }
        return elementXml;
    }

    private String getUserDiagramText(SupportingMaterial userDiagram) {
        GeneralLayout l = new GeneralLayout();
        ((AbstractElementLayout)l).init(this.getLayoutMgr(), (MethodElement)userDiagram.getPresentation());
        l.setContentTarget(this.element);
        EAttribute feature = UmaPackage.eINSTANCE.getContentDescription_MainDescription();
        return (String)l.getAttributeFeatureValue((EStructuralFeature)feature);
    }

    private void setColumns(XmlElement parentXml, List cols) {
        XmlElement colsXml = parentXml.newChild("columns");
        Iterator it = cols.iterator();
        while (it.hasNext()) {
            BSColumn col = (BSColumn)it.next();
            colsXml.newChild("column").setAttribute("id", col.id).setAttribute("label", col.label);
        }
    }

    private void buildWBS(XmlElement elementXml, Suppression sup) {
        String imgFile;
        XmlElement bs = elementXml.newChild("breakdown").setAttribute("name", "Work Breakdown Structure").setAttribute("DisplayName", this.getDisplayName());
        this.setColumns(bs, PreferenceUtil.getWBSColumns());
        ConfigurableComposedAdapterFactory adapterFactory = this.layoutManager.getCBSAdapterFactory();
        CompositeRoles crs = null;
        ProcessUtil.updateIDs((AdapterFactory)adapterFactory, (Process)sup.getProcess());
        ActivityLayoutSetting setting = new ActivityLayoutSetting((ComposedAdapterFactory)adapterFactory, crs, sup);
        setting.escapeString = true;
        setting.showTaskOnly = true;
        Object wrapper = sup.getObjectByPath(this.paths, (AdapterFactory)adapterFactory);
        if (wrapper == null) {
            wrapper = this.element;
        }
        if (sup.isSuppressed(wrapper)) {
            return;
        }
        ProcessElementItem elementItem = new ProcessElementItem(wrapper, this.element, this.elementProcessPath);
        this.iterate(elementItem, bs, setting);
        XmlElement diagrams = elementXml.newChild("diagrams");
        String diagramType = "Activity";
        SupportingMaterial userDiagram = this.userDiagramInfo.getActivityDiagram();
        if (this.userDiagramInfo.canPublishADImage() && userDiagram != null) {
            diagrams.newChild("userdiagram").setAttribute("name", diagramType).setValue(this.getUserDiagramText(userDiagram));
        } else {
            imgFile = ResourceHelper.getDiagramFilePathName(this.element, diagramType);
            org.eclipse.epf.library.layout.diagram.DiagramInfo diagram_workflow = this.generateDiagram(sup, diagramType, imgFile);
            if (diagram_workflow != null && diagram_workflow.getImageFileName() != null) {
                diagrams.newChild("diagram").setAttribute("name", "Activity").addChild(diagram_workflow.getXmlElement());
            }
        }
        diagramType = "ActivityDetail";
        userDiagram = this.userDiagramInfo.getActivityDetailDiagram();
        if (this.userDiagramInfo.canPublishADDImage() && userDiagram != null) {
            diagrams.newChild("userdiagram").setAttribute("name", diagramType).setValue(this.getUserDiagramText(userDiagram));
        } else {
            imgFile = ResourceHelper.getDiagramFilePathName(this.element, diagramType);
            org.eclipse.epf.library.layout.diagram.DiagramInfo diagram_detail = this.generateDiagram(sup, diagramType, imgFile);
            if (diagram_detail != null && diagram_detail.getImageFileName() != null) {
                diagrams.newChild("diagram").setAttribute("name", "ActivityDetail").addChild(diagram_detail.getXmlElement());
            }
        }
        diagramType = "WPDependency";
        userDiagram = this.userDiagramInfo.getActivityDetailDiagram();
        if (this.userDiagramInfo.canPublishWPDImage() && userDiagram != null) {
            diagrams.newChild("userdiagram").setAttribute("name", diagramType).setValue(this.getUserDiagramText(userDiagram));
        } else {
            imgFile = ResourceHelper.getDiagramFilePathName(this.element, diagramType);
            org.eclipse.epf.library.layout.diagram.DiagramInfo diagram_wp = this.generateDiagram(sup, diagramType, imgFile);
            if (diagram_wp != null && diagram_wp.getImageFileName() != null) {
                diagrams.newChild("diagram").setAttribute("name", "WPDependency").addChild(diagram_wp.getXmlElement());
            }
        }
    }

    private org.eclipse.epf.library.layout.diagram.DiagramInfo generateDiagram(Suppression sup, String diagramType, String imgFile) {
        Timer timer = null;
        if (this.debug) {
            timer = new Timer();
        }
        IActivityDiagramService diagramService = this.layoutManager.getActivityDiagramService();
        org.eclipse.epf.library.layout.diagram.DiagramInfo diagram = null;
        if (diagramService != null) {
            IFilter filter = this.layoutManager.getDiagramAdapterFactory().getFilter();
            Object wrapper = sup.getObjectByPath(this.paths, (AdapterFactory)this.layoutManager.getDiagramAdapterFactory());
            diagram = diagramService.saveDiagram(wrapper, imgFile, diagramType, filter, sup);
        }
        if (timer != null) {
            timer.stop();
            String msg = String.valueOf(timer.getTime()) + " mini seconds generating " + diagramType + " diagram";
            System.out.println(msg);
        }
        return diagram;
    }

    private void buildTBS(XmlElement elementXml, Suppression sup) {
        XmlElement bs = elementXml.newChild("breakdown").setAttribute("name", "Team Breakdown Structure").setAttribute("DisplayName", this.getDisplayName());
        this.setColumns(bs, PreferenceUtil.getTBSColumns());
        ConfigurableComposedAdapterFactory adapterFactory = this.layoutManager.getTBSAdapterFactory();
        CompositeRoles crs = null;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.emf.edit.provider.ITreeItemContentProvider");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        IBSItemProvider provider = (IBSItemProvider)adapterFactory.adapt((Notifier)this.element, (Object)clazz);
        Object wrapper = sup.getObjectByPath(this.paths, (AdapterFactory)adapterFactory);
        if (wrapper == null) {
            wrapper = this.element;
        }
        ProcessElementItem elementItem = new ProcessElementItem(wrapper, this.element, this.elementProcessPath);
        provider.setRolledUp(false);
        this.itemDetail.iterate((ComposedAdapterFactory)adapterFactory, wrapper);
        provider.setRolledUp(true);
        ActivityLayoutSetting setting = new ActivityLayoutSetting((ComposedAdapterFactory)adapterFactory, crs, sup);
        setting.rollupRoles = true;
        this.iterate(elementItem, bs, setting);
    }

    private void buildWPBS(XmlElement elementXml, Suppression sup) {
        XmlElement bs = elementXml.newChild("breakdown").setAttribute("name", "Work Product Breakdown Structure").setAttribute("DisplayName", this.getDisplayName());
        this.setColumns(bs, PreferenceUtil.getWPBSColumns());
        ConfigurableComposedAdapterFactory adapterFactory = this.layoutManager.getWPBSAdapterFactory();
        CompositeRoles crs = null;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.emf.edit.provider.ITreeItemContentProvider");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        IBSItemProvider provider = (IBSItemProvider)adapterFactory.adapt((Notifier)this.element, (Object)clazz);
        provider.setRolledUp(true);
        ActivityLayoutSetting setting = new ActivityLayoutSetting((ComposedAdapterFactory)adapterFactory, crs, sup);
        Object wrapper = sup.getObjectByPath(this.paths, (AdapterFactory)adapterFactory);
        if (wrapper == null) {
            wrapper = this.element;
        }
        ProcessElementItem elementItem = new ProcessElementItem(wrapper, this.element, this.elementProcessPath);
        this.iterate(elementItem, bs, setting);
    }

    private void iterate(ProcessElementItem parentItem, XmlElement parentXml, ActivityLayoutSetting setting) {
        this.iterate(parentItem, parentXml, setting, 0);
    }

    private void iterate(ProcessElementItem parentItem, XmlElement parentXml, ActivityLayoutSetting setting, int actLevel) {
        ITreeItemContentProvider provider = null;
        Object parentObj = parentItem.rawItem;
        Timer timer = null;
        if (this.debug) {
            timer = new Timer();
        }
        if (parentObj instanceof ITreeItemContentProvider) {
            provider = (ITreeItemContentProvider)parentObj;
        } else {
            ComposedAdapterFactory composedAdapterFactory = setting.adapterFactory;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.emf.edit.provider.ITreeItemContentProvider");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            provider = (ITreeItemContentProvider)composedAdapterFactory.adapt(parentObj, (Object)clazz);
        }
        if (provider != null) {
            Collection items = provider.getChildren(parentObj);
            Iterator it = items.iterator();
            while (it.hasNext()) {
                CompositeRole cr;
                Object rawitem = it.next();
                MethodElement item = (MethodElement)LibraryUtil.unwrap(rawitem);
                if (setting.showTaskOnly && actLevel > 1 && !(item instanceof Activity) && !(item instanceof TaskDescriptor) || item == null) continue;
                this.getLayoutMgr().getValidator().addReferencedElement(this.element, item);
                ProcessElementItem elementItem = new ProcessElementItem(rawitem, item, parentItem);
                if (parentObj instanceof Activity && setting.crs != null && item instanceof RoleDescriptor && (cr = setting.crs.getCompositeRole((Activity)parentObj, (RoleDescriptor)item)) != null) {
                    item = cr;
                }
                XmlElement child = this.generateChildXml(elementItem, parentXml, setting);
                parentXml.addChild(child);
                if (setting.showTaskOnly && actLevel > 1 && !(item instanceof Activity)) continue;
                this.iterate(elementItem, child, setting, item instanceof Activity ? actLevel + 1 : actLevel);
            }
        }
        if (timer != null) {
            timer.stop();
            if (timer.getTime() > 100) {
                String msg = String.valueOf(timer.getTime()) + " mini seconds iterating breakdown item " + LibraryUtil.getTypeName(parentItem.element);
                System.out.println(msg);
            }
        }
    }

    private XmlElement generateChildXml(ProcessElementItem elementItem, XmlElement parentXml, ActivityLayoutSetting setting) {
        Timer timer = null;
        if (this.debug) {
            timer = new Timer();
        }
        MethodElement item = elementItem.element;
        IElementLayout l = this.getLayout(elementItem);
        boolean isSupressed = setting.sup.isSuppressed(elementItem.rawItem);
        if (isSupressed) {
            this.itemDetail.addSuppressed(elementItem.element);
        }
        XmlElement child = l.getXmlElement(false);
        if (!this.getLayoutMgr().isPublishingMode()) {
            child.setAttribute("isSupressed", isSupressed ? "true" : "false");
        }
        IBSItemProvider adapter = null;
        if (elementItem.rawItem instanceof IBSItemProvider) {
            adapter = (IBSItemProvider)elementItem.rawItem;
        } else {
            ComposedAdapterFactory composedAdapterFactory = setting.adapterFactory;
            MethodElement methodElement = elementItem.element;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.emf.edit.provider.ITreeItemContentProvider");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            adapter = (IBSItemProvider)composedAdapterFactory.adapt((Notifier)methodElement, (Object)clazz);
        }
        if (elementItem.element instanceof BreakdownElement) {
            String index = this.getIndex(adapter);
            String modelInfo = ProcessUtil.getAttribute((Object)item, (String)"model_info", (Object)adapter);
            String team = ProcessUtil.getAttribute((Object)item, (String)"teams", (Object)adapter);
            String prefix = ProcessUtil.getAttribute((Object)item, (String)"prefix", (Object)adapter);
            String isEventDriven = ProcessUtil.getAttribute((Object)item, (String)"is_event_driven", (Object)adapter);
            String isOngoing = ProcessUtil.getAttribute((Object)item, (String)"is_ongoing", (Object)adapter);
            String isOptional = ProcessUtil.getAttribute((Object)item, (String)"is_optional", (Object)adapter);
            String isPlanned = ProcessUtil.getAttribute((Object)item, (String)"is_planned", (Object)adapter);
            String isRepeatable = ProcessUtil.getAttribute((Object)item, (String)"is_repeatable", (Object)adapter);
            String hasMultipleOccurrences = ProcessUtil.getAttribute((Object)item, (String)"has_multiple_occurrences", (Object)adapter);
            String displayName = ProcessUtil.getAttribute((Object)item, (String)"presentation_name", (Object)adapter);
            if (setting.escapeString) {
                modelInfo = StrUtil.escape((String)modelInfo);
                displayName = StrUtil.escape((String)displayName);
                String jsEscapedUrl = StrUtil.escape((String)l.getUrl());
                child.setAttribute("Url", jsEscapedUrl);
            }
            child.setAttribute("Index", index).setAttribute("ModelInfo", modelInfo).setAttribute("Team", team);
            child.newChild("attribute").setAttribute("name", "prefix").setValue(prefix);
            child.newChild("attribute").setAttribute("name", "isEventDriven").setValue(isEventDriven);
            child.newChild("attribute").setAttribute("name", "isOngoing").setValue(isOngoing);
            child.newChild("attribute").setAttribute("name", "isOptional").setValue(isOptional);
            child.newChild("attribute").setAttribute("name", "isPlanned").setValue(isPlanned);
            child.newChild("attribute").setAttribute("name", "isRepeatable").setValue(isRepeatable);
            child.newChild("attribute").setAttribute("name", "hasMultipleOccurrences").setValue(hasMultipleOccurrences);
            child.setAttribute("DisplayName", displayName);
        }
        if (item instanceof WorkProductDescriptor) {
            String entryState = adapter.getAttribute((Object)item, "entry_state");
            String exitState = adapter.getAttribute((Object)item, "exit_state");
            String deliverable = adapter.getAttribute((Object)item, "deliverable");
            child.setAttribute("EntryState", entryState).setAttribute("ExitState", exitState).setAttribute("Deliverable", deliverable);
        }
        if (item instanceof WorkBreakdownElement) {
            String predecessors = this.getPredecessors(adapter, setting.sup);
            child.setAttribute("Predecessors", predecessors);
        }
        if (item instanceof TaskDescriptor) {
            XmlElement stepsXml = child.newChild("Steps");
            TaskDescriptor td = (TaskDescriptor)item;
            List selSteps = td.getSelectedSteps();
            Task t = (Task)ConfigurationHelper.getCalculatedElement((MethodElement)td.getTask(), this.getLayoutMgr().getConfiguration());
            if (t != null) {
                List steps = ConfigurationHelper.calc0nFeatureValue((MethodElement)t, (EStructuralFeature)UmaPackage.eINSTANCE.getTask_Steps(), this.getLayoutMgr().getElementRealizer());
                int i = 0;
                while (i < steps.size()) {
                    Object step = steps.get(i);
                    boolean selected = selSteps.contains(step);
                    stepsXml.newChild("Step").setAttribute("index", Integer.toString(i)).setAttribute("selected", selected ? "true" : "false");
                    ++i;
                }
            }
        }
        if (item instanceof TeamProfile) {
            TeamProfile superTeam = ((TeamProfile)item).getSuperTeam();
            child.setAttribute("hasSuperTeam", superTeam != null ? "true" : "false");
        }
        if (setting.rollupRoles && item instanceof RoleDescriptor) {
            this.buildRoleRollup((RoleDescriptor)item, child, setting);
        }
        if (timer != null) {
            timer.stop();
            if (timer.getTime() > 100) {
                String msg = String.valueOf(timer.getTime()) + " mini seconds generating xml for breakdown item " + LibraryUtil.getTypeName(elementItem.element);
                System.out.println(msg);
            }
        }
        return child;
    }

    private void buildRoleRollup(RoleDescriptor roleItem, XmlElement parentXml, ActivityLayoutSetting setting) {
        Role r = roleItem.getRole();
        ArrayList<RoleDescriptor> descriptors = this.itemDetail.getDescriptors(r);
        if (descriptors == null) {
            descriptors = new ArrayList<RoleDescriptor>();
        }
        if (!descriptors.contains(roleItem)) {
            descriptors.add(roleItem);
        }
        ArrayList responsibleFor = new ArrayList();
        ArrayList modifies = new ArrayList();
        ArrayList primaryTasks = new ArrayList();
        ArrayList additionalTasks = new ArrayList();
        Iterator it = descriptors.iterator();
        while (it.hasNext()) {
            roleItem = (RoleDescriptor)it.next();
            List items = ConfigurationHelper.calc0nFeatureValue((MethodElement)roleItem, (EStructuralFeature)UmaPackage.eINSTANCE.getRoleDescriptor_ResponsibleFor(), this.getLayoutMgr().getElementRealizer());
            responsibleFor.addAll(items);
            items = ConfigurationHelper.calc0nFeatureValue((MethodElement)roleItem, (EStructuralFeature)UmaPackage.eINSTANCE.getRoleDescriptor_Modifies(), this.getLayoutMgr().getElementRealizer());
            modifies.addAll(items);
            items = ConfigurationHelper.calc0nFeatureValue((MethodElement)roleItem, AssociationHelper.RoleDescriptor_PrimaryTaskDescriptors, this.getLayoutMgr().getElementRealizer());
            primaryTasks.addAll(items);
            items = ConfigurationHelper.calc0nFeatureValue((MethodElement)roleItem, AssociationHelper.RoleDescriptor_AdditionalTaskDescriptors, this.getLayoutMgr().getElementRealizer());
            additionalTasks.addAll(items);
        }
        this.createRoleRollupNodes(parentXml, responsibleFor, TngUtil.getFeatureText((EStructuralFeature)UmaPackage.eINSTANCE.getRoleDescriptor_ResponsibleFor()));
        this.createRoleRollupNodes(parentXml, modifies, TngUtil.getFeatureText((EStructuralFeature)UmaPackage.eINSTANCE.getRoleDescriptor_Modifies()));
        this.createRoleRollupNodes(parentXml, primaryTasks, LibraryResources.ActivityLayout_primaryTasks_text);
        this.createRoleRollupNodes(parentXml, additionalTasks, LibraryResources.ActivityLayout_additionalTasks_text);
    }

    private void createRoleRollupNodes(XmlElement parentXml, List items, String info) {
        ArrayList<MethodElement> processed = new ArrayList<MethodElement>();
        Iterator it = items.iterator();
        while (it.hasNext()) {
            MethodElement e = (MethodElement)it.next();
            if (processed.contains(e)) continue;
            processed.add(e);
            IElementLayout l = this.layoutManager.getLayout(e, true);
            XmlElement child = l.getXmlElement(false);
            child.setAttribute("ModelInfo", info);
            parentXml.addChild(child);
        }
    }

    private String getIndex(IBSItemProvider adapter) {
        if (adapter != null) {
            int index = adapter.getId();
            if (index == 0) {
                return "";
            }
            return Integer.toString(index);
        }
        return "";
    }

    private String getPredecessors(IBSItemProvider adapter, Suppression sup) {
        PredecessorList list;
        if (adapter != null && (list = adapter.getPredecessors()) != null) {
            return list.toUnSuppressedString(sup);
        }
        return "";
    }

    public void loadLayoutData(ProcessLayoutData proc_data) {
        Timer t = new Timer();
        ActivityLayoutData act_data = proc_data.createActivityLauoutData(this.elementProcessPath);
        Process proc = this.getOwningProcess();
        if (proc == this.element) {
            supCount = 0;
        }
        Suppression sup = this.getSuppression(proc);
        this.loadWBSLayoutData(act_data, sup);
        this.loadTBSLayoutData(act_data, sup);
        this.loadWPBSLayoutData(act_data, sup);
        if (this.debug) {
            t.stop();
            String msg = String.valueOf(t.getTime()) + " mini-second(s) loading layout data for process " + LibraryUtil.getTypeName((MethodElement)proc) + ", activity: " + LibraryUtil.getTypeName(this.element);
            System.out.println(msg);
        }
    }

    private void loadWBSLayoutData(ActivityLayoutData act_data, Suppression sup) {
        org.eclipse.epf.library.layout.diagram.DiagramInfo diagram_wp;
        org.eclipse.epf.library.layout.diagram.DiagramInfo diagram_detail;
        ConfigurableComposedAdapterFactory adapterFactory = this.layoutManager.getCBSAdapterFactory();
        CompositeRoles crs = null;
        ActivityLayoutSetting setting = new ActivityLayoutSetting((ComposedAdapterFactory)adapterFactory, crs, sup);
        Object wrapper = sup.getObjectByPath(this.paths, (AdapterFactory)adapterFactory);
        if (wrapper == null) {
            wrapper = this.element;
        }
        ProcessElementItem elementItem = new ProcessElementItem(wrapper, this.element, this.elementProcessPath);
        this.iterateProcessItem(elementItem, act_data, setting);
        if (!act_data.hasLocalSuppressed()) {
            return;
        }
        String diagramType = "Activity";
        String prefix = Integer.toHexString(this.elementProcessPath.hashCode());
        String imgFile = ResourceHelper.getDiagramFilePathName(this.element, String.valueOf(prefix) + "_" + diagramType);
        org.eclipse.epf.library.layout.diagram.DiagramInfo diagram_workflow = this.generateDiagram(sup, diagramType, imgFile);
        if (diagram_workflow != null && diagram_workflow.getImageFileName() != null) {
            act_data.setActivityDiagramPath(diagram_workflow.getImageFileName());
        }
        if ((diagram_detail = this.generateDiagram(sup, diagramType = "ActivityDetail", imgFile = ResourceHelper.getDiagramFilePathName(this.element, String.valueOf(prefix) + "_" + diagramType))) != null && diagram_detail.getImageFileName() != null) {
            act_data.setActivityDetailDiagramPath(diagram_detail.getImageFileName());
        }
        if ((diagram_wp = this.generateDiagram(sup, diagramType = "WPDependency", imgFile = ResourceHelper.getDiagramFilePathName(this.element, String.valueOf(prefix) + "_" + diagramType))) != null && diagram_wp.getImageFileName() != null) {
            act_data.setWPDependencyDiagramPath(diagram_wp.getImageFileName());
        }
    }

    private void loadTBSLayoutData(ActivityLayoutData act_data, Suppression sup) {
        ConfigurableComposedAdapterFactory adapterFactory = this.layoutManager.getTBSAdapterFactory();
        CompositeRoles crs = null;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.emf.edit.provider.ITreeItemContentProvider");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        IBSItemProvider provider = (IBSItemProvider)adapterFactory.adapt((Notifier)this.element, (Object)clazz);
        provider.setRolledUp(true);
        ActivityLayoutSetting setting = new ActivityLayoutSetting((ComposedAdapterFactory)adapterFactory, crs, sup);
        setting.rollupRoles = true;
        Object wrapper = sup.getObjectByPath(this.paths, (AdapterFactory)adapterFactory);
        if (wrapper == null) {
            wrapper = this.element;
        }
        ProcessElementItem elementItem = new ProcessElementItem(wrapper, this.element, this.elementProcessPath);
        this.iterateProcessItem(elementItem, act_data, setting);
    }

    private void loadWPBSLayoutData(ActivityLayoutData act_data, Suppression sup) {
        ConfigurableComposedAdapterFactory adapterFactory = this.layoutManager.getWPBSAdapterFactory();
        CompositeRoles crs = null;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.emf.edit.provider.ITreeItemContentProvider");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        IBSItemProvider provider = (IBSItemProvider)adapterFactory.adapt((Notifier)this.element, (Object)clazz);
        provider.setRolledUp(true);
        ActivityLayoutSetting setting = new ActivityLayoutSetting((ComposedAdapterFactory)adapterFactory, crs, sup);
        Object wrapper = sup.getObjectByPath(this.paths, (AdapterFactory)adapterFactory);
        if (wrapper == null) {
            wrapper = this.element;
        }
        ProcessElementItem elementItem = new ProcessElementItem(wrapper, this.element, this.elementProcessPath);
        this.iterateProcessItem(elementItem, act_data, setting);
    }

    private void iterateProcessItem(ProcessElementItem parentItem, ActivityLayoutData act_data, ActivityLayoutSetting setting) {
        ITreeItemContentProvider provider = null;
        Object parentObj = parentItem.rawItem;
        if (parentObj instanceof ITreeItemContentProvider) {
            provider = (ITreeItemContentProvider)parentObj;
        } else {
            ComposedAdapterFactory composedAdapterFactory = setting.adapterFactory;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.emf.edit.provider.ITreeItemContentProvider");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            provider = (ITreeItemContentProvider)composedAdapterFactory.adapt(parentObj, (Object)clazz);
        }
        if (provider != null) {
            Collection items = provider.getChildren(parentObj);
            Iterator it = items.iterator();
            while (it.hasNext()) {
                IElementLayout l;
                Object rawitem = it.next();
                boolean isSupressed = setting.sup.isSuppressed(rawitem);
                MethodElement item = (MethodElement)LibraryUtil.unwrap(rawitem);
                ProcessElementItem elementItem = new ProcessElementItem(rawitem, item, parentItem);
                if (this.debug && isSupressed) {
                    System.out.println("suppressed: " + ++supCount + " : " + LibraryUtil.getTypeName(item) + ": " + elementItem.path);
                }
                if (!((l = this.getLayout(elementItem)) instanceof AbstractProcessElementLayout)) continue;
                if (isSupressed) {
                    String relPath = ((AbstractProcessElementLayout)l).getRelativeProcessPath();
                    act_data.setSuppressed(relPath);
                    continue;
                }
                if (l instanceof ActivityLayout) {
                    ((ActivityLayout)l).loadLayoutData(act_data.getProcessLayoutData());
                    continue;
                }
                this.iterateProcessItem(elementItem, act_data, setting);
            }
        }
    }

    public void findAllLinkedElements() {
        ConfigurableComposedAdapterFactory adapterFactory;
        Process proc = this.getOwningProcess();
        Suppression sup = this.getSuppression(proc);
        Object wrapper = sup.getObjectByPath(this.paths, (AdapterFactory)(adapterFactory = this.layoutManager.getCBSAdapterFactory()));
        if (wrapper == null) {
            wrapper = this.element;
        }
        this.getLayoutMgr().getValidator().addReferencedElement(null, this.element);
        this.iterateItemForLinkedElements(wrapper, (ComposedAdapterFactory)adapterFactory, sup);
    }

    private void iterateItemForLinkedElements(Object parentObj, ComposedAdapterFactory adapterFactory, Suppression sup) {
        ITreeItemContentProvider provider = null;
        if (parentObj instanceof ITreeItemContentProvider) {
            provider = (ITreeItemContentProvider)parentObj;
        } else {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.emf.edit.provider.ITreeItemContentProvider");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            provider = (ITreeItemContentProvider)adapterFactory.adapt(parentObj, (Object)clazz);
        }
        if (provider == null) {
            return;
        }
        Collection items = provider.getChildren(parentObj);
        Iterator it = items.iterator();
        while (it.hasNext()) {
            Object rawitem = it.next();
            if (sup.isSuppressed(rawitem)) continue;
            MethodElement item = (MethodElement)LibraryUtil.unwrap(rawitem);
            Task e = null;
            if (item instanceof TaskDescriptor) {
                e = ((TaskDescriptor)item).getTask();
            } else if (item instanceof RoleDescriptor) {
                e = ((RoleDescriptor)item).getRole();
            } else if (item instanceof WorkProductDescriptor) {
                e = ((WorkProductDescriptor)item).getWorkProduct();
            }
            if (e != null) {
                this.getLayoutMgr().getValidator().addReferencedElement(item, (MethodElement)e);
            }
            MethodElement parent = (MethodElement)LibraryUtil.unwrap(rawitem);
            this.getLayoutMgr().getValidator().addReferencedElement(parent, item);
            this.iterateItemForLinkedElements(rawitem, adapterFactory, sup);
        }
    }

    public class CompositeRoles {
        Map itemMap = new HashMap();
        static /* synthetic */ Class class$0;

        public CompositeRoles(ComposedAdapterFactory adapterFactory, Activity act) {
            this.scan(adapterFactory, null, act);
        }

        private CompositeRoleInfo getCompositeRoleInfo(Activity parent, Activity act) {
            CompositeRoleInfo info = (CompositeRoleInfo)this.itemMap.get(act);
            if (info == null) {
                info = new CompositeRoleInfo(parent, act);
                this.itemMap.put(act, info);
            }
            return info;
        }

        private void scan(ComposedAdapterFactory adapterFactory, Activity parent, Activity act) {
            ITreeItemContentProvider provider;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.emf.edit.provider.ITreeItemContentProvider");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((provider = (ITreeItemContentProvider)adapterFactory.adapt((Notifier)act, (Object)clazz)) != null) {
                Collection items = provider.getChildren((Object)act);
                Iterator it = items.iterator();
                while (it.hasNext()) {
                    MethodElement item = (MethodElement)LibraryUtil.unwrap(it.next());
                    if (item instanceof CompositeRole) {
                        this.getCompositeRoleInfo(parent, act).addCompositeRole((CompositeRole)item);
                        continue;
                    }
                    if (!(item instanceof Activity)) continue;
                    this.scan(adapterFactory, act, (Activity)item);
                }
            }
        }

        private CompositeRole getCompositeRole(Activity activity, RoleDescriptor item) {
            if (activity == null) {
                return null;
            }
            CompositeRole desc = null;
            CompositeRoleInfo info = (CompositeRoleInfo)this.itemMap.get(activity);
            if (info != null) {
                desc = info.getCompositeRole(item);
                if (desc != null) {
                    return desc;
                }
                return this.getCompositeRole(info.getParentActivity(), item);
            }
            return null;
        }
    }

    public class CompositeRoleInfo {
        Activity parent;
        Activity owner;
        List items = new ArrayList();

        public CompositeRoleInfo(Activity parent, Activity owner) {
            this.parent = parent;
            this.owner = owner;
        }

        private void addCompositeRole(CompositeRole e) {
            if (!this.items.contains(e)) {
                this.items.add(e);
            }
        }

        private Activity getParentActivity() {
            return this.parent;
        }

        private CompositeRole getCompositeRole(RoleDescriptor item) {
            if (this.items.size() == 0) {
                return null;
            }
            Role r = item.getRole();
            Iterator it = this.items.iterator();
            while (it.hasNext()) {
                CompositeRole cr = (CompositeRole)it.next();
                if (!cr.getAggregatedRoles().contains(r)) continue;
                return cr;
            }
            return null;
        }
    }

    public class ActivityLayoutSetting {
        public ComposedAdapterFactory adapterFactory;
        public CompositeRoles crs;
        public Suppression sup;
        boolean rollupRoles = false;
        public boolean escapeString = false;
        public boolean showTaskOnly = false;

        public ActivityLayoutSetting(ComposedAdapterFactory adapterFactory, CompositeRoles crs, Suppression sup) {
            this.adapterFactory = adapterFactory;
            this.crs = crs;
            this.sup = sup;
        }
    }

    public class TBSItemDetail {
        List suppressedItems = new ArrayList();
        Map roleDescriptorMap = new HashMap();
        static /* synthetic */ Class class$0;

        public void addSuppressed(Object item) {
            if (!this.suppressedItems.contains(item)) {
                this.suppressedItems.add(item);
            }
        }

        public void iterate(ComposedAdapterFactory adapterFactory, Object parentObj) {
            ITreeItemContentProvider provider = null;
            if (parentObj instanceof ITreeItemContentProvider) {
                provider = (ITreeItemContentProvider)parentObj;
            } else {
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("org.eclipse.emf.edit.provider.ITreeItemContentProvider");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                provider = (ITreeItemContentProvider)adapterFactory.adapt(parentObj, (Object)clazz);
            }
            if (provider == null) {
                return;
            }
            Collection items = provider.getChildren(parentObj);
            Iterator it = items.iterator();
            while (it.hasNext()) {
                Object rawitem = it.next();
                MethodElement item = (MethodElement)LibraryUtil.unwrap(rawitem);
                if (item instanceof RoleDescriptor) {
                    this.addRoleDescriptor((RoleDescriptor)item);
                    continue;
                }
                this.iterate(adapterFactory, rawitem);
            }
        }

        private void addRoleDescriptor(RoleDescriptor rdesc) {
            Role r = rdesc.getRole();
            if (r != null) {
                ArrayList<RoleDescriptor> items = (ArrayList<RoleDescriptor>)this.roleDescriptorMap.get(r);
                if (items == null) {
                    items = new ArrayList<RoleDescriptor>();
                    this.roleDescriptorMap.put(r, items);
                    if (ActivityLayout.this.debug) {
                        System.out.println("Added RoleDescriptor " + rdesc.getPresentationName());
                    }
                }
                if (!items.contains(rdesc)) {
                    items.add(rdesc);
                }
            }
        }

        public List getDescriptors(Role r) {
            return (List)this.roleDescriptorMap.get(r);
        }
    }
}

