/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.util.AbstractTreeIterator;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.epf.library.edit.command.AddToCategoryCommand;
import org.eclipse.epf.library.edit.command.IActionManager;
import org.eclipse.epf.library.edit.command.IResourceAwareCommand;
import org.eclipse.epf.library.edit.command.RemoveFromCategoryCommand;
import org.eclipse.epf.library.edit.util.MethodElementUtil;
import org.eclipse.epf.library.edit.util.Misc;
import org.eclipse.epf.library.edit.util.ModelStructure;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.uma.ContentCategory;
import org.eclipse.epf.uma.ContentElement;
import org.eclipse.epf.uma.ContentPackage;
import org.eclipse.epf.uma.CustomCategory;
import org.eclipse.epf.uma.DescribableElement;
import org.eclipse.epf.uma.Discipline;
import org.eclipse.epf.uma.Domain;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.MethodPlugin;
import org.eclipse.epf.uma.NamedElement;
import org.eclipse.epf.uma.Role;
import org.eclipse.epf.uma.RoleSet;
import org.eclipse.epf.uma.Task;
import org.eclipse.epf.uma.Tool;
import org.eclipse.epf.uma.ToolMentor;
import org.eclipse.epf.uma.UmaPackage;
import org.eclipse.epf.uma.VariabilityElement;
import org.eclipse.epf.uma.VariabilityType;
import org.eclipse.epf.uma.WorkProduct;
import org.eclipse.epf.uma.WorkProductType;
import org.eclipse.epf.uma.util.AssociationHelper;
import org.eclipse.epf.uma.util.UmaUtil;

public class LibraryManager {
    private static Comparator nameComparator = new Comparator(){

        public int compare(Object o1, Object o2) {
            if (o1 instanceof MethodElement && o2 instanceof MethodElement) {
                return ((MethodElement)o1).getName().compareTo(((MethodElement)o2).getName());
            }
            return 0;
        }
    };
    private static LibraryManager instance = null;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;
    static /* synthetic */ Class class$5;
    static /* synthetic */ Class class$6;
    static /* synthetic */ Class class$7;
    static /* synthetic */ Class class$8;
    static /* synthetic */ Class class$9;
    static /* synthetic */ Class class$10;
    static /* synthetic */ Class class$11;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final LibraryManager getInstance() {
        if (instance != null) return instance;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.epf.library.util.LibraryManager");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Class<?> clazz2 = clazz;
        synchronized (clazz) {
            if (instance != null) return instance;
            instance = new LibraryManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    protected LibraryManager() {
    }

    public List getAvailableCategories(MethodElement object, Class classType, String[] path) {
        ArrayList<Object> itemList = new ArrayList<Object>();
        MethodPlugin model = UmaUtil.getMethodPlugin((EObject)object);
        if (model != null) {
            ContentPackage disciplinePkg = UmaUtil.findContentPackage((MethodPlugin)model, (String[])path);
            if (disciplinePkg != null) {
                EList contentCats = (EList)disciplinePkg.getContentElements();
                int i = 0;
                while (i < contentCats.size()) {
                    Object element = contentCats.get(i);
                    if (classType.isInstance(element) && element != object) {
                        itemList.add(element);
                    }
                    ++i;
                }
            }
            List list = Misc.getAllBase((MethodPlugin)model);
            int j = 0;
            while (j < list.size()) {
                ContentPackage parentDisciplines = UmaUtil.findContentPackage((MethodPlugin)((MethodPlugin)list.get(j)), (String[])path);
                if (parentDisciplines != null) {
                    EList contentCats = (EList)parentDisciplines.getContentElements();
                    int i = 0;
                    while (i < contentCats.size()) {
                        VariabilityElement item;
                        Object element = contentCats.get(i);
                        if (classType.isInstance(element) && (item = (VariabilityElement)element).getVariabilityBasedOnElement() == null) {
                            int k = 0;
                            while (k < itemList.size()) {
                                if (((VariabilityElement)itemList.get(k)).getVariabilityBasedOnElement() == item) break;
                                ++k;
                            }
                            if (k == itemList.size()) {
                                itemList.add(item);
                            }
                        }
                        ++i;
                    }
                }
                ++j;
            }
        }
        Collections.sort(itemList, nameComparator);
        return itemList;
    }

    public List getAvailableDisciplines(MethodElement e) {
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.epf.uma.Discipline");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return this.getAvailableCategories(e, clazz, ModelStructure.DEFAULT_DISCIPLINE_DEF_PATH);
    }

    public List getAvailableDomains(MethodElement e) {
        Class<?> clazz = class$2;
        if (clazz == null) {
            try {
                clazz = class$2 = Class.forName("org.eclipse.epf.uma.Domain");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        List domains = this.getAvailableCategories(e, clazz, ModelStructure.DEFAULT_DOMAIN_PATH);
        ArrayList allDomains = new ArrayList();
        Iterator iter = domains.iterator();
        while (iter.hasNext()) {
            Domain domain = (Domain)iter.next();
            AbstractTreeIterator domainTree = new AbstractTreeIterator(domain, true){

                protected Iterator getChildren(Object object) {
                    return ((Domain)object).getSubdomains().iterator();
                }
            };
            while (domainTree.hasNext()) {
                allDomains.add(domainTree.next());
            }
        }
        Collections.sort(allDomains, nameComparator);
        return allDomains;
    }

    public List getAvailableWorkProductTypes(MethodElement e) {
        Class<?> clazz = class$3;
        if (clazz == null) {
            try {
                clazz = class$3 = Class.forName("org.eclipse.epf.uma.WorkProductType");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return this.getAvailableCategories(e, clazz, ModelStructure.DEFAULT_WORK_PRODUCT_TYPE_PATH);
    }

    public List getAvailableRoleSets(MethodElement e) {
        Class<?> clazz = class$4;
        if (clazz == null) {
            try {
                clazz = class$4 = Class.forName("org.eclipse.epf.uma.RoleSet");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return this.getAvailableCategories(e, clazz, ModelStructure.DEFAULT.roleSetPath);
    }

    public List getAvailableCustomCategories(MethodElement e) {
        Class<?> clazz = class$5;
        if (clazz == null) {
            try {
                clazz = class$5 = Class.forName("org.eclipse.epf.uma.CustomCategory");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        List categories = this.getAvailableCategories(e, clazz, ModelStructure.DEFAULT_CUSTOM_CATEGORY_PATH);
        Iterator iter = categories.iterator();
        while (iter.hasNext()) {
            if (!TngUtil.isRootCustomCategory((CustomCategory)((CustomCategory)iter.next()))) continue;
            iter.remove();
        }
        return categories;
    }

    public List getAvailableTools(MethodElement e) {
        Class<?> clazz = class$6;
        if (clazz == null) {
            try {
                clazz = class$6 = Class.forName("org.eclipse.epf.uma.Tool");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return this.getAvailableCategories(e, clazz, ModelStructure.DEFAULT.toolPath);
    }

    public List getAvailableDisciplineGroupings(MethodElement e) {
        Class<?> clazz = class$7;
        if (clazz == null) {
            try {
                clazz = class$7 = Class.forName("org.eclipse.epf.uma.DisciplineGrouping");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return this.getAvailableCategories(e, clazz, ModelStructure.DEFAULT.disciplineDefinitionPath);
    }

    public List getAvailableRoleSetGroupings(MethodElement e) {
        Class<?> clazz = class$8;
        if (clazz == null) {
            try {
                clazz = class$8 = Class.forName("org.eclipse.epf.uma.RoleSetGrouping");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return this.getAvailableCategories(e, clazz, ModelStructure.DEFAULT.roleSetPath);
    }

    public Discipline addToDiscipline(IActionManager actionMgr, Discipline discipline, Task task) {
        return (Discipline)this.addToCategory(actionMgr, (ContentCategory)discipline, (MethodElement)task, (EStructuralFeature)UmaPackage.eINSTANCE.getDiscipline_Tasks(), ModelStructure.DEFAULT.disciplineDefinitionPath, true);
    }

    public Domain addToDomain(IActionManager actionMgr, Domain domain, WorkProduct wp) {
        return (Domain)this.addToCategory(actionMgr, (ContentCategory)domain, (MethodElement)wp, (EStructuralFeature)UmaPackage.eINSTANCE.getDomain_WorkProducts(), ModelStructure.DEFAULT.domainPath, true);
    }

    public WorkProductType addToWorkProductType(IActionManager actionMgr, WorkProductType wpType, WorkProduct wp) {
        return (WorkProductType)this.addToCategory(actionMgr, (ContentCategory)wpType, (MethodElement)wp, (EStructuralFeature)UmaPackage.eINSTANCE.getWorkProductType_WorkProducts(), ModelStructure.DEFAULT.workProductTypePath, true);
    }

    public CustomCategory addToCustomCategory(IActionManager actionMgr, CustomCategory userDefinedCategory, MethodElement element) {
        if (element instanceof DescribableElement) {
            return (CustomCategory)this.addToCategory(actionMgr, (ContentCategory)userDefinedCategory, element, (EStructuralFeature)UmaPackage.eINSTANCE.getCustomCategory_CategorizedElements(), ModelStructure.DEFAULT.customCategoryPath, true);
        }
        return null;
    }

    public Tool addToTool(IActionManager actionMgr, Tool tool, ToolMentor toolMentor) {
        return (Tool)this.addToCategory(actionMgr, (ContentCategory)tool, (MethodElement)toolMentor, (EStructuralFeature)UmaPackage.eINSTANCE.getTool_ToolMentors(), ModelStructure.DEFAULT.toolPath, true);
    }

    public RoleSet addToRoleSet(IActionManager actionMgr, RoleSet roleSet, Role role) {
        return (RoleSet)this.addToCategory(actionMgr, (ContentCategory)roleSet, (MethodElement)role, (EStructuralFeature)UmaPackage.eINSTANCE.getRoleSet_Roles(), ModelStructure.DEFAULT.roleSetPath, true);
    }

    public ContentCategory addToCategory(IActionManager actionMgr, ContentCategory category, MethodElement element, EStructuralFeature feature, String[] categoryPkgPath, boolean checkForExistingContributor) {
        AddToCategoryCommand cmd = new AddToCategoryCommand(category, element, feature, categoryPkgPath, checkForExistingContributor);
        actionMgr.execute((IResourceAwareCommand)cmd);
        return (ContentCategory)((List)cmd.getAffectedObjects()).get(0);
    }

    public boolean removeFromCategory(IActionManager actionMgr, ContentCategory category, MethodElement element, EStructuralFeature feature, String[] contentPkgPath) {
        RemoveFromCategoryCommand cmd = new RemoveFromCategoryCommand(category, element, feature, contentPkgPath);
        actionMgr.execute((IResourceAwareCommand)cmd);
        return !cmd.getResult().isEmpty();
    }

    public boolean removeFromDiscipline(IActionManager actionMgr, Discipline discipline, Task task) {
        EReference feature = UmaPackage.eINSTANCE.getDiscipline_Tasks();
        return this.removeFromCategory(actionMgr, (ContentCategory)discipline, (MethodElement)task, (EStructuralFeature)feature, ModelStructure.DEFAULT.disciplineDefinitionPath);
    }

    public boolean removeFromDomain(IActionManager actionMgr, Domain domain, WorkProduct wp) {
        EReference feature = UmaPackage.eINSTANCE.getDomain_WorkProducts();
        return this.removeFromCategory(actionMgr, (ContentCategory)domain, (MethodElement)wp, (EStructuralFeature)feature, ModelStructure.DEFAULT.domainPath);
    }

    public boolean removeFromWorkProductType(IActionManager actionMgr, WorkProductType wpType, WorkProduct wp) {
        EReference feature = UmaPackage.eINSTANCE.getWorkProductType_WorkProducts();
        return this.removeFromCategory(actionMgr, (ContentCategory)wpType, (MethodElement)wp, (EStructuralFeature)feature, ModelStructure.DEFAULT.workProductTypePath);
    }

    public boolean removeFromRoleSet(IActionManager actionMgr, RoleSet roleSet, Role role) {
        EReference feature = UmaPackage.eINSTANCE.getRoleSet_Roles();
        return this.removeFromCategory(actionMgr, (ContentCategory)roleSet, (MethodElement)role, (EStructuralFeature)feature, ModelStructure.DEFAULT.roleSetPath);
    }

    public boolean removeFromTool(IActionManager actionMgr, Tool tool, ToolMentor toolMentor) {
        EReference feature = UmaPackage.eINSTANCE.getTool_ToolMentors();
        return this.removeFromCategory(actionMgr, (ContentCategory)tool, (MethodElement)toolMentor, (EStructuralFeature)feature, ModelStructure.DEFAULT.toolPath);
    }

    public boolean removeFromCustomCategory(IActionManager actionMgr, CustomCategory userDefinedCategory, MethodElement e) {
        if (e instanceof DescribableElement) {
            EReference feature = UmaPackage.eINSTANCE.getCustomCategory_CategorizedElements();
            return this.removeFromCategory(actionMgr, (ContentCategory)userDefinedCategory, e, (EStructuralFeature)feature, ModelStructure.DEFAULT.customCategoryPath);
        }
        return false;
    }

    public void releaseCategories(MethodElement consumer, Collection categories) {
        MethodPlugin consumerPlugin = UmaUtil.getMethodPlugin((EObject)consumer);
        Iterator iter = categories.iterator();
        while (iter.hasNext()) {
            ContentPackage categoryPkg;
            ContentCategory contributor;
            ContentCategory category = (ContentCategory)iter.next();
            MethodPlugin categoryPlugin = UmaUtil.getMethodPlugin((EObject)category);
            if (category.getVariabilityBasedOnElement() != null && categoryPlugin == consumerPlugin && TngUtil.isEmpty((ContentCategory)category)) {
                EcoreUtil.remove((EObject)category);
                if (!(category instanceof CustomCategory)) continue;
                TngUtil.getRootCustomCategory((MethodPlugin)categoryPlugin).getCategorizedElements().remove(category);
                continue;
            }
            String[] path = LibraryManager.getCategoryPackagePath(category);
            if (path == null || (contributor = TngUtil.findContributor((ContentPackage)(categoryPkg = UmaUtil.findContentPackage((MethodPlugin)consumerPlugin, (String[])path)), (ContentCategory)category)) == null || !TngUtil.isEmpty((ContentCategory)contributor)) continue;
            EcoreUtil.remove((EObject)contributor);
        }
    }

    public List getAvailableTasks(ContentCategory category) {
        Class<?> clazz = class$9;
        if (clazz == null) {
            try {
                clazz = class$9 = Class.forName("org.eclipse.epf.uma.Task");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return this.getAvailableContentElements(clazz, (ContentElement)category, false);
    }

    public List getAvailableWorkProducts(ContentCategory category) {
        Class<?> clazz = class$10;
        if (clazz == null) {
            try {
                clazz = class$10 = Class.forName("org.eclipse.epf.uma.WorkProduct");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return this.getAvailableContentElements(clazz, (ContentElement)category, false);
    }

    public List getAvailableRoles(ContentCategory category) {
        Class<?> clazz = class$11;
        if (clazz == null) {
            try {
                clazz = class$11 = Class.forName("org.eclipse.epf.uma.Role");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return this.getAvailableContentElements(clazz, (ContentElement)category, false);
    }

    public List getAvailableContentElements(Class methodElementType, ContentElement element, boolean localOnly) {
        ArrayList<Object> elementList = new ArrayList<Object>();
        List<MethodPlugin> modelList = localOnly ? Collections.singletonList(UmaUtil.getMethodPlugin((EObject)element)) : MethodElementUtil.getAllModels((Object)element);
        int size = modelList.size();
        int i = 0;
        while (i < size) {
            MethodPlugin model = modelList.get(i);
            ContentPackage coreContentPkg = UmaUtil.findContentPackage((MethodPlugin)model, (String[])ModelStructure.DEFAULT.coreContentPath);
            if (coreContentPkg != null) {
                TreeIterator iterator = coreContentPkg.eAllContents();
                while (iterator.hasNext()) {
                    Object obj = iterator.next();
                    if (!methodElementType.isInstance(obj) || obj == element) continue;
                    elementList.add(obj);
                }
            }
            ++i;
        }
        Collections.sort(elementList, nameComparator);
        return elementList;
    }

    public List getAvailableTasks(Role role) {
        Class<?> clazz = class$9;
        if (clazz == null) {
            try {
                clazz = class$9 = Class.forName("org.eclipse.epf.uma.Task");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return this.getAvailableContentElements(clazz, (ContentElement)role, true);
    }

    public List getAvailableTasks(WorkProduct wp) {
        Class<?> clazz = class$9;
        if (clazz == null) {
            try {
                clazz = class$9 = Class.forName("org.eclipse.epf.uma.Task");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return this.getAvailableContentElements(clazz, (ContentElement)wp, true);
    }

    public List getAvailableRoles(WorkProduct wp) {
        Class<?> clazz = class$11;
        if (clazz == null) {
            try {
                clazz = class$11 = Class.forName("org.eclipse.epf.uma.Role");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return this.getAvailableContentElements(clazz, (ContentElement)wp, true);
    }

    public List getAvailableWorkProducts(Role role) {
        Class<?> clazz = class$10;
        if (clazz == null) {
            try {
                clazz = class$10 = Class.forName("org.eclipse.epf.uma.WorkProduct");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return this.getAvailableContentElements(clazz, (ContentElement)role, false);
    }

    public List getAvailableWorkProducts(Task task) {
        Class<?> clazz = class$10;
        if (clazz == null) {
            try {
                clazz = class$10 = Class.forName("org.eclipse.epf.uma.WorkProduct");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return this.getAvailableContentElements(clazz, (ContentElement)task, false);
    }

    public List getAvailableRoles(Task task) {
        Class<?> clazz = class$11;
        if (clazz == null) {
            try {
                clazz = class$11 = Class.forName("org.eclipse.epf.uma.Role");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return this.getAvailableContentElements(clazz, (ContentElement)task, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getStepList(Task task) {
        if (task.getVariabilityType() == VariabilityType.EXTENDS_LITERAL || task.getVariabilityType() == VariabilityType.CONTRIBUTES_LITERAL) {
            VariabilityElement base = TngUtil.getBase((VariabilityElement)task);
            final ArrayList<VariabilityType> types = new ArrayList<VariabilityType>();
            if (types.isEmpty()) {
                ArrayList<VariabilityType> arrayList = types;
                synchronized (arrayList) {
                    if (types.isEmpty()) {
                        types.add(VariabilityType.CONTRIBUTES_LITERAL);
                        types.add(VariabilityType.EXTENDS_LITERAL);
                    }
                }
            }
            AbstractTreeIterator extended = new AbstractTreeIterator(base){

                protected Iterator getChildren(Object object) {
                    List list = AssociationHelper.getImmediateVarieties((VariabilityElement)((VariabilityElement)object));
                    if (list == null || list.isEmpty()) {
                        Collections.EMPTY_LIST.iterator();
                    }
                    int size = list.size();
                    ArrayList<VariabilityElement> outputList = new ArrayList<VariabilityElement>();
                    int i = 0;
                    while (i < size) {
                        VariabilityElement e = (VariabilityElement)list.get(i);
                        if (types.contains(e.getVariabilityType())) {
                            outputList.add(e);
                        }
                        ++i;
                    }
                    return outputList.iterator();
                }
            };
            while (extended.hasNext()) {
                Task t = (Task)extended.next();
                t.getPresentation().getSections();
            }
        }
        return null;
    }

    public List getExtended(VariabilityElement base, Collection variabilityTypes) {
        ArrayList list = new ArrayList();
        LibraryManager.getExtended(list, base, variabilityTypes);
        return list;
    }

    private static void getExtended(List outputList, VariabilityElement base, Collection variabilityTypes) {
        VariabilityElement e;
        List list = AssociationHelper.getImmediateVarieties((VariabilityElement)base);
        if (list == null || list.isEmpty()) {
            return;
        }
        int size = list.size();
        int i = 0;
        while (i < size) {
            e = (VariabilityElement)list.get(i);
            if (variabilityTypes.contains(e.getVariabilityType())) {
                outputList.add(e);
            }
            ++i;
        }
        i = 0;
        while (i < size) {
            e = (VariabilityElement)list.get(i);
            if (variabilityTypes.contains(e.getVariabilityType())) {
                LibraryManager.getExtended(outputList, base, variabilityTypes);
            }
            ++i;
        }
    }

    private static String[] getCategoryPackagePath(ContentCategory category) {
        EObject parent = null;
        parent = category.eContainer();
        while (parent != null && !(parent instanceof ContentPackage)) {
            parent = parent.eContainer();
        }
        if (parent == null) {
            return null;
        }
        ContentPackage categoryPkg = (ContentPackage)parent;
        return Misc.getPathRelativeToPlugin((NamedElement)categoryPkg);
    }
}

