/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.richtext.actions;

import java.io.File;
import java.net.URL;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.epf.common.serviceability.Logger;
import org.eclipse.epf.common.utils.ClipboardUtil;
import org.eclipse.epf.common.utils.FileUtil;
import org.eclipse.epf.common.utils.NetUtil;
import org.eclipse.epf.richtext.IRichText;
import org.eclipse.epf.richtext.RichTextEditor;
import org.eclipse.epf.richtext.RichTextImages;
import org.eclipse.epf.richtext.RichTextPlugin;
import org.eclipse.epf.richtext.RichTextResources;
import org.eclipse.epf.richtext.actions.RichTextAction;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.HTMLTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Display;

public class PasteAction
extends RichTextAction {
    private static final String SOURCE_URL = "SourceURL:";
    private static final String HTM_EXT = ".htm";
    private static final String HTML_EXT = ".html";
    private static final Pattern HREF_REFERENCES = Pattern.compile("href\\s*=\\s*\"(.*?)\"", 34);
    protected static final Pattern p_image_ref = Pattern.compile("(<(img|iframe).*?src\\s*=\\s*\")(.*?)(\")", 34);
    protected static String sourceURLStr = "";
    private Logger logger;

    public PasteAction() {
        this.setImage(RichTextImages.IMG_PASTE);
        this.setDisabledImage(RichTextImages.DISABLED_IMG_PASTE);
        this.setToolTipText(RichTextResources.pasteAction_toolTipText);
        this.setEnabled(true);
        this.logger = RichTextPlugin.getDefault().getLogger();
    }

    public boolean disableInSourceMode() {
        return false;
    }

    public void execute(IRichText richText) {
        if (richText != null) {
            this.copyLinkResources(richText);
            if (richText instanceof RichTextEditor && ((RichTextEditor)richText).isHTMLTabSelected()) {
                StyledText styledText = ((RichTextEditor)richText).getSourceEdit();
                styledText.paste();
            } else {
                richText.executeCommand("paste", sourceURLStr);
            }
        }
    }

    protected void copyLinkResources(IRichText richText) {
        try {
            sourceURLStr = ClipboardUtil.getHTMLSourceURL();
            Clipboard clipboard = new Clipboard(Display.getCurrent());
            String html = (String)clipboard.getContents((Transfer)HTMLTransfer.getInstance());
            if (html != null && html.length() > 0) {
                File tgtFile;
                String scheme;
                String basePath = richText.getBasePath();
                if (sourceURLStr == null || sourceURLStr.length() == 0) {
                    sourceURLStr = basePath;
                }
                URL sourceURL = new URL(sourceURLStr);
                Matcher matcher = HREF_REFERENCES.matcher(html);
                while (matcher.find()) {
                    String href = NetUtil.decodeURL((String)matcher.group(1));
                    if (!href.toLowerCase().endsWith(HTM_EXT) && !href.toLowerCase().endsWith(HTML_EXT)) continue;
                    try {
                        URL hrefURL = new URL(sourceURL, href);
                        scheme = hrefURL.getProtocol();
                        if (scheme == null || !scheme.equalsIgnoreCase("file")) continue;
                        String url = hrefURL.toString();
                        File srcFile = new File(url);
                        tgtFile = new File(String.valueOf(basePath) + "resources");
                        tgtFile.mkdirs();
                        FileUtil.copyFile((File)srcFile, (File)tgtFile);
                    }
                    catch (Exception e) {
                        this.logger.logError((Throwable)e);
                    }
                }
                matcher = p_image_ref.matcher(html);
                while (matcher.find()) {
                    String src = NetUtil.decodeURL((String)matcher.group(3));
                    try {
                        URL srcURL = new URL(sourceURL, src);
                        scheme = srcURL.getProtocol();
                        if (scheme == null || !scheme.equalsIgnoreCase("file")) continue;
                        File srcFile = null;
                        String authority = srcURL.getAuthority();
                        srcFile = authority != null ? new File(String.valueOf(authority) + srcURL.getPath()) : new File(srcURL.getPath());
                        tgtFile = new File(String.valueOf(basePath) + "resources");
                        tgtFile.mkdirs();
                        FileUtil.copyFile((File)srcFile, (File)tgtFile);
                    }
                    catch (Exception e) {
                        this.logger.logError((Throwable)e);
                    }
                }
            }
        }
        catch (Exception e) {
            this.logger.logError((Throwable)e);
        }
    }

    protected String getSourceURL(String htmlContent) {
        String sourceURL = null;
        int sourceURLIndex = htmlContent.indexOf(SOURCE_URL);
        if (sourceURLIndex > 0) {
            sourceURL = htmlContent.substring(sourceURLIndex + SOURCE_URL.length());
            if ((sourceURL = sourceURL.substring(0, sourceURL.indexOf(FileUtil.LINE_SEP))).toLowerCase().endsWith(HTM_EXT) || sourceURL.toLowerCase().endsWith(HTML_EXT)) {
                sourceURL = sourceURL.substring(0, sourceURL.indexOf(FileUtil.getFileName((String)sourceURL)) - 1);
                sourceURL = sourceURL.replace('\\', '/');
            }
            sourceURL = FileUtil.appendSeparator((String)sourceURL, (String)"/");
        }
        return sourceURL;
    }
}

