/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.authoring.gef.edit;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.epf.authoring.gef.commands.ChangeBoundsCommand;
import org.eclipse.epf.authoring.gef.edit.ActivityDetailDiagramEditPart;
import org.eclipse.epf.authoring.gef.edit.DiagramEditPart;
import org.eclipse.epf.authoring.gef.edit.LinkEditPart;
import org.eclipse.epf.authoring.gef.edit.NodeContainerEditPart;
import org.eclipse.epf.authoring.gef.edit.RoleTaskCompositeEditPart;
import org.eclipse.epf.authoring.gef.edit.WorkProductCompositeEditPart;
import org.eclipse.epf.diagram.model.Node;
import org.eclipse.gef.DefaultEditDomain;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CommandStack;
import org.eclipse.gef.editparts.AbstractGraphicalEditPart;
import org.eclipse.gef.ui.actions.ActionRegistry;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;

public class DiagramUpdateService {
    private DefaultEditDomain editDomain;
    private GraphicalViewer graphicalViewer;
    private ActionRegistry actionRegistry;
    protected static final int HORIZ_PIX_PADDING = 30;
    protected static final int VERT_PIX_PADDING = 20;

    public DiagramUpdateService(GraphicalViewer graphicalViewer, DefaultEditDomain editDomain, ActionRegistry actionRegistry) {
        this.graphicalViewer = graphicalViewer;
        this.editDomain = editDomain;
        this.actionRegistry = actionRegistry;
    }

    private GraphicalViewer getGraphicalViewer() {
        return this.graphicalViewer;
    }

    protected CommandStack getCommandStack() {
        return this.getEditDomain().getCommandStack();
    }

    protected DefaultEditDomain getEditDomain() {
        return this.editDomain;
    }

    protected ActionRegistry getActionRegistry() {
        return this.actionRegistry;
    }

    public void cleanUpDiagram() {
        ActivityDetailDiagramEditPart dep;
        List children;
        if (this.getGraphicalViewer().getContents() instanceof ActivityDetailDiagramEditPart && !(children = (dep = (ActivityDetailDiagramEditPart)this.getGraphicalViewer().getContents()).getRecentlyAddedParts()).isEmpty()) {
            AbstractGraphicalEditPart ep;
            Comparator comparator = new Comparator(){

                public int compare(Object arg0, Object arg1) {
                    int rc = 0;
                    if (arg0 instanceof RoleTaskCompositeEditPart) {
                        if (!(arg1 instanceof RoleTaskCompositeEditPart)) {
                            rc = -1;
                        }
                    } else if (arg1 instanceof RoleTaskCompositeEditPart) {
                        rc = 1;
                    }
                    return rc;
                }
            };
            Object[] array = children.toArray();
            Arrays.sort(array, comparator);
            int a = 0;
            while (a < array.length) {
                ep = (AbstractGraphicalEditPart)array[a];
                this.adjustSize(ep);
                ++a;
            }
            int b = 0;
            while (b < array.length) {
                ep = (AbstractGraphicalEditPart)array[b];
                this.cleanUp(ep);
                ++b;
            }
            int c = 0;
            while (c < array.length) {
                ep = (AbstractGraphicalEditPart)array[c];
                this.reduceLinkLength(ep);
                ++c;
            }
            this.packDiagram();
            dep.clearRecentlyAddedParts();
            this.getGraphicalViewer().setSelection((ISelection)new StructuredSelection());
        }
    }

    private void resetSizes(AbstractGraphicalEditPart ep, AbstractGraphicalEditPart parent) {
        if (!(ep instanceof WorkProductCompositeEditPart)) {
            List targetLinks;
            int h;
            ChangeBoundsCommand c;
            List sourceLinks = ep.getSourceConnections();
            if (sourceLinks.size() > 0) {
                int b = 0;
                while (b < sourceLinks.size()) {
                    LinkEditPart link = (LinkEditPart)((Object)sourceLinks.get(b));
                    AbstractGraphicalEditPart target = (AbstractGraphicalEditPart)link.getTarget();
                    int w = target.getFigure().getBounds().width;
                    int ew = ep.getFigure().getPreferredSize().width;
                    if (w > ew) {
                        Point location = ep.getFigure().getBounds().getLocation();
                        location.x += (w - ew) / 2;
                        c = new ChangeBoundsCommand((Node)ep.getModel(), ep.getFigure().getBounds().getLocation(), w);
                        this.getCommandStack().execute((Command)c);
                        h = ep.getFigure().getPreferredSize().height;
                        ep.getFigure().setPreferredSize(new Dimension(w, h));
                        ep.getFigure().setSize(new Dimension(w, h));
                    }
                    this.getGraphicalViewer().setSelection((ISelection)new StructuredSelection(new Object[]{ep, target}));
                    IAction valign = this.getActionRegistry().getAction((Object)"align_vertical_to_first_selection");
                    valign.run();
                    ++b;
                }
            }
            if ((targetLinks = ep.getTargetConnections()).size() > 0) {
                int b = 0;
                while (b < targetLinks.size()) {
                    LinkEditPart link = (LinkEditPart)((Object)targetLinks.get(b));
                    AbstractGraphicalEditPart source = (AbstractGraphicalEditPart)link.getSource();
                    int w = source.getFigure().getBounds().width;
                    int ew = ep.getFigure().getPreferredSize().width;
                    if (w > ew) {
                        c = new ChangeBoundsCommand((Node)ep.getModel(), ep.getFigure().getBounds().getLocation(), w);
                        this.getCommandStack().execute((Command)c);
                        h = ep.getFigure().getPreferredSize().height;
                        ep.getFigure().setPreferredSize(new Dimension(w, h));
                        ep.getFigure().setSize(new Dimension(w, h));
                    }
                    this.getGraphicalViewer().setSelection((ISelection)new StructuredSelection(new Object[]{ep, source}));
                    IAction valign = this.getActionRegistry().getAction((Object)"align_vertical_to_first_selection");
                    valign.run();
                    ++b;
                }
            }
            parent.getFigure().getLayoutManager().layout(parent.getFigure());
            if (ep instanceof NodeContainerEditPart) {
                List children = ep.getChildren();
                int d = 0;
                while (d < children.size()) {
                    AbstractGraphicalEditPart p = (AbstractGraphicalEditPart)children.get(d);
                    this.resetSizes(p, ep);
                    ++d;
                }
            }
        }
    }

    private void cleanUp(AbstractGraphicalEditPart ep) {
        if (!(ep instanceof WorkProductCompositeEditPart)) {
            List targetLinks;
            List sourceLinks = ep.getSourceConnections();
            if (sourceLinks.size() > 0) {
                int b = 0;
                while (b < sourceLinks.size()) {
                    LinkEditPart link = (LinkEditPart)((Object)sourceLinks.get(b));
                    AbstractGraphicalEditPart target = (AbstractGraphicalEditPart)link.getTarget();
                    int w = target.getFigure().getBounds().width;
                    int ew = ep.getFigure().getPreferredSize().width;
                    if (w < ew) {
                        ChangeBoundsCommand c = new ChangeBoundsCommand((Node)ep.getModel(), target.getFigure().getBounds().getLocation(), w);
                        this.getCommandStack().execute((Command)c);
                        int h = target.getFigure().getPreferredSize().height;
                        target.getFigure().setPreferredSize(new Dimension(w, h));
                        target.getFigure().setSize(new Dimension(w, h));
                    }
                    this.getGraphicalViewer().setSelection((ISelection)new StructuredSelection(new Object[]{ep, target}));
                    IAction valign = this.getActionRegistry().getAction((Object)"align_vertical_to_first_selection");
                    valign.run();
                    ++b;
                }
            }
            if ((targetLinks = ep.getTargetConnections()).size() > 0) {
                int b = 0;
                while (b < targetLinks.size()) {
                    LinkEditPart link = (LinkEditPart)((Object)targetLinks.get(b));
                    AbstractGraphicalEditPart source = (AbstractGraphicalEditPart)link.getSource();
                    int w = source.getFigure().getBounds().width;
                    int ew = ep.getFigure().getPreferredSize().width;
                    if (w < ew) {
                        ChangeBoundsCommand c = new ChangeBoundsCommand((Node)ep.getModel(), source.getFigure().getBounds().getLocation(), w);
                        this.getCommandStack().execute((Command)c);
                        int h = source.getFigure().getPreferredSize().height;
                        source.getFigure().setPreferredSize(new Dimension(w, h));
                        source.getFigure().setSize(new Dimension(w, h));
                    }
                    this.getGraphicalViewer().setSelection((ISelection)new StructuredSelection(new Object[]{ep, source}));
                    IAction valign = this.getActionRegistry().getAction((Object)"align_vertical_to_first_selection");
                    valign.run();
                    ++b;
                }
            }
            if (ep instanceof NodeContainerEditPart) {
                List children = ep.getChildren();
                int d = 0;
                while (d < children.size()) {
                    AbstractGraphicalEditPart p = (AbstractGraphicalEditPart)children.get(d);
                    this.cleanUp(p);
                    ++d;
                }
            }
        }
    }

    private boolean reduceLinkLength(AbstractGraphicalEditPart part) {
        boolean moved = false;
        if (part instanceof WorkProductCompositeEditPart) {
            AbstractGraphicalEditPart linkedPart = null;
            int position = 2;
            if (part.getTargetConnections().size() > 0) {
                linkedPart = (AbstractGraphicalEditPart)((LinkEditPart)((Object)part.getTargetConnections().get(0))).getSource();
                position = 1;
            } else if (part.getSourceConnections().size() > 0) {
                linkedPart = (AbstractGraphicalEditPart)((LinkEditPart)((Object)part.getSourceConnections().get(0))).getTarget();
                position = 4;
            }
            if (linkedPart != null) {
                if (!(linkedPart.getParent() instanceof DiagramEditPart)) {
                    linkedPart = (AbstractGraphicalEditPart)linkedPart.getParent();
                }
                Rectangle partBounds = part.getFigure().getBounds();
                Rectangle linkedPartBounds = linkedPart.getFigure().getBounds();
                int direction = -1;
                if ((position & 1) == 1 || (position & 2) == 2) {
                    direction = 1;
                }
                Rectangle testBounds = partBounds.getCopy();
                testBounds.y = direction == 1 ? linkedPartBounds.y + linkedPartBounds.height + 20 : linkedPartBounds.y - 20 - partBounds.height;
                Point np = new Point(testBounds.x, testBounds.y);
                part.getFigure().setLocation(np);
                ChangeBoundsCommand c = new ChangeBoundsCommand((Node)part.getModel(), np, partBounds.width);
                this.getCommandStack().execute((Command)c);
            }
        }
        return moved;
    }

    private void adjustSize(AbstractGraphicalEditPart ep) {
        if (ep instanceof WorkProductCompositeEditPart) {
            this.adjustSize((NodeContainerEditPart)ep, 1);
        } else if (ep instanceof NodeContainerEditPart) {
            this.adjustSize((NodeContainerEditPart)ep, 50);
        }
    }

    private void adjustSize(NodeContainerEditPart ep, int horizCount) {
        int requiredWidth = 0;
        int rowMaxHeight = 0;
        int rows = 0;
        int widthSum = 0;
        int heightSum = 0;
        int column = 0;
        List children = ep.getChildren();
        int p = 0;
        while (p < children.size()) {
            if (column == 0) {
                ++rows;
            }
            if (column < horizCount) {
                AbstractGraphicalEditPart child = (AbstractGraphicalEditPart)children.get(p);
                Dimension d = child.getFigure().getPreferredSize();
                widthSum += d.width;
                if (d.height > rowMaxHeight) {
                    rowMaxHeight = d.height;
                }
                ++p;
                ++column;
                continue;
            }
            if (widthSum > requiredWidth) {
                requiredWidth = widthSum;
            }
            heightSum += rowMaxHeight;
            rowMaxHeight = 0;
            widthSum = 0;
            column = 0;
        }
        if (widthSum > requiredWidth) {
            requiredWidth = widthSum;
        }
        int requiredHeight = (heightSum += rowMaxHeight) + 20 * rows;
        ChangeBoundsCommand cmd = new ChangeBoundsCommand((Node)ep.getModel(), ep.getFigure().getBounds().getLocation(), requiredWidth += 30 * Math.min(horizCount, children.size()));
        this.getCommandStack().execute((Command)cmd);
        ep.getFigure().setPreferredSize(new Dimension(requiredWidth, requiredHeight));
        ((Node)ep.getModel()).setHeight(requiredHeight);
        ep.getFigure().setSize(new Dimension(requiredWidth, requiredHeight));
        ep.getFigure().getLayoutManager().layout(ep.getFigure());
        if (ep instanceof WorkProductCompositeEditPart && children.size() > 0) {
            GraphicalEditPart last = (GraphicalEditPart)children.get(children.size() - 1);
            Point childBottom = last.getFigure().getBounds().getBottom();
            Point parentBottom = ep.getFigure().getBounds().getBottom();
            int delta = parentBottom.y - childBottom.y - 10;
            ep.getFigure().setPreferredSize(new Dimension(requiredWidth, requiredHeight - delta));
            ((Node)ep.getModel()).setHeight(requiredHeight - delta);
            ep.getFigure().setSize(new Dimension(requiredWidth, requiredHeight - delta));
        }
    }

    protected void enumerateConnectedParts(AbstractGraphicalEditPart part, List connected) {
        if (!connected.contains(part)) {
            if (!(part.getParent() instanceof DiagramEditPart)) {
                if (!connected.contains(part.getParent())) {
                    connected.add(part.getParent());
                }
            } else {
                connected.add(part);
            }
            AbstractGraphicalEditPart linkedPart = null;
            List children = part.getChildren();
            int x = 0;
            while (x < children.size()) {
                AbstractGraphicalEditPart p = (AbstractGraphicalEditPart)children.get(x);
                this.enumerateConnectedParts(p, connected);
                ++x;
            }
            x = 0;
            while (x < part.getTargetConnections().size()) {
                linkedPart = (AbstractGraphicalEditPart)((LinkEditPart)((Object)part.getTargetConnections().get(x))).getSource();
                this.enumerateConnectedParts(linkedPart, connected);
                ++x;
            }
            x = 0;
            while (x < part.getSourceConnections().size()) {
                linkedPart = (AbstractGraphicalEditPart)((LinkEditPart)((Object)part.getSourceConnections().get(x))).getTarget();
                this.enumerateConnectedParts(linkedPart, connected);
                ++x;
            }
        }
    }

    private void packDiagram() {
        int limit;
        ActivityDetailDiagramEditPart diagram = (ActivityDetailDiagramEditPart)this.getGraphicalViewer().getContents();
        int reserved = 0;
        ArrayList<AbstractGraphicalEditPart> stragglers = new ArrayList<AbstractGraphicalEditPart>();
        ArrayList groups = new ArrayList();
        List diagramParts = diagram.getRecentlyAddedParts();
        int x = 0;
        while (x < diagramParts.size()) {
            AbstractGraphicalEditPart p = (AbstractGraphicalEditPart)diagramParts.get(x);
            boolean found = false;
            int g = 0;
            while (g < groups.size() && !found) {
                List group = (List)groups.get(g);
                if (group.contains(p)) {
                    found = true;
                    break;
                }
                ++g;
            }
            if (!found) {
                ArrayList connected = new ArrayList();
                this.enumerateConnectedParts(p, connected);
                if (connected.size() == 1) {
                    stragglers.add(p);
                } else {
                    groups.add(connected);
                }
            }
            ++x;
        }
        while (groups.size() > 0) {
            List top = (List)groups.get(0);
            int topY = this.getVerticalMinPart((List)top).getFigure().getBounds().y;
            int x2 = 0;
            while (x2 < groups.size()) {
                List g = (List)groups.get(x2);
                int y = this.getVerticalMinPart((List)g).getFigure().getBounds().y;
                if (y < topY) {
                    top = g;
                    topY = y;
                }
                ++x2;
            }
            limit = reserved + 1;
            int verticalDelta = limit - topY;
            int leftX = this.getHorizontalMinPart((List)top).getFigure().getBounds().x;
            int horizontalDelta = 30 - leftX;
            int x3 = 0;
            while (x3 < top.size()) {
                AbstractGraphicalEditPart p = (AbstractGraphicalEditPart)top.get(x3);
                Rectangle bounds = p.getFigure().getBounds();
                ChangeBoundsCommand cbc = new ChangeBoundsCommand((Node)p.getModel(), new Point(bounds.x + horizontalDelta, bounds.y + verticalDelta), bounds.width);
                this.getCommandStack().execute((Command)cbc);
                p.getFigure().setLocation(new Point(bounds.x + horizontalDelta, bounds.y + verticalDelta));
                ++x3;
            }
            int bottomY = this.getVerticalMaxPart(top).getFigure().getBounds().bottom();
            reserved = bottomY + 40;
            groups.remove(top);
        }
        int next = 30;
        int x4 = 0;
        while (x4 < stragglers.size()) {
            limit = reserved + 1;
            AbstractGraphicalEditPart p = (AbstractGraphicalEditPart)stragglers.get(x4);
            Rectangle bounds = p.getFigure().getBounds();
            ChangeBoundsCommand cbc = new ChangeBoundsCommand((Node)p.getModel(), new Point(next, limit), bounds.width);
            this.getCommandStack().execute((Command)cbc);
            p.getFigure().setLocation(new Point(next, limit));
            next += bounds.width + 30;
            ++x4;
        }
    }

    private AbstractGraphicalEditPart getVerticalMinPart(List parts) {
        AbstractGraphicalEditPart rc = parts.size() > 0 ? (AbstractGraphicalEditPart)parts.get(0) : null;
        int x = 0;
        while (x < parts.size()) {
            AbstractGraphicalEditPart p = (AbstractGraphicalEditPart)parts.get(x);
            if (p.getFigure().getBounds().y < rc.getFigure().getBounds().y) {
                rc = p;
            }
            ++x;
        }
        return rc;
    }

    private AbstractGraphicalEditPart getHorizontalMinPart(List parts) {
        AbstractGraphicalEditPart rc = parts.size() > 0 ? (AbstractGraphicalEditPart)parts.get(0) : null;
        int x = 0;
        while (x < parts.size()) {
            AbstractGraphicalEditPart p = (AbstractGraphicalEditPart)parts.get(x);
            if (p.getFigure().getBounds().x < rc.getFigure().getBounds().x) {
                rc = p;
            }
            ++x;
        }
        return rc;
    }

    private AbstractGraphicalEditPart getVerticalMaxPart(List parts) {
        AbstractGraphicalEditPart rc = parts.size() > 0 ? (AbstractGraphicalEditPart)parts.get(0) : null;
        int x = 0;
        while (x < parts.size()) {
            AbstractGraphicalEditPart p = (AbstractGraphicalEditPart)parts.get(x);
            if (p.getFigure().getBounds().bottom() > rc.getFigure().getBounds().bottom()) {
                rc = p;
            }
            ++x;
        }
        return rc;
    }
}

