/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.authoring.ui.editors;

import java.io.File;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.CommonPlugin;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CommandStackListener;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.epf.authoring.ui.AuthoringUIPlugin;
import org.eclipse.epf.authoring.ui.AuthoringUIResources;
import org.eclipse.epf.authoring.ui.editors.AbstractBaseFormEditor;
import org.eclipse.epf.authoring.ui.editors.MethodElementEditor;
import org.eclipse.epf.authoring.ui.editors.MethodElementEditorInput;
import org.eclipse.epf.authoring.ui.editors.MethodRichTextEditor;
import org.eclipse.epf.authoring.ui.editors.PreviewPage;
import org.eclipse.epf.authoring.ui.forms.ChecklistItemsPage;
import org.eclipse.epf.authoring.ui.forms.ContentElementGuidancePage;
import org.eclipse.epf.authoring.ui.forms.ContentPackageDescriptionPage;
import org.eclipse.epf.authoring.ui.forms.CustomCategoryAssignPage;
import org.eclipse.epf.authoring.ui.forms.CustomCategoryDescriptionPage;
import org.eclipse.epf.authoring.ui.forms.DisciplineDescriptionPage;
import org.eclipse.epf.authoring.ui.forms.DisciplineGroupingDescriptionPage;
import org.eclipse.epf.authoring.ui.forms.DisciplineGroupingDisciplinesPage;
import org.eclipse.epf.authoring.ui.forms.DisciplineReferenceWorkflowPage;
import org.eclipse.epf.authoring.ui.forms.DisciplineTasksPage;
import org.eclipse.epf.authoring.ui.forms.DomainDescriptionPage;
import org.eclipse.epf.authoring.ui.forms.DomainWorkProductsPage;
import org.eclipse.epf.authoring.ui.forms.GuidanceDescriptionPage;
import org.eclipse.epf.authoring.ui.forms.IExtensionFormPage;
import org.eclipse.epf.authoring.ui.forms.IRefreshable;
import org.eclipse.epf.authoring.ui.forms.MethodLibraryDescriptionFormPage;
import org.eclipse.epf.authoring.ui.forms.MethodPluginDescriptionPage;
import org.eclipse.epf.authoring.ui.forms.PracticeDescriptionPage;
import org.eclipse.epf.authoring.ui.forms.PracticeReferencesPage;
import org.eclipse.epf.authoring.ui.forms.RoleCategoriesPage;
import org.eclipse.epf.authoring.ui.forms.RoleDescriptionPage;
import org.eclipse.epf.authoring.ui.forms.RoleSetDescriptionPage;
import org.eclipse.epf.authoring.ui.forms.RoleSetGroupingDescriptionPage;
import org.eclipse.epf.authoring.ui.forms.RoleSetGroupingRoleSets;
import org.eclipse.epf.authoring.ui.forms.RoleSetRolesPage;
import org.eclipse.epf.authoring.ui.forms.RoleWorkProductsPage;
import org.eclipse.epf.authoring.ui.forms.TaskCategoriesPage;
import org.eclipse.epf.authoring.ui.forms.TaskDescriptionPage;
import org.eclipse.epf.authoring.ui.forms.TaskRolesPage;
import org.eclipse.epf.authoring.ui.forms.TaskStepsPage;
import org.eclipse.epf.authoring.ui.forms.TaskWorkProductsPage;
import org.eclipse.epf.authoring.ui.forms.TemplateDescriptionPage;
import org.eclipse.epf.authoring.ui.forms.ToolDescriptionPage;
import org.eclipse.epf.authoring.ui.forms.ToolToolMentorsPage;
import org.eclipse.epf.authoring.ui.forms.WorkProductCategoriesPage;
import org.eclipse.epf.authoring.ui.forms.WorkProductDeliverablePartsPage;
import org.eclipse.epf.authoring.ui.forms.WorkProductDescriptionPage;
import org.eclipse.epf.authoring.ui.forms.WorkProductTypeDescriptionPage;
import org.eclipse.epf.authoring.ui.forms.WorkProductTypeWorkProductsPage;
import org.eclipse.epf.authoring.ui.providers.MethodEditorPageProvider;
import org.eclipse.epf.authoring.ui.richtext.IMethodRichText;
import org.eclipse.epf.authoring.ui.views.ElementHTMLViewer;
import org.eclipse.epf.authoring.ui.views.ViewHelper;
import org.eclipse.epf.common.utils.StrUtil;
import org.eclipse.epf.library.ILibraryManager;
import org.eclipse.epf.library.LibraryService;
import org.eclipse.epf.library.edit.command.ActionManager;
import org.eclipse.epf.library.edit.command.FullyRevertibleCommandStack;
import org.eclipse.epf.library.edit.command.IActionManager;
import org.eclipse.epf.library.edit.command.IResourceAwareCommand;
import org.eclipse.epf.library.edit.ui.UserInteractionHelper;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.library.util.ResourceUtil;
import org.eclipse.epf.library.xmi.XMILibraryUtil;
import org.eclipse.epf.persistence.FileManager;
import org.eclipse.epf.persistence.MultiFileXMIResourceImpl;
import org.eclipse.epf.persistence.refresh.RefreshJob;
import org.eclipse.epf.richtext.IRichText;
import org.eclipse.epf.uma.Checklist;
import org.eclipse.epf.uma.ContentPackage;
import org.eclipse.epf.uma.CustomCategory;
import org.eclipse.epf.uma.Deliverable;
import org.eclipse.epf.uma.Discipline;
import org.eclipse.epf.uma.DisciplineGrouping;
import org.eclipse.epf.uma.Domain;
import org.eclipse.epf.uma.Guidance;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.MethodLibrary;
import org.eclipse.epf.uma.MethodPlugin;
import org.eclipse.epf.uma.Practice;
import org.eclipse.epf.uma.Role;
import org.eclipse.epf.uma.RoleSet;
import org.eclipse.epf.uma.RoleSetGrouping;
import org.eclipse.epf.uma.Task;
import org.eclipse.epf.uma.Template;
import org.eclipse.epf.uma.Tool;
import org.eclipse.epf.uma.WorkProduct;
import org.eclipse.epf.uma.WorkProductType;
import org.eclipse.epf.uma.util.ContentDescriptionFactory;
import org.eclipse.epf.uma.util.IMethodLibraryPersister;
import org.eclipse.epf.uma.util.UmaUtil;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.SWTError;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IPartService;
import org.eclipse.ui.IWindowListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.editor.IFormPage;

public class MethodElementEditor
extends AbstractBaseFormEditor
implements ISelectionProvider {
    public static final String EDITOR_ID;
    protected int preview_page_index = -1;
    protected ElementHTMLViewer previewer = null;
    protected MethodElement elementObj = null;
    protected IMethodRichText modifiedRichText = null;
    protected Adapter nameChangedListener = new AdapterImpl(){

        public void notifyChanged(Notification msg) {
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("org.eclipse.epf.uma.MethodElement");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            switch (msg.getFeatureID((Class)clazz)) {
                case 0: {
                    MethodElementEditor.this.setPartName();
                    if (MethodElementEditor.this.pages == null) break;
                    Iterator iter = MethodElementEditor.this.pages.iterator();
                    while (iter.hasNext()) {
                        Object page = iter.next();
                        if (!(page instanceof IRefreshable)) continue;
                        ((IRefreshable)page).refreshName(MethodElementEditor.this.elementObj.getName());
                    }
                    break;
                }
            }
        }
    };
    protected Collection selectionChangedListeners = new ArrayList();
    protected ISelection currentSelection = StructuredSelection.EMPTY;
    protected ActionManager actionMgr;
    private boolean dirty;
    private IMethodLibraryPersister.FailSafeMethodLibraryPersister persister;
    private Collection resourcesToAdjustLocation = new HashSet();
    private Collection widgetsToRestoreValue = new HashSet();
    private long changeTime = -1L;
    public Object widgetToCheck;
    private Object currentFeatureEditor;
    private EStructuralFeature currentEditedFeature;
    protected ArrayList removedResources = new ArrayList();
    protected ArrayList changedResources = new ArrayList();
    protected IResourceChangeListener resourceChangeListener = new IResourceChangeListener(){

        public void resourceChanged(IResourceChangeEvent event) {
            System.out.println("MethodElementEditor.resourceChanged(): event = " + event);
            if (MethodElementEditor.this.elementObj.eIsProxy()) {
                return;
            }
            IResourceDelta delta = event.getDelta();
            try {
                class ResourceDeltaVisitor
                implements IResourceDeltaVisitor {
                    protected Map URIToUsedResourceMap;
                    protected Collection changedResources;
                    protected Collection removedResources;
                    final /* synthetic */ 2 this$1;

                    ResourceDeltaVisitor(2 var1_1) {
                        this.this$1 = var1_1;
                        this.URIToUsedResourceMap = MethodElementEditor.access$1(2.access$0(var1_1));
                        this.changedResources = new ArrayList<E>();
                        this.removedResources = new ArrayList<E>();
                    }

                    public boolean visit(IResourceDelta delta) {
                        Resource resource;
                        if (delta.getFlags() != 131072 && delta.getResource().getType() == 1 && (delta.getKind() & 6) != 0 && (resource = (Resource)this.URIToUsedResourceMap.get(URI.createFileURI((String)delta.getResource().getLocation().toString()))) != null) {
                            if ((delta.getKind() & 2) != 0) {
                                this.removedResources.add(resource);
                            } else {
                                this.changedResources.add(resource);
                            }
                        }
                        return true;
                    }

                    public Collection getChangedResources() {
                        return this.changedResources;
                    }

                    public Collection getRemovedResources() {
                        return this.removedResources;
                    }
                }
                ResourceDeltaVisitor visitor = new ResourceDeltaVisitor(this);
                delta.accept((IResourceDeltaVisitor)visitor);
                MethodElementEditor.this.removedResources.addAll(visitor.getRemovedResources());
                if (!visitor.getRemovedResources().isEmpty() && !MethodElementEditor.this.isDirty()) {
                    MethodElementEditor.this.getSite().getShell().getDisplay().asyncExec(new Runnable(this){
                        final /* synthetic */ 2 this$1;
                        {
                            this.this$1 = var1_1;
                        }

                        public void run() {
                            2.access$0(this.this$1).dispose();
                        }
                    });
                }
                MethodElementEditor.this.changedResources.addAll(visitor.getChangedResources());
            }
            catch (CoreException e) {
                AuthoringUIPlugin.getDefault().getLogger().logError((Throwable)e);
            }
        }

        static /* synthetic */ MethodElementEditor access$0(2 var0) {
            return var0.MethodElementEditor.this;
        }
    };
    private ActivationListener activationListener;
    private HashMap modificationTimeStampMap;
    private boolean checkFileChangedRequired = false;
    protected HashSet lastUsedResources;
    private boolean disposed;
    private HashMap loadTimeStampMap;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.epf.authoring.ui.editors.MethodElementEditor");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        EDITOR_ID = clazz.getName();
    }

    public MethodElementEditor() {
        this.actionMgr = new ActionManager(){

            protected FullyRevertibleCommandStack createCommandStack() {
                return new FullyRevertibleCommandStack(this, this){
                    final /* synthetic */ 5 this$1;
                    {
                        this.this$1 = var1_1;
                    }

                    public boolean doExecute(Command command) {
                        boolean ret;
                        if (command instanceof IResourceAwareCommand) {
                            IStatus status;
                            Collection modifiedResources = ((IResourceAwareCommand)command).getModifiedResources();
                            if (modifiedResources != null && !modifiedResources.isEmpty() && !(status = UserInteractionHelper.checkModify((Collection)modifiedResources, (Shell)5.access$0(this.this$1).getSite().getShell())).isOK()) {
                                5.access$0(this.this$1).handleError(status);
                                return false;
                            }
                        } else {
                            IStatus status;
                            EObject owner = TngUtil.getOwner((Command)command);
                            if (owner != null && !(status = TngUtil.checkEdit((EObject)owner, (Object)5.access$0(this.this$1).getSite().getShell())).isOK()) {
                                AuthoringUIPlugin.getDefault().getMsgDialog().display(AuthoringUIResources.errorDialog_title, AuthoringUIResources.editDialog_msgCannotEdit, status);
                                return false;
                            }
                        }
                        if (MethodElementEditor.access$9(5.access$0(this.this$1)) == -1L) {
                            MethodElementEditor.access$10(5.access$0(this.this$1), System.currentTimeMillis());
                        }
                        if (!(ret = super.doExecute(command)) && MethodElementEditor.access$9(5.access$0(this.this$1)) != -1L) {
                            MethodElementEditor.access$10(5.access$0(this.this$1), -1L);
                        }
                        return ret;
                    }
                };
            }

            public boolean doAction(int actionType, EObject object, EStructuralFeature feature, Object value, int index) {
                IStatus status = TngUtil.checkEdit((EObject)object, (Object)MethodElementEditor.this.getSite().getShell());
                if (status.isOK()) {
                    return super.doAction(actionType, object, feature, value, index);
                }
                AuthoringUIPlugin.getDefault().getMsgDialog().displayError(AuthoringUIResources.editDialog_title, AuthoringUIResources.editDialog_msgCannotEdit, status);
                return false;
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            protected void save(Resource resource) {
                if (MethodElementEditor.this.changedResources.contains(resource)) {
                    return;
                }
                File file = new File(resource.getURI().toFileString());
                try {
                    if (file.lastModified() > MethodElementEditor.this.changeTime) {
                        IMethodLibraryPersister.FailSafeMethodLibraryPersister persister = MethodElementEditor.this.getPersister();
                        try {
                            persister.save(resource);
                            persister.commit();
                        }
                        catch (Exception e) {
                            AuthoringUIPlugin.getDefault().getLogger().logError((Throwable)e);
                            try {
                                persister.rollback();
                            }
                            catch (Exception exception) {
                                ViewHelper.reloadCurrentLibaryOnRollbackError(MethodElementEditor.this.getEditorSite().getShell());
                            }
                        }
                    }
                    Object var5_7 = null;
                }
                catch (Throwable throwable) {
                    Object var5_6 = null;
                    MethodElementEditor.this.changeTime = -1L;
                    throw throwable;
                }
                MethodElementEditor.this.changeTime = -1L;
            }

            static /* synthetic */ MethodElementEditor access$0(5 var0) {
                return var0.MethodElementEditor.this;
            }
        };
        this.actionMgr.getCommandStack().addCommandStackListener(new CommandStackListener(){

            public void commandStackChanged(EventObject event) {
                MethodElementEditor.this.firePropertyChange(257);
            }
        });
        ILibraryManager manager = LibraryService.getInstance().getCurrentLibraryManager();
        if (manager != null) {
            manager.startListeningTo(this.actionMgr.getCommandStack());
        }
    }

    public IActionManager getActionManager() {
        return this.actionMgr;
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        this.setSite((IWorkbenchPartSite)site);
        this.setInput(input);
        site.setSelectionProvider((ISelectionProvider)this);
        this.activationListener = new ActivationListener(site.getWorkbenchWindow().getPartService());
    }

    protected void setInput(IEditorInput input) {
        super.setInput(input);
        MethodElementEditorInput methodElementInput = (MethodElementEditorInput)input;
        this.elementObj = methodElementInput.getMethodElement();
        this.setPartName();
        this.elementObj.eAdapters().add((Object)this.nameChangedListener);
    }

    private void updateTimeStamps(Collection usedResources) {
        this.updateModificationTimeStampMap(usedResources);
        this.updateLoadTimeStampMap(usedResources);
    }

    private void updateModificationTimeStampMap(Collection usedResources) {
        if (this.modificationTimeStampMap == null) {
            this.modificationTimeStampMap = new HashMap();
        } else {
            this.modificationTimeStampMap.clear();
        }
        Iterator iter = usedResources.iterator();
        while (iter.hasNext()) {
            Resource resource = (Resource)iter.next();
            this.modificationTimeStampMap.put(resource, new Long(new File(resource.getURI().toFileString()).lastModified()));
        }
        this.checkFileChangedRequired = true;
    }

    private void updateLoadTimeStampMap(Collection usedResources) {
        if (this.loadTimeStampMap == null) {
            this.loadTimeStampMap = new HashMap();
        } else {
            this.loadTimeStampMap.clear();
        }
        Iterator iter = usedResources.iterator();
        while (iter.hasNext()) {
            MultiFileXMIResourceImpl resource = (MultiFileXMIResourceImpl)iter.next();
            this.loadTimeStampMap.put(resource, new Long(resource.getLastLoadTimeStamp()));
        }
    }

    private boolean checkReloaded(Collection usedResources) {
        Iterator iter = usedResources.iterator();
        while (iter.hasNext()) {
            IResource wsRes;
            MultiFileXMIResourceImpl resource = (MultiFileXMIResourceImpl)iter.next();
            Long oldTime = (Long)this.loadTimeStampMap.get(resource);
            long currentTime = resource.getLastLoadTimeStamp();
            if (oldTime == null || oldTime == currentTime || (wsRes = FileManager.getResourceForLocation((String)resource.getURI().toFileString())) == null) continue;
            return true;
        }
        return false;
    }

    private boolean checkFileChanged(Collection usedResources) {
        Iterator iter = usedResources.iterator();
        while (iter.hasNext()) {
            IResource wsRes;
            Resource resource = (Resource)iter.next();
            String filePath = resource.getURI().toFileString();
            Long oldTime = (Long)this.modificationTimeStampMap.get(resource);
            boolean checkForSynch = false;
            if (oldTime == null) {
                checkForSynch = true;
            } else {
                File file = new File(filePath);
                if (!file.exists()) {
                    return true;
                }
                long currentTime = file.lastModified();
                boolean bl = checkForSynch = oldTime != currentTime;
            }
            if (!checkForSynch || (wsRes = FileManager.getResourceForLocation((String)filePath)) == null || wsRes.isSynchronized(0)) continue;
            return true;
        }
        return false;
    }

    protected boolean promptReloadFiles() {
        String title = AuthoringUIResources.editor_error_activated_outofsync_title;
        String msg = AuthoringUIResources.editor_error_activated_outofsync_message;
        return AuthoringUIPlugin.getDefault().getMsgDialog().displayPrompt(title, msg);
    }

    private boolean handleFileChanged(final Collection usedResources) {
        boolean ret = this.promptReloadFiles();
        if (ret) {
            IRunnableWithProgress runnable = new IRunnableWithProgress(){

                /*
                 * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    monitor.beginTask("", 10);
                    monitor.subTask(AuthoringUIResources.refresh_text);
                    monitor.worked(1);
                    try {
                        ArrayList<Resource> removedResources = new ArrayList<Resource>();
                        Iterator iter = usedResources.iterator();
                        while (true) {
                            if (!iter.hasNext()) break;
                            Resource resource = (Resource)iter.next();
                            if (new File(resource.getURI().toFileString()).exists()) continue;
                            removedResources.add(resource);
                        }
                        Collection changedResources = ResourceUtil.getOutOfSynchResources((Collection)usedResources);
                        monitor.worked(2);
                        Iterator iter2 = removedResources.iterator();
                        while (true) {
                            if (!iter2.hasNext()) {
                                monitor.worked(2);
                                ILibraryManager manager = LibraryService.getInstance().getCurrentLibraryManager();
                                if (manager != null) {
                                    Collection reloadedResources = manager.reloadResources(changedResources);
                                    if (!reloadedResources.isEmpty()) {
                                        RefreshJob.getInstance().getReloadedBeforeRefreshResources().addAll(reloadedResources);
                                    }
                                    if (!removedResources.isEmpty() || !reloadedResources.isEmpty()) {
                                        MethodElementEditor.this.changedResources.addAll(reloadedResources);
                                        MethodElementEditor.this.refresh(true);
                                        MethodElementEditor.this.changedResources.clear();
                                    }
                                }
                                break;
                            }
                            MultiFileXMIResourceImpl resource = (MultiFileXMIResourceImpl)iter2.next();
                            try {
                                resource.unloadWithoutRemove();
                            }
                            catch (Exception e) {
                                CommonPlugin.INSTANCE.log((Object)e);
                            }
                        }
                        monitor.worked(4);
                        Iterator iter3 = changedResources.iterator();
                        while (true) {
                            block12: {
                                if (iter3.hasNext()) break block12;
                                monitor.worked(1);
                                break;
                            }
                            FileManager.getInstance().refresh((Resource)iter3.next());
                        }
                    }
                    catch (Throwable throwable) {
                        Object var7_8 = null;
                        monitor.done();
                        throw throwable;
                    }
                    {
                        Object var7_9 = null;
                    }
                    monitor.done();
                }
            };
            try {
                this.getSite().getWorkbenchWindow().getWorkbench().getProgressService().runInUI((IRunnableContext)new ProgressMonitorDialog(this.getSite().getShell()), runnable, null);
            }
            catch (Exception e) {
                AuthoringUIPlugin.getDefault().getLogger().logError((Throwable)e);
                String title = AuthoringUIResources.ProcessEditor_refreshErrorTitle;
                AuthoringUIPlugin.getDefault().getMsgDialog().displayError(title, e.toString(), (Throwable)e);
            }
        } else {
            this.checkFileChangedRequired = false;
        }
        return ret;
    }

    public void setPartName() {
        String partName = this.elementObj.getName();
        if (partName == null) {
            partName = "";
        }
        this.setPartName(partName);
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionChangedListeners.add(listener);
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionChangedListeners.remove(listener);
    }

    public ISelection getSelection() {
        return this.currentSelection;
    }

    public void setSelection(ISelection selection) {
        this.currentSelection = selection;
        Iterator listeners = new ArrayList(this.selectionChangedListeners).iterator();
        while (listeners.hasNext()) {
            ISelectionChangedListener listener = (ISelectionChangedListener)listeners.next();
            listener.selectionChanged(new SelectionChangedEvent((ISelectionProvider)this, selection));
        }
    }

    protected void addPages() {
        block44: {
            try {
                List pageProviders;
                if (this.elementObj instanceof MethodLibrary) {
                    this.addPage((IFormPage)new MethodLibraryDescriptionFormPage(this));
                } else if (this.elementObj instanceof MethodPlugin) {
                    this.addPage((IFormPage)new MethodPluginDescriptionPage(this));
                } else if (this.elementObj instanceof ContentPackage) {
                    this.addPage((IFormPage)new ContentPackageDescriptionPage(this));
                } else if (this.elementObj instanceof Role) {
                    this.addPage((IFormPage)new RoleDescriptionPage(this));
                    this.addPage((IFormPage)new RoleWorkProductsPage(this));
                    this.addPage((IFormPage)new ContentElementGuidancePage(this));
                    this.addPage((IFormPage)new RoleCategoriesPage(this));
                } else if (this.elementObj instanceof Task) {
                    this.addPage((IFormPage)new TaskDescriptionPage(this));
                    this.addPage((IFormPage)new TaskStepsPage(this));
                    this.addPage((IFormPage)new TaskRolesPage(this));
                    this.addPage((IFormPage)new TaskWorkProductsPage(this));
                    this.addPage((IFormPage)new ContentElementGuidancePage(this));
                    this.addPage((IFormPage)new TaskCategoriesPage(this));
                } else if (this.elementObj instanceof WorkProduct) {
                    this.addPage((IFormPage)new WorkProductDescriptionPage(this));
                    if (this.elementObj instanceof Deliverable) {
                        this.addPage((IFormPage)new WorkProductDeliverablePartsPage(this));
                    }
                    this.addPage((IFormPage)new ContentElementGuidancePage(this));
                    this.addPage((IFormPage)new WorkProductCategoriesPage(this));
                } else if (this.elementObj instanceof Guidance) {
                    if (this.elementObj instanceof Template) {
                        this.addPage((IFormPage)new TemplateDescriptionPage(this));
                    } else if (this.elementObj instanceof Practice) {
                        this.addPage((IFormPage)new PracticeDescriptionPage(this));
                        this.addPage((IFormPage)new PracticeReferencesPage(this));
                    } else if (this.elementObj instanceof Checklist) {
                        this.addPage((IFormPage)new GuidanceDescriptionPage(this));
                        this.addPage((IFormPage)new ChecklistItemsPage(this));
                    } else {
                        this.addPage((IFormPage)new GuidanceDescriptionPage(this));
                    }
                    if (!(this.elementObj instanceof Practice)) {
                        this.addPage((IFormPage)new ContentElementGuidancePage(this));
                    }
                } else if (this.elementObj instanceof Discipline) {
                    this.addPage((IFormPage)new DisciplineDescriptionPage(this));
                    this.addPage((IFormPage)new DisciplineTasksPage(this));
                    this.addPage((IFormPage)new DisciplineReferenceWorkflowPage(this));
                    this.addPage((IFormPage)new ContentElementGuidancePage(this));
                } else if (this.elementObj instanceof DisciplineGrouping) {
                    this.addPage((IFormPage)new DisciplineGroupingDescriptionPage(this));
                    this.addPage((IFormPage)new DisciplineGroupingDisciplinesPage(this));
                } else if (this.elementObj instanceof Domain) {
                    this.addPage((IFormPage)new DomainDescriptionPage(this));
                    this.addPage((IFormPage)new DomainWorkProductsPage(this));
                    this.addPage((IFormPage)new ContentElementGuidancePage(this));
                } else if (this.elementObj instanceof WorkProductType) {
                    this.addPage((IFormPage)new WorkProductTypeDescriptionPage(this));
                    this.addPage((IFormPage)new WorkProductTypeWorkProductsPage(this));
                    this.addPage((IFormPage)new ContentElementGuidancePage(this));
                } else if (this.elementObj instanceof RoleSet) {
                    this.addPage((IFormPage)new RoleSetDescriptionPage(this));
                    this.addPage((IFormPage)new RoleSetRolesPage(this));
                    this.addPage((IFormPage)new ContentElementGuidancePage(this));
                } else if (this.elementObj instanceof RoleSetGrouping) {
                    this.addPage((IFormPage)new RoleSetGroupingDescriptionPage(this));
                    this.addPage((IFormPage)new RoleSetGroupingRoleSets(this));
                } else if (this.elementObj instanceof Tool) {
                    this.addPage((IFormPage)new ToolDescriptionPage(this));
                    this.addPage((IFormPage)new ToolToolMentorsPage(this));
                    this.addPage((IFormPage)new ContentElementGuidancePage(this));
                } else if (this.elementObj instanceof CustomCategory) {
                    this.addPage((IFormPage)new CustomCategoryDescriptionPage(this));
                    this.addPage((IFormPage)new CustomCategoryAssignPage(this));
                }
                this.setPartName(this.elementObj.getName());
                AdapterFactoryLabelProvider labelProvider = new AdapterFactoryLabelProvider((AdapterFactory)TngUtil.umaItemProviderAdapterFactory);
                Image titleImage = labelProvider.getImage((Object)this.elementObj);
                labelProvider.dispose();
                this.setTitleImage(titleImage);
                if (!(this.elementObj instanceof ContentPackage) && !(this.elementObj instanceof MethodPlugin)) {
                    this.createPreviewPage();
                }
                if (!(this.elementObj instanceof Task) || (pageProviders = MethodEditorPageProvider.getInstance().getPageProviders()) == null || pageProviders.size() <= 0) break block44;
                try {
                    int i = 0;
                    while (i < pageProviders.size()) {
                        Object page = pageProviders.get(i);
                        if (page instanceof IExtensionFormPage) {
                            IExtensionFormPage formPage = (IExtensionFormPage)page;
                            formPage.setEditor(this);
                        }
                        ++i;
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            catch (Throwable t) {
                t.printStackTrace();
                this.dispose();
                throw (SWTError)t;
            }
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void dispose() {
        try {
            if (this.activationListener != null) {
                this.activationListener.dispose();
            }
            this.modifiedRichText = null;
            ILibraryManager manager = LibraryService.getInstance().getCurrentLibraryManager();
            if (manager != null) {
                manager.stopListeningTo(this.actionMgr.getCommandStack());
            }
            if (this.isDirty()) {
                this.actionMgr.undoAll();
            }
            this.actionMgr.dispose();
            this.elementObj.eAdapters().remove((Object)this.nameChangedListener);
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            super.dispose();
            this.disposed = true;
            throw throwable;
        }
        {
            Object var2_4 = null;
            super.dispose();
            this.disposed = true;
            return;
        }
    }

    public boolean isDirty() {
        if (this.dirty) {
            return true;
        }
        this.dirty = this.actionMgr.isSaveNeeded();
        return this.dirty;
    }

    public IMethodLibraryPersister.FailSafeMethodLibraryPersister getPersister() {
        if (this.persister == null) {
            this.persister = ContentDescriptionFactory.getMethodLibraryPersister().getFailSafePersister();
        }
        return this.persister;
    }

    protected Collection getModifiedResources() {
        return this.actionMgr.getModifiedResources();
    }

    public void setModifiedRichText(IMethodRichText modifiedRichText) {
        this.modifiedRichText = modifiedRichText;
    }

    public void saveModifiedRichText(IMethodRichText richText) {
        if (richText != null && !richText.isDisposed() && richText.getModified()) {
            String newContent;
            Object oldContent;
            EObject modalObject = richText.getModalObject();
            EStructuralFeature modalObjectFeature = richText.getModalObjectFeature();
            if (modalObject != null && modalObjectFeature != null && !this.mustRestoreValue(richText, oldContent = modalObject.eGet(modalObjectFeature)) && !(newContent = richText.getText()).equals(oldContent)) {
                this.actionMgr.doAction(1, modalObject, modalObjectFeature, (Object)newContent, -1);
            }
        }
    }

    public void saveModifiedRichText() {
        this.saveModifiedRichText(this.modifiedRichText);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void doSave(IProgressMonitor monitor) {
        if (DEBUG) {
            System.out.println("MethodElementEditor.doSave: saving changes to method library");
        }
        this.saveModifiedRichText(this.modifiedRichText);
        this.getPersister();
        try {
            String reason;
            block22: {
                String msg;
                Iterator iter;
                StringBuffer fileList;
                String template;
                String title;
                Collection modifiedResources = this.getModifiedResources();
                IStatus status = UserInteractionHelper.checkModify((Collection)modifiedResources, (Shell)this.getSite().getShell());
                if (!status.isOK()) {
                    this.handleError(status);
                    return;
                }
                if (this.checkFileChanged(modifiedResources)) {
                    String title2 = AuthoringUIResources.editor_error_activated_outofsync_title;
                    String msg2 = AuthoringUIResources.editor_error_activated_outofsync_message;
                    if (!AuthoringUIPlugin.getDefault().getMsgDialog().displayPrompt(title2, msg2)) {
                        return;
                    }
                }
                Iterator iter2 = modifiedResources.iterator();
                while (true) {
                    if (!iter2.hasNext()) {
                        try {
                            this.persister.commit();
                            this.dirty = false;
                            this.actionMgr.saveIsDone();
                            this.changeTime = -1L;
                            this.updateTimeStamps(this.getUsedResources());
                            break;
                        }
                        catch (Exception e) {
                            reason = e.getMessage();
                            if (StrUtil.isBlank((String)reason)) {
                                reason = AuthoringUIResources.editors_MethodElementEditor_saveErrorReason2;
                            }
                            StringWriter details = new StringWriter();
                            e.printStackTrace(new PrintWriter(details));
                            String title3 = AuthoringUIResources.editors_MethodElementEditor_saveErrorTitle;
                            String message = AuthoringUIResources.editors_MethodElementEditor_saveErrorMessage2;
                            AuthoringUIPlugin.getDefault().getMsgDialog().displayError(title3, message, reason, details.toString(), (Throwable)e);
                            throw e;
                        }
                    }
                    Resource resource = (Resource)iter2.next();
                    try {
                        this.persister.save(resource);
                    }
                    catch (Exception e) {
                        String title4 = AuthoringUIResources.editors_MethodElementEditor_saveErrorTitle;
                        String msg3 = AuthoringUIResources.editors_MethodElementEditor_saveErrorMessage1;
                        String reason2 = e.getMessage() == null ? AuthoringUIResources.editors_MethodElementEditor_saveErrorReason1 : e.getMessage();
                        AuthoringUIPlugin.getDefault().getMsgDialog().displayError(title4, msg3, reason2, (Throwable)e);
                        throw e;
                    }
                }
                if (this.resourcesToAdjustLocation.isEmpty()) return;
                try {
                    this.persister.adjustLocation(this.resourcesToAdjustLocation);
                    break block22;
                }
                catch (Exception e) {
                    title = AuthoringUIResources.editors_MethodElementEditor_renameErrorTitle;
                    template = AuthoringUIResources.editors_MethodElementEditor_renameErrorMessage1;
                    fileList = new StringBuffer();
                    iter = this.resourcesToAdjustLocation.iterator();
                }
                while (true) {
                    if (!iter.hasNext()) {
                        msg = MessageFormat.format(template, fileList);
                    }
                    Resource resource = (Resource)iter.next();
                    fileList.append(resource.getURI().toFileString()).append(", ");
                }
                String reason3 = e.getMessage() == null ? AuthoringUIResources.editors_MethodElementEditor_saveErrorReason1 : e.getMessage();
                AuthoringUIPlugin.getDefault().getMsgDialog().displayError(title, msg, reason3, (Throwable)e);
                throw e;
            }
            try {
                this.persister.commit();
            }
            catch (Exception e) {
                reason = e.getMessage();
                if (StrUtil.isBlank((String)reason)) {
                    reason = AuthoringUIResources.editors_MethodElementEditor_saveErrorReason2;
                }
                StringWriter details = new StringWriter();
                e.printStackTrace(new PrintWriter(details));
                String title = AuthoringUIResources.editors_MethodElementEditor_renameErrorTitle;
                String message = AuthoringUIResources.editors_MethodElementEditor_saveErrorMessage2;
                AuthoringUIPlugin.getDefault().getMsgDialog().displayError(title, message, reason, details.toString(), (Throwable)e);
                throw e;
            }
            this.resourcesToAdjustLocation.clear();
            return;
        }
        catch (Exception exception) {
            try {
                this.persister.rollback();
                return;
            }
            catch (Exception ex) {
                AuthoringUIPlugin.getDefault().getLogger().logError((Throwable)ex);
                ViewHelper.reloadCurrentLibaryOnRollbackError(this.getSite().getShell());
            }
        }
    }

    protected void saveResource(Resource resource) {
        if (resource != null && resource.isModified()) {
            try {
                this.getPersister().save(resource);
            }
            catch (Exception e) {
                String title = AuthoringUIResources.editors_MethodElementEditor_saveErrorTitle;
                String template = AuthoringUIResources.editors_MethodElementEditor_saveErrorMessage1;
                String msg = MessageFormat.format(template, resource.getURI().toFileString());
                String reason = e.getMessage() == null ? AuthoringUIResources.editors_MethodElementEditor_saveErrorReason1 : e.getMessage();
                AuthoringUIPlugin.getDefault().getMsgDialog().displayError(title, msg, reason, (Throwable)e);
            }
        }
    }

    protected void createPreviewPage() {
        Composite parent = this.getContainer();
        Composite previewComposite = new Composite(parent, 0);
        previewComposite.setLayout((Layout)new GridLayout());
        PreviewPage page = new PreviewPage(previewComposite);
        this.previewer = page.getPreviewViewer();
        this.preview_page_index = this.addPage((Control)previewComposite);
        this.setPageText(this.preview_page_index, AuthoringUIResources.previewPage_title);
    }

    protected void pageChange(int newPageIndex) {
        super.pageChange(newPageIndex);
        if (this.preview_page_index == newPageIndex && this.previewer != null) {
            this.previewer.setLayoutManager(null);
            this.previewer.showElementContent(this.elementObj);
        }
    }

    private void setDirty() {
        this.dirty = true;
        this.firePropertyChange(257);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean mustRestoreValue(Object control, Object value) {
        boolean restore;
        if (this.widgetToCheck == control) {
            return true;
        }
        Object editControl = control;
        if (editControl instanceof MethodRichTextEditor) {
            editControl = ((MethodRichTextEditor)control).getRichTextControl();
        }
        if (!(restore = this.widgetsToRestoreValue.contains(editControl))) {
            Collection collection = this.widgetsToRestoreValue;
            synchronized (collection) {
                restore = this.widgetsToRestoreValue.contains(editControl);
            }
        }
        if (restore) {
            if (editControl instanceof Text) {
                Text text = (Text)editControl;
                text.setText((String)value);
            } else if (editControl instanceof IMethodRichText) {
                IMethodRichText richText = (IMethodRichText)editControl;
                richText.setText((String)value);
            }
            this.widgetsToRestoreValue.remove(editControl);
        }
        return restore;
    }

    public ModifyListener createModifyListener(EObject eObj) {
        return this.createModifyListener(eObj, false);
    }

    public ModifyListener createModifyListener(EObject eObj, boolean checkContainer) {
        return new ModifyListener(eObj, checkContainer);
    }

    public void setCurrentFeatureEditor(Object control, EStructuralFeature feature) {
        this.currentFeatureEditor = control;
        this.currentEditedFeature = feature;
    }

    protected void monitorChange() {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint point = registry.getExtensionPoint("org.eclipse.core.resources.refreshProviders");
        if (point == null) {
            return;
        }
        IExtension[] extensions = point.getExtensions();
        int i = 0;
        while (i < extensions.length) {
            IExtension extension = extensions[i];
            if (DEBUG) {
                System.out.println("extension: UID=" + extension.getUniqueIdentifier() + ", " + extension);
            }
            ++i;
        }
    }

    public void addResourceToAdjustLocation(Resource resource) {
        this.resourcesToAdjustLocation.add(resource);
    }

    protected List getUsedFeatures() {
        return this.elementObj.eClass().getEAllStructuralFeatures();
    }

    public Collection getUsedResources() {
        HashSet<Resource> resources = new HashSet<Resource>();
        Resource resource = this.elementObj.eResource();
        if (resource != null) {
            resources.add(resource);
        }
        List allFeatures = this.getUsedFeatures();
        int i = allFeatures.size() - 1;
        while (i > -1) {
            EStructuralFeature feature = (EStructuralFeature)allFeatures.get(i);
            if (feature.isMany()) {
                List values = (List)this.elementObj.eGet(feature);
                int j = values.size() - 1;
                while (j > -1) {
                    EObject value = (EObject)values.get(j);
                    if (value.eResource() != null) {
                        resources.add(value.eResource());
                    }
                    --j;
                }
            } else {
                Object value = this.elementObj.eGet(feature);
                if (value instanceof EObject && (resource = ((EObject)value).eResource()) != null) {
                    resources.add(resource);
                }
            }
            --i;
        }
        this.lastUsedResources = resources;
        return resources;
    }

    private Map getURIToUsedResourceMap() {
        HashMap<URI, Resource> map = new HashMap<URI, Resource>();
        Iterator iter = this.getUsedResources().iterator();
        while (iter.hasNext()) {
            Resource resource = (Resource)iter.next();
            map.put(resource.getURI(), resource);
        }
        return map;
    }

    protected void handleError(IStatus status) {
        AuthoringUIPlugin.getDefault().getMsgDialog().display(AuthoringUIResources.errorDialog_title, AuthoringUIResources.editDialog_msgCannotEdit, status);
    }

    protected void handleActivate(IWorkbenchPart part) {
        Collection usedResources;
        XMILibraryUtil.openMethodLibraryProject((MethodLibrary)LibraryService.getInstance().getCurrentMethodLibrary(), (IProgressMonitor)this.getEditorSite().getActionBars().getStatusLineManager().getProgressMonitor());
        if (this.checkFileChangedRequired && this.checkFileChanged(usedResources = this.getUsedResources())) {
            this.handleFileChanged(usedResources);
        }
    }

    protected boolean handleDirtyConflict() {
        String title = AuthoringUIResources._UI_FileConflict_label;
        String msg = AuthoringUIResources._WARN_FileConflict;
        return AuthoringUIPlugin.getDefault().getMsgDialog().displayPrompt(title, msg);
    }

    protected void handleChangedResources() {
        if ((this.elementObj.eIsProxy() || !this.changedResources.isEmpty()) && this.isDirty()) {
            this.handleDirtyConflict();
        }
    }

    public boolean isInputValid() {
        if (this.elementObj != null && this.elementObj.eIsProxy()) {
            EObject e = RefreshJob.getInstance().resolve((EObject)this.elementObj);
            return e instanceof MethodElement && !e.eIsProxy() && UmaUtil.getMethodLibrary((EObject)e) == LibraryService.getInstance().getCurrentMethodLibrary();
        }
        return true;
    }

    protected void updatePages() {
        while (this.getPageCount() > 0) {
            this.removePage(0);
        }
        this.addPages();
    }

    protected MethodElementEditorInput createInput(MethodElement e) {
        return new MethodElementEditorInput(e);
    }

    public synchronized void refresh(final boolean force) {
        BusyIndicator.showWhile((Display)this.getSite().getShell().getDisplay(), (Runnable)new Runnable(){

            public void run() {
                HashSet usedResources = MethodElementEditor.this.lastUsedResources;
                if (!(force || MethodElementEditor.this.elementObj.eIsProxy() || MethodElementEditor.this.checkReloaded(usedResources))) {
                    return;
                }
                int activePageIndex = MethodElementEditor.this.getActivePage();
                MethodElementEditor.this.modifiedRichText = null;
                if (MethodElementEditor.this.isDirty()) {
                    MethodElementEditor.this.actionMgr.undoAll();
                    MethodElementEditor.this.dirty = false;
                }
                if (MethodElementEditor.this.elementObj.eIsProxy()) {
                    MethodElementEditor.this.elementObj.eAdapters().remove((Object)MethodElementEditor.this.nameChangedListener);
                    EObject e = RefreshJob.getInstance().resolve((EObject)MethodElementEditor.this.elementObj);
                    if (e instanceof MethodElement && !e.eIsProxy() && UmaUtil.getMethodLibrary((EObject)e) == LibraryService.getInstance().getCurrentMethodLibrary()) {
                        MethodElementEditor.this.setInput(MethodElementEditor.this.createInput((MethodElement)e));
                    } else {
                        MethodElementEditor.this.close(false);
                        return;
                    }
                }
                MethodElementEditor.this.updateTimeStamps(usedResources);
                MethodElementEditor.this.updatePages();
                if (activePageIndex != -1) {
                    MethodElementEditor.this.setActivePage(activePageIndex);
                }
                MethodElementEditor.this.firePropertyChange(257);
            }
        });
    }

    public void refresh() {
        this.changedResources.addAll(RefreshJob.getInstance().getChangedResources());
        this.refresh(false);
        this.changedResources.clear();
    }

    static /* synthetic */ Map access$1(MethodElementEditor methodElementEditor) {
        return methodElementEditor.getURIToUsedResourceMap();
    }

    class ActivationListener
    implements IPartListener,
    IWindowListener {
        private IWorkbenchPart fActivePart;
        private boolean fIsHandlingActivation = false;
        private IPartService fPartService;

        public ActivationListener(IPartService partService) {
            this.fPartService = partService;
            this.fPartService.addPartListener((IPartListener)this);
            PlatformUI.getWorkbench().addWindowListener((IWindowListener)this);
        }

        public void dispose() {
            this.fPartService.removePartListener((IPartListener)this);
            PlatformUI.getWorkbench().removeWindowListener((IWindowListener)this);
            this.fPartService = null;
        }

        public void partActivated(IWorkbenchPart part) {
            this.fActivePart = part;
            this.handleActivation();
        }

        public void partBroughtToTop(IWorkbenchPart part) {
        }

        public void partClosed(IWorkbenchPart part) {
        }

        public void partDeactivated(IWorkbenchPart part) {
            this.fActivePart = null;
        }

        public void partOpened(IWorkbenchPart part) {
            if (part == MethodElementEditor.this) {
                if (!MethodElementEditor.this.isInputValid()) {
                    AuthoringUIPlugin.getDefault().getMsgDialog().displayInfo(AuthoringUIResources.editors_MethodElementEditor_invalidEditorTitle, AuthoringUIResources.editors_MethodElementEditor_invalidEditorMsg);
                    MethodElementEditor.this.close(false);
                    return;
                }
                Collection usedResources = MethodElementEditor.this.getUsedResources();
                if (ResourceUtil.hasOutOfSynch((Collection)usedResources)) {
                    MethodElementEditor.this.handleFileChanged(usedResources);
                    return;
                }
                MethodElementEditor.this.updateTimeStamps(usedResources);
            }
        }

        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private void handleActivation() {
            if (this.fIsHandlingActivation) return;
            if (MethodElementEditor.this.disposed) {
                return;
            }
            if (this.fActivePart != MethodElementEditor.this) return;
            this.fIsHandlingActivation = true;
            try {
                MethodElementEditor.this.handleActivate(this.fActivePart);
            }
            catch (Throwable throwable) {
                Object var1_2 = null;
                this.fIsHandlingActivation = false;
                throw throwable;
            }
            {
                Object var1_3 = null;
                this.fIsHandlingActivation = false;
                return;
            }
        }

        public void windowActivated(IWorkbenchWindow window) {
            if (window == MethodElementEditor.this.getEditorSite().getWorkbenchWindow()) {
                window.getShell().getDisplay().asyncExec(new Runnable(this){
                    final /* synthetic */ ActivationListener this$1;
                    {
                        this.this$1 = activationListener;
                    }

                    public void run() {
                        ActivationListener.access$0(this.this$1);
                    }
                });
            }
        }

        public void windowDeactivated(IWorkbenchWindow window) {
        }

        public void windowClosed(IWorkbenchWindow window) {
        }

        public void windowOpened(IWorkbenchWindow window) {
        }

        static /* synthetic */ void access$0(ActivationListener activationListener) {
            activationListener.handleActivation();
        }
    }

    public class ModifyListener
    implements org.eclipse.swt.events.ModifyListener {
        private EObject element;
        private boolean checkContainerResource;
        private boolean disabled = false;

        public ModifyListener(EObject element, boolean checkContainer) {
            this.checkContainerResource = checkContainer;
            this.element = element;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private void restoreText(Object control, String txt) {
            boolean old = this.disabled;
            try {
                this.disabled = true;
                Object editControl = control;
                if (editControl instanceof MethodRichTextEditor) {
                    editControl = ((MethodRichTextEditor)control).getRichTextControl();
                }
                if (editControl instanceof Text) {
                    Text text = (Text)editControl;
                    text.setText(txt);
                } else if (editControl instanceof IMethodRichText) {
                    IMethodRichText richText = (IMethodRichText)editControl;
                    richText.setText(txt);
                }
                Object var6_9 = null;
                this.disabled = old;
                return;
            }
            catch (Throwable throwable) {
                Object var6_8 = null;
                this.disabled = old;
                throw throwable;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private boolean checkEdit(EObject element, Object control, boolean checkContainerResource) {
            MethodElementEditor.this.widgetToCheck = control;
            try {
                block27: {
                    block22: {
                        IStatus status;
                        block26: {
                            block23: {
                                if (DEBUG) {
                                    System.out.println("MethodElementEditor.checkEdit: enter, control=" + control);
                                }
                                status = null;
                                if (!MethodElementEditor.this.widgetsToRestoreValue.contains(control)) break block23;
                                if (DEBUG) {
                                    System.out.println("MethodElementEditor.checkEdit: widget found in widgetsToRestoreValue, exit");
                                }
                                break block22;
                            }
                            Collection collection = MethodElementEditor.this.widgetsToRestoreValue;
                            synchronized (collection) {
                                block24: {
                                    block25: {
                                        if (MethodElementEditor.this.widgetsToRestoreValue.contains(control)) {
                                            if (DEBUG) {
                                                System.out.println("MethodElementEditor.checkEdit: widget found in widgetsToRestoreValue, exit");
                                            }
                                            break block22;
                                        }
                                        status = TngUtil.checkEdit((EObject)element, (Object)MethodElementEditor.this.getSite().getShell());
                                        if (status.isOK()) break block24;
                                        if (!(control instanceof IRichText)) break block25;
                                        ((IRichText)control).restoreText();
                                        break block26;
                                    }
                                    if (control == MethodElementEditor.this.currentFeatureEditor) {
                                        this.restoreText(control, (String)element.eGet(MethodElementEditor.this.currentEditedFeature));
                                        break block26;
                                    } else {
                                        MethodElementEditor.this.widgetsToRestoreValue.add(control);
                                        if (DEBUG) {
                                            System.out.println("MethodElementEditor.checkEdit: added widget to widgetsToRestoreValue");
                                        }
                                    }
                                    break block26;
                                }
                                if (checkContainerResource && element.eContainer() != null && element.eContainer().eResource() != element.eResource() && !(status = TngUtil.checkEdit((EObject)element.eContainer(), (Object)MethodElementEditor.this.getSite().getShell())).isOK()) {
                                    if (control instanceof IRichText) {
                                        ((IRichText)control).restoreText();
                                    } else if (control == MethodElementEditor.this.currentFeatureEditor) {
                                        this.restoreText(control, (String)element.eGet(MethodElementEditor.this.currentEditedFeature));
                                    } else {
                                        MethodElementEditor.this.widgetsToRestoreValue.add(control);
                                    }
                                }
                            }
                        }
                        if (status == null || status.isOK()) break block27;
                        AuthoringUIPlugin.getDefault().getMsgDialog().displayError(AuthoringUIResources.editDialog_title, AuthoringUIResources.editDialog_msgCannotEdit, status);
                    }
                    Object var6_5 = null;
                    MethodElementEditor.this.widgetToCheck = null;
                    return false;
                }
                Object var6_6 = null;
                MethodElementEditor.this.widgetToCheck = null;
                return true;
            }
            catch (Throwable throwable) {
                Object var6_7 = null;
                MethodElementEditor.this.widgetToCheck = null;
                throw throwable;
            }
        }

        public void modifyText(ModifyEvent e) {
            if (DEBUG) {
                System.out.println("MethodElementEditor.ModifyListener.modifyText: enter, disabled=" + this.disabled);
            }
            if (!this.disabled && this.element != null) {
                if (e.widget == null) {
                    return;
                }
                Object widget = e.widget;
                if (widget instanceof Browser && (widget = ((Browser)widget).getData("richText")) == null) {
                    widget = e.widget;
                }
                if (DEBUG) {
                    System.out.println("MethodElementEditor.ModifyListener.modifyText: widget=" + widget);
                }
                if (MethodElementEditor.this.widgetsToRestoreValue.contains(widget)) {
                    if (DEBUG) {
                        System.out.println("MethodElementEditor.ModifyListener.modifyText: widget found in widgetsToRestoreValue, exit");
                    }
                    return;
                }
                if (!this.checkEdit(this.element, widget, this.checkContainerResource)) {
                    if (DEBUG) {
                        System.out.println("MethodElementEditor.ModifyListener.modifyText: checkEdit failed, exit");
                    }
                    return;
                }
                if (widget instanceof IMethodRichText) {
                    IMethodRichText richText = (IMethodRichText)widget;
                    MethodElementEditor.this.setModifiedRichText(richText);
                    if (DEBUG) {
                        System.out.println("MethodElementEditor.ModifyListener.modifyText: adding to modifiedRichTexts list");
                    }
                }
                if (DEBUG) {
                    System.out.println("MethodElementEditor.ModifyListener.modifyText: marking editor as dirty");
                }
                MethodElementEditor.this.setDirty();
            }
            if (DEBUG) {
                System.out.println("MethodElementEditor.ModifyListener.modifyText: exit");
            }
        }

        public void setElement(EObject element) {
            this.element = element;
        }

        public void setDisable(boolean disabled) {
            this.disabled = disabled;
        }
    }
}

