/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.authoring.ui.views;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.epf.authoring.ui.AuthoringUIResources;
import org.eclipse.epf.authoring.ui.editors.ConfigurationEditor;
import org.eclipse.epf.authoring.ui.views.MessageContentProvider;
import org.eclipse.epf.authoring.ui.views.MessageLabelProvider;
import org.eclipse.epf.library.configuration.ConfigurationClosure;
import org.eclipse.epf.library.configuration.ElementDependencyError;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;

public class MessageView
extends ViewPart
implements ISelectionProvider,
IPartListener {
    public static final String VIEW_ID;
    public static final int ERROR_MESSAGE_COLUMN = 0;
    public static final int ERROR_ELEMENT_COLUMN = 1;
    public static final int CAUSE_ELEMENT_COLUMN = 2;
    protected MessageViewer tableViewer;
    protected Collection selectionChangedListeners = new ArrayList();
    private ISelectionChangedListener selectionChangedListener = null;
    protected ISelection currentSelection = StructuredSelection.EMPTY;
    private ConfigurationClosure closure = null;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.epf.authoring.ui.views.MessageView");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        VIEW_ID = clazz.getName();
    }

    public void configurationFactoryChanged(ConfigurationClosure closure) {
        this.closure = closure;
        ComposedAdapterFactory adapterFactory = null;
        if (closure != null) {
            adapterFactory = (ComposedAdapterFactory)closure.getConfigurationManager().getAdapterFactory();
            this.tableViewer.setLabelProvider((IBaseLabelProvider)new MessageLabelProvider((AdapterFactory)adapterFactory));
        }
        this.tableViewer.setContentProvider((IContentProvider)new MessageContentProvider(closure));
        this.updateMessage();
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionChangedListeners.add(listener);
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionChangedListeners.remove(listener);
    }

    public ISelection getSelection() {
        return this.currentSelection;
    }

    public void setSelection(ISelection selection) {
        this.currentSelection = selection;
        Iterator listeners = new ArrayList(this.selectionChangedListeners).iterator();
        while (listeners.hasNext()) {
            ISelectionChangedListener listener = (ISelectionChangedListener)listeners.next();
            listener.selectionChanged(new SelectionChangedEvent((ISelectionProvider)this, selection));
        }
    }

    private void createViewer(Composite composite) {
        this.tableViewer = new MessageViewer(composite);
        IViewSite site = (IViewSite)this.getSite();
        site.setSelectionProvider((ISelectionProvider)this);
        if (this.selectionChangedListener == null) {
            this.selectionChangedListener = new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    System.out.println(String.valueOf(AuthoringUIResources.MessageView_selected_text) + event.getSelection());
                    MessageView.this.setSelection(event.getSelection());
                }
            };
            this.tableViewer.addSelectionChangedListener(this.selectionChangedListener);
        }
        this.setColumns();
    }

    private void setColumns() {
        Tree table = this.tableViewer.getTree();
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        TreeColumn column = new TreeColumn(table, 0, 0);
        column.setText(AuthoringUIResources.MessageView_errmsg_text);
        column.setWidth(450);
        column = new TreeColumn(table, 0, 1);
        column.setText(AuthoringUIResources.MessageView_errelement_text);
        column.setWidth(200);
        column = new TreeColumn(table, 0, 2);
        column.setText(AuthoringUIResources.MessageView_refelement_text);
        column.setWidth(200);
    }

    public void createPartControl(Composite parent) {
        this.createViewer(parent);
        IWorkbenchWindow workbenchWindow = this.getSite().getWorkbenchWindow();
        workbenchWindow.getPartService().addPartListener((IPartListener)this);
    }

    public void setFocus() {
    }

    public static MessageView getView() {
        try {
            IWorkbenchPage activePage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
            if (activePage != null) {
                IViewPart view = activePage.findView(VIEW_ID);
                if (view == null) {
                    view = activePage.showView(VIEW_ID);
                }
                return (MessageView)view;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return null;
    }

    public void updateMessage() {
        if (this.closure != null) {
            this.tableViewer.setInput(this.closure);
        } else {
            this.tableViewer.setInput(new Object());
        }
    }

    public boolean isDisposed() {
        return this.closure == null;
    }

    public void dispose() {
        super.dispose();
        IWorkbenchWindow workbenchWindow = this.getSite().getWorkbenchWindow();
        workbenchWindow.getPartService().removePartListener((IPartListener)this);
        this.selectionChangedListeners.clear();
        this.closure = null;
    }

    public void showError(Object e) {
        ElementDependencyError error = this.closure.getError(e);
        if (error != null) {
            this.tableViewer.setSelection(error);
        }
    }

    public void partActivated(IWorkbenchPart part) {
        ConfigurationClosure c;
        if (part instanceof ConfigurationEditor && (c = ((ConfigurationEditor)part).getClosure()) != this.closure) {
            this.configurationFactoryChanged(c);
        }
    }

    public void partBroughtToTop(IWorkbenchPart part) {
    }

    public void partClosed(IWorkbenchPart part) {
        ConfigurationClosure c;
        if (part instanceof ConfigurationEditor && (c = ((ConfigurationEditor)part).getClosure()) == this.closure) {
            this.configurationFactoryChanged(null);
        }
    }

    public void partDeactivated(IWorkbenchPart part) {
    }

    public void partOpened(IWorkbenchPart part) {
    }

    public class MessageViewer
    extends TreeViewer {
        public MessageViewer(Composite parent) {
            this(parent, 65536);
        }

        public MessageViewer(Composite parent, int style) {
            super(parent, style);
            Tree tree = this.getTree();
            tree.setHeaderVisible(true);
            tree.setLinesVisible(true);
        }

        public void setSelection(Object element) {
            super.expandToLevel(element, 1);
            Widget ctrl = super.findItem(element);
            if (ctrl != null) {
                ArrayList<Widget> items = new ArrayList<Widget>();
                items.add(ctrl);
                super.setSelection(items);
            }
        }
    }
}

