/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.xmi;

import java.io.File;
import java.nio.channels.FileLock;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.emf.common.command.BasicCommandStack;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CommandStack;
import org.eclipse.emf.common.command.CommandStackListener;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.command.CreateChildCommand;
import org.eclipse.emf.edit.command.PasteFromClipboardCommand;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.INotifyChangedListener;
import org.eclipse.emf.edit.provider.ReflectiveItemProviderAdapterFactory;
import org.eclipse.emf.edit.provider.resource.ResourceItemProviderAdapterFactory;
import org.eclipse.epf.common.serviceability.DebugTrace;
import org.eclipse.epf.common.utils.FileUtil;
import org.eclipse.epf.library.ILibraryManager;
import org.eclipse.epf.library.InvalidMethodElementNameException;
import org.eclipse.epf.library.LibraryAlreadyExistsException;
import org.eclipse.epf.library.LibraryNotFoundException;
import org.eclipse.epf.library.LibraryPlugin;
import org.eclipse.epf.library.LibraryService;
import org.eclipse.epf.library.LibraryServiceException;
import org.eclipse.epf.library.edit.TngAdapterFactory;
import org.eclipse.epf.library.edit.util.Suppression;
import org.eclipse.epf.library.events.ILibraryChangeListener;
import org.eclipse.epf.library.layout.LayoutResources;
import org.eclipse.epf.library.project.MethodLibraryProject;
import org.eclipse.epf.library.services.LibraryModificationHelper;
import org.eclipse.epf.library.services.SafeUpdateController;
import org.eclipse.epf.library.util.LibraryUtil;
import org.eclipse.epf.library.util.ModelStorage;
import org.eclipse.epf.library.xmi.XMILibraryPlugin;
import org.eclipse.epf.library.xmi.XMILibraryUtil;
import org.eclipse.epf.persistence.FileManager;
import org.eclipse.epf.persistence.MethodLibraryPersister;
import org.eclipse.epf.persistence.MultiFileResourceSetImpl;
import org.eclipse.epf.persistence.MultiFileSaveUtil;
import org.eclipse.epf.persistence.refresh.IRefreshEvent;
import org.eclipse.epf.persistence.refresh.IRefreshListener;
import org.eclipse.epf.persistence.refresh.RefreshJob;
import org.eclipse.epf.persistence.util.LibrarySchedulingRule;
import org.eclipse.epf.uma.MethodConfiguration;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.MethodLibrary;
import org.eclipse.epf.uma.MethodPackage;
import org.eclipse.epf.uma.MethodPlugin;
import org.eclipse.epf.uma.UmaPackage;
import org.eclipse.epf.uma.ecore.impl.MultiResourceEObject;
import org.eclipse.epf.uma.util.AssociationHelper;
import org.eclipse.epf.uma.util.ContentDescriptionFactory;
import org.eclipse.epf.uma.util.IFileManager;
import org.eclipse.epf.uma.util.IMethodLibraryPersister;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.ui.IPropertyListener;

public class XMILibraryManager
implements ILibraryManager {
    public static final int PROP_DIRTY = 1;
    public static final String LIBRARY_TYPE = "xmi";
    public static final String LIBRARY_XMI = "library.xmi";
    public static final String ARG_LIBRARY_NAME = "library.name";
    public static final String ARG_LIBRARY_PATH = "library.path";
    protected static final String LIBRARY_LOCK_FILENAME = ".lock";
    protected static boolean debug = XMILibraryPlugin.getDefault().isDebugging();
    protected MethodLibrary library;
    protected String path;
    protected AdapterFactoryEditingDomain editingDomain;
    private List libraryChangedListeners = new ArrayList();
    private List detachedLibraryChangedListeners = new ArrayList();
    private ListenerList resourceChangeListeners = new ListenerList();
    private FileLock lock;
    private Map saveOptions;
    private boolean skipEventProcessing = false;
    private CommandStackListener commandStackListener = new CommandStackListener(){

        public void commandStackChanged(EventObject event) {
            if (debug) {
                DebugTrace.print((Object)this, (String)"commandStackChanged", (String)("event=" + event));
            }
            if (!XMILibraryManager.this.skipEventProcessing) {
                SafeUpdateController.asyncExec((Runnable)new Runnable(this, event){
                    final /* synthetic */ 1 this$1;
                    private final /* synthetic */ EventObject val$event;
                    {
                        this.this$1 = var1_1;
                        this.val$event = eventObject;
                    }

                    public void run() {
                        Command mostRecentCommand = LibraryUtil.unwrap((Command)((CommandStack)this.val$event.getSource()).getMostRecentCommand());
                        if (mostRecentCommand != null) {
                            if (mostRecentCommand instanceof AddCommand) {
                                AddCommand cmd = (AddCommand)mostRecentCommand;
                                EObject owner = cmd.getOwner();
                                if (owner instanceof MethodConfiguration) {
                                    ArrayList<EObject> objs = new ArrayList<EObject>();
                                    objs.add(owner);
                                    1.access$0(this.this$1).notifyListeners(8, objs);
                                } else {
                                    Collection objs = mostRecentCommand.getResult();
                                    1.access$0(this.this$1).notifyListeners(32, objs);
                                    if (owner instanceof MethodPackage && !(objs = LibraryUtil.getContainedElements((Object)owner, (Collection)objs)).isEmpty()) {
                                        XMILibraryManager.access$1(1.access$0(this.this$1), objs);
                                    }
                                }
                            } else if (mostRecentCommand instanceof PasteFromClipboardCommand) {
                                Collection objs = mostRecentCommand.getResult();
                                1.access$0(this.this$1).notifyListeners(32, objs);
                                PasteFromClipboardCommand cmd = (PasteFromClipboardCommand)mostRecentCommand;
                                if (cmd.getOwner() instanceof MethodPackage && !(objs = LibraryUtil.getContainedElements((Object)cmd.getOwner(), (Collection)objs)).isEmpty()) {
                                    XMILibraryManager.access$1(1.access$0(this.this$1), objs);
                                }
                            } else if (mostRecentCommand instanceof CreateChildCommand) {
                                1.access$0(this.this$1).notifyListeners(32, mostRecentCommand.getAffectedObjects());
                            } else if (mostRecentCommand != null) {
                                1.access$0(this.this$1).notifyListeners(8, mostRecentCommand.getAffectedObjects());
                            }
                        }
                    }
                });
            }
        }

        static /* synthetic */ XMILibraryManager access$0(1 var0) {
            return var0.XMILibraryManager.this;
        }
    };
    private INotifyChangedListener notifyChangedListener = new INotifyChangedListener(){

        public void notifyChanged(Notification notification) {
            if (debug) {
                DebugTrace.print((Object)this, (String)"notifyChanged", (String)("notification=" + notification));
            }
            if (!XMILibraryManager.this.skipEventProcessing) {
                int eventType = notification.getEventType();
                switch (eventType) {
                    case 3: {
                        Object notifier = notification.getNotifier();
                        Object value = notification.getNewValue();
                        if (!(notifier instanceof MethodLibrary) || !(value instanceof MethodPlugin)) break;
                        ArrayList<Object> affectedObjects = new ArrayList<Object>();
                        affectedObjects.add(value);
                        XMILibraryManager.this.notifyListeners(32, affectedObjects);
                        break;
                    }
                    case 1: {
                        Object notifier = notification.getNotifier();
                        if (notifier == null) break;
                        ArrayList<Object> affectedObjects = new ArrayList<Object>();
                        affectedObjects.add(notifier);
                        XMILibraryManager.this.notifyListeners(8, affectedObjects);
                        break;
                    }
                    case 4: {
                        Object notifier = notification.getNotifier();
                        Object oldValue = notification.getOldValue();
                        ArrayList<Object> affectedObjects = new ArrayList<Object>();
                        if (oldValue instanceof EObject && ((EObject)oldValue).eContainer() == null) {
                            affectedObjects.add(oldValue);
                            XMILibraryManager.this.notifyListeners(16, affectedObjects);
                            break;
                        }
                        affectedObjects.add(notifier);
                        XMILibraryManager.this.notifyListeners(8, affectedObjects);
                        break;
                    }
                    case 6: {
                        ArrayList oldValue = new ArrayList((Collection)notification.getOldValue());
                        ArrayList deletedElements = new ArrayList();
                        ArrayList removedReferences = new ArrayList();
                        if (!oldValue.isEmpty()) {
                            Iterator iter = oldValue.iterator();
                            while (iter.hasNext()) {
                                Object element = iter.next();
                                if (!(element instanceof EObject)) continue;
                                if (((EObject)element).eContainer() == null) {
                                    deletedElements.add(element);
                                    continue;
                                }
                                removedReferences.add(element);
                            }
                        }
                        if (!deletedElements.isEmpty()) {
                            XMILibraryManager.this.notifyListeners(16, deletedElements);
                        }
                        if (removedReferences.isEmpty()) break;
                        XMILibraryManager.this.notifyListeners(8, removedReferences);
                    }
                }
            }
        }
    };
    private Adapter resourceChangedListener = new AdapterImpl(){

        public void notifyChanged(Notification msg) {
            if (debug) {
                DebugTrace.print((Object)((Object)this), (String)"notifyChanged", (String)("msg=" + msg));
            }
            if (msg.getFeatureID(null) == 3 && msg.getEventType() == 1) {
                XMILibraryManager.this.firePropertyChange(msg.getNotifier(), 1);
            }
        }
    };
    private IRefreshListener refreshListener = new IRefreshListener(){

        public void notifyRefreshed(IRefreshEvent event) {
            if (debug) {
                DebugTrace.print((Object)this, (String)"notifyRefreshed", (String)("event=" + event));
            }
            XMILibraryManager.this.handleRefreshEvent(event);
        }
    };
    private IPropertyChangeListener preferenceStoreChangeListener = new IPropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent event) {
            if (event.getProperty().equals("org.eclipse.epf.library.pref.back_up_before_save")) {
                XMILibraryManager.this.saveOptions.put("BACK_UP_BEFORE_SAVE", event.getNewValue());
            } else if (event.getProperty().equals("org.eclipse.epf.library.pref.discard_unresolved_references")) {
                XMILibraryManager.this.saveOptions.put("DISCARD_UNRESOLVED_REFERENCES", event.getNewValue());
            }
        }
    };

    public XMILibraryManager() {
        this.init();
    }

    protected void init() {
        if (debug) {
            DebugTrace.print((Object)this, (String)"init");
        }
        LibraryPlugin.getDefault().getPreferenceStore().addPropertyChangeListener(this.preferenceStoreChangeListener);
        ArrayList<Object> factories = new ArrayList<Object>();
        factories.add(new ResourceItemProviderAdapterFactory());
        factories.add(new ReflectiveItemProviderAdapterFactory());
        ComposedAdapterFactory adapterFactory = new ComposedAdapterFactory(factories);
        BasicCommandStack commandStack = new BasicCommandStack();
        MultiFileResourceSetImpl resourceSet = new MultiFileResourceSetImpl();
        resourceSet.addRefreshListener(this.refreshListener);
        RefreshJob.getInstance().setResourceSet((ResourceSet)resourceSet);
        this.saveOptions = resourceSet.getDefaultSaveOptions();
        boolean b = LibraryPlugin.getDefault().getPreferenceStore().getBoolean("org.eclipse.epf.library.pref.back_up_before_save");
        this.saveOptions.put("BACK_UP_BEFORE_SAVE", b);
        b = LibraryPlugin.getDefault().getPreferenceStore().getBoolean("org.eclipse.epf.library.pref.discard_unresolved_references");
        this.saveOptions.put("DISCARD_UNRESOLVED_REFERENCES", b);
        this.editingDomain = new AdapterFactoryEditingDomain((AdapterFactory)adapterFactory, (CommandStack)commandStack, (ResourceSet)resourceSet);
        MethodLibraryPersister contentDescPersister = new MethodLibraryPersister();
        ContentDescriptionFactory.setMethodLibraryPersister((IMethodLibraryPersister)contentDescPersister);
        ContentDescriptionFactory.setFileManager((IFileManager)FileManager.getInstance());
        this.registerEditingDomain(this.editingDomain);
    }

    public MethodLibrary createMethodLibrary(String name, Map args) throws LibraryServiceException {
        if (debug) {
            DebugTrace.print((Object)this, (String)"createMethodLibrary", (String)("name=" + name));
        }
        if (name == null || name.length() == 0 || args == null) {
            throw new IllegalArgumentException();
        }
        String path = (String)args.get(ARG_LIBRARY_PATH);
        if (path == null || path.length() == 0) {
            throw new IllegalArgumentException();
        }
        File libraryPath = new File(path);
        File libraryXMIFile = new File(libraryPath, LIBRARY_XMI);
        if (libraryXMIFile.exists()) {
            throw new LibraryAlreadyExistsException();
        }
        if (!libraryPath.exists()) {
            libraryPath.mkdirs();
        }
        try {
            this.skipEventProcessing = true;
            this.lockMethodLibrary(libraryPath);
            MethodLibraryProject.openProject((String)libraryPath.getAbsolutePath(), null);
            MultiFileResourceSetImpl resourceSet = (MultiFileResourceSetImpl)this.editingDomain.getResourceSet();
            ModelStorage.newLibrary((MultiFileResourceSetImpl)resourceSet, (String)name, (String)libraryPath.getAbsolutePath(), (boolean)true);
            this.library = resourceSet.getMethodLibrary();
            this.addResourceChangedListeners();
            if (debug) {
                DebugTrace.print((Object)this, (String)"createMethodLibrary", (String)("library=" + this.library));
            }
            MethodLibrary methodLibrary = this.library;
            Object var7_9 = null;
            this.skipEventProcessing = false;
            return methodLibrary;
        }
        catch (Exception e) {
            try {
                throw new LibraryServiceException((Throwable)e);
            }
            catch (Throwable throwable) {
                Object var7_10 = null;
                this.skipEventProcessing = false;
                throw throwable;
            }
        }
    }

    public MethodLibrary openMethodLibrary(Map args) throws LibraryServiceException {
        if (debug) {
            DebugTrace.print((Object)this, (String)"openMethodLibrary");
        }
        if (args == null) {
            throw new IllegalArgumentException();
        }
        String path = (String)args.get(ARG_LIBRARY_PATH);
        if (path == null || path.length() == 0) {
            throw new IllegalArgumentException();
        }
        this.library = this.openMethodLibrary(new File(path));
        if (debug) {
            DebugTrace.print((Object)this, (String)"openMethodLibrary", (String)("library=" + this.library));
        }
        return this.library;
    }

    public MethodLibrary reopenMethodLibrary() throws LibraryServiceException {
        if (debug) {
            DebugTrace.print((Object)this, (String)"reopenMethodLibrary");
        }
        this.library = this.openMethodLibrary(new File(this.getMethodLibraryPath()));
        if (debug) {
            DebugTrace.print((Object)this, (String)"reopenMethodLibrary", (String)("library=" + this.library));
        }
        return this.library;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void saveMethodLibrary() throws LibraryServiceException {
        if (debug) {
            DebugTrace.print((Object)this, (String)"saveMethodLibrary");
        }
        try {
            try {
                if (this.library != null) {
                    this.skipEventProcessing = true;
                    MultiFileResourceSetImpl resourceSet = (MultiFileResourceSetImpl)this.editingDomain.getResourceSet();
                    resourceSet.save(this.saveOptions);
                    ((BasicCommandStack)this.editingDomain.getCommandStack()).saveIsDone();
                    this.skipEventProcessing = false;
                    this.firePropertyChange(this.library, 1);
                }
            }
            catch (Exception e) {
                throw new LibraryServiceException((Throwable)e);
            }
        }
        catch (Throwable throwable) {
            Object var2_4 = null;
            this.skipEventProcessing = false;
            throw throwable;
        }
        {
            Object var2_5 = null;
            this.skipEventProcessing = false;
            return;
        }
    }

    public void discardMethodLibraryChanges() {
        if (debug) {
            DebugTrace.print((Object)this, (String)"discardMethodLibraryChanges");
        }
        Iterator it = this.getEditingDomain().getResourceSet().getResources().iterator();
        while (it.hasNext()) {
            Resource resource = (Resource)it.next();
            resource.setModified(false);
        }
    }

    public void closeMethodLibrary() throws LibraryServiceException {
        if (debug) {
            String msg = "library=" + this.library + ", memory on entry=" + (Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory());
            DebugTrace.print((Object)this, (String)"closeMethodLibrary", (String)msg);
        }
        LibraryService.getInstance().removeConfigurationManagers(this.library);
        this.removeResourceChangedListeners();
        LayoutResources.clear();
        MultiFileResourceSetImpl resourceSet = (MultiFileResourceSetImpl)this.editingDomain.getResourceSet();
        resourceSet.reset();
        this.unlockMethodLibrary();
        RefreshJob.getInstance().reset();
        Runtime.getRuntime().gc();
        if (debug) {
            String msg = "library=" + this.library + ", memory on exit=" + (Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory());
            DebugTrace.print((Object)this, (String)"closeMethodLibrary", (String)msg);
        }
    }

    public MethodLibrary getMethodLibrary() {
        if (debug) {
            DebugTrace.print((Object)this, (String)"getMethodLibrary", (String)("library=" + this.library));
        }
        return this.library;
    }

    public void setMethodLibrary(MethodLibrary library) {
        Resource resource;
        if (debug) {
            DebugTrace.print((Object)this, (String)"setMethodLibrary", (String)("library=" + library));
        }
        if (this.library != null && (resource = this.library.eResource()) != null) {
            resource.getContents().clear();
            resource.getContents().add((Object)library);
        }
        this.library = library;
    }

    public String getMethodLibraryPath() {
        URI libraryURI;
        if (debug) {
            DebugTrace.print((Object)this, (String)"getMethodLibraryPath");
        }
        if ((libraryURI = this.getLibraryURI()) != null) {
            File libraryXMIFile = new File(libraryURI.toFileString());
            return libraryXMIFile.getParentFile().getAbsolutePath();
        }
        return null;
    }

    public ComposedAdapterFactory getAdapterFactory() {
        if (debug) {
            DebugTrace.print((Object)this, (String)"getAdapterFactory");
        }
        return (ComposedAdapterFactory)this.getEditingDomain().getAdapterFactory();
    }

    public AdapterFactoryEditingDomain getEditingDomain() {
        if (debug) {
            DebugTrace.print((Object)this, (String)"getEditingDomain", (String)("editingDomain=" + this.editingDomain));
        }
        return this.editingDomain;
    }

    public void registerEditingDomain(AdapterFactoryEditingDomain domain) {
        if (debug) {
            DebugTrace.print((Object)this, (String)"registerEditingDomain", (String)("domain=" + domain));
        }
        ((ComposedAdapterFactory)domain.getAdapterFactory()).addListener(this.notifyChangedListener);
        domain.getCommandStack().addCommandStackListener(this.commandStackListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(ILibraryChangeListener listener) {
        List list = this.libraryChangedListeners;
        synchronized (list) {
            if (debug) {
                DebugTrace.print((Object)this, (String)"addListener", (String)("listener=" + listener));
            }
            if (!this.libraryChangedListeners.contains(listener)) {
                this.libraryChangedListeners.add(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(ILibraryChangeListener listener) {
        List list = this.detachedLibraryChangedListeners;
        synchronized (list) {
            if (debug) {
                DebugTrace.print((Object)this, (String)"removeListener", (String)("listener=" + listener));
            }
            if (!this.detachedLibraryChangedListeners.contains(listener)) {
                this.detachedLibraryChangedListeners.add(listener);
            }
        }
    }

    public void addPropertyListener(IPropertyListener listener) {
        if (debug) {
            DebugTrace.print((Object)this, (String)"addPropertyListener", (String)("listener=" + listener));
        }
        this.resourceChangeListeners.add((Object)listener);
    }

    public void removePropertyListener(IPropertyListener listener) {
        if (debug) {
            DebugTrace.print((Object)this, (String)"removePropertyListener", (String)("listener=" + listener));
        }
        this.resourceChangeListeners.remove((Object)listener);
    }

    public void startListeningTo(CommandStack commandStack) {
        if (debug) {
            DebugTrace.print((Object)this, (String)"startListeningTo", (String)("commandStack=" + commandStack));
        }
        commandStack.addCommandStackListener(this.commandStackListener);
    }

    public void stopListeningTo(CommandStack commandStack) {
        if (debug) {
            DebugTrace.print((Object)this, (String)"stopListeningTo", (String)("commandStack=" + commandStack));
        }
        commandStack.removeCommandStackListener(this.commandStackListener);
    }

    public void startListeningTo(ComposedAdapterFactory adapterFactory) {
        if (debug) {
            DebugTrace.print((Object)this, (String)"startListeningTo", (String)("adapterFactory=" + adapterFactory));
        }
        adapterFactory.addListener(this.notifyChangedListener);
    }

    public void stopListeningTo(ComposedAdapterFactory adapterFactory) {
        if (debug) {
            DebugTrace.print((Object)this, (String)"stopListeningTo", (String)("adapterFactory=" + adapterFactory));
        }
        adapterFactory.removeListener(this.notifyChangedListener);
    }

    public MethodElement getMethodElement(String guid) {
        if (debug) {
            DebugTrace.print((Object)this, (String)"getMethodElement", (String)("guid=" + guid));
        }
        try {
            MultiFileResourceSetImpl resourceSet = (MultiFileResourceSetImpl)this.library.eResource().getResourceSet();
            if (resourceSet != null) {
                return (MethodElement)resourceSet.getEObject(guid);
            }
        }
        catch (Throwable throwable) {}
        return null;
    }

    public URI getElementRelativeURI(MethodElement element) {
        Resource resource;
        if (debug) {
            DebugTrace.print((Object)this, (String)"getElementRelativeURI", (String)("element=" + element));
        }
        if (element != null && (resource = this.library.eResource()) != null) {
            URI libraryURI = resource.getURI();
            URI elementURI = element.eResource().getURI();
            return elementURI.deresolve(libraryURI);
        }
        return null;
    }

    public boolean isMethodLibraryLocked() {
        if (debug) {
            DebugTrace.print((Object)this, (String)"isMethodLibraryLocked");
        }
        return XMILibraryUtil.isMethodLibraryLocked(this.getMethodLibraryPath());
    }

    public boolean isMethodLibraryReadOnly() {
        URI libraryURI;
        File libraryXMIFile;
        if (debug) {
            DebugTrace.print((Object)this, (String)"isMethodLibraryReadOnly");
        }
        return (libraryXMIFile = new File((libraryURI = this.library.eResource().getURI()).toFileString())).exists() && !libraryXMIFile.canWrite();
    }

    public boolean isMethodLibraryModified() {
        if (debug) {
            DebugTrace.print((Object)this, (String)"isMethodLibraryModified");
        }
        Iterator it = this.getEditingDomain().getResourceSet().getResources().iterator();
        while (it.hasNext()) {
            Resource resource = (Resource)it.next();
            if (!resource.isModified()) continue;
            return true;
        }
        return false;
    }

    public boolean hasUnresolvedProxy() {
        if (debug) {
            DebugTrace.print((Object)this, (String)"hasUnresolvedProxy");
        }
        MultiFileResourceSetImpl resourceSet = (MultiFileResourceSetImpl)this.editingDomain.getResourceSet();
        return resourceSet.hasUnresolvedProxy();
    }

    public Collection reloadResources(final Collection resources) {
        if (debug) {
            System.out.println("XMILibraryManager.reloadResources(): START");
        }
        try {
            final ArrayList reloadedResources = new ArrayList();
            IWorkspaceRunnable runnable = new IWorkspaceRunnable(){

                public void run(IProgressMonitor monitor) throws CoreException {
                    reloadedResources.addAll(XMILibraryManager.this.doReloadResources(resources));
                }
            };
            try {
                ResourcesPlugin.getWorkspace().run(runnable, (ISchedulingRule)new LibrarySchedulingRule(this.library), 1, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (Exception e) {
                XMILibraryPlugin.getDefault().getLogger().logError((Throwable)e);
            }
            ArrayList arrayList = reloadedResources;
            Object var5_6 = null;
            if (debug) {
                System.out.println("XMILibraryManager.doReloadResources(): END");
            }
            return arrayList;
        }
        catch (Throwable throwable) {
            block6: {
                Object var5_7 = null;
                if (!debug) break block6;
                System.out.println("XMILibraryManager.doReloadResources(): END");
            }
            throw throwable;
        }
    }

    private Collection doReloadResources(Collection resources) {
        if (debug) {
            DebugTrace.print((Object)this, (String)"reloadResources");
        }
        if (this.library == null) {
            return Collections.EMPTY_LIST;
        }
        LibraryService libSvc = (LibraryService)LibraryService.getInstance();
        Resource currentLibResource = null;
        ILibraryManager currentLibMgr = null;
        Resource currentConfigResource = null;
        MethodConfiguration currentConfig = null;
        ArrayList<Resource> configResources = new ArrayList<Resource>();
        ArrayList<MethodElement> configs = new ArrayList<MethodElement>();
        Iterator iter = resources.iterator();
        while (iter.hasNext()) {
            Resource resource = (Resource)iter.next();
            MethodElement e = MultiFileSaveUtil.getMethodElement((Resource)resource);
            if (e == libSvc.getCurrentMethodLibrary()) {
                currentLibMgr = libSvc.getCurrentLibraryManager();
                currentLibResource = resource;
                continue;
            }
            if (e == libSvc.getCurrentMethodConfiguration()) {
                currentConfigResource = resource;
                currentConfig = libSvc.getCurrentMethodConfiguration();
                continue;
            }
            if (!(e instanceof MethodConfiguration)) continue;
            configResources.add(resource);
            configs.add(e);
        }
        MultiFileResourceSetImpl resourceSet = (MultiFileResourceSetImpl)this.library.eResource().getResourceSet();
        Collection reloadedResources = resourceSet.reloadResources(resources);
        if (!reloadedResources.isEmpty()) {
            if (currentLibResource != null || currentConfigResource != null) {
                Iterator iter2 = reloadedResources.iterator();
                while (iter2.hasNext()) {
                    int id;
                    MethodElement e;
                    Resource resource = (Resource)iter2.next();
                    if (resource == currentLibResource && (e = MultiFileSaveUtil.getMethodElement((Resource)resource)) instanceof MethodLibrary) {
                        MethodLibrary newLib = (MethodLibrary)e;
                        libSvc.setCurrentMethodLibrary(newLib);
                        if (currentLibMgr instanceof XMILibraryManager) {
                            libSvc.removeLibraryManager(currentLibMgr);
                            ((XMILibraryManager)currentLibMgr).updateMethodLibrary(newLib);
                            libSvc.setLibraryManager(currentLibMgr);
                        }
                    }
                    if (resource == currentConfigResource) {
                        e = MultiFileSaveUtil.getMethodElement((Resource)resource);
                        if (!(e instanceof MethodConfiguration)) continue;
                        libSvc.removeConfigurationManager(currentConfig);
                        MethodConfiguration config = (MethodConfiguration)e;
                        libSvc.setCurrentMethodConfiguration(config);
                        continue;
                    }
                    if (configResources.isEmpty() || (id = configResources.indexOf(resource)) == -1) continue;
                    libSvc.removeConfigurationManager((MethodConfiguration)configs.get(id));
                }
            }
            Suppression.cleanUp();
        }
        return reloadedResources;
    }

    private void updateMethodLibrary(MethodLibrary newLib) {
        this.library = newLib;
    }

    public Map getSaveOptions() {
        if (debug) {
            DebugTrace.print((Object)this, (String)"getSaveOptions");
        }
        return this.saveOptions;
    }

    public void addMethodPlugin(final MethodPlugin plugin) throws LibraryServiceException {
        if (debug) {
            DebugTrace.print((Object)this, (String)"addMethodPlugin", (String)("plugin=" + plugin));
        }
        final Exception[] exceptions = new Exception[1];
        try {
            SafeUpdateController.syncExec((Runnable)new Runnable(){

                public void run() {
                    XMILibraryManager.this.library.getMethodPlugins().add(plugin);
                    IMethodLibraryPersister.FailSafeMethodLibraryPersister persister = ContentDescriptionFactory.getMethodLibraryPersister().getFailSafePersister();
                    try {
                        persister.save(XMILibraryManager.this.library.eResource());
                        persister.commit();
                    }
                    catch (Exception e) {
                        persister.rollback();
                        exceptions[0] = e;
                        return;
                    }
                    plugin.eResource().eAdapters().add((Object)XMILibraryManager.this.resourceChangedListener);
                }
            });
        }
        catch (Exception e) {
            throw new LibraryServiceException((Throwable)e);
        }
        if (exceptions[0] != null) {
            throw new LibraryServiceException((Throwable)exceptions[0]);
        }
    }

    public void dispose() {
        if (this.preferenceStoreChangeListener != null) {
            LibraryPlugin.getDefault().getPreferenceStore().removePropertyChangeListener(this.preferenceStoreChangeListener);
        }
        if (this.libraryChangedListeners.size() > 0) {
            this.libraryChangedListeners.clear();
        }
        if (this.detachedLibraryChangedListeners.size() > 0) {
            this.detachedLibraryChangedListeners.clear();
        }
        if (this.resourceChangeListeners.size() > 0) {
            this.resourceChangeListeners.clear();
        }
        this.editingDomain = null;
        this.library = null;
    }

    protected void checkElementCreationArguments(MethodElement containingElement, String name) throws LibraryServiceException {
        if (containingElement == null) {
            throw new IllegalArgumentException();
        }
        if (name == null || name.length() == 0) {
            throw new InvalidMethodElementNameException();
        }
    }

    protected void lockMethodLibrary(File path) {
        File lockFile = new File(path, LIBRARY_LOCK_FILENAME);
        this.lock = FileUtil.lockFile((File)lockFile);
    }

    protected void unlockMethodLibrary() {
        block3: {
            try {
                if (this.lock != null) {
                    this.lock.release();
                    this.lock.channel().close();
                }
            }
            catch (Exception e) {
                LibraryPlugin.getDefault().getLogger().logError((Throwable)e);
                if (!debug) break block3;
                DebugTrace.print((Object)this, (String)"unlockMethodLibrary", (Throwable)e);
            }
        }
    }

    protected void handleRefreshEvent(IRefreshEvent event) {
        if (debug) {
            DebugTrace.print((Object)this, (String)"handleRefreshEvent", (String)("refreshedResources=" + event.getRefreshedResources()));
        }
        if (!event.getUnloadedObjects().isEmpty()) {
            TngAdapterFactory.INSTANCE.cleanUp();
        }
    }

    protected synchronized void notifyListeners(final int option, final Collection collection) {
        block7: {
            if (debug) {
                DebugTrace.print((Object)this, (String)"notifyListeners", (String)("option=" + option));
            }
            try {
                if (this.detachedLibraryChangedListeners.size() > 0) {
                    Iterator it = this.detachedLibraryChangedListeners.iterator();
                    while (it.hasNext()) {
                        Object l = it.next();
                        if (!this.libraryChangedListeners.contains(l)) continue;
                        this.libraryChangedListeners.remove(l);
                    }
                    this.detachedLibraryChangedListeners.clear();
                }
                int i = 0;
                while (i < this.libraryChangedListeners.size()) {
                    final ILibraryChangeListener listener = (ILibraryChangeListener)this.libraryChangedListeners.get(i);
                    if (listener != null) {
                        SafeUpdateController.syncExec((Runnable)new Runnable(){

                            public void run() {
                                if (debug) {
                                    DebugTrace.print((Object)this, (String)"notifyListeners", (String)("listener=" + listener));
                                }
                                listener.libraryChanged(option, collection);
                            }
                        });
                    }
                    ++i;
                }
            }
            catch (Exception e) {
                if (!debug) break block7;
                DebugTrace.print((Object)this, (String)"notifyListeners", (Throwable)e);
            }
        }
    }

    protected void firePropertyChange(final Object source, final int propertyId) {
        if (debug) {
            DebugTrace.print((Object)this, (String)"firePropertyChange", (String)("source=" + source));
        }
        Object[] array = this.resourceChangeListeners.getListeners();
        int i = 0;
        while (i < array.length) {
            final IPropertyListener listener = (IPropertyListener)array[i];
            SafeUpdateController.asyncExec((Runnable)new Runnable(){

                public void run() {
                    if (debug) {
                        DebugTrace.print((Object)this, (String)"firePropertyChange", (String)("listener=" + listener));
                    }
                    listener.propertyChanged(source, propertyId);
                }
            });
            ++i;
        }
    }

    protected void addResourceChangedListeners() {
        if (this.library == null || this.library.eResource() == null) {
            return;
        }
        if (!this.library.eResource().eAdapters().contains((Object)this.resourceChangedListener)) {
            this.library.eResource().eAdapters().add((Object)this.resourceChangedListener);
        }
        Iterator it = this.library.getMethodPlugins().iterator();
        while (it.hasNext()) {
            MethodPlugin plugin = (MethodPlugin)it.next();
            if (plugin.eResource().eAdapters().contains((Object)this.resourceChangedListener)) continue;
            plugin.eResource().eAdapters().add((Object)this.resourceChangedListener);
        }
        it = this.library.getPredefinedConfigurations().iterator();
        while (it.hasNext()) {
            MethodConfiguration config = (MethodConfiguration)it.next();
            if (config.eResource().eAdapters().contains((Object)this.resourceChangedListener)) continue;
            config.eResource().eAdapters().add((Object)this.resourceChangedListener);
        }
    }

    protected void removeResourceChangedListeners() {
        if (this.library == null || this.library.eResource() == null) {
            return;
        }
        this.library.eResource().eAdapters().remove((Object)this.resourceChangedListener);
        Iterator iter = this.library.getMethodPlugins().iterator();
        while (iter.hasNext()) {
            MethodPlugin plugin = (MethodPlugin)iter.next();
            plugin.eResource().eAdapters().remove((Object)this.resourceChangedListener);
        }
        Iterator it = this.library.getPredefinedConfigurations().iterator();
        while (it.hasNext()) {
            MethodConfiguration config = (MethodConfiguration)it.next();
            config.eResource().eAdapters().remove((Object)this.resourceChangedListener);
        }
    }

    protected MethodLibrary openMethodLibrary(File path) throws LibraryServiceException {
        File libraryXMIFile = new File(path, LIBRARY_XMI);
        if (!libraryXMIFile.exists()) {
            throw new LibraryNotFoundException();
        }
        try {
            this.skipEventProcessing = true;
            this.lockMethodLibrary(path);
            MethodLibraryProject.openProject((String)path.getAbsolutePath(), null);
            MultiFileResourceSetImpl resourceSet = (MultiFileResourceSetImpl)this.editingDomain.getResourceSet();
            MethodLibrary library = resourceSet.loadLibrary(libraryXMIFile.getAbsolutePath());
            this.addResourceChangedListeners();
            MethodLibrary methodLibrary = library;
            Object var5_7 = null;
            this.firePropertyChange(this.library, 1);
            this.skipEventProcessing = false;
            return methodLibrary;
        }
        catch (Exception e) {
            try {
                if (debug) {
                    DebugTrace.print((Throwable)e);
                }
                throw new LibraryServiceException((Throwable)e);
            }
            catch (Throwable throwable) {
                Object var5_8 = null;
                this.firePropertyChange(this.library, 1);
                this.skipEventProcessing = false;
                throw throwable;
            }
        }
    }

    protected Resource getMethodLibraryResource() {
        EList res = this.getEditingDomain().getResourceSet().getResources();
        if (res.size() > 0) {
            return (Resource)res.get(0);
        }
        return null;
    }

    protected URI getLibraryURI() {
        Resource savedResource = this.getMethodLibraryResource();
        if (savedResource != null) {
            return savedResource.getURI();
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void addNewPackagesToConfiguration(Collection newobjs) {
        if (newobjs == null) return;
        if (newobjs.size() == 0) {
            return;
        }
        LibraryModificationHelper helper = new LibraryModificationHelper();
        try {
            try {
                Iterator it = newobjs.iterator();
                while (it.hasNext()) {
                    Object configs;
                    EObject parent;
                    EObject e = (EObject)it.next();
                    if (!(e instanceof MethodPackage) || (parent = e.eContainer()) == null || !(parent instanceof MethodPackage) || !((configs = ((MultiResourceEObject)parent).getOppositeFeatureValue(AssociationHelper.MethodPackage_MethodConfigurations)) instanceof List)) continue;
                    Iterator itconfig = ((List)configs).iterator();
                    while (itconfig.hasNext()) {
                        MethodConfiguration config = (MethodConfiguration)itconfig.next();
                        List pkgs = config.getMethodPackageSelection();
                        if (pkgs.contains(e)) continue;
                        helper.getActionManager().doAction(3, (EObject)config, (EStructuralFeature)UmaPackage.eINSTANCE.getMethodConfiguration_MethodPackageSelection(), (Object)e, -1);
                    }
                }
                helper.save();
            }
            catch (RuntimeException e) {
                LibraryPlugin.getDefault().getLogger().logError((Throwable)e);
            }
            Object var10_13 = null;
        }
        catch (Throwable throwable) {
            Object var10_12 = null;
            helper.dispose();
            throw throwable;
        }
        helper.dispose();
    }

    static /* synthetic */ void access$1(XMILibraryManager xMILibraryManager, Collection collection) {
        xMILibraryManager.addNewPackagesToConfiguration(collection);
    }
}

