/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.persistence.refresh;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.CommonPlugin;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.UniqueEList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.epf.persistence.FileManager;
import org.eclipse.epf.persistence.MultiFileResourceSetImpl;
import org.eclipse.epf.persistence.refresh.IRefreshHandler;
import org.eclipse.epf.persistence.refresh.RefreshJob;

public class RefreshJob
extends WorkspaceJob
implements IResourceChangeListener {
    private static final long UPDATE_DELAY = 200L;
    private static final boolean DEBUG = org.eclipse.epf.common.CommonPlugin.getDefault().isDebugging();
    private static final String DEBUG_PREFIX = "EPF Auto-refresh:";
    private ResourceSet resourceSet;
    private Collection addedResources = new UniqueEList();
    private Collection changedResources = new UniqueEList();
    private Collection removedResources = new UniqueEList();
    private UniqueEList savedResources = new UniqueEList();
    private Collection loadedBeforeRefreshResources = new ArrayList();
    private IRefreshHandler refreshHandler;
    private boolean enabled = true;
    private Collection addedWorkspaceResources = new UniqueEList();
    private static RefreshJob instance = new RefreshJob();

    private RefreshJob() {
        super("EPF Auto-Refresh");
    }

    public void setEnabled(boolean b) {
        this.enabled = b;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setResourceSet(ResourceSet resourceSet) {
        this.resourceSet = resourceSet;
    }

    public void setRefreshHandler(IRefreshHandler handler) {
        this.refreshHandler = handler;
    }

    public Collection getAddedResources() {
        return this.addedResources;
    }

    public Collection getAddedWorkspaceResources() {
        return this.addedWorkspaceResources;
    }

    public Collection getChangedResources() {
        this.removeFromChangedResources((Collection)this.savedResources);
        this.removeFromChangedResources(this.loadedBeforeRefreshResources);
        return this.changedResources;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeFromChangedResources(Collection resources) {
        Collection collection = resources;
        synchronized (collection) {
            if (!resources.isEmpty()) {
                Iterator iter = resources.iterator();
                while (iter.hasNext()) {
                    Object resource = iter.next();
                    if (!this.changedResources.remove(resource)) continue;
                    iter.remove();
                }
            }
        }
    }

    public Collection getRemovedResources() {
        return this.removedResources;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resourceSaved(Resource resource) {
        UniqueEList uniqueEList = this.savedResources;
        synchronized (uniqueEList) {
            this.savedResources.add((Object)resource);
        }
    }

    public Collection getReloadedBeforeRefreshResources() {
        return this.loadedBeforeRefreshResources;
    }

    public void reset() {
        this.changedResources.clear();
        this.removedResources.clear();
        this.savedResources.clear();
        this.loadedBeforeRefreshResources.clear();
        this.addedResources.clear();
    }

    private void scheduleRefresh() {
        if (this.getState() == 0) {
            this.schedule(200L);
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IStatus runInWorkspace(IProgressMonitor monitor) {
        if (this.refreshHandler == null) {
            return Status.OK_STATUS;
        }
        long start = System.currentTimeMillis();
        Throwable error = null;
        try {
            if (DEBUG) {
                System.out.println("EPF Auto-refresh: starting refresh job");
            }
            monitor.beginTask("", -1);
            if (monitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            try {
                this.refreshHandler.refresh(monitor);
            }
            catch (Throwable e) {
                error = e;
            }
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            monitor.done();
            if (DEBUG) {
                System.out.println("EPF Auto-refresh: finished refresh job in: " + (System.currentTimeMillis() - start) + "ms");
            }
            throw throwable;
        }
        {
            Object var6_7 = null;
        }
        monitor.done();
        if (DEBUG) {
            System.out.println("EPF Auto-refresh: finished refresh job in: " + (System.currentTimeMillis() - start) + "ms");
        }
        if (error != null) {
            return new Status(4, FileManager.PLUGIN_ID, 0, "Refresh error", error);
        }
        return Status.OK_STATUS;
    }

    public synchronized boolean shouldRun() {
        return this.shouldRefresh();
    }

    private boolean shouldRefresh() {
        return !this.removedResources.isEmpty() || !this.changedResources.isEmpty() || !this.addedResources.isEmpty() || !this.loadedBeforeRefreshResources.isEmpty() || !this.addedWorkspaceResources.isEmpty();
    }

    public void start() {
        if (DEBUG) {
            System.out.println("RefreshJob.start()");
        }
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this);
    }

    public void stop() {
        if (DEBUG) {
            System.out.println("RefreshJob.stop()");
        }
        ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
        this.cancel();
    }

    public Resource getResource(String path) {
        URI uri = URI.createFileURI((String)path);
        Iterator iter = new ArrayList(this.resourceSet.getResources()).iterator();
        while (iter.hasNext()) {
            Resource resource = (Resource)iter.next();
            if (!uri.equals((Object)resource.getURI())) continue;
            return resource;
        }
        return null;
    }

    public Resource getResource(IResource wsRes) {
        return this.getResource(wsRes.getLocation().toString());
    }

    private boolean accept(IResource resource) {
        if (this.resourceSet instanceof MultiFileResourceSetImpl) {
            return ((MultiFileResourceSetImpl)this.resourceSet).isLibraryResource(resource);
        }
        return false;
    }

    public void resourceChanged(IResourceChangeEvent event) {
        if (!this.isEnabled() || this.resourceSet == null) {
            return;
        }
        IResourceDelta delta = event.getDelta();
        if (delta == null) {
            return;
        }
        try {
            class ResourceDeltaVisitor
            implements IResourceDeltaVisitor {
                private Collection changedResources;
                private Collection removedResources;
                private Collection addedResources;
                private ArrayList addedWorkspaceResources;
                final /* synthetic */ RefreshJob this$0;

                ResourceDeltaVisitor(RefreshJob refreshJob) {
                    this.this$0 = refreshJob;
                    this.changedResources = new ArrayList<E>();
                    this.removedResources = new ArrayList<E>();
                    this.addedResources = new ArrayList<E>();
                    this.addedWorkspaceResources = new ArrayList<E>();
                }

                public boolean visit(IResourceDelta delta) throws CoreException {
                    if (delta.getFlags() != 131072 && delta.getResource().getType() == 1) {
                        switch (delta.getKind()) {
                            case 1: {
                                String loc = delta.getResource().getLocation().toString();
                                Resource resource = this.this$0.getResource(loc);
                                if (resource != null) {
                                    this.addedResources.add(resource);
                                    break;
                                }
                                if (!RefreshJob.access$0(this.this$0, delta.getResource())) break;
                                this.addedWorkspaceResources.add(delta.getResource());
                                break;
                            }
                            case 2: {
                                if ((0x2000 & delta.getFlags()) != 0) {
                                    if (!RefreshJob.access$1()) break;
                                    IPath movedFromPath = delta.getResource().getLocation();
                                    IPath movedToPath = delta.getMovedToPath();
                                    System.out.println("Resource moved from '" + movedFromPath + "' to '" + movedToPath + "'");
                                    break;
                                }
                                Resource resource = this.this$0.getResource(delta.getResource().getLocation().toString());
                                if (resource == null) break;
                                this.removedResources.add(resource);
                                break;
                            }
                            case 4: {
                                Resource resource;
                                boolean contentChanged;
                                boolean encodingChanged = (0x100000 & delta.getFlags()) != 0;
                                boolean bl = contentChanged = (0x100 & delta.getFlags()) != 0;
                                if (!encodingChanged && !contentChanged || (resource = this.this$0.getResource(delta.getResource().getLocation().toString())) == null) break;
                                this.changedResources.add(resource);
                            }
                        }
                    }
                    return true;
                }

                public Collection getChangedResources() {
                    return this.changedResources;
                }

                public Collection getRemovedResources() {
                    return this.removedResources;
                }
            }
            ResourceDeltaVisitor visitor = new ResourceDeltaVisitor(this);
            delta.accept((IResourceDeltaVisitor)visitor);
            this.removedResources.addAll(visitor.getRemovedResources());
            this.changedResources.addAll(visitor.getChangedResources());
            this.addedResources.addAll(visitor.addedResources);
            this.addedWorkspaceResources.addAll(visitor.addedWorkspaceResources);
            if (this.shouldRefresh()) {
                this.scheduleRefresh();
            }
        }
        catch (CoreException e) {
            CommonPlugin.INSTANCE.log((Object)e);
        }
    }

    public EObject resolve(EObject proxy) {
        EObject resolved = EcoreUtil.resolve((EObject)proxy, (ResourceSet)this.resourceSet);
        EObject container = proxy.eContainer();
        if (resolved.eContainer() == null && container != null) {
            EReference ref;
            if (container.eIsProxy()) {
                container = this.resolve(container);
            }
            if ((ref = proxy.eContainmentFeature()).isMany()) {
                List values = (List)container.eGet((EStructuralFeature)ref);
                Iterator iter = values.iterator();
                while (iter.hasNext()) {
                    iter.next();
                }
            } else {
                container.eGet((EStructuralFeature)ref);
            }
        }
        return resolved;
    }

    public static RefreshJob getInstance() {
        return instance;
    }

    static /* synthetic */ boolean access$0(RefreshJob refreshJob, IResource iResource) {
        return refreshJob.accept(iResource);
    }

    static /* synthetic */ boolean access$1() {
        return DEBUG;
    }
}

