/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.ui.dialogs;

import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.epf.common.utils.StrUtil;
import org.eclipse.epf.library.ui.LibraryUIPlugin;
import org.eclipse.epf.library.ui.LibraryUIResources;
import org.eclipse.epf.library.ui.dialogs.BaseDialog;
import org.eclipse.epf.library.ui.dialogs.SelectLibraryDirectoryDialog;
import org.eclipse.epf.library.ui.preferences.LibraryUIPreferences;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class OpenLibraryDialog
extends BaseDialog
implements Listener {
    private Image titleImage;
    private Text libraryPathText;
    private String libraryPath;
    private Button promptForLibraryCheckbox;

    public OpenLibraryDialog(Shell parent, String libraryPath) {
        super(parent);
        this.libraryPath = libraryPath;
    }

    protected Control createDialogArea(Composite parent) {
        Composite dialogArea = (Composite)super.createDialogArea(parent);
        this.setTitle(LibraryUIResources.openLibraryDialogArea_title);
        String appName = Platform.getProduct().getName();
        String openLibDtext = NLS.bind((String)LibraryUIResources.openLibraryDialogArea_text, (Object[])new Object[]{appName});
        this.setMessage(openLibDtext);
        this.titleImage = LibraryUIPlugin.getDefault().getImage("OpenLibrary.gif");
        this.setTitleImage(this.titleImage);
        Composite inputComposite = new Composite(dialogArea, 0);
        inputComposite.setLayout((Layout)new GridLayout(3, false));
        this.createLabel(inputComposite, " ", 3);
        Label libraryLabel = new Label(inputComposite, 0);
        libraryLabel.setText(LibraryUIResources.libraryLabel_text);
        this.libraryPathText = new Text(inputComposite, 2048);
        GridData gridData = new GridData(768);
        gridData.widthHint = 450;
        this.libraryPathText.setLayoutData((Object)gridData);
        this.libraryPathText.setText(this.libraryPath);
        this.libraryPathText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (OpenLibraryDialog.this.okButton != null) {
                    String status = OpenLibraryDialog.this.isValidPath(OpenLibraryDialog.this.libraryPathText.getText());
                    if (status == null) {
                        OpenLibraryDialog.this.setErrorMessage(null);
                        OpenLibraryDialog.this.okButton.setEnabled(true);
                    } else {
                        OpenLibraryDialog.this.setErrorMessage(status);
                        OpenLibraryDialog.this.okButton.setEnabled(false);
                    }
                }
            }
        });
        Button browseButton = new Button(inputComposite, 0);
        browseButton.setText(LibraryUIResources.browseButton_text);
        browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                try {
                    SelectLibraryDirectoryDialog dd = new SelectLibraryDirectoryDialog(Display.getCurrent().getActiveShell());
                    dd.setFilterPath(OpenLibraryDialog.this.libraryPathText.getText());
                    String path = dd.open();
                    if (path != null) {
                        OpenLibraryDialog.this.libraryPathText.setText(path);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
        this.createLabel(inputComposite, " ", 3);
        this.createLabel(inputComposite, " ", 3);
        this.createLabel(inputComposite, " ", 3);
        new Label(inputComposite, 32);
        this.promptForLibraryCheckbox = new Button(inputComposite, 32);
        this.promptForLibraryCheckbox.setText(LibraryUIResources.promptForLibraryCheckbox_text);
        super.getShell().setText(LibraryUIResources.openLibraryDialog_title);
        super.getShell().addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent event) {
                if (OpenLibraryDialog.this.titleImage != null && !OpenLibraryDialog.this.titleImage.isDisposed()) {
                    OpenLibraryDialog.this.titleImage.dispose();
                }
            }
        });
        return dialogArea;
    }

    public int open() {
        this.setShellStyle(this.getShellStyle() | 0x10000);
        return super.open();
    }

    public void handleEvent(Event event) {
        if (event.widget == this.promptForLibraryCheckbox) {
            LibraryUIPreferences.setPromptForMethodLibraryAtStartup(this.promptForLibraryCheckbox.getSelection());
        }
    }

    private Label createLabel(Composite parent, String text, int span) {
        Label label = new Label(parent, 16384);
        label.setText(text);
        GridData data = new GridData();
        data.horizontalSpan = span;
        data.horizontalAlignment = 4;
        label.setLayoutData((Object)data);
        return label;
    }

    private String isValidPath(String path) {
        if (path == null || path.trim().length() == 0) {
            return LibraryUIResources.invalidPath_msg;
        }
        IPath ecPath = Path.fromOSString((String)path);
        boolean isValid = ecPath.isValidPath(path);
        if (!isValid) {
            return LibraryUIResources.invalidPath_msg;
        }
        if (!StrUtil.isValidPublishPath((String)path)) {
            return LibraryUIResources.invalidPath_msg;
        }
        return null;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        super.createButtonsForButtonBar(parent);
        this.okButton.setEnabled(true);
    }

    protected void okPressed() {
        this.libraryPath = this.libraryPathText.getText().trim();
        LibraryUIPreferences.setPromptForMethodLibraryAtStartup(!this.promptForLibraryCheckbox.getSelection());
        super.okPressed();
    }

    protected void cancelPressed() {
        System.exit(0);
    }

    public String getLibraryPath() {
        return this.libraryPath;
    }
}

