/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.importing.services;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.epf.library.util.ResourceHelper;
import org.eclipse.epf.uma.MethodElement;

public class ResourceScanner {
    public static final Pattern p_src_ref = Pattern.compile("src\\s*=\\s*\"(.*?)\"", 34);
    public static final Pattern p_href_ref = Pattern.compile("href\\s*=\\s*\"(.*?)\"", 34);
    File srcLibRoot;
    File targetLibRoot;
    private Map newFileMap = new HashMap();
    private Map existingFileMap = new HashMap();

    public ResourceScanner(File srcLibRoot, File targetLibRoot) {
        this.srcLibRoot = srcLibRoot;
        this.targetLibRoot = targetLibRoot;
    }

    public void scan(MethodElement owner, String source) {
        try {
            String url;
            Matcher m = p_src_ref.matcher(source);
            while (m.find()) {
                url = m.group(1);
                this.processUrl(owner, url);
            }
            m = p_href_ref.matcher(source);
            while (m.find()) {
                url = m.group(1);
                this.processUrl(owner, url);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void processUrl(MethodElement owner, String url) {
        if (url == null) {
            return;
        }
        int index = url.indexOf("#");
        if (index >= 0) {
            url = url.substring(0, index);
        }
        if ((index = url.indexOf("?")) >= 0) {
            url = url.substring(0, index);
        }
        if (url.trim().length() == 0) {
            return;
        }
        File srcFile = null;
        File targetFile = null;
        try {
            if (owner != null) {
                String elementPath = ResourceHelper.getElementPath((MethodElement)owner);
                srcFile = new File(new File(this.srcLibRoot, elementPath), url);
                targetFile = new File(new File(this.targetLibRoot, elementPath), url);
            } else {
                srcFile = new File(this.srcLibRoot, url);
                targetFile = new File(this.targetLibRoot, url);
            }
            if (srcFile.isFile() && srcFile.exists()) {
                srcFile = srcFile.getCanonicalFile();
                if ((targetFile = targetFile.getCanonicalFile()).exists()) {
                    if (!(this.existingFileMap.containsKey(srcFile) || srcFile.length() == targetFile.length() && srcFile.lastModified() == targetFile.lastModified())) {
                        this.existingFileMap.put(srcFile, targetFile);
                    }
                } else if (!this.newFileMap.containsKey(srcFile)) {
                    this.newFileMap.put(srcFile, targetFile);
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void copyResource(String url) {
        this.processUrl(null, url);
    }

    public List getFilesTobeReplaced() {
        ArrayList<String> files = new ArrayList<String>();
        if (this.existingFileMap.size() > 0) {
            Iterator it = this.existingFileMap.values().iterator();
            while (it.hasNext()) {
                String path;
                File f = (File)it.next();
                if (f == null || files.contains(path = f.getAbsolutePath())) continue;
                files.add(path);
            }
        }
        return files;
    }

    public void execute() {
        File targetFile;
        File srcFile;
        Map.Entry entry;
        Iterator it = this.newFileMap.entrySet().iterator();
        while (it.hasNext()) {
            entry = it.next();
            srcFile = (File)entry.getKey();
            targetFile = (File)entry.getValue();
            ResourceHelper.copyFile((File)srcFile, (File)targetFile);
            System.out.println("File copied: " + srcFile);
        }
        it = this.existingFileMap.entrySet().iterator();
        while (it.hasNext()) {
            entry = it.next();
            srcFile = (File)entry.getKey();
            targetFile = (File)entry.getValue();
            ResourceHelper.copyFile((File)srcFile, (File)targetFile);
            System.out.println("File copied: " + srcFile);
        }
    }
}

