/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.export.msp;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.epf.common.utils.XMLUtil;
import org.eclipse.epf.export.msp.ExportMSPException;
import org.eclipse.epf.export.msp.ExportMSPPlugin;
import org.eclipse.epf.export.msp.ExportMSPResources;
import org.eclipse.epf.export.msp.ExportMSPServiceException;
import org.eclipse.epf.export.msp.ExportMSPXMLOperation;
import org.eclipse.epf.export.msp.ExportOptions;
import org.eclipse.epf.library.edit.process.ActivityWrapperItemProvider;
import org.eclipse.epf.library.edit.process.BreakdownElementWrapperItemProvider;
import org.eclipse.epf.library.edit.process.RoleDescriptorWrapperItemProvider;
import org.eclipse.epf.library.edit.process.TaskDescriptorWrapperItemProvider;
import org.eclipse.epf.library.edit.ui.UserInteractionHelper;
import org.eclipse.epf.library.edit.util.ProcessUtil;
import org.eclipse.epf.library.edit.util.Suppression;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.library.util.ResourceHelper;
import org.eclipse.epf.msproject.Assignment;
import org.eclipse.epf.msproject.DocumentRoot;
import org.eclipse.epf.msproject.MsprojectFactory;
import org.eclipse.epf.msproject.PredecessorLink;
import org.eclipse.epf.msproject.Project;
import org.eclipse.epf.msproject.Resource;
import org.eclipse.epf.msproject.util.MsprojectResourceImpl;
import org.eclipse.epf.publishing.services.AbstractPublishManager;
import org.eclipse.epf.publishing.services.PublishManager;
import org.eclipse.epf.publishing.services.PublishOptions;
import org.eclipse.epf.publishing.wizards.PublishProgressMonitorDialog;
import org.eclipse.epf.uma.Activity;
import org.eclipse.epf.uma.BreakdownElement;
import org.eclipse.epf.uma.CapabilityPattern;
import org.eclipse.epf.uma.DeliveryProcess;
import org.eclipse.epf.uma.DescribableElement;
import org.eclipse.epf.uma.MethodConfiguration;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.Milestone;
import org.eclipse.epf.uma.Process;
import org.eclipse.epf.uma.Role;
import org.eclipse.epf.uma.RoleDescriptor;
import org.eclipse.epf.uma.Task;
import org.eclipse.epf.uma.TaskDescriptor;
import org.eclipse.epf.uma.WorkBreakdownElement;
import org.eclipse.epf.uma.WorkOrder;
import org.eclipse.epf.uma.WorkProductDescriptor;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.swt.widgets.Display;

public class ExportMSPXMLService {
    private static boolean debug = ExportMSPPlugin.getDefault().isDebugging();
    private AbstractPublishManager publishMgr;
    private List referencedTasks = new ArrayList();
    private HashMap rolesToUidMap = new HashMap();
    private HashMap wbsToUidMap = new HashMap();
    private HashMap taskToGuidMap = new HashMap();
    private HashMap predListMap = new HashMap();
    private String contentFolderName;
    private String abTargetDir;
    private Suppression suppression;
    private boolean exportOnlyPlannedElements;
    private boolean publishContentSite = false;
    private int task_uid = 1;
    private int res_uid = 1;
    private int assign_uid = 1;
    private MsprojectFactory projectFactory = MsprojectFactory.eINSTANCE;
    private IStructuredContentProvider contentProvider;

    public boolean export(Process process, String msprojectName, File targetDir, ExportOptions exportOptions, PublishOptions publishConfigOptions) throws ExportMSPServiceException {
        if (debug) {
            System.out.println("$$$ exporting to Microsoft Project!");
            System.out.println("$$$ process                   = " + process);
            System.out.println("$$$ msprojectName             = " + msprojectName);
            System.out.println("$$$ targetDir                 = " + targetDir);
            System.out.println("$$$ exportOnlyPlannedElements = " + this.exportOnlyPlannedElements);
            System.out.println("$$$ publishConfigOptions      = " + publishConfigOptions);
        }
        if (!targetDir.exists()) {
            targetDir.mkdirs();
        }
        this.abTargetDir = targetDir.getAbsolutePath();
        Path exportPath = new Path(this.abTargetDir);
        boolean endWithXmlExt = msprojectName.toLowerCase().endsWith(".xml");
        String exportPathStr = exportPath.append(endWithXmlExt ? msprojectName : String.valueOf(msprojectName) + ".xml").toOSString();
        if (debug) {
            System.out.println("$$$ exportPathStr                 = " + exportPathStr);
        }
        String emptyTemplateFile = String.valueOf(ExportMSPPlugin.getDefault().getInstallPath()) + "template" + File.separator + "msproject_2003_template.xml";
        if (debug) {
            System.out.println("$$$ emptyTemplateFile             = " + emptyTemplateFile);
        }
        try {
            File src = new File(emptyTemplateFile);
            File dst = new File(exportPathStr);
            this.copy(src, dst);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Project project = null;
        URI fileURI = URI.createFileURI((String)exportPathStr);
        try {
            MsprojectResourceImpl res = new MsprojectResourceImpl(fileURI);
            res.getDefaultSaveOptions().put("EXTENDED_META_DATA", Boolean.TRUE);
            res.getDefaultLoadOptions().put("EXTENDED_META_DATA", Boolean.TRUE);
            res.getDefaultSaveOptions().put("SCHEMA_LOCATION", Boolean.TRUE);
            res.getDefaultSaveOptions().put("USE_ENCODED_ATTRIBUTE_STYLE", Boolean.TRUE);
            res.getDefaultLoadOptions().put("USE_LEXICAL_HANDLER", Boolean.TRUE);
            res.load(null);
            DocumentRoot docRoot = (DocumentRoot)res.getEObject("/");
            project = docRoot.getProject();
            this.generateMSProject(process, project, targetDir, exportOptions, publishConfigOptions);
            res.save(null);
            if (debug) {
                ExportMSPXMLService.printMSProject(project);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ExportMSPException(e);
        }
        return true;
    }

    public boolean generateMSProject(Process process, Project project, File targetDir, ExportOptions exportOptions, PublishOptions publishConfigOptions) throws Exception {
        block14: {
            block12: {
                block13: {
                    if (process == null || project == null) {
                        throw new IllegalArgumentException();
                    }
                    MethodConfiguration methodConfig = null;
                    if (process instanceof DeliveryProcess) {
                        methodConfig = ((DeliveryProcess)process).getDefaultContext();
                    } else if (process instanceof CapabilityPattern) {
                        methodConfig = ((CapabilityPattern)process).getDefaultContext();
                    } else {
                        throw new IllegalArgumentException();
                    }
                    this.contentFolderName = methodConfig.getName();
                    if (publishConfigOptions == null) break block12;
                    this.publishContentSite = true;
                    File contentDir = new File(targetDir, this.contentFolderName);
                    if (!contentDir.exists()) {
                        contentDir.mkdirs();
                    }
                    if (debug) {
                        System.out.println("$$$ vieBuilder methodConfig = " + methodConfig);
                        System.out.println("$$$ vieBuilder publishConfigOptions = " + publishConfigOptions);
                    }
                    this.publishMgr = new PublishManager();
                    this.publishMgr.init(contentDir.getAbsolutePath(), methodConfig, publishConfigOptions);
                    if (this.publishConfiguration()) break block12;
                    Object var8_9 = null;
                    if (this.publishMgr == null) break block13;
                    this.publishMgr.dispose();
                    this.publishMgr = null;
                }
                return false;
            }
            try {
                this.setExportOptions(exportOptions);
                this.suppression = new Suppression(process);
                project.setName(process.getName());
                project.setStartDate((Object)new Date());
                project.setCreationDate((Object)new Date());
                project.setLastSaved((Object)new Date());
                project.setFinishDate((Object)new Date());
                this.generateProjectResources(process, project);
                this.generateProjectTasks(process, project);
                this.generateLinks(process, project);
                Object var8_10 = null;
                if (this.publishMgr == null) break block14;
            }
            catch (Exception e) {
                try {
                    throw e;
                }
                catch (Throwable throwable) {
                    block15: {
                        Object var8_11 = null;
                        if (this.publishMgr == null) break block15;
                        this.publishMgr.dispose();
                        this.publishMgr = null;
                    }
                    throw throwable;
                }
            }
            this.publishMgr.dispose();
            this.publishMgr = null;
        }
        return true;
    }

    protected void setExportOptions(ExportOptions exportOptions) {
        Boolean exportOnlyPlannedElements = (Boolean)exportOptions.get("exportOnlyPlannedElements");
        this.exportOnlyPlannedElements = exportOnlyPlannedElements;
    }

    /*
     * Exception decompiling
     */
    protected void generateProjectResources(Process process, Project project) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 2[TRYBLOCK] [2 : 149->153)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected void generateProjectResource(IStructuredContentProvider contentProvider, BreakdownElement breakdownElement, Project project) throws Exception {
        if (breakdownElement instanceof WorkProductDescriptor || breakdownElement.getSuppressed().booleanValue() || this.exportOnlyPlannedElements && !breakdownElement.getIsPlanned().booleanValue()) {
            return;
        }
        if (breakdownElement instanceof RoleDescriptor) {
            this.addResource(breakdownElement, project);
            return;
        }
        if (contentProvider != null) {
            Object[] elements = contentProvider.getElements((Object)breakdownElement);
            int i = 0;
            while (i < elements.length) {
                Object value;
                RoleDescriptorWrapperItemProvider provider;
                Object element = elements[i];
                if (element instanceof RoleDescriptorWrapperItemProvider) {
                    provider = (RoleDescriptorWrapperItemProvider)element;
                    value = provider.getValue();
                    if (value instanceof RoleDescriptor) {
                        this.addResource((BreakdownElement)value, project);
                    }
                } else if (element instanceof RoleDescriptor) {
                    this.addResource((BreakdownElement)element, project);
                } else if (element instanceof BreakdownElementWrapperItemProvider) {
                    provider = (BreakdownElementWrapperItemProvider)element;
                    value = provider.getValue();
                    if (value instanceof WorkBreakdownElement) {
                        this.generateProjectResource(contentProvider, (BreakdownElement)((WorkBreakdownElement)value), project);
                    }
                } else if (element instanceof WorkBreakdownElement) {
                    this.generateProjectResource(contentProvider, (BreakdownElement)((WorkBreakdownElement)element), project);
                }
                ++i;
            }
        }
    }

    protected void addResource(BreakdownElement breakdownElement, Project proj) throws Exception {
        Resource aRes;
        if (!(breakdownElement instanceof RoleDescriptor)) {
            return;
        }
        RoleDescriptor roleDescriptor = (RoleDescriptor)breakdownElement;
        if (debug) {
            System.out.println("$$$ handle RoleDescriptor = " + roleDescriptor);
        }
        Role ref_edRole = roleDescriptor.getRole();
        if (debug) {
            System.out.println("$$$ handle Ref-ed Role = " + ref_edRole);
        }
        boolean newRDResource = true;
        String rdResourceName = this.getDisplayName((MethodElement)roleDescriptor);
        if (this.rolesToUidMap.get(rdResourceName) != null) {
            newRDResource = false;
        }
        boolean newRoleReource = false;
        String roleResourceName = null;
        if (ref_edRole != null && this.rolesToUidMap.get(roleResourceName = this.getDisplayName((MethodElement)ref_edRole)) == null && !roleResourceName.equalsIgnoreCase(rdResourceName)) {
            newRoleReource = true;
        }
        if (newRDResource) {
            aRes = this.projectFactory.createResource();
            aRes.setUID(BigInteger.valueOf(this.res_uid));
            aRes.setID(BigInteger.valueOf(this.res_uid));
            aRes.setName(rdResourceName);
            proj.getResources().getResource().add((Object)aRes);
            this.rolesToUidMap.put(rdResourceName, BigInteger.valueOf(this.res_uid));
            ++this.res_uid;
        }
        if (newRoleReource) {
            aRes = this.projectFactory.createResource();
            aRes.setUID(BigInteger.valueOf(this.res_uid));
            aRes.setID(BigInteger.valueOf(this.res_uid));
            aRes.setName(roleResourceName);
            proj.getResources().getResource().add((Object)aRes);
            this.rolesToUidMap.put(roleResourceName, BigInteger.valueOf(this.res_uid));
            ++this.res_uid;
        }
    }

    /*
     * Exception decompiling
     */
    protected void generateProjectTasks(Process process, Project project) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 2[TRYBLOCK] [2 : 175->179)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected void generateProjectTask(IStructuredContentProvider contentProvider, BreakdownElement breakdownElement, int taskOLevel, Project proj) throws Exception {
        ArrayList rollupRoles;
        boolean rb;
        if (breakdownElement instanceof WorkProductDescriptor || breakdownElement instanceof RoleDescriptor || breakdownElement.getSuppressed().booleanValue() || this.exportOnlyPlannedElements && !breakdownElement.getIsPlanned().booleanValue()) {
            return;
        }
        boolean isSubTasksPlanned = false;
        if (this.exportOnlyPlannedElements && breakdownElement instanceof Activity && contentProvider != null) {
            Object[] elements = contentProvider.getElements((Object)breakdownElement);
            int i = 0;
            while (i < elements.length) {
                Object wrappedElement;
                Object element = elements[i];
                if (element instanceof Activity) {
                    if (!this.exportOnlyPlannedElements || ((Activity)element).getIsPlanned().booleanValue()) {
                        isSubTasksPlanned = true;
                        break;
                    }
                } else if (element instanceof ActivityWrapperItemProvider) {
                    wrappedElement = TngUtil.unwrap((Object)element);
                    if (wrappedElement instanceof Activity && (!this.exportOnlyPlannedElements || ((Activity)wrappedElement).getIsPlanned().booleanValue())) {
                        isSubTasksPlanned = true;
                        break;
                    }
                } else if (element instanceof TaskDescriptor) {
                    TaskDescriptor descriptor = (TaskDescriptor)element;
                    if (!this.exportOnlyPlannedElements || descriptor.getIsPlanned().booleanValue()) {
                        isSubTasksPlanned = true;
                        break;
                    }
                } else if (element instanceof TaskDescriptorWrapperItemProvider && (wrappedElement = TngUtil.unwrap((Object)element)) instanceof TaskDescriptor) {
                    TaskDescriptor descriptor = (TaskDescriptor)wrappedElement;
                    if (!this.exportOnlyPlannedElements || descriptor.getIsPlanned().booleanValue()) {
                        isSubTasksPlanned = true;
                        break;
                    }
                }
                ++i;
            }
        }
        boolean isPlannedTask = breakdownElement.getIsPlanned();
        org.eclipse.epf.msproject.Task newTask = null;
        if (!this.exportOnlyPlannedElements || this.exportOnlyPlannedElements && isPlannedTask) {
            newTask = this.addTask((WorkBreakdownElement)breakdownElement, taskOLevel, proj);
        }
        if (this.exportOnlyPlannedElements && newTask != null && breakdownElement instanceof Activity && contentProvider != null && !isSubTasksPlanned && !(rb = this.calculateRollupRoles(contentProvider, breakdownElement, rollupRoles = new ArrayList()))) {
            HashSet rolesSet = new HashSet(rollupRoles);
            Iterator iter = rolesSet.iterator();
            while (iter.hasNext()) {
                String roleName = (String)iter.next();
                this.addAssignment(roleName, newTask.getUID().intValue(), proj);
            }
        }
        if (contentProvider != null) {
            Object[] elements = contentProvider.getElements((Object)breakdownElement);
            int i = 0;
            while (i < elements.length) {
                Object element = elements[i];
                if (element instanceof BreakdownElementWrapperItemProvider) {
                    BreakdownElementWrapperItemProvider provider = (BreakdownElementWrapperItemProvider)element;
                    Object value = provider.getValue();
                    this.generateProjectTask(contentProvider, (BreakdownElement)value, taskOLevel + 1, proj);
                } else if (element instanceof WorkBreakdownElement) {
                    this.generateProjectTask(contentProvider, (BreakdownElement)((WorkBreakdownElement)element), taskOLevel + 1, proj);
                }
                ++i;
            }
        }
    }

    protected org.eclipse.epf.msproject.Task addTask(WorkBreakdownElement element, int taskOLevel, Project project) throws Exception {
        if (element == null) {
            return null;
        }
        org.eclipse.epf.msproject.Task task = this.projectFactory.createTask();
        task.setName(this.getDisplayName((MethodElement)element));
        task.setOutlineLevel(BigInteger.valueOf(taskOLevel));
        task.setUID(BigInteger.valueOf(this.task_uid));
        task.setID(BigInteger.valueOf(this.task_uid));
        task.setType(BigInteger.valueOf(0L));
        GregorianCalendar gcDate = new GregorianCalendar();
        Date startDate = gcDate.getTime();
        task.setStart((Object)startDate);
        String notes = this.getBriefDescription(element);
        if (notes != null || notes.trim().length() > 0) {
            task.setNotes(notes);
        }
        if (element instanceof Milestone) {
            task.setMilestone(true);
            task.setDurationFormat(BigInteger.valueOf(7L));
        }
        List rolesList = null;
        if (element instanceof TaskDescriptor) {
            rolesList = this.getRolesForTaskD((TaskDescriptor)element);
        } else if (element instanceof Task) {
            rolesList = this.getRolesForTask((Task)element);
        }
        if (rolesList != null) {
            Iterator iter = rolesList.iterator();
            while (iter.hasNext()) {
                String roleName = (String)iter.next();
                this.addAssignment(roleName, this.task_uid, project);
            }
        }
        if (this.publishContentSite) {
            String linkURL = this.getElementURL((MethodElement)element);
            if (element instanceof TaskDescriptor) {
                TaskDescriptor taskDescriptor = (TaskDescriptor)element;
                Task ref_edTask = taskDescriptor.getTask();
                linkURL = this.getElementURL((MethodElement)ref_edTask);
                this.referencedTasks.add(ref_edTask);
            }
            task.setHyperlinkAddress(linkURL);
        }
        this.storeTaskPredecessors(element);
        project.getTasks().getTask().add((Object)task);
        this.wbsToUidMap.put(element.getGuid(), BigInteger.valueOf(this.task_uid));
        this.taskToGuidMap.put(BigInteger.valueOf(this.task_uid), element.getGuid());
        ++this.task_uid;
        return task;
    }

    private String getBriefDescription(WorkBreakdownElement element) {
        TaskDescriptor taskDescriptor;
        Task ref_edTask;
        if (element == null) {
            return null;
        }
        String briefDesc = element.getBriefDescription();
        if ((briefDesc == null || briefDesc.trim().length() <= 0) && element instanceof TaskDescriptor && (ref_edTask = (taskDescriptor = (TaskDescriptor)element).getTask()) != null) {
            briefDesc = ref_edTask.getBriefDescription();
        }
        return briefDesc;
    }

    private void addAssignment(String resName, int taskUid, Project proj) {
        Assignment assignment = this.projectFactory.createAssignment();
        assignment.setUID(BigInteger.valueOf(this.assign_uid));
        assignment.setTaskUID(BigInteger.valueOf(taskUid));
        BigInteger resID = (BigInteger)this.rolesToUidMap.get(resName);
        assignment.setResourceUID(resID);
        proj.getAssignments().getAssignment().add((Object)assignment);
        ++this.assign_uid;
    }

    private List getRolesForTaskD(TaskDescriptor taskDescriptor) {
        ArrayList<String> rolesList = new ArrayList<String>();
        RoleDescriptor roleDescrp = taskDescriptor.getPerformedPrimarilyBy();
        if (roleDescrp != null) {
            rolesList.add(this.getDisplayName((MethodElement)roleDescrp));
        }
        List roleDescrpList = taskDescriptor.getAdditionallyPerformedBy();
        Iterator iter = roleDescrpList.iterator();
        while (iter.hasNext()) {
            roleDescrp = (RoleDescriptor)iter.next();
            rolesList.add(this.getDisplayName((MethodElement)roleDescrp));
        }
        return rolesList;
    }

    private List getRolesForTask(Task umaTask) {
        ArrayList<String> rolesList = new ArrayList<String>();
        Role role = umaTask.getPerformedBy();
        if (role != null) {
            rolesList.add(this.getDisplayName((MethodElement)role));
        }
        List list = umaTask.getAdditionallyPerformedBy();
        Iterator iter = list.iterator();
        while (iter.hasNext()) {
            role = (Role)iter.next();
            rolesList.add(this.getDisplayName((MethodElement)role));
        }
        return rolesList;
    }

    private boolean calculateRollupRoles(IStructuredContentProvider contentProvider, BreakdownElement breakdownElement, List rollupRoles) {
        boolean isAnySubTaskPlanned = false;
        Object[] elements = contentProvider.getElements((Object)breakdownElement);
        int i = 0;
        while (i < elements.length) {
            Object wrappedElement;
            Object element = elements[i];
            if (element instanceof Activity) {
                isAnySubTaskPlanned = !this.exportOnlyPlannedElements || ((Activity)element).getIsPlanned().booleanValue() ? true : this.calculateRollupRoles(contentProvider, (BreakdownElement)element, rollupRoles);
            } else if (element instanceof ActivityWrapperItemProvider) {
                wrappedElement = TngUtil.unwrap((Object)element);
                if (wrappedElement instanceof Activity) {
                    isAnySubTaskPlanned = !this.exportOnlyPlannedElements || ((Activity)wrappedElement).getIsPlanned().booleanValue() ? true : this.calculateRollupRoles(contentProvider, (BreakdownElement)wrappedElement, rollupRoles);
                }
            } else if (element instanceof TaskDescriptor) {
                TaskDescriptor descriptor = (TaskDescriptor)element;
                if (!this.exportOnlyPlannedElements || descriptor.getIsPlanned().booleanValue()) {
                    isAnySubTaskPlanned = true;
                } else {
                    rollupRoles.addAll(this.getRolesForTaskD((TaskDescriptor)element));
                }
            } else if (element instanceof TaskDescriptorWrapperItemProvider && (wrappedElement = TngUtil.unwrap((Object)element)) instanceof TaskDescriptor) {
                TaskDescriptor descriptor = (TaskDescriptor)wrappedElement;
                if (!this.exportOnlyPlannedElements || descriptor.getIsPlanned().booleanValue()) {
                    isAnySubTaskPlanned = true;
                } else {
                    rollupRoles.addAll(this.getRolesForTaskD((TaskDescriptor)wrappedElement));
                }
            }
            ++i;
        }
        return isAnySubTaskPlanned;
    }

    private void storeTaskPredecessors(WorkBreakdownElement element) {
        if (element == null) {
            return;
        }
        List predecessors = element.getLinkToPredecessor();
        ArrayList<String> predList = new ArrayList<String>();
        if (predecessors != null && predecessors.size() > 0) {
            Iterator i = predecessors.iterator();
            while (i.hasNext()) {
                String predGuid;
                WorkOrder workOrder = (WorkOrder)i.next();
                WorkBreakdownElement predecessor = workOrder.getPred();
                if (predecessor == null || (predGuid = predecessor.getGuid()) == null) continue;
                predList.add(predGuid);
            }
        }
        if (debug) {
            System.out.println("$$$ predlist for " + element.getName() + " = " + predList.toString());
        }
        this.predListMap.put(element.getGuid(), predList);
    }

    protected void generateLinks(Process process, Project project) throws Exception {
        EList tasks = project.getTasks().getTask();
        Iterator iter = tasks.iterator();
        while (iter.hasNext()) {
            String wbsGuid;
            ArrayList predList;
            org.eclipse.epf.msproject.Task task = (org.eclipse.epf.msproject.Task)iter.next();
            BigInteger taskUid = task.getUID();
            if (taskUid.intValue() == 0 || (predList = (ArrayList)this.predListMap.get(wbsGuid = (String)this.taskToGuidMap.get(taskUid))) == null) continue;
            Iterator iterator = predList.iterator();
            while (iterator.hasNext()) {
                String predGuid = (String)iterator.next();
                BigInteger predTaskUid = (BigInteger)this.wbsToUidMap.get(predGuid);
                if (predTaskUid == null || predTaskUid.intValue() == taskUid.intValue()) continue;
                PredecessorLink preLink = this.projectFactory.createPredecessorLink();
                task.getPredecessorLink().add((Object)preLink);
                preLink.setPredecessorUID(predTaskUid);
                preLink.setType(new BigInteger("1"));
                preLink.setCrossProject(false);
                preLink.setLinkLag(new BigInteger("0"));
                preLink.setLagFormat(new BigInteger("7"));
            }
        }
    }

    protected String getElementURL(MethodElement element) {
        String elementPath = null;
        String elementFileName = null;
        try {
            elementPath = ResourceHelper.getElementPath((MethodElement)element);
            elementFileName = ResourceHelper.getFileName((MethodElement)element, (String)".html");
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
        if (elementPath != null && elementFileName != null) {
            elementPath = elementPath.replace('\\', '/');
            elementFileName = elementFileName.replace('\\', '/');
            String url = String.valueOf(this.contentFolderName) + "/" + elementPath + elementFileName;
            return String.valueOf(this.abTargetDir) + File.separator + url;
        }
        return "";
    }

    protected String getDisplayName(MethodElement element) {
        String name = null;
        if (element instanceof BreakdownElement) {
            name = ProcessUtil.getPresentationName((BreakdownElement)((BreakdownElement)element));
        } else if (element instanceof DescribableElement) {
            name = ((DescribableElement)element).getPresentationName();
        }
        if (name == null || name.length() == 0) {
            name = element.getName();
        }
        return XMLUtil.escapeAttr((String)name);
    }

    protected boolean publishConfiguration() throws Exception {
        ExportMSPXMLOperation operation = new ExportMSPXMLOperation(this.publishMgr);
        PublishProgressMonitorDialog dlg = new PublishProgressMonitorDialog(Display.getCurrent().getActiveShell(), this.publishMgr.getViewBuilder());
        boolean success = UserInteractionHelper.runWithProgress((IRunnableWithProgress)operation, (ProgressMonitorDialog)dlg, (boolean)true, (String)ExportMSPResources.exportMSPWizard_title);
        if (operation.getException() != null) {
            throw operation.getException();
        }
        return success && !dlg.getProgressMonitor().isCanceled();
    }

    private void copy(File src, File dst) throws IOException {
        int len;
        FileInputStream in = new FileInputStream(src);
        FileOutputStream out = new FileOutputStream(dst);
        byte[] buf = new byte[1024];
        while ((len = ((InputStream)in).read(buf)) > 0) {
            ((OutputStream)out).write(buf, 0, len);
        }
        ((InputStream)in).close();
        ((OutputStream)out).close();
    }

    private static void printMSProject(Project project) {
        System.out.println("\n$$$ read-in project = " + project);
        EList tasks = project.getTasks().getTask();
        Iterator iter = tasks.iterator();
        while (iter.hasNext()) {
            org.eclipse.epf.msproject.Task element = (org.eclipse.epf.msproject.Task)iter.next();
            System.out.println("$$$ a task = " + element);
        }
        EList resources = project.getResources().getResource();
        Iterator iter2 = resources.iterator();
        while (iter2.hasNext()) {
            Resource element = (Resource)iter2.next();
            System.out.println("$$$ a resource = " + element);
        }
        EList assignments = project.getAssignments().getAssignment();
        Iterator iter3 = assignments.iterator();
        while (iter3.hasNext()) {
            Assignment element = (Assignment)iter3.next();
            System.out.println("$$$ an assignment = " + element);
        }
        System.out.println("$$$===\n");
    }
}

