/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.export.msp.ui.wizards;

import java.util.List;
import java.util.Map;
import org.eclipse.epf.export.msp.ExportMSPPlugin;
import org.eclipse.epf.export.msp.ExportMSPResources;
import org.eclipse.epf.export.msp.ExportMSPUtil;
import org.eclipse.epf.export.msp.ExportOptions;
import org.eclipse.epf.export.msp.ui.wizards.ExportMSPWizard;
import org.eclipse.epf.export.msp.ui.wizards.ExportOptionContribution;
import org.eclipse.epf.export.msp.ui.wizards.IExportMSPWizardExtender;
import org.eclipse.epf.uma.Process;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;

public class SelectProcessPage
extends WizardPage
implements Listener {
    public static final String PAGE_NAME;
    private static final String[] EMPTY_ARRAY;
    private ExportOptions exportOptions;
    private Button capabilityPatternRadioButton;
    private Button deliveryProcessRadioButton;
    private Combo processCombo;
    private Combo contextCombo;
    private Button publishConfigurationCheckBox;
    private Button exportOnlyPlannedElementsCheckBox;
    private Button[] exportOptionCheckBoxes;
    private Map capabilityPatterns;
    private Map deliveryProcesses;
    private ModifyListener modifyListener = new ModifyListener(){

        public void modifyText(ModifyEvent e) {
            SelectProcessPage.this.setPageComplete(SelectProcessPage.this.isPageComplete());
        }
    };
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.epf.export.msp.ui.wizards.SelectProcessPage");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        PAGE_NAME = clazz.getName();
        EMPTY_ARRAY = new String[0];
    }

    public SelectProcessPage(ExportOptions exportOptions) {
        super(PAGE_NAME);
        this.exportOptions = exportOptions;
        this.setTitle(ExportMSPResources.selectProcessWizardPage_title);
        this.setDescription(ExportMSPResources.selectProcessWizardPage_text);
        this.setImageDescriptor(ExportMSPPlugin.getDefault().getImageDescriptor("full/wizban/ExportMSProject.gif"));
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(1, false));
        Group processGroup = new Group(composite, 0);
        processGroup.setLayout((Layout)new GridLayout(1, false));
        processGroup.setLayoutData((Object)new GridData(768));
        processGroup.setText(ExportMSPResources.processGroup_text);
        Composite buttonComposite = new Composite((Composite)processGroup, 0);
        buttonComposite.setLayout((Layout)new GridLayout(2, false));
        this.capabilityPatternRadioButton = new Button(buttonComposite, 16);
        this.capabilityPatternRadioButton.setText(ExportMSPResources.capabilityPatternRadioButton_text);
        this.capabilityPatternRadioButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent event) {
                SelectProcessPage.this.updateProcessCombo(SelectProcessPage.this.capabilityPatterns);
            }

            public void widgetDefaultSelected(SelectionEvent event) {
            }
        });
        this.deliveryProcessRadioButton = new Button(buttonComposite, 16);
        this.deliveryProcessRadioButton.setText(ExportMSPResources.deliveryProcessRadioButton_text);
        this.deliveryProcessRadioButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent event) {
                SelectProcessPage.this.updateProcessCombo(SelectProcessPage.this.deliveryProcesses);
            }

            public void widgetDefaultSelected(SelectionEvent event) {
            }
        });
        Composite processComposite = new Composite((Composite)processGroup, 0);
        processComposite.setLayout((Layout)new GridLayout(2, false));
        processComposite.setLayoutData((Object)new GridData(768));
        Label processNameLabel = new Label(processComposite, 0);
        processNameLabel.setText(ExportMSPResources.processNameLabel_text);
        this.processCombo = new Combo(processComposite, 2056);
        this.processCombo.setLayoutData((Object)new GridData(768));
        this.processCombo.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent event) {
                SelectProcessPage.this.updateContextCombo(SelectProcessPage.this.getProcess());
            }

            public void widgetDefaultSelected(SelectionEvent event) {
            }
        });
        Label contextNameLabel = new Label(processComposite, 0);
        contextNameLabel.setText(ExportMSPResources.contextNameLabel_text);
        this.contextCombo = new Combo(processComposite, 2056);
        this.contextCombo.setLayoutData((Object)new GridData(768));
        this.contextCombo.addModifyListener(this.modifyListener);
        this.capabilityPatterns = ExportMSPUtil.getCapabilityPatterns();
        this.deliveryProcesses = ExportMSPUtil.getDeliveryProcesses();
        String savedProcessType = ExportMSPPlugin.getDefault().getPreferenceStore().getString("processType");
        if (savedProcessType != null && savedProcessType.equals("DeliveryProcess") && this.deliveryProcesses.size() > 0) {
            this.deliveryProcessRadioButton.setSelection(true);
            this.updateProcessCombo(this.deliveryProcesses);
        } else if (savedProcessType != null && this.capabilityPatterns.size() > 0) {
            this.capabilityPatternRadioButton.setSelection(true);
            this.updateProcessCombo(this.capabilityPatterns);
        } else if (this.capabilityPatterns.size() > 0) {
            this.capabilityPatternRadioButton.setSelection(true);
            this.updateProcessCombo(this.capabilityPatterns);
        } else {
            this.deliveryProcessRadioButton.setSelection(true);
            this.updateProcessCombo(this.deliveryProcesses);
        }
        Group optionsGroup = new Group(composite, 0);
        optionsGroup.setLayout((Layout)new GridLayout(1, false));
        optionsGroup.setLayoutData((Object)new GridData(768));
        optionsGroup.setText(ExportMSPResources.optionsGroup_text);
        Composite checkBoxComposite = new Composite((Composite)optionsGroup, 0);
        checkBoxComposite.setLayout((Layout)new GridLayout(1, false));
        this.publishConfigurationCheckBox = new Button(checkBoxComposite, 32);
        this.publishConfigurationCheckBox.setText(ExportMSPResources.publishConfigurationCheckBox_text);
        this.publishConfigurationCheckBox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                SelectProcessPage.this.exportOptions.remove("publishConfig");
                SelectProcessPage.this.exportOptions.put("publishConfig", new Boolean(SelectProcessPage.this.publishConfigurationCheckBox.getSelection()));
                SelectProcessPage.this.setPageComplete(SelectProcessPage.this.isPageComplete());
            }
        });
        this.exportOnlyPlannedElementsCheckBox = new Button(checkBoxComposite, 32);
        this.exportOnlyPlannedElementsCheckBox.setText(ExportMSPResources.exportOnlyPlannedElementsCheckBox_text);
        this.exportOnlyPlannedElementsCheckBox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                SelectProcessPage.this.exportOptions.remove("exportOnlyPlannedElements");
                SelectProcessPage.this.exportOptions.put("exportOnlyPlannedElements", new Boolean(SelectProcessPage.this.exportOnlyPlannedElementsCheckBox.getSelection()));
                SelectProcessPage.this.setPageComplete(SelectProcessPage.this.isPageComplete());
            }
        });
        ExportMSPWizard wizard = (ExportMSPWizard)this.getWizard();
        IExportMSPWizardExtender wizardExtender = wizard.getWizardExtender();
        if (wizardExtender != null) {
            List exportOptionContributions = wizardExtender.getExportOptionContributions();
            int size = exportOptionContributions.size();
            this.exportOptionCheckBoxes = new Button[size];
            int i = 0;
            while (i < size) {
                ExportOptionContribution exportOptionContribution = (ExportOptionContribution)exportOptionContributions.get(i);
                this.exportOptionCheckBoxes[i] = new Button(checkBoxComposite, 32);
                this.exportOptionCheckBoxes[i].setText(exportOptionContribution.getDescription());
                final String optionName = exportOptionContribution.getName();
                this.exportOptionCheckBoxes[i].addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent event) {
                        SelectProcessPage.this.exportOptions.remove(optionName);
                        Button button = (Button)event.getSource();
                        SelectProcessPage.this.exportOptions.put(optionName, new Boolean(button.getSelection()));
                    }
                });
                this.exportOptionCheckBoxes[i].setSelection(exportOptionContribution.getDefaultSelection());
                ++i;
            }
        }
        this.setControl((Control)composite);
    }

    public void handleEvent(Event event) {
        this.setPageComplete(this.isPageComplete());
        this.getWizard().getContainer().updateButtons();
    }

    public boolean isPageComplete() {
        return this.processCombo.getText().trim().length() > 0 && this.contextCombo.getText().trim().length() > 0;
    }

    public IWizardPage getNextPage() {
        IWizardPage page;
        ExportMSPWizard wizard = (ExportMSPWizard)this.getWizard();
        IExportMSPWizardExtender wizardExtender = wizard.getWizardExtender();
        if (wizardExtender != null && (page = wizardExtender.getNextPage((IWizardPage)this)) != null) {
            return page;
        }
        if (this.getPublishedConfiguration()) {
            return super.getNextPage();
        }
        return wizard.getSelectExportDirectoryPage();
    }

    public Process getProcess() {
        if (this.capabilityPatternRadioButton.getSelection()) {
            String name = this.processCombo.getText();
            return (Process)this.capabilityPatterns.get(name);
        }
        String name = this.processCombo.getText();
        return (Process)this.deliveryProcesses.get(name);
    }

    public ExportOptions getExportOptions() {
        return this.exportOptions;
    }

    public String getProcessContextName() {
        return this.contextCombo.getText();
    }

    public boolean getExportOnlyPlannedElements() {
        return this.exportOnlyPlannedElementsCheckBox.getSelection();
    }

    public boolean getPublishedConfiguration() {
        return this.publishConfigurationCheckBox.getSelection();
    }

    protected void updateProcessCombo(Map processes) {
        if (processes != null && processes.size() > 0) {
            String[] names = new String[processes.size()];
            processes.keySet().toArray(names);
            this.processCombo.setItems(names);
            String savedProcess = ExportMSPPlugin.getDefault().getPreferenceStore().getString("processName");
            if (savedProcess != null && processes.containsKey(savedProcess)) {
                this.processCombo.setText(savedProcess);
            } else {
                this.processCombo.setText(this.processCombo.getItem(0));
            }
            this.updateContextCombo(this.getProcess());
        }
    }

    protected void updateContextCombo(Process process) {
        try {
            Map contexts = ExportMSPUtil.getContexts(process);
            if (contexts != null && contexts.size() > 0) {
                String[] names = new String[contexts.size()];
                contexts.keySet().toArray(names);
                this.contextCombo.setItems(names);
                String savedContext = ExportMSPPlugin.getDefault().getPreferenceStore().getString("context");
                if (savedContext != null && contexts.containsKey(savedContext)) {
                    this.contextCombo.setText(savedContext);
                } else {
                    String defaultContext = process.getDefaultContext().getName();
                    this.contextCombo.setText(defaultContext);
                }
            } else {
                this.contextCombo.setItems(EMPTY_ARRAY);
            }
        }
        catch (Exception exception) {}
    }
}

