/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.publishing.ui.preferences;

import org.eclipse.epf.library.ui.preferences.LibraryUIPreferences;
import org.eclipse.epf.publishing.ui.PublishingUIPlugin;
import org.eclipse.jface.preference.IPreferenceStore;

public class PublishingUIPreferences {
    private static String defaultPublishPath = null;
    private static String defaultTitle = null;
    private static String defaultBannerImage = null;
    private static String defaultAboutHTML = null;
    private static String defaultFeedbackURL = null;

    static {
        IPreferenceStore store = PublishingUIPlugin.getDefault().getPreferenceStore();
        store.setDefault("publishPath", PublishingUIPreferences.getPublishPath());
        store.setDefault("publishPathDefault", PublishingUIPreferences.getDefaultPublishPath());
        store.setDefault("title", PublishingUIPreferences.getDefaultTitle());
        store.setDefault("bannerImage", PublishingUIPreferences.getDefaultBannerImage());
        store.setDefault("aboutHTML", PublishingUIPreferences.getDefaultAboutHTML());
        store.setDefault("feedbackURL", PublishingUIPreferences.getFeedbackURL());
        store.setDefault("feedbackURLDefault", PublishingUIPreferences.getDefaultFeedbackURL());
        store.setDefault("includeGlossary", true);
        store.setDefault("includeIndex", true);
        store.setDefault("checkExternalLinks", false);
    }

    public static String getPublishPath() {
        return PublishingUIPlugin.getDefault().getPreferenceStore().getString("publishPath");
    }

    public static void setPublishPath(String path) {
        PublishingUIPlugin.getDefault().getPreferenceStore().setValue("publishPath", path);
    }

    public static String getTitle() {
        return PublishingUIPlugin.getDefault().getPreferenceStore().getString("title");
    }

    public static void setTitle(String title) {
        PublishingUIPlugin.getDefault().getPreferenceStore().setValue("title", title);
    }

    public static String getBannerImage() {
        return PublishingUIPlugin.getDefault().getPreferenceStore().getString("bannerImage");
    }

    public static void setBannerImage(String image) {
        PublishingUIPlugin.getDefault().getPreferenceStore().setValue("bannerImage", image);
    }

    public static String getAboutHTML() {
        return PublishingUIPlugin.getDefault().getPreferenceStore().getString("aboutHTML");
    }

    public static void setAboutHTML(String file) {
        PublishingUIPlugin.getDefault().getPreferenceStore().setValue("aboutHTML", file);
    }

    public static String getFeedbackURL() {
        return PublishingUIPlugin.getDefault().getPreferenceStore().getString("feedbackURL");
    }

    public static void setFeedbackURL(String url) {
        PublishingUIPlugin.getDefault().getPreferenceStore().setValue("feedbackURL", url);
    }

    public static boolean getIncludeGlossary() {
        return PublishingUIPlugin.getDefault().getPreferenceStore().getBoolean("includeGlossary");
    }

    public static void setIncludeGlossary(boolean flag) {
        PublishingUIPlugin.getDefault().getPreferenceStore().setValue("includeGlossary", flag);
    }

    public static boolean getIncludeIndex() {
        return PublishingUIPlugin.getDefault().getPreferenceStore().getBoolean("includeIndex");
    }

    public static void setIncludeIndex(boolean flag) {
        PublishingUIPlugin.getDefault().getPreferenceStore().setValue("includeIndex", flag);
    }

    public static boolean getCheckExternalLinks() {
        return PublishingUIPlugin.getDefault().getPreferenceStore().getBoolean("checkExternalLinks");
    }

    public static void setCheckExternalLinks(boolean flag) {
        PublishingUIPlugin.getDefault().getPreferenceStore().setValue("checkExternalLinks", flag);
    }

    public static String getDefaultPublishPath() {
        defaultPublishPath = PublishingUIPlugin.getDefault().getPreferenceStore().getString("publishPathDefault").trim();
        if (defaultPublishPath == null || defaultPublishPath.length() <= 0) {
            defaultPublishPath = PublishingUIPreferences.getInitDefaultPublishPath();
        }
        return defaultPublishPath;
    }

    public static String getInitDefaultPublishPath() {
        String userHome = System.getProperty("user.home").replace('\\', '/');
        String path = PublishingUIPlugin.getDefault().getString("publishPath");
        if (path == null || path.length() == 0 || path.startsWith("[")) {
            path = String.valueOf(userHome) + "/publish";
        } else if (path.startsWith("<user.home>")) {
            path = String.valueOf(userHome) + path.substring(11);
        }
        if (System.getProperty("file.separator").equals("\\")) {
            path = path.replace('/', '\\');
        }
        int idx = -1;
        idx = path.indexOf("<app.name>");
        if (idx >= 0) {
            String appNameProper = LibraryUIPreferences.getApplicationShortName();
            path = String.valueOf(path.substring(0, idx)) + appNameProper + path.substring(idx + 10);
        }
        return path;
    }

    public static void setDefaultPublishPath(String path) {
        PublishingUIPlugin.getDefault().getPreferenceStore().setValue("publishPathDefault", path);
    }

    public static String getDefaultTitle() {
        if (defaultTitle == null) {
            String url = PublishingUIPlugin.getDefault().getString("title");
            if (url == null || url.length() == 0 || url.startsWith("[")) {
                url = "";
            }
            defaultTitle = url;
        }
        return defaultTitle;
    }

    public static String getDefaultBannerImage() {
        if (defaultBannerImage == null) {
            String image = PublishingUIPlugin.getDefault().getString("bannerImage");
            if (image == null || image.length() == 0 || image.startsWith("[")) {
                image = "";
            }
            defaultBannerImage = image;
        }
        return defaultBannerImage;
    }

    public static String getDefaultAboutHTML() {
        if (defaultAboutHTML == null) {
            String file = PublishingUIPlugin.getDefault().getString("aboutHTML");
            if (file == null || file.length() == 0 || file.startsWith("[")) {
                file = "";
            }
            defaultAboutHTML = file;
        }
        return defaultAboutHTML;
    }

    public static String getDefaultFeedbackURL() {
        defaultFeedbackURL = PublishingUIPlugin.getDefault().getPreferenceStore().getString("feedbackURLDefault").trim();
        if (defaultFeedbackURL == null || defaultFeedbackURL.length() <= 0) {
            defaultFeedbackURL = PublishingUIPreferences.getInitDefaultFeedbackURL();
        }
        return defaultFeedbackURL;
    }

    public static String getInitDefaultFeedbackURL() {
        String url = PublishingUIPlugin.getDefault().getString("feedbackURL");
        if (url == null || url.length() == 0 || url.startsWith("[")) {
            url = "http://www.published_website.com/feedback";
        }
        return url;
    }

    public static void setDefaultFeedbackURL(String path) {
        PublishingUIPlugin.getDefault().getPreferenceStore().setValue("feedbackURLDefault", path);
    }

    public static void setValue(String name, String value) {
        PublishingUIPlugin.getDefault().getPreferenceStore().setValue(name, value);
    }

    public static void setValue(String name, boolean value) {
        PublishingUIPlugin.getDefault().getPreferenceStore().setValue(name, value);
    }

    public static String getStringValue(String name) {
        return PublishingUIPlugin.getDefault().getPreferenceStore().getString(name);
    }

    public static boolean getBooleanValue(String name) {
        return PublishingUIPlugin.getDefault().getPreferenceStore().getBoolean(name);
    }

    public static void setDefaultValue(String name, String value) {
        PublishingUIPlugin.getDefault().getPreferenceStore().setValue(name, value);
    }

    public static void setDefaultValue(String name, boolean value) {
        PublishingUIPlugin.getDefault().getPreferenceStore().setValue(name, value);
    }

    public static String getDefaultStringValue(String name) {
        return PublishingUIPlugin.getDefault().getPreferenceStore().getString(name);
    }

    public static boolean getDefaultBooleanValue(String name) {
        return PublishingUIPlugin.getDefault().getPreferenceStore().getBoolean(name);
    }
}

