/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.publishing.wizards;

import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.epf.common.utils.FileUtil;
import org.eclipse.epf.library.LibraryService;
import org.eclipse.epf.library.LibraryServiceUtil;
import org.eclipse.epf.library.configuration.ConfigurationHelper;
import org.eclipse.epf.library.ui.preferences.LibraryUIPreferences;
import org.eclipse.epf.publishing.services.PublishOptions;
import org.eclipse.epf.publishing.ui.PublishingUIPlugin;
import org.eclipse.epf.publishing.ui.PublishingUIResources;
import org.eclipse.epf.publishing.ui.preferences.PublishingUIPreferences;
import org.eclipse.epf.publishing.wizards.AbstractPublishWizard;
import org.eclipse.epf.publishing.wizards.PublishConfigPublishOptionsPage;
import org.eclipse.epf.publishing.wizards.PublishConfigSelectConfigPage;
import org.eclipse.epf.publishing.wizards.PublishConfigSelectProcessPage;
import org.eclipse.epf.uma.MethodConfiguration;
import org.eclipse.epf.uma.MethodLibrary;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.ui.IWorkbench;

public class PublishConfigurationWizard
extends AbstractPublishWizard {
    protected PublishConfigSelectConfigPage selectConfigPage;
    protected PublishConfigPublishOptionsPage publishOptionsPage;
    private Map configProcesspageMap = new HashMap();

    public PublishConfigurationWizard() {
        this.setWindowTitle(PublishingUIResources.publishConfigWizard_title);
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
    }

    public ImageDescriptor getImageDescriptor() {
        return PublishingUIPlugin.getDefault().getImageDescriptor("wizban/PublishConfiguration.gif");
    }

    public PublishOptions getPublishOptions() {
        if (this.dataModel == null) {
            this.dataModel = new PublishOptions();
        }
        return this.dataModel;
    }

    public void addPages() {
        ImageDescriptor imageDescriptor = this.getImageDescriptor();
        this.selectConfigPage = new PublishConfigSelectConfigPage("PublishConfigSelectOverviewPage", this.dataModel);
        this.selectConfigPage.setImageDescriptor(imageDescriptor);
        this.addPage((IWizardPage)this.selectConfigPage);
        this.publishOptionsPage = new PublishConfigPublishOptionsPage("PublishConfigPublishOptionsPage", this.dataModel);
        this.publishOptionsPage.setImageDescriptor(imageDescriptor);
        this.addPage((IWizardPage)this.publishOptionsPage);
    }

    public IWizardPage getSelProcessPage(String configName) {
        PublishConfigSelectProcessPage selectProcessPage = (PublishConfigSelectProcessPage)((Object)this.configProcesspageMap.get(configName));
        if (selectProcessPage == null) {
            ImageDescriptor imageDescriptor = PublishingUIPlugin.getDefault().getImageDescriptor("wizban/PublishConfiguration.gif");
            selectProcessPage = new PublishConfigSelectProcessPage("PublishConfigSelectProcessPage", this.dataModel);
            this.selectConfigPage.setImageDescriptor(imageDescriptor);
            this.addPage((IWizardPage)selectProcessPage);
            this.configProcesspageMap.put(configName, selectProcessPage);
        }
        return selectProcessPage;
    }

    public IWizardPage getNextPage(IWizardPage page) {
        if (page == this.selectConfigPage) {
            if (this.dataModel.getSelectedConfig() != null) {
                String configName = this.dataModel.getSelectedConfig();
                MethodConfiguration config = LibraryServiceUtil.getMethodConfiguration((MethodLibrary)LibraryService.getInstance().getCurrentMethodLibrary(), (String)configName);
                List procs = ConfigurationHelper.getAllProcesses((MethodConfiguration)config);
                if (procs != null && procs.size() > 0) {
                    return this.getSelProcessPage(configName);
                }
                return this.publishOptionsPage;
            }
            return null;
        }
        if (page == this.publishOptionsPage) {
            return null;
        }
        return this.publishOptionsPage;
    }

    public boolean canFinish() {
        return this.getContainer().getCurrentPage() == this.publishOptionsPage && this.publishOptionsPage.isPageComplete();
    }

    public boolean performFinish() {
        this.dataModel = this.publishOptionsPage.getPublishingOptions();
        boolean answer = this.checkAndCreateDir(this.dataModel.publicationPath);
        if (answer) {
            this.dataModel.setFinishPressed(true);
            PublishingUIPreferences.setPublishPath(this.dataModel.getPublicationPath());
            PublishingUIPreferences.setTitle(this.dataModel.getTitle());
            PublishingUIPreferences.setBannerImage(this.dataModel.getBannerImage());
            PublishingUIPreferences.setAboutHTML(this.dataModel.getAboutHTML());
            PublishingUIPreferences.setFeedbackURL(this.dataModel.getFeedbackURL());
            PublishingUIPreferences.setIncludeGlossary(this.dataModel.isGenerateGlossary());
            PublishingUIPreferences.setIncludeIndex(this.dataModel.isGenerateIndex());
            PublishingUIPreferences.setCheckExternalLinks(this.dataModel.isCheckExtLinks());
            LibraryUIPreferences.setPublishUnopenActivitydd((boolean)this.dataModel.isAutoGenerateActivityDiagrams());
            LibraryUIPreferences.setPublishADForActivityExtension((boolean)this.dataModel.isUnopenExtendedActivityDiagram());
            return true;
        }
        this.dataModel.setFinishPressed(false);
        return false;
    }

    public boolean performCancel() {
        this.dataModel.setFinishPressed(false);
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean checkAndCreateDir(String dir) {
        File file;
        String defaultPublishPath = PublishingUIPreferences.getDefaultPublishPath();
        boolean answer = false;
        IPath ecPath = Path.fromOSString((String)dir);
        if (!ecPath.isAbsolute()) {
            String path = String.valueOf(defaultPublishPath) + System.getProperty("file.separator") + dir;
            answer = PublishingUIPlugin.getDefault().getMsgDialog().displayPrompt(PublishingUIResources.publishConfigDialog_title, PublishingUIResources.bind(PublishingUIResources.confirmPathDialog_text, path));
            if (!answer) return false;
            this.dataModel.setPublicationPath(dir);
        }
        if ((file = new File(dir)).exists()) {
            File[] files = file.listFiles();
            if (files == null || files.length <= 0) return true;
            answer = PublishingUIPlugin.getDefault().getMsgDialog().displayConfirmation(PublishingUIResources.publishConfigDialog_title, PublishingUIResources.bind(PublishingUIResources.overwriteDialog_text, dir));
            if (!answer) return answer;
            try {
                answer = FileUtil.deleteAllFiles((String)file.getAbsolutePath());
                if (answer) return answer;
                PublishingUIPlugin.getDefault().getMsgDialog().displayError(PublishingUIResources.publishConfigDialog_title, PublishingUIResources.cannotPublishError_msg, PublishingUIResources.bind(PublishingUIResources.deleteFilesError_reason, dir));
                return false;
            }
            catch (Exception e) {
                PublishingUIPlugin.getDefault().getMsgDialog().displayError(PublishingUIResources.publishConfigDialog_title, PublishingUIResources.cannotPublishError_msg, PublishingUIResources.bind(PublishingUIResources.deleteFilesError_reason, dir), (Throwable)e);
                return false;
            }
        }
        try {
            answer = file.mkdirs();
        }
        catch (Exception e) {
            PublishingUIPlugin.getDefault().getMsgDialog().displayError(PublishingUIResources.publishConfigDialog_title, PublishingUIResources.cannotPublishError_msg, PublishingUIResources.bind(PublishingUIResources.createDirError_reason, file.getAbsolutePath()), (Throwable)e);
            return false;
        }
        if (answer) return answer;
        PublishingUIPlugin.getDefault().getMsgDialog().displayError(PublishingUIResources.publishConfigDialog_title, PublishingUIResources.cannotPublishError_msg, PublishingUIResources.bind(PublishingUIResources.createDirError_reason, file.getAbsolutePath()));
        return false;
    }
}

