/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.publishing.services;

import java.io.File;
import java.net.URL;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.epf.common.utils.FileUtil;
import org.eclipse.epf.common.utils.StrUtil;
import org.eclipse.epf.library.configuration.ElementRealizer;
import org.eclipse.epf.library.layout.ElementLayoutManager;
import org.eclipse.epf.library.layout.HtmlBuilder;
import org.eclipse.epf.library.layout.IContentValidator;
import org.eclipse.epf.library.layout.LayoutResources;
import org.eclipse.epf.library.layout.util.XmlElement;
import org.eclipse.epf.publishing.PublishingPlugin;
import org.eclipse.epf.publishing.PublishingResources;
import org.eclipse.epf.publishing.layout.Bookmark;
import org.eclipse.epf.publishing.layout.BookmarkList;
import org.eclipse.epf.publishing.services.AbstractPublishManager;
import org.eclipse.epf.publishing.services.AbstractViewBuilder;
import org.eclipse.epf.publishing.services.ConfigurationViewBuilder;
import org.eclipse.epf.publishing.services.GlossaryBuilder;
import org.eclipse.epf.publishing.services.ProcessPublishingContentValidator;
import org.eclipse.epf.publishing.services.ProcessPublishingElementRealizer;
import org.eclipse.epf.publishing.services.PublishingContentValidator;
import org.eclipse.epf.publishing.services.PublishingElementRealizer;
import org.eclipse.epf.publishing.services.index.DefinitionObject;
import org.eclipse.epf.publishing.services.index.KeyWordIndexHelper;
import org.eclipse.epf.publishing.util.PublishingUtil;

public class PublishManager
extends AbstractPublishManager {
    protected static final String DOC_ROOT = "docroot/";
    public static final String NO_APPLET_DIRECTORY = "noapplet";
    public static final String BOOKMARK_SUFFIX_XML = ".xml";
    public static final String BOOKMARK_SUFFIX_HTML = ".html";
    public static final String SPACE_REPLACEMENT = "_";
    public static final String SPACE_STRING = " ";
    public static final String PUBLISHED_BOOKMARKS_CFG_NAME = "PublishedBookmarks.xml";
    public static final String PUBLISHED_BOOKMARKS_DELIMITER = "*";
    protected static final String BOOKMARK_XSL_FILE = "xsl/bookmark.xsl";
    protected static final String BOOKMARKS_XSL_FILE = "xsl/PublishedBookmarks.xsl";
    protected static final String INDEX_XSL_FILE = "xsl/index.xsl";
    protected static final String TOPNAV_XSL_FILE = "xsl/topnav.xsl";
    protected static final String KEYWORD_DEF_FILE = "keywordindexdef.txt";
    protected static final String PUBLISHING_REPORT_XSL_FILE = "xsl/PublishingReport.xsl";
    protected static final String PUBLISHING_REPORT_HTML_FILE = "PublishingReport.html";

    protected AbstractViewBuilder createViewBuilder() {
        boolean validateExternalLinks = this.options != null && this.options.checkExtLinks;
        PublishingContentValidator validator = null;
        PublishingElementRealizer realizer = null;
        if (this.options != null && this.options.publishProcess) {
            validator = new ProcessPublishingContentValidator(this.pubDir, validateExternalLinks);
            realizer = new ProcessPublishingElementRealizer(this.config, (ProcessPublishingContentValidator)validator);
        } else {
            validator = new PublishingContentValidator(this.pubDir, validateExternalLinks);
            realizer = new PublishingElementRealizer(this.config, validator);
        }
        validator.setShowBrokenLinks(!this.options.convertBrokenLinks);
        validator.setShowExtraInfoForDescriptors(this.options.showExtraDescriptorInfo);
        ElementLayoutManager layoutMgr = new ElementLayoutManager(this.config, this.pubDir, (IContentValidator)validator, true);
        layoutMgr.setElementRealizer((ElementRealizer)realizer);
        HtmlBuilder builder = new HtmlBuilder(layoutMgr);
        return new ConfigurationViewBuilder(builder, this.options);
    }

    protected void prePublish(IProgressMonitor monitor) throws Exception {
        monitor.subTask(PublishingResources.initializingDirTask_name);
        File f = new File(this.viewBuilder.getHtmlBuilder().getPublishDir());
        if (!f.exists()) {
            f.mkdirs();
        }
        monitor.subTask(PublishingResources.copyingFilesTask_name);
        this.copyDocRootFiles();
        this.copyLocalizedFiles();
        this.copyCustomizedFiles();
    }

    protected void doPublish(IProgressMonitor monitor) throws Exception {
        String title;
        this.viewBuilder.getHtmlBuilder().enableContentScan(true);
        this.viewBuilder.getHtmlBuilder().enableTreeBrowser(true);
        monitor.subTask(PublishingResources.generatingBookmarksTask_name);
        this.generateBookmarks(monitor);
        this.writeIndexAndTopNavHtml();
        String string = title = this.options == null ? "" : this.options.getTitle();
        if (monitor.isCanceled()) {
            return;
        }
        if (this.options == null || this.options.isGenerateGlossary()) {
            monitor.subTask(PublishingResources.generatingGlossaryTask_name);
            new GlossaryBuilder().execute(this.config, this.pubDir, title, monitor);
        }
        if (monitor.isCanceled()) {
            return;
        }
        if (this.options == null || this.options.isGenerateIndex()) {
            monitor.subTask(PublishingResources.generatingBookmarkIndexTask_name);
            this.generateBookmarkIndex(this.pubDir, title, monitor);
        }
    }

    protected void postPublish(IProgressMonitor monitor) throws Exception {
        this.getPublishReportUrl();
    }

    private void generateBookmarks(IProgressMonitor monitor) {
        List bookmarks = this.viewBuilder.buildViews(monitor);
        Bookmark defaultView = this.viewBuilder.getDefaultView();
        if (monitor.isCanceled()) {
            return;
        }
        this.writePublishedBookmarks(bookmarks, defaultView);
    }

    public String getPublishedUrl() {
        String url;
        File f;
        if (this.sucess && (f = new File(url = this.getIndexFilePath())).exists()) {
            return url;
        }
        return null;
    }

    protected void copyDocRootFiles() throws Exception {
        URL plugin_url = PublishingPlugin.getDefault().getInstallURL();
        URL url = new URL(plugin_url, DOC_ROOT);
        String fromPath = Platform.resolve((URL)url).getPath();
        String includes = "*.*, process/**, images/**, index/**, scripts/**, stylesheets/**";
        String excludes = "";
        if (this.options.useDefaultTreeBrowser) {
            includes = String.valueOf(includes) + ", noapplet/**";
        }
        LayoutResources.copyDir((String)fromPath, (String)this.pubDir, (String)includes, (String)excludes);
    }

    protected void copyCustomizedFiles() throws Exception {
        if (this.options.bannerImage != null && this.options.bannerImage.length() > 0) {
            FileUtil.copyFile((String)this.options.bannerImage, (String)(String.valueOf(this.pubDir) + "images"));
            this.options.bannerImage = FileUtil.getFileName((String)this.options.bannerImage);
        } else {
            this.options.bannerImage = "banner.gif";
        }
        if (this.options.aboutHTML != null && this.options.aboutHTML.length() > 0) {
            FileUtil.copyFile((String)this.options.aboutHTML, (String)(String.valueOf(this.pubDir) + "about.htm"));
        }
    }

    protected void copyLocalizedFiles() throws Exception {
        PublishingPlugin.getDefault().copyLocalizedFiles("docroot/scripts/", new File(this.pubDir, "scripts/"), true, false);
        PublishingPlugin.getDefault().copyLocalizedFiles("docroot/images/", new File(this.pubDir, "images/"), true, false);
        PublishingPlugin.getDefault().copyLocalizedFiles(DOC_ROOT, new File(this.pubDir, "/"), false, false);
        if (this.options.useDefaultTreeBrowser) {
            PublishingPlugin.getDefault().copyLocalizedFiles("docroot/noapplet/", new File(this.pubDir, "noapplet/"), false, false);
        }
    }

    protected String makeBookmarkFileName(String bookmarkName) {
        return String.valueOf(bookmarkName.replace(SPACE_STRING.charAt(0), SPACE_REPLACEMENT.charAt(0))) + BOOKMARK_SUFFIX_XML;
    }

    private String writeBookmark(Bookmark b) {
        String bookmarkFileName = this.makeBookmarkFileName(StrUtil.makeValidFileName((String)b.getPresentationName()));
        XmlElement xml = b.getXmlElement();
        String buffer = PublishingUtil.getHtml(xml, BOOKMARK_XSL_FILE);
        if (buffer != null) {
            String htmlPath = this.getBookmarkHtmlPath(bookmarkFileName);
            FileUtil.writeUTF8File((String)htmlPath, (String)buffer.toString());
        }
        return bookmarkFileName;
    }

    protected void writePublishedBookmarks(List bookmarks, Bookmark defaultView) {
        BookmarkList list = new BookmarkList();
        if (defaultView == null && bookmarks.size() > 0) {
            defaultView = (Bookmark)bookmarks.get(0);
        }
        Iterator it = bookmarks.iterator();
        while (it.hasNext()) {
            Bookmark b = (Bookmark)it.next();
            String fileName = this.writeBookmark(b);
            list.addBookmark(b.getPresentationName(), fileName, defaultView == b);
        }
        XmlElement xml = list.getXmlElement();
        String buffer = PublishingUtil.getHtml(xml, BOOKMARKS_XSL_FILE);
        if (buffer != null) {
            String htmlPath = this.getBookmarkHtmlPath(PUBLISHED_BOOKMARKS_CFG_NAME);
            FileUtil.writeUTF8File((String)htmlPath, (String)buffer.toString());
        }
    }

    protected void writeIndexAndTopNavHtml() {
        String htmlPath;
        XmlElement optionXml = this.getOptionXml();
        String buffer = PublishingUtil.getHtml(optionXml, INDEX_XSL_FILE);
        if (buffer != null) {
            htmlPath = this.getIndexFilePath();
            FileUtil.writeUTF8File((String)htmlPath, (String)buffer.toString());
        }
        if ((buffer = PublishingUtil.getHtml(optionXml, TOPNAV_XSL_FILE)) != null) {
            htmlPath = String.valueOf(this.viewBuilder.getHtmlBuilder().getPublishDir()) + "topnav.htm";
            FileUtil.writeUTF8File((String)htmlPath, (String)buffer.toString());
        }
    }

    protected XmlElement getOptionXml() {
        boolean showGlossary = this.options == null || this.options.generateGlossary;
        boolean showIndex = this.options == null || this.options.generateIndex;
        XmlElement optionXml = new XmlElement("PublishingOption").setAttribute("title", this.options == null ? "" : this.options.title).setAttribute("bannerImage", this.options == null ? "" : this.options.bannerImage).setAttribute("feedbackUrl", this.options == null ? "" : this.options.feedbackURL).setAttribute("showGlossary", showGlossary ? "true" : "false").setAttribute("showIndex", showIndex ? "true" : "false");
        return optionXml;
    }

    public String getIndexFilePath() {
        return String.valueOf(this.viewBuilder.getHtmlBuilder().getPublishDir()) + "index.htm";
    }

    protected String getBookmarkHtmlPath(String boomkarkFile) {
        int indx = boomkarkFile.lastIndexOf(BOOKMARK_SUFFIX_XML);
        return String.valueOf(this.viewBuilder.getHtmlBuilder().getPublishDir()) + NO_APPLET_DIRECTORY + File.separatorChar + boomkarkFile.substring(0, indx) + BOOKMARK_SUFFIX_HTML;
    }

    protected void generateBookmarkIndex(String publishDir, String title, IProgressMonitor monitor) {
        try {
            String helpFile;
            String charSet;
            URL url = new URL(PublishingPlugin.getDefault().getInstallURL(), KEYWORD_DEF_FILE);
            if (url == null) {
                System.out.println("Unable to get index definition file ");
                return;
            }
            String deffile = Platform.resolve((URL)url).getPath();
            KeyWordIndexHelper indexHelper = new KeyWordIndexHelper(deffile, charSet = "utf-8", helpFile = null);
            DefinitionObject defObj = indexHelper.loadDefinition(publishDir);
            if (defObj != null) {
                defObj.setwwwRoot(publishDir);
                defObj.setIndexTitle(String.valueOf(PublishingResources.indexLabel_text) + " - " + title);
            }
            indexHelper.execute(monitor);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String getPublishReportUrl() {
        String publishDir = this.viewBuilder.getHtmlBuilder().getPublishDir();
        String file_pathname = "logs" + File.separator + PUBLISHING_REPORT_HTML_FILE;
        File f = new File(publishDir, file_pathname);
        String report_file = f.getAbsolutePath();
        if (!f.exists()) {
            File errorLog = new File(publishDir, "logs" + File.separator + "error.log");
            File warningLog = new File(publishDir, "logs" + File.separator + "warning.log");
            File infoLog = new File(publishDir, "logs" + File.separator + "info.log");
            XmlElement reportXml = new XmlElement("PublishingReport");
            reportXml.newChild("pubDir").setAttribute("path", publishDir);
            reportXml.newChild("errorLog").setAttribute("name", "error.log").setAttribute("path", "./" + errorLog.getName());
            reportXml.newChild("warningLog").setAttribute("name", "warning.log").setAttribute("path", "./" + warningLog.getName());
            reportXml.newChild("infoLog").setAttribute("name", "info.log").setAttribute("path", "./" + infoLog.getName());
            PublishingContentValidator validator = (PublishingContentValidator)this.viewBuilder.getHtmlBuilder().getValidator();
            reportXml.addChild(validator.getReport());
            String buffer = PublishingUtil.getHtml(reportXml, PUBLISHING_REPORT_XSL_FILE);
            if (buffer != null) {
                FileUtil.writeUTF8File((String)report_file, (String)buffer.toString());
            }
        }
        return report_file;
    }
}

