/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.menus;

import org.eclipse.jface.util.Util;
import org.eclipse.ui.internal.menus.LocationElement;
import org.eclipse.ui.internal.menus.SBar;
import org.eclipse.ui.internal.menus.SOrder;

public final class SLocation {
    public static final char MNEMONIC_NONE = '\u0000';
    private final String imageStyle;
    private final char mnemonic;
    private final SOrder ordering;
    private final LocationElement path;

    public SLocation() {
        this(new SBar());
    }

    public SLocation(LocationElement path) {
        this(path, '\u0000');
    }

    public SLocation(SLocation parent, String id) {
        this(parent, id, '\u0000');
    }

    public SLocation(SLocation parent, String id, char mnemonic) {
        if (parent == null) {
            throw new NullPointerException("The parent cannot be null");
        }
        if (id == null) {
            throw new NullPointerException("The id cannot be null");
        }
        LocationElement parentPath = parent.getPath();
        LocationElement childPath = parentPath.createChild(id);
        this.imageStyle = null;
        this.mnemonic = mnemonic;
        this.ordering = null;
        this.path = childPath;
    }

    public SLocation(LocationElement path, char mnemonic) {
        this(path, null, mnemonic);
    }

    public SLocation(LocationElement path, SOrder ordering) {
        this(path, ordering, '\u0000');
    }

    public SLocation(LocationElement path, SOrder ordering, char mnemonic) {
        this(path, ordering, mnemonic, null);
    }

    public SLocation(LocationElement path, SOrder ordering, char mnemonic, String imageStyle) {
        if (imageStyle != null && imageStyle.length() == 0) {
            imageStyle = null;
        }
        if (path == null) {
            throw new NullPointerException("The path for a location must not be null");
        }
        this.mnemonic = mnemonic;
        this.imageStyle = imageStyle;
        this.ordering = ordering;
        this.path = path;
    }

    public final String getImageStyle() {
        return this.imageStyle;
    }

    public final char getMnemonic() {
        return this.mnemonic;
    }

    public final SOrder getOrdering() {
        return this.ordering;
    }

    public final LocationElement getPath() {
        return this.path;
    }

    public final String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("SLocation(");
        buffer.append(this.path);
        buffer.append(',');
        if (this.mnemonic != '\u0000') {
            buffer.append(this.mnemonic);
            buffer.append(',');
        }
        buffer.append(this.imageStyle);
        buffer.append(',');
        buffer.append(this.ordering);
        buffer.append(')');
        return buffer.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof SLocation) {
            SLocation loc = (SLocation)obj;
            return this.path.equals(loc.path) && this.mnemonic == loc.mnemonic && Util.equals((Object)this.ordering, (Object)loc.ordering) && Util.equals((Object)this.imageStyle, (Object)loc.imageStyle);
        }
        return false;
    }

    public int hashCode() {
        return this.path.hashCode() + Util.hashCode((Object)this.imageStyle) + Util.hashCode((Object)this.ordering);
    }
}

