<?xml version="1.0" encoding="UTF-8"?>
<!-- 
    Copyright (c) 2005, 2006 IBM Corporation and others.
    All rights reserved. This program and the accompanying materials
    are made available under the terms of the Eclipse Public License v1.0
    which accompanies this distribution, and is available at
    http://www.eclipse.org/legal/epl-v10.html
    Contributors:
    IBM Corporation - initial implementation
-->

<xsl:stylesheet version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance">
	
	<xsl:include href="workproduct.xsl"/>
	

	<xsl:template match="/Element">
		<xsl:variable name="elementType" select="@Type"/>
		<xsl:variable name="elementTypeName" select="@TypeName"/>
		<xsl:variable name="elementName" select="@Name"/>
		<xsl:variable name="elementPresentationName" select="@DisplayName"/>
		<xsl:variable name="backPath" select="@BackPath"/>
		<xsl:variable name="shapeImage" select="concat($backPath,@ShapeiconUrl)"/>
		<xsl:variable name="imagePath" select="concat($backPath, 'images/')"/>		
		<xsl:variable name="presentation" select="reference[@name='presentation']"/>				
		<xsl:variable name="contentDescription" select="$presentation/Element[@Type='WorkProductDescriptor']"/>
		<xsl:variable name="workProductDescriptor" select="$presentation/Element[@Type='WorkProductDescriptor']"/>
		<xsl:variable name="descriptorDescription" select="$presentation/Element[@Type='DescriptorDescription']"/>		
		<xsl:variable name="responsibleRole" select="reference[@name='responsibleRole']/Element[@Type='RoleDescriptor']"/>
		<xsl:variable name="copyright" select="copyright"/>
		<xsl:variable name="showTreeBrowser" select="@showTreeBrowser"/>
		<xsl:variable name="queryString" select="@queryString"/>
		<xsl:variable name="relProcessPath" select="@relProcessPath"/>
	
		<html>
			<head>
				<title><xsl:value-of select="$elementTypeName"/>: <xsl:value-of select="$elementPresentationName"/></title>
				<xsl:call-template name="umaMetaTags">
					<xsl:with-param name="elementType" select="$elementType"/>
					<xsl:with-param name="elementName" select="$elementName"/>
					<xsl:with-param name="elementPresentationName" select="$elementPresentationName"/>
				</xsl:call-template>
				<meta name="element_type" content="{$elementType}"/>
				<meta name="filetype" content="description"/>
				<meta name="role">
					<xsl:attribute name="content"><xsl:value-of select="$responsibleRole/@DisplayName"/></xsl:attribute>
				</meta>
				<link rel="StyleSheet" href="{$backPath}css/default.css" type="text/css"/>
				<script language="JavaScript" type="text/javascript" src="{$backPath}scripts/elementUrls.js"></script>
				<script language="JavaScript" type="text/javascript" src="{$backPath}scripts/contentpage.js"></script>
				<script language="JavaScript" type="text/javascript" src="{$backPath}scripts/activitylayout.js"/>
				<script language="JavaScript" type="text/javascript" >
					backPath = '<xsl:value-of select="$backPath"/>';
					// get url parameters here
					// query string from url take precedence, if not, use the one passed in form xml
					// this handles both published site, and browsing, where user click in a node, there is no url parameter
					var defaultQueryStr = '<xsl:value-of select="$queryString"/>';
					var queryStr = location.search;
					if ( queryStr == null || queryStr == "" )
					{
						queryStr = defaultQueryStr;
					}
					var parameters = getUrlParameters(queryStr.substring(1));
					var par_proc = parameters["proc"];
					var par_path = parameters["path"];
				</script>
								
			</head>
			<body onload="createSectionLinks('div', 'sectionHeading', '{$imagePath}');">
				<script language="JavaScript" type="text/javascript">buildProcessElementBreadCrumb(backPath);</script>
				<table border="0" cellpadding="0" cellspacing="0" width="100%">
					<tr>
						<td valign="top">
							<a name="Top"/>
							<xsl:call-template name="overview">
								<xsl:with-param name="elementType" select="$elementType"/>
								<xsl:with-param name="elementTypeName" select="$elementTypeName"/>
								<xsl:with-param name="elementPresentationName" select="$elementPresentationName"/>
								<xsl:with-param name="elementIcon" select="$shapeImage"/>
								<xsl:with-param name="backPath" select="$backPath"/>
								<xsl:with-param name="showTreeBrowser" select="$showTreeBrowser"/>
							</xsl:call-template>
							<xsl:call-template name="purposeSection">
								<xsl:with-param name="description" select="$descriptorDescription"/>
							</xsl:call-template>

							<xsl:call-template name="descriptorRelationshipsSection"/>
							
							<xsl:choose>
								<xsl:when test="$descriptorDescription/attribute[@name='briefOutline'] !='' ">
									<xsl:call-template name="descriptionSection">
										<xsl:with-param name="description" select="$descriptorDescription"/>
									</xsl:call-template>	
								</xsl:when>
								<xsl:otherwise>
									<xsl:call-template name="refinedDescriptionSection">
										<xsl:with-param name="description" select="$descriptorDescription"/>
									</xsl:call-template>	
								</xsl:otherwise>
							</xsl:choose>
							<xsl:call-template name="propertiesSection">
								<xsl:with-param name="contentDescription" select="$contentDescription"/>
							</xsl:call-template>
							<xsl:call-template name="usageSection">
								<xsl:with-param name="contentDescription" select="$descriptorDescription"/>
							</xsl:call-template>
							
							<xsl:call-template name="workProductIllustrationsSection"/>

							<xsl:call-template name="keyConsiderationsSection">
								<xsl:with-param name="description" select="$descriptorDescription"/>
							</xsl:call-template>
							
							<xsl:call-template name="tailoringSection">
								<xsl:with-param name="description" select="$descriptorDescription"/>
							</xsl:call-template>
							<xsl:call-template name="moreInfoSection"/>
							
							
							<xsl:call-template name="copyright">
								<xsl:with-param name="copyright" select="$copyright"/>
							</xsl:call-template>
						</td>						
					</tr>
				</table>
			</body>
		</html>
	</xsl:template>	
	
		<xsl:template name="descriptionSection">
		<xsl:param name="description"/>
		<xsl:variable name="briefOutline" select="$description/attribute[@name='briefOutline']"/>
		<xsl:variable name="mainDescription" select="$description/attribute[@name='refinedDescription']"/>
		<xsl:if test="$briefOutline != '' or $mainDescription != ''">
			<div class="sectionHeading"><xsl:value-of select="$descriptionText"/></div>
			<div class="sectionContent">			
				<table class="sectionTable" border="0" cellspacing="0" cellpadding="0">
					<xsl:if test="$briefOutline != ''">
						<tr valign="top">
							<th class="sectionTableHeading" scope="row"><xsl:value-of select="$briefOutlineText"/></th>
							<td class="sectionTableCell">
								<xsl:value-of disable-output-escaping="yes" select="$briefOutline"/>
							</td>
						</tr>
					</xsl:if>
					<xsl:if test="$mainDescription != ''">
						<tr valign="top">
							<th class="sectionTableHeading" scope="row"><xsl:value-of select="$mainDescriptionText"/></th>
							<td class="sectionTableCell">
								<xsl:value-of disable-output-escaping="yes" select="$mainDescription"/>
							</td>
						</tr>
					</xsl:if>					
				</table>
			</div>
		</xsl:if>
	</xsl:template>	
	
	<xsl:template name="propertiesSection">
		<xsl:param name="contentDescription"/>
		<div class="sectionHeading"><xsl:value-of select="$propertiesText"/></div>
		<div class="sectionContent">
			<table class="sectionTable" border="0" cellspacing="0" cellpadding="0">
			    <xsl:if test="attribute[@name='activityEntryState']">
					<xsl:call-template name="property">
						<xsl:with-param name="fieldLabel" select="$activityEntryStateText"/>
						<xsl:with-param name="fieldText" select="attribute[@name='activityEntryState']"/>
					</xsl:call-template>
				</xsl:if>
				<xsl:if test="attribute[@name='activityExitState']">
					<xsl:call-template name="property">
						<xsl:with-param name="fieldLabel" select="$activityExitStateText"/>
						<xsl:with-param name="fieldText" select="attribute[@name='activityExitState']"/>
					</xsl:call-template>
				</xsl:if>			
				<xsl:if test="attribute[@name='isOptional']">
					<xsl:call-template name="property">
						<xsl:with-param name="fieldLabel" select="$optionalText"/>
						<xsl:with-param name="fieldText" select="attribute[@name='isOptional']"/>
					</xsl:call-template>
				</xsl:if>				
				<xsl:if test="attribute[@name='isPlanned']">
					<xsl:call-template name="property">
						<xsl:with-param name="fieldLabel" select="$plannedText"/>
						<xsl:with-param name="fieldText" select="attribute[@name='isPlanned']"/>
					</xsl:call-template>
				</xsl:if>		
				<xsl:if test="attribute[@name='PlanningData']">
					<xsl:call-template name="property">
						<xsl:with-param name="fieldLabel" select="$planningDataText"/>
						<xsl:with-param name="fieldText" select="attribute[@name='PlanningData']"/>
					</xsl:call-template>
				</xsl:if>
			</table>
		</div>
	</xsl:template>
	
	<!--
	<xsl:template name="usageSection">
		<xsl:param name="contentDescription"/>
		<xsl:if test="$contentDescription/attribute[@name='usageGuidance'] != ''">
			<div class="sectionHeading"><xsl:value-of select="$usageText"/></div>
			<div class="sectionContent">
				<table class="sectionTable" border="0" cellspacing="0" cellpadding="0">
					<xsl:call-template name="property">
						<xsl:with-param name="fieldLabel" select="'Usage Guidance'"/>
						<xsl:with-param name="fieldText" select="$contentDescription/attribute[@name='usageGuidance']"/>
					</xsl:call-template>
				</table>
			</div>
		</xsl:if>
	</xsl:template>
	-->
	
	<xsl:template name="usageSection">
		<xsl:param name="contentDescription"/>
		<xsl:variable name="usageGuidance" select="$contentDescription/attribute[@name='usageGuidance']"/>
		<xsl:if test="$usageGuidance != ''">
			<div class="sectionHeading"><xsl:value-of select="$usageGuidanceText"/></div>
			<div class="sectionContent">
				<table class="sectionTable" border="0" cellspacing="0" cellpadding="0">
					<tr valign="top">
						<td class="sectionTableCell">
							<xsl:value-of disable-output-escaping="yes" select="$usageGuidance"/>
						</td>
					</tr>
				</table>
			</div>
		</xsl:if>
	</xsl:template>
	
	<xsl:template name="descriptorRelationshipsSection">
		<xsl:variable name="workProduct" select="reference[@name='WorkProduct']/Element[@Type='Artifact']"/>
		<xsl:variable name="deliverableParts" select="referenceList[@name='deliverableParts']/Element"/>
		<xsl:variable name="impacts" select="referenceList[@name='impacts']/Element[@Type='WorkProductDescriptor']"/>
		<xsl:variable name="impactedBy" select="referenceList[@name='impactedBy']/Element[@Type='WorkProductDescriptor']"/>
		<xsl:variable name="mandatoryInputTo" select="referenceList[@name='WorkProductDescriptor_MandatoryInputTo_TaskDescriptors']/Element[@Type='TaskDescriptor']"/>
		<xsl:variable name="optionalInputTo" select="referenceList[@name='OptionalInputTo']/Element[@Type='TaskDescriptor']"/>
		<xsl:variable name="externalInputTo" select="referenceList[@name='externalInputTo']/Element[@Type='TaskDescriptor']"/>
		<xsl:variable name="outputFrom" select="referenceList[@name='WorkProductDescriptor_OutputFrom_TaskDescriptors']/Element[@Type='TaskDescriptor']"/>
		<xsl:variable name="superActivities" select="referenceList[@name='superActivities']/Element[@Type='Activity']"/>
		<xsl:variable name="responsibleRole" select="referenceList[@name='WorkProductDescriptor_ResponsibleRoleDescriptors']/Element[@Type='RoleDescriptor']"/>
		<xsl:variable name="workedOnBy" select="referenceList[@name='workedOnBy']/Element"/>
			
		<xsl:if test="count($mandatoryInputTo) + count($optionalInputTo) + count($outputFrom) + count($impacts) + count($impactedBy)> 0">
			<div class="sectionHeading"><xsl:value-of select="$relationshipsText"/></div>
			<div class="sectionContent">
				<table class="sectionTable" border="0" cellspacing="0" cellpadding="0">
					<xsl:if test="count($impacts) > 0">
						<tr valign="top">
							<th class="sectionTableHeading" scope="row"><xsl:value-of select="$dependentText"/></th>
							<td class="sectionTableCell" colspan="3">
								<xsl:for-each select="$impacts">
									<li>
										<a>
											<xsl:attribute name="href"><xsl:value-of select="/Element/@BackPath"/><xsl:value-of select="@Url"/></xsl:attribute>
											<xsl:value-of select="@DisplayName"/>
										</a>
									</li>
								</xsl:for-each>
							</td>
						</tr>
					</xsl:if>				
					<xsl:if test="count($impactedBy) > 0">
						<tr valign="top">
							<th class="sectionTableHeading" scope="row"><xsl:value-of select="$impactingText"/></th>
							<td class="sectionTableCell" colspan="3">
								<xsl:for-each select="$impactedBy">
									<li>
										<a>
											<xsl:attribute name="href"><xsl:value-of select="/Element/@BackPath"/><xsl:value-of select="@Url"/></xsl:attribute>
											<xsl:value-of select="@DisplayName"/>
										</a>
									</li>
								</xsl:for-each>
							</td>
						</tr>
					</xsl:if>
					<xsl:if test="count($responsibleRole) + count($workedOnBy) > 0">
						<tr valign="top">
							<th class="sectionTableHeading" scope="row"><xsl:value-of select="$rolesText"/></th>
							<td class="sectionTableCell" width="30%">
								<xsl:value-of select="$responsibleText"/>:							
									<ul>
									<xsl:for-each select="$responsibleRole">
										<li>
											<a><xsl:attribute name="href"><xsl:value-of select="/Element/@BackPath"/><xsl:value-of select="@Url"/></xsl:attribute><xsl:value-of select="@DisplayName"/></a>
										</li>
									</xsl:for-each>
									</ul>
							</td>
							<td class="sectionTableCell" colspan="2">
								<xsl:value-of select="$modifiedByText"/>:
								<ul>
									<xsl:for-each select="$workedOnBy">
										<li>
											<a><xsl:attribute name="href"><xsl:value-of select="/Element/@BackPath"/><xsl:value-of select="@Url"/></xsl:attribute><xsl:value-of select="@DisplayName"/></a>
										</li>
									</xsl:for-each>
								</ul>
							</td>
						</tr>
					</xsl:if>
					<xsl:if test="count($mandatoryInputTo) + count($optionalInputTo) + count($externalInputTo) > 0">
						<tr valign="top">
							<th class="sectionTableHeading" scope="row"><xsl:value-of select="$inputToText"/></th>
							<td class="sectionTableCell" width="30%">
								<xsl:value-of select="$mandatoryText"/>:								
								<xsl:choose>
									<xsl:when test="count($mandatoryInputTo) > 0">
										<ul>
										<xsl:for-each select="$mandatoryInputTo">										
											<li>
												<a><xsl:attribute name="href"><xsl:value-of select="/Element/@BackPath"/><xsl:value-of select="@Url"/></xsl:attribute><xsl:value-of select="@DisplayName"/></a>
											</li>
										</xsl:for-each>							
										</ul>
									</xsl:when>				
									<xsl:otherwise>
									<ul>
										<li>
											<xsl:value-of select="$noneText"/>
										</li>									
									</ul>
									</xsl:otherwise>
								</xsl:choose>
							</td>
							<td class="sectionTableCell" width="30%">
								<xsl:value-of select="$optionalText"/>:
								<xsl:choose>
									<xsl:when test="count($optionalInputTo) > 0">
									<ul>
										<xsl:for-each select="$optionalInputTo">
											<li>
												<a><xsl:attribute name="href"><xsl:value-of select="/Element/@BackPath"/><xsl:value-of select="@Url"/></xsl:attribute><xsl:value-of select="@DisplayName"/></a>
											</li>
										</xsl:for-each>							
									</ul>
									</xsl:when>				
									<xsl:otherwise>
									<ul>
										<li>
											<xsl:value-of select="$noneText"/>
										</li>
									</ul>									
									</xsl:otherwise>									
								</xsl:choose>
							</td>
							<td class="sectionTableCell">
								<xsl:value-of select="$externalText"/>:
								<xsl:choose>
									<xsl:when test="count($externalInputTo) > 0">
									<ul>
										<xsl:for-each select="$externalInputTo">
											<li>
												<a><xsl:attribute name="href"><xsl:value-of select="/Element/@BackPath"/><xsl:value-of select="@Url"/></xsl:attribute><xsl:value-of select="@DisplayName"/></a>
											</li>
										</xsl:for-each>							
									</ul>
									</xsl:when>				
									<xsl:otherwise>
									<ul>
										<li>
											<xsl:value-of select="$noneText"/>
										</li>
									</ul>									
									</xsl:otherwise>									
								</xsl:choose>
							</td>					
						</tr>
					</xsl:if>					
					<xsl:if test="count($outputFrom) > 0">
						<tr valign="top">
							<th class="sectionTableHeading" scope="row"><xsl:value-of select="$outputFromText"/></th>							
							<td class="sectionTableCell" colspan="3">
							<xsl:if test="count($outputFrom) > 0">									
								<ul>
									<xsl:for-each select="$outputFrom">
										<li>
											<a><xsl:attribute name="href"><xsl:value-of select="/Element/@BackPath"/><xsl:value-of select="@Url"/></xsl:attribute><xsl:value-of select="@DisplayName"/></a>
										</li>
									</xsl:for-each>
								</ul>
							</xsl:if>
							</td>							
						</tr>
					</xsl:if>
				</table>
			</div>
		</xsl:if>
	</xsl:template>
	
</xsl:stylesheet>
