/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.publishing.wizards;

import java.util.List;
import org.eclipse.epf.authoring.ui.AuthoringUIHelpContexts;
import org.eclipse.epf.authoring.ui.AuthoringUIText;
import org.eclipse.epf.library.LibraryService;
import org.eclipse.epf.library.LibraryServiceUtil;
import org.eclipse.epf.library.ui.LibraryUIImages;
import org.eclipse.epf.library.ui.wizards.BaseWizardPage;
import org.eclipse.epf.publishing.services.PublishOptions;
import org.eclipse.epf.publishing.ui.PublishingUIResources;
import org.eclipse.epf.publishing.wizards.PublishConfigurationWizard;
import org.eclipse.epf.uma.MethodConfiguration;
import org.eclipse.epf.uma.MethodLibrary;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class PublishConfigSelectConfigPage
extends BaseWizardPage
implements ISelectionChangedListener,
Listener {
    private Table table;
    private TableViewer tableViewer;
    private Text ctrl_briefDesc;
    private PublishOptions dataModel = null;
    private List vwList;

    public PublishConfigSelectConfigPage(String pageName, PublishOptions dataModel) {
        super(pageName);
        this.setTitle(PublishingUIResources.publishConfigWizard_selectConfigPage_title);
        this.setDescription(PublishingUIResources.publishConfigWizard_selectConfigPage_text);
        this.dataModel = dataModel;
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(1, false));
        this.createLabel(composite, PublishingUIResources.publishConfigWizard_methodConfig_text);
        this.table = new Table(composite, 2560);
        GridData gridData = new GridData(1808);
        gridData.heightHint = 120;
        gridData.widthHint = 280;
        this.table.setLayoutData((Object)gridData);
        this.tableViewer = new TableViewer(this.table);
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new ConfigurationTableLabelProvider());
        this.tableViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        MethodConfiguration[] configs = LibraryServiceUtil.getMethodConfigurations((MethodLibrary)LibraryService.getInstance().getCurrentMethodLibrary());
        this.tableViewer.setInput((Object)configs);
        this.createLabel(composite, AuthoringUIText.DESCRIPTION_TEXT);
        this.ctrl_briefDesc = this.createTextMulti(composite, "", 360, 80, 1);
        if (configs.length > 0) {
            this.table.select(0);
            this.setDisplayAttributes(configs[0]);
        }
        PublishConfigurationWizard wizard = (PublishConfigurationWizard)this.getWizard();
        Shell shell = wizard.getContainer().getShell();
        shell.setImage(LibraryUIImages.IMG_METHOD_CONFIGURATON);
        this.tableViewer.addSelectionChangedListener((ISelectionChangedListener)this);
        this.setControl((Control)composite);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, AuthoringUIHelpContexts.CONFIGURATION_PUBLISH_WIZARD_ALL_PAGES_CONTEXT);
    }

    public void selectionChanged(SelectionChangedEvent event) {
        StructuredSelection selection = (StructuredSelection)event.getSelection();
        if (!selection.isEmpty()) {
            Object[] configs = selection.toArray();
            this.setDisplayAttributes((MethodConfiguration)configs[0]);
        }
        this.setPageComplete(this.isPageComplete());
        this.getWizard().getContainer().updateButtons();
    }

    public void handleEvent(Event event) {
        this.setPageComplete(this.isPageComplete());
        this.getWizard().getContainer().updateButtons();
    }

    private void setDisplayAttributes(MethodConfiguration config) {
        this.ctrl_briefDesc.setText(config.getBriefDescription());
    }

    public IWizardPage getNextPage() {
        this.dataModel.publishConfiguration = true;
        IWizardPage page = this.getWizard().getNextPage((IWizardPage)this);
        return page;
    }

    public boolean isPageComplete() {
        if (this.getErrorMessage() != null) {
            return false;
        }
        int count = this.table.getSelectionCount();
        if (count > 0) {
            TableItem[] items = this.table.getSelection();
            this.dataModel.setSelectedConfig(items[0].getText());
            MethodConfiguration config = LibraryServiceUtil.getMethodConfiguration((MethodLibrary)LibraryService.getInstance().getCurrentMethodLibrary(), (String)this.dataModel.selectedConfig);
            this.vwList = null;
            if (config != null) {
                this.vwList = config.getProcessViews();
            }
            if (this.vwList != null && this.vwList.size() > 0) {
                this.setErrorMessage(null);
                this.setMessage(null);
                return true;
            }
            this.setErrorMessage(null);
            this.setMessage(PublishingUIResources.missingViewError_msg, 2);
            return false;
        }
        return false;
    }

    public class ConfigurationTableLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        public Image getColumnImage(Object element, int index) {
            return null;
        }

        public String getColumnText(Object element, int index) {
            MethodConfiguration config = (MethodConfiguration)element;
            return config.getName();
        }
    }
}

