/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.authoring.gef.edit;

import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.IFigure;
import org.eclipse.epf.authoring.gef.edit.ActivityDetailDiagramEditPart;
import org.eclipse.epf.authoring.gef.edit.NamedNodeEditPart;
import org.eclipse.epf.authoring.gef.edit.TextFigureCellEditorLocator;
import org.eclipse.epf.authoring.gef.edit.TextFigureDirectEditManager;
import org.eclipse.epf.authoring.gef.figures.ActivityFigure;
import org.eclipse.epf.authoring.gef.figures.Colors;
import org.eclipse.epf.authoring.gef.figures.Images;
import org.eclipse.epf.authoring.gef.figures.TextFigure;
import org.eclipse.epf.diagram.model.NamedNode;
import org.eclipse.epf.diagram.model.Node;
import org.eclipse.epf.diagram.model.WorkBreakdownElementNode;
import org.eclipse.epf.diagram.model.WorkProductDescriptorNode;
import org.eclipse.epf.library.edit.util.ProcessUtil;
import org.eclipse.epf.library.edit.util.Suppression;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.uma.Activity;
import org.eclipse.epf.uma.BreakdownElement;
import org.eclipse.epf.uma.Iteration;
import org.eclipse.epf.uma.Milestone;
import org.eclipse.epf.uma.Phase;
import org.eclipse.epf.uma.TaskDescriptor;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.tools.DirectEditManager;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;

public class WorkBreakdownElementNodeEditPart
extends NamedNodeEditPart {
    static /* synthetic */ Class class$0;

    public WorkBreakdownElementNodeEditPart(NamedNode model) {
        super(model);
    }

    protected Image getImage() {
        Image img = null;
        Node node = (Node)this.getModel();
        Object obj = node.getObject();
        if (obj instanceof Phase) {
            img = Images.PHASE;
        } else if (obj instanceof Iteration) {
            img = Images.ITERATION;
        } else if (obj instanceof Activity) {
            img = Images.ACTIVITY;
        } else if (obj instanceof TaskDescriptor) {
            img = Images.TASK_DESCRIPTOR;
        } else if (obj instanceof Milestone) {
            img = Images.MILESTONE;
        }
        return img;
    }

    protected IFigure createFigure() {
        ActivityFigure figure = new ActivityFigure();
        Image image = this.getImage();
        if (image != null) {
            figure.add(image);
        }
        return figure;
    }

    String getDirectEditText() {
        TextFigure note = (TextFigure)this.getFigure();
        return note.getText();
    }

    protected void refreshVisuals() {
        super.refreshVisuals();
        IFigure fig = this.getDirectEditFigure();
        if (fig instanceof ActivityFigure) {
            WorkBreakdownElementNode node;
            Object wbelement;
            ActivityFigure l = (ActivityFigure)fig;
            fig.setForegroundColor(this.getForegroundColor());
            String text = this.getModel() instanceof WorkBreakdownElementNode ? ((wbelement = (node = (WorkBreakdownElementNode)this.getModel()).getObject()) instanceof Activity && ProcessUtil.isExtendingOrLocallyContributing((BreakdownElement)((BreakdownElement)wbelement)) ? ProcessUtil.getPresentationName((BreakdownElement)((BreakdownElement)wbelement)) : ((NamedNode)this.getModel()).getName()) : ((NamedNode)this.getModel()).getName();
            try {
                if (this.getParent() instanceof ActivityDetailDiagramEditPart || this.getParent().getParent() instanceof ActivityDetailDiagramEditPart) {
                    int w = 12;
                    if (this.getModel() instanceof WorkProductDescriptorNode) {
                        w = 3;
                    }
                    text = this.wrap(text, w);
                }
            }
            catch (NullPointerException nullPointerException) {}
            l.setText(text);
        }
    }

    private Color getForegroundColor() {
        NamedNode node = (NamedNode)this.getModel();
        if (node.isSuppressed()) {
            return Colors.SUPRESSED_ELEMENT_LABEL;
        }
        if (node.isReadOnly()) {
            return Colors.INHERITED_ELEMENT_LABEL;
        }
        return ColorConstants.black;
    }

    protected DirectEditManager createDirectEditManager() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.jface.viewers.TextCellEditor");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return new TextFigureDirectEditManager((GraphicalEditPart)this, clazz, new TextFigureCellEditorLocator((TextFigure)this.getFigure()), (TextFigure)this.getFigure()){

            protected String validate(String txt) {
                Object obj = this.getEditPart().getModel();
                if (obj instanceof WorkBreakdownElementNode) {
                    WorkBreakdownElementNode node = (WorkBreakdownElementNode)obj;
                    Object e = node.getObject();
                    if (e instanceof Activity) {
                        return TngUtil.checkWBSActivityPresentationName((Object)e, (String)txt, (Suppression)node.getDiagram().getSuppression());
                    }
                    return TngUtil.checkWorkBreakdownElementPresentationName((Object)e, (String)txt, (Suppression)node.getDiagram().getSuppression());
                }
                return super.validate(txt);
            }
        };
    }
}

