/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.authoring.ui;

import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.epf.authoring.gef.util.DiagramEditorUtil;
import org.eclipse.epf.authoring.ui.editors.EditorChooser;
import org.eclipse.epf.authoring.ui.providers.MethodEditorPageProvider;
import org.eclipse.epf.authoring.ui.providers.ProcessEditorPageProvider;
import org.eclipse.epf.common.plugin.AbstractPlugin;
import org.eclipse.epf.diagram.model.util.GraphicalDataManager;
import org.eclipse.epf.library.LibraryPlugin;
import org.eclipse.epf.library.LibraryService;
import org.eclipse.epf.library.configuration.ConfigurationHelper;
import org.eclipse.epf.library.configuration.DefaultElementRealizer;
import org.eclipse.epf.library.configuration.ElementRealizer;
import org.eclipse.epf.library.configuration.ProcessAuthoringConfigurator;
import org.eclipse.epf.library.configuration.ProcessConfigurator;
import org.eclipse.epf.library.edit.ICommandListener;
import org.eclipse.epf.library.edit.IConfigurationApplicator;
import org.eclipse.epf.library.edit.IConfigurator;
import org.eclipse.epf.library.edit.IConfiguratorFactory;
import org.eclipse.epf.library.edit.Providers;
import org.eclipse.epf.library.edit.command.MethodElementAddCommand;
import org.eclipse.epf.library.ui.LibraryUIManager;
import org.eclipse.epf.library.util.CopyAttachmentsToNewLocation;
import org.eclipse.epf.persistence.refresh.RefreshJob;
import org.eclipse.epf.uma.ContentDescription;
import org.eclipse.epf.uma.MethodConfiguration;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.VariabilityElement;
import org.eclipse.epf.uma.ecore.util.OppositeFeature;
import org.eclipse.jface.preference.IPreferenceStore;
import org.osgi.framework.BundleContext;

public class AuthoringUIPlugin
extends AbstractPlugin {
    private static AuthoringUIPlugin plugin;

    public AuthoringUIPlugin() {
        plugin = this;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        if (LibraryService.getInstance().getCurrentMethodLibrary() == null) {
            LibraryUIManager.getInstance().promptForMethodLibrary();
        }
        ProcessAuthoringConfigurator.INSTANCE.getClass();
        MethodElementAddCommand.setResourceManager((MethodElementAddCommand.ResourceManager)new CopyAttachmentsToNewLocation());
        EditorChooser.getInstance();
        MethodEditorPageProvider.getInstance().loadProviders();
        ProcessEditorPageProvider.getInstance().loadProviders();
        Providers.setConfiguratorFactory((IConfiguratorFactory)new IConfiguratorFactory(){

            public IConfigurator createConfigurator(MethodConfiguration config) {
                return new ProcessConfigurator(config, null, true);
            }
        });
        Providers.setConfigurationApplicator((IConfigurationApplicator)new IConfigurationApplicator(){

            public Object getAttribute(VariabilityElement ve, EAttribute attribute, MethodConfiguration config) {
                return ConfigurationHelper.calcAttributeFeatureValue((MethodElement)ve, (EStructuralFeature)attribute, (MethodConfiguration)config);
            }

            public Object getReference(VariabilityElement ve, EReference ref, MethodConfiguration config) {
                if (ConfigurationHelper.is0nFeature((EStructuralFeature)ref)) {
                    return ConfigurationHelper.calc0nFeatureValue((MethodElement)ve, (EStructuralFeature)ref, (ElementRealizer)new DefaultElementRealizer(config));
                }
                if (ConfigurationHelper.is01Feature((EStructuralFeature)ref)) {
                    return ConfigurationHelper.calc01FeatureValue((MethodElement)ve, (EStructuralFeature)ref, (ElementRealizer)new DefaultElementRealizer(config));
                }
                return null;
            }

            public Object getReference(ContentDescription desc, MethodElement owner, EReference ref, MethodConfiguration config) {
                List values = ConfigurationHelper.calc0nFeatureValue((MethodElement)desc, (MethodElement)owner, (EStructuralFeature)ref, (ElementRealizer)new DefaultElementRealizer(config));
                if (ref.isMany()) {
                    return values;
                }
                if (values.isEmpty()) {
                    return null;
                }
                return values;
            }

            public Object getReference(MethodElement element, OppositeFeature feature, MethodConfiguration config) {
                List values = ConfigurationHelper.calc0nFeatureValue((MethodElement)element, (OppositeFeature)feature, (ElementRealizer)new DefaultElementRealizer(config));
                return values;
            }

            public Object resolve(Object object, MethodConfiguration config) {
                if (object instanceof MethodElement) {
                    MethodElement resolved = ConfigurationHelper.getCalculatedElement((MethodElement)((MethodElement)object), (MethodConfiguration)config);
                    if (resolved == null) {
                        return object;
                    }
                    return resolved;
                }
                return object;
            }
        });
        Providers.setPreferenceStore((IPreferenceStore)LibraryPlugin.getDefault().getPreferenceStore());
        Providers.setAuthoringPlugin((AbstractPlugin)this);
        List cmdListeners = GraphicalDataManager.getInstance().getCommandListeners();
        cmdListeners.addAll(DiagramEditorUtil.getInstance().getVaryCommandListeners());
        Iterator iter = cmdListeners.iterator();
        while (iter.hasNext()) {
            ICommandListener listener = (ICommandListener)iter.next();
            Providers.registerCommandListener((ICommandListener)listener);
        }
        RefreshJob.getInstance().start();
    }

    public void stop(BundleContext context) throws Exception {
        RefreshJob.getInstance().stop();
        super.stop(context);
        plugin = null;
    }

    public static AuthoringUIPlugin getDefault() {
        return plugin;
    }
}

