/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.authoring.ui.dnd;

import org.eclipse.emf.edit.ui.dnd.ViewerDragAdapter;
import org.eclipse.epf.authoring.ui.editors.MethodElementEditorInput;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.library.util.ResourceHelper;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.ProcessComponent;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.HTMLTransfer;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;

public class LibraryViewerDragAdapter
extends ViewerDragAdapter {
    public LibraryViewerDragAdapter(Viewer viewer) {
        super(viewer);
    }

    public void dragStart(DragSourceEvent event) {
        super.dragStart(event);
        event.doit = !this.viewer.getSelection().isEmpty();
    }

    public void dragSetData(DragSourceEvent event) {
        if (HTMLTransfer.getInstance().isSupportedType(event.dataType)) {
            Object selectedElement;
            IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
            Object[] selectedElements = selection.toList().toArray(new Object[selection.size()]);
            if (selectedElements != null && selectedElements.length > 0 && (selectedElement = TngUtil.unwrap((Object)selectedElements[0])) instanceof MethodElement) {
                event.data = this.getHyperlink((MethodElement)selectedElement);
            }
        } else {
            super.dragSetData(event);
        }
    }

    protected String getHyperlink(MethodElement dragElement) {
        IEditorInput editorInput;
        MethodElement dropElement = null;
        IWorkbenchPage activePage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        IEditorPart activeEditor = activePage.getActiveEditor();
        if (activeEditor != null && (editorInput = activeEditor.getEditorInput()) instanceof MethodElementEditorInput) {
            dropElement = ((MethodElementEditorInput)editorInput).getMethodElement();
        }
        if (dragElement instanceof ProcessComponent) {
            dragElement = ((ProcessComponent)dragElement).getProcess();
        }
        String href = ResourceHelper.getUrl((MethodElement)dragElement, dropElement, (String)".html");
        return ResourceHelper.getElementLink((MethodElement)dragElement, (boolean)true, (String)("file://" + href));
    }
}

