/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.authoring.ui.views;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.emf.common.CommonPlugin;
import org.eclipse.emf.common.command.BasicCommandStack;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CommandStack;
import org.eclipse.emf.common.command.CommandStackListener;
import org.eclipse.emf.common.ui.viewer.IViewerProvider;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;
import org.eclipse.emf.edit.provider.ItemProviderAdapter;
import org.eclipse.emf.edit.ui.action.CopyAction;
import org.eclipse.emf.edit.ui.action.CutAction;
import org.eclipse.emf.edit.ui.action.DeleteAction;
import org.eclipse.emf.edit.ui.action.PasteAction;
import org.eclipse.emf.edit.ui.dnd.LocalTransfer;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.epf.authoring.ui.AuthoringUIHelpContexts;
import org.eclipse.epf.authoring.ui.AuthoringUIPlugin;
import org.eclipse.epf.authoring.ui.AuthoringUIResources;
import org.eclipse.epf.authoring.ui.UIActionDispatcher;
import org.eclipse.epf.authoring.ui.actions.ILibraryActionBarContributor;
import org.eclipse.epf.authoring.ui.actions.LibraryActionBarContributor;
import org.eclipse.epf.authoring.ui.actions.LibraryLockingOperationRunner;
import org.eclipse.epf.authoring.ui.actions.LibraryViewCopyAction;
import org.eclipse.epf.authoring.ui.actions.LibraryViewCutAction;
import org.eclipse.epf.authoring.ui.actions.LibraryViewDeleteAction;
import org.eclipse.epf.authoring.ui.actions.LibraryViewPasteAction;
import org.eclipse.epf.authoring.ui.actions.NewPluginAction;
import org.eclipse.epf.authoring.ui.dialogs.MoveDialog;
import org.eclipse.epf.authoring.ui.dialogs.VariabilitySelection;
import org.eclipse.epf.authoring.ui.dnd.LibraryViewerDragAdapter;
import org.eclipse.epf.authoring.ui.editors.AbstractDiagramEditor;
import org.eclipse.epf.authoring.ui.editors.BreakdownElementEditorInput;
import org.eclipse.epf.authoring.ui.editors.EditorChooser;
import org.eclipse.epf.authoring.ui.editors.MethodElementEditor;
import org.eclipse.epf.authoring.ui.editors.MethodElementEditorInput;
import org.eclipse.epf.authoring.ui.providers.MethodElementLabelDecorator;
import org.eclipse.epf.authoring.ui.views.AbstractBaseView;
import org.eclipse.epf.authoring.ui.views.ConfigurationView;
import org.eclipse.epf.authoring.ui.views.LibraryView;
import org.eclipse.epf.authoring.ui.views.ViewHelper;
import org.eclipse.epf.common.serviceability.MsgBox;
import org.eclipse.epf.library.ILibraryManager;
import org.eclipse.epf.library.LibraryService;
import org.eclipse.epf.library.LibraryServiceUtil;
import org.eclipse.epf.library.edit.TngAdapterFactory;
import org.eclipse.epf.library.edit.ui.UserInteractionHelper;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.library.edit.validation.IValidator;
import org.eclipse.epf.library.edit.validation.IValidatorFactory;
import org.eclipse.epf.library.services.SafeUpdateController;
import org.eclipse.epf.library.ui.LibraryUIManager;
import org.eclipse.epf.library.ui.dialogs.SwitchConfigDialog;
import org.eclipse.epf.library.ui.preferences.LibraryUIPreferences;
import org.eclipse.epf.library.util.ImportExportUtil;
import org.eclipse.epf.library.xmi.XMILibraryUtil;
import org.eclipse.epf.persistence.FileManager;
import org.eclipse.epf.persistence.MultiFileResourceSetImpl;
import org.eclipse.epf.persistence.MultiFileXMIResourceImpl;
import org.eclipse.epf.persistence.refresh.IRefreshHandler;
import org.eclipse.epf.persistence.refresh.RefreshJob;
import org.eclipse.epf.persistence.util.LibrarySchedulingRule;
import org.eclipse.epf.persistence.util.PersistenceUtil;
import org.eclipse.epf.uma.CapabilityPattern;
import org.eclipse.epf.uma.ContentCategory;
import org.eclipse.epf.uma.ContentDescription;
import org.eclipse.epf.uma.ContentElement;
import org.eclipse.epf.uma.ContentPackage;
import org.eclipse.epf.uma.CustomCategory;
import org.eclipse.epf.uma.DeliveryProcess;
import org.eclipse.epf.uma.MethodConfiguration;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.MethodLibrary;
import org.eclipse.epf.uma.MethodPlugin;
import org.eclipse.epf.uma.NamedElement;
import org.eclipse.epf.uma.Process;
import org.eclipse.epf.uma.ProcessComponent;
import org.eclipse.epf.uma.ProcessPackage;
import org.eclipse.epf.uma.VariabilityElement;
import org.eclipse.epf.uma.edit.domain.TraceableAdapterFactoryEditingDomain;
import org.eclipse.epf.uma.util.ContentDescriptionFactory;
import org.eclipse.epf.uma.util.IMethodLibraryPersister;
import org.eclipse.epf.uma.util.MessageException;
import org.eclipse.epf.uma.util.UmaUtil;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.DecoratingLabelProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.HTMLTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IPropertyListener;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.dialogs.ListSelectionDialog;
import org.eclipse.ui.views.navigator.ResourceNavigator;

public class LibraryView
extends AbstractBaseView
implements IRefreshHandler {
    public static final String VIEW_ID;
    protected TreeViewer treeViewer;
    protected IDoubleClickListener doubleClickListener = null;
    private ISelection selection;
    private IPartListener editorPartListener = new IPartListener(){

        public void partOpened(IWorkbenchPart part) {
        }

        public void partDeactivated(IWorkbenchPart part) {
        }

        public void partClosed(IWorkbenchPart part) {
        }

        public void partBroughtToTop(IWorkbenchPart part) {
        }

        public void partActivated(IWorkbenchPart part) {
            if (part instanceof IEditorPart) {
                Object obj = null;
                if (part instanceof AbstractDiagramEditor) {
                    BreakdownElementEditorInput input = (BreakdownElementEditorInput)((IEditorPart)part).getEditorInput();
                    if (input.getSuppression().getProcess() != null) {
                        obj = input.getSuppression().getProcess().eContainer();
                    }
                } else {
                    obj = EditorChooser.getInstance().getSelectedEditorInput();
                }
                if (obj != null && obj instanceof ProcessComponent) {
                    SwitchConfigDialog dialog = new SwitchConfigDialog(Display.getCurrent().getActiveShell(), ((ProcessComponent)obj).getProcess().getDefaultContext());
                    dialog.execute();
                }
            }
        }
    };
    private long lastRefreshTimeStamp;
    private IResourceChangeListener markerListener = new IResourceChangeListener(){

        public void resourceChanged(IResourceChangeEvent event) {
            if (LibraryService.getInstance().getCurrentLibraryManager() == null || LibraryService.getInstance().getCurrentLibraryManager().getEditingDomain() == null || LibraryService.getInstance().getCurrentLibraryManager().getEditingDomain().getResourceSet() == null) {
                return;
            }
            IResourceDelta delta = event.getDelta();
            if (delta == null) {
                return;
            }
            try {
                class ResourceDeltaVisitor
                implements IResourceDeltaVisitor {
                    final /* synthetic */ 2 this$1;

                    ResourceDeltaVisitor(2 var1_1) {
                        this.this$1 = var1_1;
                    }

                    public boolean visit(IResourceDelta delta) throws CoreException {
                        if ((delta.getFlags() & 0x20000) == 131072) {
                            switch (delta.getKind()) {
                                case 1: 
                                case 4: {
                                    MultiFileResourceSetImpl resourceSet = (MultiFileResourceSetImpl)LibraryService.getInstance().getCurrentLibraryManager().getEditingDomain().getResourceSet();
                                    if (resourceSet.getMarkerMananger().hasUnresolvedProxy()) {
                                        SafeUpdateController.asyncExec((Runnable)new Runnable(this){
                                            final /* synthetic */ ResourceDeltaVisitor this$2;
                                            {
                                                this.this$2 = resourceDeltaVisitor;
                                            }

                                            public void run() {
                                                try {
                                                    PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("org.eclipse.ui.views.ProblemView", null, 2);
                                                }
                                                catch (Exception exception) {}
                                            }
                                        });
                                    }
                                    return false;
                                }
                            }
                        }
                        return true;
                    }
                }
                ResourceDeltaVisitor visitor = new ResourceDeltaVisitor(this);
                delta.accept((IResourceDeltaVisitor)visitor);
            }
            catch (CoreException e) {
                CommonPlugin.INSTANCE.log((Object)e);
            }
        }
    };
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.epf.authoring.ui.views.LibraryView");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        VIEW_ID = clazz.getName();
    }

    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, AuthoringUIHelpContexts.LIBRARY_NAVIGATOR_VIEW_CONTEXT);
        RefreshJob.getInstance().setRefreshHandler((IRefreshHandler)this);
    }

    public void setFocus() {
        this.actionBarContributor.setActiveView((IViewPart)this);
        IStructuredSelection selected = (IStructuredSelection)this.getSelection();
        if (selected.isEmpty()) {
            this.actionBarContributor.disableGlobalEditMenu();
        } else {
            this.actionBarContributor.enableGlobalEditMenu();
        }
        if (this.treeViewer != null) {
            this.treeViewer.getControl().setFocus();
        }
    }

    public Viewer getViewer() {
        return this.treeViewer;
    }

    public void createViewer(Composite parent) {
        this.treeViewer = new TreeViewer(parent){

            protected void handleLabelProviderChanged(LabelProviderChangedEvent event) {
                if (event.getElement() instanceof IResource && event.getSource() instanceof ILabelDecorator) {
                    this.refresh();
                    return;
                }
                super.handleLabelProviderChanged(event);
            }
        };
        this.adapterFactory = TngAdapterFactory.INSTANCE.getNavigatorView_ComposedAdapterFactory();
        BasicCommandStack commandStack = new BasicCommandStack();
        commandStack.addCommandStackListener(new CommandStackListener(){

            public void commandStackChanged(EventObject event) {
                Runnable runnable = new Runnable(this, event){
                    final /* synthetic */ 17 this$1;
                    private final /* synthetic */ EventObject val$event;
                    {
                        this.this$1 = var1_1;
                        this.val$event = eventObject;
                    }

                    public void run() {
                        LibraryView.access$3(17.access$0(this.this$1), 257);
                        Command mostRecentCommand = ((CommandStack)this.val$event.getSource()).getMostRecentCommand();
                        if (mostRecentCommand != null) {
                            17.access$0(this.this$1).setSelectionToViewer(mostRecentCommand.getAffectedObjects());
                        }
                        if (17.access$0(this.this$1).propertySheetPage != null && 17.access$0(this.this$1).propertySheetPage.getControl() != null && !17.access$0(this.this$1).propertySheetPage.getControl().isDisposed() && 17.access$0(this.this$1).propertySheetPage.getControl().isVisible()) {
                            17.access$0(this.this$1).propertySheetPage.refresh();
                        }
                    }
                };
                if (Display.getCurrent() != null) {
                    Display.getCurrent().asyncExec(runnable);
                } else {
                    runnable.run();
                }
            }

            static /* synthetic */ LibraryView access$0(17 var0) {
                return var0.LibraryView.this;
            }
        });
        MultiFileResourceSetImpl resourceSet = new MultiFileResourceSetImpl();
        this.editingDomain = new TraceableAdapterFactoryEditingDomain(this.adapterFactory, (CommandStack)commandStack, (ResourceSet)resourceSet);
        ILibraryManager manager = LibraryService.getInstance().getCurrentLibraryManager();
        if (manager != null) {
            manager.registerEditingDomain(this.editingDomain);
            manager.addPropertyListener(new IPropertyListener(){

                public void propertyChanged(Object source, int propId) {
                    if (propId == 1) {
                        LibraryView.this.firePropertyChange(257);
                    }
                }
            });
        }
        this.treeViewer.setContentProvider((IContentProvider)new AdapterFactoryContentProvider(this.adapterFactory));
        this.treeViewer.setLabelProvider((IBaseLabelProvider)new DecoratingLabelProvider((ILabelProvider)new AdapterFactoryLabelProvider(this.adapterFactory), (ILabelDecorator)new MethodElementLabelDecorator()));
        this.doubleClickListener = new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                UIActionDispatcher.getInstance().handleDoubleClickEvent(event);
            }
        };
        this.treeViewer.addDoubleClickListener(this.doubleClickListener);
        this.getSite().getPage().addPartListener(this.editorPartListener);
        ResourcesPlugin.getWorkspace().addResourceChangeListener(this.markerListener);
        this.createContextMenuFor((StructuredViewer)this.treeViewer);
    }

    public void setInputForViewer(Object model) {
        Control ctrl = this.getViewer().getControl();
        if (ctrl.isDisposed()) {
            return;
        }
        if (model == null || model instanceof MethodLibrary) {
            StructuredSelection emptySelection = new StructuredSelection();
            this.actionDispatcher.setSelection((ISelection)emptySelection);
            UIActionDispatcher.getInstance().setSelection((ISelection)emptySelection);
            this.getViewer().setInput(model);
            this.updateLastRefreshTimestamp();
        } else {
            AuthoringUIPlugin.getDefault().getLogger().logError("Library viewer input is not a MethodLibrary object: " + model);
        }
    }

    private void updateLastRefreshTimestamp() {
        this.lastRefreshTimeStamp = System.currentTimeMillis();
    }

    public static LibraryView getView() {
        return (LibraryView)ViewHelper.openView(VIEW_ID);
    }

    public void setSelection(ISelection selection) {
        ((LibraryViewActionBarContributor)this.actionBarContributor).updateSelection(selection);
        super.setSelection(selection);
        this.selection = selection;
        IStatusLineManager statusLineManager = this.getViewSite().getActionBars().getStatusLineManager();
        if (statusLineManager != null) {
            URI uri;
            Resource resource;
            Object o;
            IStructuredSelection structuredSelection;
            String path = "";
            if (selection instanceof IStructuredSelection && (structuredSelection = (IStructuredSelection)selection).size() == 1 && (o = TngUtil.unwrap((Object)structuredSelection.getFirstElement())) instanceof EObject && (resource = ((EObject)o).eResource()) != null && (uri = resource.getURI()) != null) {
                URI contentURI;
                ContentDescription content;
                path = uri.toFileString();
                if (o instanceof ContentElement && (content = ((ContentElement)o).getPresentation()) != null && (resource = content.eResource()) != null && (contentURI = resource.getURI()) != null) {
                    path = String.valueOf(path) + ",." + File.separatorChar + contentURI.deresolve(uri).toFileString();
                }
            }
            statusLineManager.setMessage(path);
        }
    }

    public void libraryReopened(MethodLibrary library) {
        this.refreshViews();
    }

    public ILibraryActionBarContributor createActionBarContributor() {
        LibraryViewActionBarContributor actionBar = new LibraryViewActionBarContributor((EditingDomain)this.editingDomain);
        return actionBar;
    }

    public void createContextMenuFor(StructuredViewer viewer) {
        super.createContextMenuFor(viewer);
        int dndOperations = 2;
        Transfer[] transfers = new Transfer[]{HTMLTransfer.getInstance(), LocalTransfer.getInstance()};
        viewer.addDragSupport(dndOperations, transfers, (DragSourceListener)new LibraryViewerDragAdapter((Viewer)viewer));
    }

    public void menuAboutToShow(IMenuManager menuManager) {
        super.menuAboutToShow(menuManager);
    }

    public void init(IViewSite site) throws PartInitException {
        super.init(site);
    }

    public void dispose() {
        RefreshJob.getInstance().setRefreshHandler(null);
        super.dispose();
        if (this.doubleClickListener != null) {
            this.treeViewer.removeDoubleClickListener(this.doubleClickListener);
        }
    }

    public ProcessComponent getProcessComponent(Object obj) {
        Object parent = obj;
        while (parent != null && !(parent instanceof ProcessComponent)) {
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = Class.forName("org.eclipse.emf.edit.provider.ITreeItemContentProvider");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            ItemProviderAdapter adapter = (ItemProviderAdapter)this.adapterFactory.adapt(parent, (Object)clazz);
            parent = adapter.getParent(parent);
        }
        return (ProcessComponent)parent;
    }

    public void openLibrary(final String path) {
        StatusWorkspaceModifyOperation operation = new StatusWorkspaceModifyOperation(){

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void execute(IProgressMonitor monitor) {
                monitor.beginTask(AuthoringUIResources.openingLibraryTask_name, 2);
                try {
                    block7: {
                        try {
                            monitor.worked(1);
                            LibraryService.getInstance().closeCurrentMethodLibrary();
                            MethodLibrary library = XMILibraryUtil.openMethodLibrary((String)path);
                            LibraryService.getInstance().setCurrentMethodLibrary(library);
                            LibraryUIPreferences.setSavedLibraryPath((String)path);
                        }
                        catch (Exception ex) {
                            if (ex instanceof IOException) {
                                String message = ex.getMessage();
                                if (!message.startsWith("###")) break block7;
                                String projectFileName = message.substring(3);
                                String prompt = AuthoringUIResources.bind((String)AuthoringUIResources.ElementsView_35, (Object[])new Object[]{projectFileName});
                                if (MsgBox.prompt((String)prompt, (int)1280) == 1024) {
                                    LibraryView.this.openLibrary(path);
                                }
                                break block7;
                            }
                            AuthoringUIPlugin.getDefault().getMsgDialog().displayError(AuthoringUIResources.errorDialog_title, AuthoringUIResources.openLibraryError_msg, (Throwable)ex);
                        }
                    }
                    Object var6_9 = null;
                }
                catch (Throwable throwable) {
                    Object var6_8 = null;
                    monitor.done();
                    throw throwable;
                }
                monitor.done();
            }
        };
        try {
            new ProgressMonitorDialog(this.getSite().getShell()).run(true, false, (IRunnableWithProgress)operation);
            if (operation.getErrorMessage() == null) {
                this.getSite().getPage().closeAllEditors(false);
            }
        }
        catch (Exception e) {
            AuthoringUIPlugin.getDefault().getLogger().logError((Throwable)e);
        }
    }

    protected void handleActivate(IWorkbenchPart part) {
        super.handleActivate(part);
        XMILibraryUtil.openMethodLibraryProject((MethodLibrary)LibraryService.getInstance().getCurrentMethodLibrary(), (IProgressMonitor)this.getViewSite().getActionBars().getStatusLineManager().getProgressMonitor());
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public void doSaveAs() {
    }

    public void setSelectionToViewer(Object o) {
        if (!((o = TngUtil.unwrap((Object)o)) instanceof MethodElement)) {
            return;
        }
        if (o instanceof MethodConfiguration) {
            super.setSelectionToViewer(Arrays.asList(o));
            return;
        }
        try {
            MethodPlugin plugin = UmaUtil.getMethodPlugin((EObject)((MethodElement)o));
            this.treeViewer.setExpandedState((Object)plugin, true);
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("org.eclipse.emf.edit.provider.ITreeItemContentProvider");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            ITreeItemContentProvider pluginAdapter = (ITreeItemContentProvider)TngUtil.getAdapter((EObject)plugin, (Class)clazz);
            if (o instanceof Process) {
                o = ((Process)o).eContainer();
            }
            if (o instanceof ProcessComponent || o instanceof ProcessPackage) {
                this.treeViewer.setExpandedState(pluginAdapter.getChildren((Object)plugin).toArray()[1], true);
                this.expandTreeViewerPackages(((MethodElement)o).eContainer());
            } else {
                ITreeItemContentProvider methodContentPkg = (ITreeItemContentProvider)pluginAdapter.getChildren((Object)plugin).toArray()[0];
                this.treeViewer.setExpandedState((Object)methodContentPkg, true);
                if (o instanceof CustomCategory) {
                    CustomCategory rootCC = TngUtil.getRootCustomCategory((MethodPlugin)plugin);
                    this.treeViewer.setExpandedState((Object)rootCC, true);
                } else if (o instanceof ContentCategory) {
                    Object stdCats = methodContentPkg.getChildren(o).toArray()[1];
                    this.treeViewer.setExpandedState(stdCats, true);
                } else {
                    Object coreContent = methodContentPkg.getChildren(o).toArray()[0];
                    this.treeViewer.setExpandedState(coreContent, true);
                    this.expandTreeViewerPackages(((MethodElement)o).eContainer());
                }
            }
        }
        catch (Exception ex) {
            AuthoringUIPlugin.getDefault().getLogger().logError((Throwable)ex);
        }
        super.setSelectionToViewer(Arrays.asList(o));
    }

    private void expandTreeViewerPackages(EObject e) {
        if (e == null) {
            return;
        }
        if (e instanceof ContentPackage || e instanceof ProcessPackage) {
            this.expandTreeViewerPackages(e.eContainer());
            this.treeViewer.setExpandedState((Object)e, true);
        }
    }

    public void refresh(IProgressMonitor monitor) {
        Control ctrl = this.getViewer().getControl();
        if (ctrl == null || ctrl.isDisposed()) {
            return;
        }
        if (ctrl.getDisplay().getThread() == Thread.currentThread()) {
            this.doRefresh(this.getSite().getShell());
        } else {
            ctrl.getDisplay().syncExec(new Runnable(){

                public void run() {
                    LibraryView.this.doRefresh(null);
                }
            });
        }
    }

    private void blockingRefresh(final ArrayList removedResources, final ArrayList changedResources, final Collection addedWorkspaceResources, final boolean refreshViews, Shell shell) {
        IRunnableWithProgress runnable = new IRunnableWithProgress(){

            /*
             * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                monitor.beginTask("", -1);
                monitor.subTask(AuthoringUIResources._UI_RefreshViewer_menu_item);
                monitor.worked(1);
                try {
                    LibraryView.this.doRefresh(removedResources, changedResources, addedWorkspaceResources, refreshViews);
                }
                catch (Throwable throwable) {
                    Object var2_3 = null;
                    monitor.done();
                    throw throwable;
                }
                {
                    Object var2_4 = null;
                }
                monitor.done();
            }
        };
        ProgressMonitorDialog context = new ProgressMonitorDialog(shell);
        try {
            this.getSite().getWorkbenchWindow().getWorkbench().getProgressService().runInUI((IRunnableContext)context, runnable, (ISchedulingRule)new LibrarySchedulingRule(LibraryService.getInstance().getCurrentMethodLibrary()));
        }
        catch (Exception e) {
            AuthoringUIPlugin.getDefault().getLogger().logError((Throwable)e);
            String title = AuthoringUIResources.ProcessEditor_refreshErrorTitle;
            AuthoringUIPlugin.getDefault().getMsgDialog().displayError(title, e.toString(), (Throwable)e);
        }
    }

    private synchronized void doRefresh(Collection removedResources, Collection changedResources, Collection addedWorkspaceResources, boolean refreshViews) {
        ILibraryManager mgr;
        HashSet editorsToRefresh = new HashSet();
        if (!removedResources.isEmpty()) {
            this.handleRemovedResources(removedResources, editorsToRefresh);
            refreshViews = true;
        }
        if (!changedResources.isEmpty()) {
            this.handleChangedResources(changedResources, editorsToRefresh, refreshViews);
        } else {
            if (refreshViews) {
                this.refreshViews();
            }
            if (!editorsToRefresh.isEmpty()) {
                Iterator iter = editorsToRefresh.iterator();
                while (iter.hasNext()) {
                    Object editor = iter.next();
                    if (!(editor instanceof MethodElementEditor)) continue;
                    ((MethodElementEditor)((Object)editor)).refresh();
                }
            }
        }
        if (addedWorkspaceResources != null && !addedWorkspaceResources.isEmpty() && (mgr = LibraryService.getInstance().getCurrentLibraryManager()) != null) {
            MultiFileResourceSetImpl resourceSet = (MultiFileResourceSetImpl)mgr.getEditingDomain().getResourceSet();
            resourceSet.loadNewResources(addedWorkspaceResources);
        }
    }

    private void doRefresh(Shell shell) {
        boolean refreshViews = !RefreshJob.getInstance().getReloadedBeforeRefreshResources().isEmpty() || !RefreshJob.getInstance().getAddedResources().isEmpty();
        ArrayList removedResources = new ArrayList(RefreshJob.getInstance().getRemovedResources());
        ArrayList changedResources = new ArrayList(RefreshJob.getInstance().getChangedResources());
        ArrayList addedWsResources = new ArrayList(RefreshJob.getInstance().getAddedWorkspaceResources());
        if (!removedResources.isEmpty() || !changedResources.isEmpty() || !addedWsResources.isEmpty() || refreshViews) {
            this.blockingRefresh(removedResources, changedResources, addedWsResources, refreshViews, shell);
        }
        if (!removedResources.isEmpty()) {
            RefreshJob.getInstance().getRemovedResources().removeAll(removedResources);
        }
        if (!changedResources.isEmpty()) {
            RefreshJob.getInstance().getChangedResources().removeAll(changedResources);
        }
        if (!addedWsResources.isEmpty()) {
            RefreshJob.getInstance().getAddedWorkspaceResources().removeAll(addedWsResources);
        }
        if (refreshViews) {
            RefreshJob.getInstance().getReloadedBeforeRefreshResources().clear();
            RefreshJob.getInstance().getAddedResources().clear();
        }
    }

    private Collection handleRemovedResources(Collection removedResources, Collection editorsToRefresh) {
        ResourceSet resourceSet;
        IWorkbenchPage workbenchPage = this.getSite().getPage();
        IEditorReference[] editorReferences = workbenchPage.getEditorReferences();
        ArrayList<IEditorPart> dirtyEditorsWithConflict = new ArrayList<IEditorPart>();
        ArrayList removedResourceList = new ArrayList(removedResources);
        if (editorsToRefresh == null) {
            editorsToRefresh = new ArrayList<Object>();
        }
        int i = 0;
        while (i < editorReferences.length) {
            IEditorReference reference = editorReferences[i];
            IEditorPart editor = reference.getEditor(true);
            if (editor instanceof MethodElementEditor && editor.isDirty()) {
                Resource resource;
                MethodElementEditorInput input = (MethodElementEditorInput)editor.getEditorInput();
                Resource resource2 = resource = input.getMethodElement() != null ? input.getMethodElement().eResource() : null;
                if (!removedResources.contains(resource)) {
                    Collection usedResources = ((MethodElementEditor)editor).getUsedResources();
                    int j = 0;
                    while (j < removedResourceList.size()) {
                        resource = (Resource)removedResourceList.get(j);
                        if (usedResources.contains(resource)) {
                            dirtyEditorsWithConflict.add(editor);
                            break;
                        }
                        ++j;
                    }
                } else {
                    editorsToRefresh.add(editor);
                }
            }
            ++i;
        }
        if (!dirtyEditorsWithConflict.isEmpty()) {
            Object[] selected = this.selectDirtyEditors(dirtyEditorsWithConflict);
            int i2 = 0;
            while (i2 < selected.length) {
                editorsToRefresh.add(selected[i2]);
                ++i2;
            }
        }
        Iterator iter = removedResources.iterator();
        while (iter.hasNext()) {
            MultiFileXMIResourceImpl resource = (MultiFileXMIResourceImpl)iter.next();
            try {
                ((MultiFileResourceSetImpl)resource.getResourceSet()).unloadWithoutRemove(resource);
            }
            catch (Exception e) {
                CommonPlugin.INSTANCE.log((Object)e);
            }
        }
        ILibraryManager manager = LibraryService.getInstance().getCurrentLibraryManager();
        if (manager != null && (resourceSet = manager.getEditingDomain().getResourceSet()) != null) {
            resourceSet.getResources().removeAll(removedResources);
        }
        int i3 = 0;
        while (i3 < editorReferences.length) {
            IEditorReference reference = editorReferences[i3];
            IEditorPart editor = reference.getEditor(true);
            if (editor instanceof MethodElementEditor && !editor.isDirty()) {
                Collection usedResources = ((MethodElementEditor)editor).getUsedResources();
                int j = 0;
                while (j < removedResourceList.size()) {
                    Resource resource = (Resource)removedResourceList.get(j);
                    if (usedResources.contains(resource)) {
                        editorsToRefresh.add(editor);
                        break;
                    }
                    ++j;
                }
            }
            ++i3;
        }
        return removedResources;
    }

    private Collection handleChangedResources(Collection changedResources, Collection editorsToRefresh, boolean forceRefreshViews) {
        if (!forceRefreshViews) {
            Iterator iter = changedResources.iterator();
            while (iter.hasNext()) {
                MultiFileXMIResourceImpl resource = (MultiFileXMIResourceImpl)iter.next();
                if (resource.getLastLoadTimeStamp() <= this.lastRefreshTimeStamp) continue;
                forceRefreshViews = true;
                break;
            }
        }
        return this.handleChangedResources(changedResources, null, forceRefreshViews, editorsToRefresh);
    }

    public Collection handleChangedResources(Collection changedResources, Collection editorsNotToRefresh, boolean forceRefreshViews, Collection editorsToRefresh) {
        Object editor;
        Control ctrl = this.getViewer().getControl();
        if (ctrl == null || ctrl.isDisposed()) {
            return Collections.EMPTY_LIST;
        }
        IWorkbenchPage workbenchPage = this.getSite().getPage();
        IEditorReference[] editorReferences = workbenchPage.getEditorReferences();
        ArrayList<IEditorPart> dirtyEditorsWithConflict = new ArrayList<IEditorPart>();
        ArrayList changedResourceList = new ArrayList(changedResources);
        int i = 0;
        while (i < editorReferences.length) {
            IEditorReference reference = editorReferences[i];
            IEditorPart editor2 = reference.getEditor(true);
            if (editor2 instanceof MethodElementEditor && editor2.isDirty()) {
                Collection usedResources = ((MethodElementEditor)editor2).getUsedResources();
                int j = 0;
                while (j < changedResourceList.size()) {
                    Resource resource = (Resource)changedResourceList.get(j);
                    if (usedResources.contains(resource)) {
                        dirtyEditorsWithConflict.add(editor2);
                        break;
                    }
                    ++j;
                }
            }
            ++i;
        }
        ArrayList<Object> editorListToRefresh = new ArrayList<Object>();
        if (editorsToRefresh != null) {
            editorListToRefresh.addAll(editorsToRefresh);
        }
        if (!dirtyEditorsWithConflict.isEmpty()) {
            Object[] result = this.selectDirtyEditors(dirtyEditorsWithConflict);
            int i2 = 0;
            while (i2 < result.length) {
                editor = result[i2];
                if (!(editorsNotToRefresh != null && editorsNotToRefresh.contains(editor) || editorsToRefresh != null && editorsToRefresh.contains(editor))) {
                    editorListToRefresh.add(editor);
                    dirtyEditorsWithConflict.remove(editor);
                }
                ++i2;
            }
            i2 = 0;
            while (i2 < dirtyEditorsWithConflict.size()) {
                editor = (MethodElementEditor)((Object)dirtyEditorsWithConflict.get(i2));
                Collection usedResources = ((MethodElementEditor)((Object)editor)).getUsedResources();
                changedResourceList.removeAll(usedResources);
                ++i2;
            }
        }
        boolean refreshViews = false;
        if (!changedResourceList.isEmpty()) {
            int i3 = 0;
            while (i3 < editorReferences.length) {
                IEditorReference reference = editorReferences[i3];
                IEditorPart editor3 = reference.getEditor(true);
                if (editor3 instanceof MethodElementEditor && !editor3.isDirty()) {
                    Collection usedResources = ((MethodElementEditor)editor3).getUsedResources();
                    int j = 0;
                    while (j < changedResourceList.size()) {
                        Resource resource = (Resource)changedResourceList.get(j);
                        if (usedResources.contains(resource)) {
                            editorListToRefresh.add(editor3);
                            break;
                        }
                        ++j;
                    }
                }
                ++i3;
            }
            ILibraryManager manager = LibraryService.getInstance().getCurrentLibraryManager();
            if (manager != null) {
                Collection reloadedResources = manager.reloadResources(changedResourceList);
                boolean bl = refreshViews = !reloadedResources.isEmpty();
            }
        }
        if (forceRefreshViews || refreshViews) {
            this.refreshViews();
        }
        if (!editorListToRefresh.isEmpty()) {
            int i4 = 0;
            while (i4 < editorListToRefresh.size()) {
                editor = (MethodElementEditor)((Object)editorListToRefresh.get(i4));
                try {
                    ((MethodElementEditor)((Object)editor)).refresh();
                }
                catch (Exception e) {
                    AuthoringUIPlugin.getDefault().getLogger().logError((Throwable)e);
                }
                ++i4;
            }
        }
        return changedResourceList;
    }

    public synchronized void refreshViews() {
        Control ctrl;
        ConfigurationView configView;
        EObject input = (EObject)this.getViewer().getInput();
        if (input != null) {
            if (input.eIsProxy()) {
                this.setInputForViewer(RefreshJob.getInstance().resolve(input));
            } else {
                ISelection selection = this.getViewer().getSelection();
                this.getViewer().refresh();
                this.updateLastRefreshTimestamp();
                if (selection instanceof IStructuredSelection) {
                    IStructuredSelection structuredSelection = (IStructuredSelection)selection;
                    Object o = null;
                    if (structuredSelection.size() == 1 && (o = structuredSelection.getFirstElement()) instanceof EObject && ((EObject)o).eIsProxy()) {
                        o = RefreshJob.getInstance().resolve((EObject)o);
                        try {
                            this.setSelectionToViewer(o);
                        }
                        catch (Exception e) {
                            AuthoringUIPlugin.getDefault().getLogger().logError((Throwable)e);
                        }
                    } else {
                        LibraryView.restoreSelection(this.getViewer(), selection);
                    }
                }
            }
        }
        if ((configView = ConfigurationView.getView()) != null && (ctrl = configView.getViewer().getControl()) != null && !ctrl.isDisposed() && (input = (EObject)configView.getViewer().getInput()) != null) {
            if (input.eIsProxy()) {
                configView.setInputForViewer(RefreshJob.getInstance().resolve(input));
            } else {
                ISelection selection = configView.getViewer().getSelection();
                configView.getViewer().refresh();
                LibraryView.restoreSelection(configView.getViewer(), selection);
            }
        }
    }

    private Object[] selectDirtyEditors(List dirtyEditors) {
        String title = AuthoringUIResources._UI_FileConflict_label;
        String msg = AuthoringUIResources.selectEditorsToDiscardConflictChanges;
        return this.selectEditors(dirtyEditors, title, msg);
    }

    private Object[] selectEditors(List editors, String title, String msg) {
        IStructuredContentProvider contentProvider = new IStructuredContentProvider(){
            List fContents;

            public Object[] getElements(Object inputElement) {
                if (this.fContents != null && this.fContents == inputElement) {
                    return this.fContents.toArray();
                }
                return new Object[0];
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
                this.fContents = newInput instanceof List ? (List)newInput : null;
            }
        };
        LabelProvider labelProvider = new LabelProvider(){

            public String getText(Object element) {
                if (element instanceof IEditorPart) {
                    return ((IEditorPart)element).getTitle();
                }
                return super.getText(element);
            }

            public Image getImage(Object element) {
                if (element instanceof IEditorPart) {
                    return ((IEditorPart)element).getTitleImage();
                }
                return super.getImage(element);
            }
        };
        ListSelectionDialog dlg = new ListSelectionDialog(this.getSite().getShell(), (Object)editors, contentProvider, (ILabelProvider)labelProvider, msg);
        dlg.setTitle(title);
        dlg.setBlockOnOpen(true);
        dlg.open();
        return dlg.getResult();
    }

    private static void restoreSelection(Viewer viewer, ISelection selection) {
        if (selection instanceof IStructuredSelection && !selection.isEmpty()) {
            IStructuredSelection structuredSelection = (IStructuredSelection)selection;
            boolean restore = false;
            ArrayList<EObject> resolvedList = new ArrayList<EObject>();
            Iterator iter = structuredSelection.iterator();
            while (iter.hasNext()) {
                Object object = iter.next();
                if (!(object instanceof EObject)) continue;
                EObject eObj = (EObject)object;
                if (eObj.eIsProxy()) {
                    eObj = RefreshJob.getInstance().resolve(eObj);
                    restore = true;
                }
                if (eObj.eIsProxy()) continue;
                resolvedList.add(eObj);
            }
            if (restore) {
                viewer.setSelection((ISelection)new StructuredSelection(resolvedList), true);
            }
        }
    }

    public static void runRename(final NamedElement e, final String newName) {
        Display.getDefault().syncExec(new Runnable(){

            public void run() {
                LibraryView.doRename(e, newName);
            }
        });
    }

    private static void doRename(final NamedElement e, String newName) {
        Runnable runnable;
        String oldName = e.getName();
        e.setName(newName);
        if (e instanceof ProcessComponent) {
            Process proc = ((ProcessComponent)e).getProcess();
            proc.setName(newName);
        }
        if (!UserInteractionHelper.runWithProgress((Runnable)(runnable = new Runnable(){

            public void run() {
                IMethodLibraryPersister.FailSafeMethodLibraryPersister persister = ContentDescriptionFactory.getMethodLibraryPersister().getFailSafePersister();
                try {
                    persister.save(e.eResource());
                    persister.commit();
                    ArrayList<Resource> renamedResources = new ArrayList<Resource>();
                    if (e instanceof ContentElement && ContentDescriptionFactory.hasPresentation((MethodElement)((MethodElement)e))) {
                        renamedResources.add(((ContentElement)e).getPresentation().eResource());
                    }
                    renamedResources.add(e.eResource());
                    persister.adjustLocation(renamedResources);
                }
                catch (Exception e1) {
                    AuthoringUIPlugin.getDefault().getLogger().logError((Throwable)e1);
                    persister.rollback();
                    String details = e1.getMessage() != null ? MessageFormat.format(": {0}", e1.getMessage()) : "";
                    String msg = MessageFormat.format(AuthoringUIResources.ElementsView_err_saving, e.eResource().getURI().toFileString(), details);
                    throw new MessageException(msg);
                }
            }
        }), (String)AuthoringUIResources.ElementsView_renaming_text)) {
            e.setName(oldName);
        }
    }

    class LibraryViewActionBarContributor
    extends LibraryActionBarContributor {
        private IAction newPluginAction = new NewPluginAction(AuthoringUIResources.new_plugin);
        private IAction moveAction = new Action(this, AuthoringUIResources.move){
            final /* synthetic */ LibraryViewActionBarContributor this$1;
            {
                this.this$1 = libraryViewActionBarContributor;
            }

            private void doMove() {
                Object element;
                ArrayList<E> elementsToMove = new ArrayList<E>();
                IStructuredSelection selection = (IStructuredSelection)LibraryView.access$0(LibraryViewActionBarContributor.access$2(this.this$1));
                Iterator iter = selection.iterator();
                while (iter.hasNext()) {
                    element = iter.next();
                    if (!(element instanceof MethodElement) && !((element = TngUtil.unwrap(element)) instanceof CustomCategory)) continue;
                    EObject container = ((EObject)element).eContainer();
                    IStatus status = UserInteractionHelper.checkModify((EObject)container, (Shell)LibraryViewActionBarContributor.access$2(this.this$1).getSite().getShell());
                    if (container != null && !status.isOK()) {
                        AuthoringUIPlugin.getDefault().getMsgDialog().displayError(AuthoringUIResources.errorDialog_title, AuthoringUIResources.errorDialog_moveError, status);
                        return;
                    }
                    elementsToMove.add(element);
                }
                Iterator<E> iterator = elementsToMove.iterator();
                while (iterator.hasNext()) {
                    element = (EObject)iterator.next();
                    boolean isContained = false;
                    Iterator<E> iter2 = elementsToMove.iterator();
                    while (iter2.hasNext()) {
                        E e = iter2.next();
                        if (!UmaUtil.isContainedBy(element, e)) continue;
                        isContained = true;
                        break;
                    }
                    if (!isContained) continue;
                    iterator.remove();
                }
                MoveDialog dlg = new MoveDialog(LibraryViewActionBarContributor.access$2(this.this$1).getSite().getShell(), elementsToMove, (EditingDomain)LibraryViewActionBarContributor.access$2((LibraryViewActionBarContributor)this.this$1).editingDomain);
                dlg.open();
            }

            public void run() {
                LibraryLockingOperationRunner runner = new LibraryLockingOperationRunner();
                runner.setProgressMonitor(this.this$1.getActionBars().getStatusLineManager().getProgressMonitor());
                runner.run(new IRunnableWithProgress(this){
                    final /* synthetic */ 4 this$2;
                    {
                        this.this$2 = var1_1;
                    }

                    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                        4.access$0(this.this$2);
                    }
                });
            }

            static /* synthetic */ void access$0(4 var0) {
                var0.doMove();
            }
        };
        private IAction renameAction = new Action(this, AuthoringUIResources.renameAction_text){
            final /* synthetic */ LibraryViewActionBarContributor this$1;
            {
                this.this$1 = libraryViewActionBarContributor;
            }

            public void run() {
                NamedElement e = (NamedElement)TngUtil.unwrap((Object)((IStructuredSelection)LibraryView.access$0(LibraryViewActionBarContributor.access$2(this.this$1))).getFirstElement());
                IStatus status = UserInteractionHelper.checkModify((EObject)e, (Shell)LibraryViewActionBarContributor.access$2(this.this$1).getSite().getShell());
                if (!status.isOK()) {
                    AuthoringUIPlugin.getDefault().getMsgDialog().displayError(AuthoringUIResources.renameDialog_title, AuthoringUIResources.renameDialog_renameError, status);
                    return;
                }
                if (e.eContainer() != null && e.eContainer().eResource() != e.eResource() && !(status = UserInteractionHelper.checkModify((EObject)e.eContainer(), (Shell)LibraryViewActionBarContributor.access$2(this.this$1).getSite().getShell())).isOK()) {
                    AuthoringUIPlugin.getDefault().getMsgDialog().displayError(AuthoringUIResources.renameDialog_title, AuthoringUIResources.renameDialog_renameError, status);
                    return;
                }
                IValidator validator = IValidatorFactory.INSTANCE.createNameValidator(e, LibraryViewActionBarContributor.access$2((LibraryViewActionBarContributor)this.this$1).adapterFactory);
                IInputValidator inputValidator = new IInputValidator(this, validator){
                    final /* synthetic */ 6 this$2;
                    private final /* synthetic */ IValidator val$validator;
                    {
                        this.this$2 = var1_1;
                        this.val$validator = iValidator;
                    }

                    public String isValid(String newText) {
                        if (this.val$validator != null) {
                            return UserInteractionHelper.getSimpleErrorMessage((String)this.val$validator.isValid(newText));
                        }
                        return null;
                    }
                };
                boolean getInput = true;
                InputDialog inputDlg = new InputDialog(Display.getCurrent().getActiveShell(), AuthoringUIResources.rename_text, AuthoringUIResources.newname_text, e.getName(), inputValidator);
                while (getInput) {
                    String newName;
                    getInput = false;
                    if (inputDlg.open() != 0 || (newName = inputDlg.getValue()).equals(e.getName())) continue;
                    if (e instanceof MethodConfiguration) {
                        String[] configNames = LibraryServiceUtil.getMethodConfigurationNames((MethodLibrary)LibraryService.getInstance().getCurrentMethodLibrary());
                        int i = 0;
                        while (i < configNames.length) {
                            if (newName.equals(configNames[i])) {
                                AuthoringUIPlugin.getDefault().getMsgDialog().displayError(AuthoringUIResources.renameDialog_title, AuthoringUIResources.bind((String)AuthoringUIResources.duplicateElementNameError_msg, (Object)newName));
                                getInput = true;
                                break;
                            }
                            ++i;
                        }
                    }
                    if (getInput) {
                        inputDlg = new InputDialog(Display.getCurrent().getActiveShell(), AuthoringUIResources.rename_text, AuthoringUIResources.newname_text, e.getName(), inputValidator);
                        continue;
                    }
                    LibraryView.access$1(e, newName);
                }
            }
        };
        private IAction replaceAction = new Action(this, AuthoringUIResources.ElementsView_replaceAction_text){
            final /* synthetic */ LibraryViewActionBarContributor this$1;
            {
                this.this$1 = libraryViewActionBarContributor;
            }

            public void run() {
                if (!this.this$1.getPage().closeAllEditors(true)) {
                    return;
                }
                ProcessComponent procComp = (ProcessComponent)((IStructuredSelection)LibraryView.access$0(LibraryViewActionBarContributor.access$2(this.this$1))).getFirstElement();
                Process proc = procComp.getProcess();
                String typeStr = proc instanceof CapabilityPattern ? AuthoringUIResources.ElementsView_20 : (proc instanceof DeliveryProcess ? AuthoringUIResources.ElementsView_21 : AuthoringUIResources.ElementsView_22);
                DirectoryDialog dirDlg = new DirectoryDialog(LibraryViewActionBarContributor.access$2(this.this$1).getSite().getShell());
                dirDlg.setText(AuthoringUIResources.ElementsView_replace_text);
                dirDlg.setMessage(MessageFormat.format(AuthoringUIResources.ElementsView_migration_dir_dlg_description_text, typeStr));
                String dir = dirDlg.open();
                if (dir == null) {
                    return;
                }
                boolean ret = UserInteractionHelper.runWithProgress((IRunnableWithProgress)new IRunnableWithProgress(this, procComp, dir){
                    final /* synthetic */ 8 this$2;
                    private final /* synthetic */ ProcessComponent val$procComp;
                    private final /* synthetic */ String val$dir;
                    {
                        this.this$2 = var1_1;
                        this.val$procComp = processComponent;
                        this.val$dir = string;
                    }

                    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                        try {
                            ImportExportUtil.replace((ProcessComponent)this.val$procComp, (String)this.val$dir);
                        }
                        catch (Exception e) {
                            throw new WrappedException(e);
                        }
                    }
                }, (String)MessageFormat.format(AuthoringUIResources.ElementsView_replaceingwithformat_text, typeStr));
                if (ret) {
                    LibraryUIManager.getInstance().openLibrary(LibraryService.getInstance().getCurrentMethodLibraryPath());
                }
            }
        };
        private IAction openVariabilityDialogAction = new Action(this, AuthoringUIResources.ElementsView_openVariabilityDialogAction_text){
            final /* synthetic */ LibraryViewActionBarContributor this$1;
            {
                this.this$1 = libraryViewActionBarContributor;
            }

            public void run() {
                VariabilityElement element;
                VariabilitySelection variabilitySelection;
                Object selectedObject;
                Object obj = TngUtil.unwrap((Object)((IStructuredSelection)LibraryView.access$0(LibraryViewActionBarContributor.access$2(this.this$1))).getFirstElement());
                if (obj instanceof VariabilityElement && (selectedObject = (variabilitySelection = new VariabilitySelection()).getSelectedVariability(element = (VariabilityElement)obj)) != null) {
                    EditorChooser.getInstance().openEditor(selectedObject);
                }
            }
        };
        private boolean locked;
        private boolean canRename;
        private boolean canMove;
        private IAction showInResourceNavigatorAction = new Action(this, AuthoringUIResources.showInResourceNavigatorAction_label){
            final /* synthetic */ LibraryViewActionBarContributor this$1;
            {
                this.this$1 = libraryViewActionBarContributor;
            }

            public void run() {
                try {
                    ResourceNavigator navigator = (ResourceNavigator)this.this$1.getPage().showView("org.eclipse.ui.views.ResourceNavigator");
                    Object obj = TngUtil.unwrap((Object)((IStructuredSelection)LibraryView.access$0(LibraryViewActionBarContributor.access$2(this.this$1))).getFirstElement());
                    IResource wsRes = PersistenceUtil.getWorkspaceResource((Object)obj);
                    if (wsRes != null) {
                        navigator.getViewer().setSelection((ISelection)new StructuredSelection((Object)wsRes), true);
                    }
                }
                catch (PartInitException e) {
                    AuthoringUIPlugin.getDefault().getLogger().logError((Throwable)e);
                }
            }
        };

        public LibraryViewActionBarContributor(EditingDomain editingDomain) {
            super(editingDomain);
        }

        protected DeleteAction createDeleteAction() {
            LibraryViewDeleteAction action = new LibraryViewDeleteAction(this){
                final /* synthetic */ LibraryViewActionBarContributor this$1;
                {
                    this.this$1 = libraryViewActionBarContributor;
                }

                public boolean updateSelection(IStructuredSelection selection) {
                    if (LibraryViewActionBarContributor.access$0(this.this$1)) {
                        return false;
                    }
                    return super.updateSelection(selection);
                }

                public void run() {
                    String title = AuthoringUIResources.actions_LibraryActionBarContributor_deleteErrorTitle;
                    try {
                        super.run();
                    }
                    catch (MessageException e) {
                        AuthoringUIPlugin.getDefault().getMsgDialog().displayError(title, e.getMessage());
                    }
                    catch (Exception e) {
                        String details = TngUtil.toStackTraceString((Throwable)e);
                        String message = AuthoringUIResources.actions_LibraryActionBarContributor_deleteErrorMessage;
                        String reason = AuthoringUIResources.actions_LibraryActionBarContributor_deleteErrorReason;
                        AuthoringUIPlugin.getDefault().getMsgDialog().displayError(title, message, reason, details, (Throwable)e);
                    }
                }

                protected void deleteFailed() {
                    AuthoringUIPlugin.getDefault().getMsgDialog().displayInfo(AuthoringUIResources.dlgTitle_reloadLibrary, AuthoringUIResources.msg_reloadLibrary);
                    String libDir = LibraryService.getInstance().getCurrentMethodLibraryPath();
                    LibraryUIManager.getInstance().openLibrary(libDir);
                    if (LibraryViewActionBarContributor.access$1(this.this$1) instanceof IViewerProvider) {
                        ArrayList<MethodElement> elements = new ArrayList<MethodElement>();
                        Iterator<E> iter = this.selection.iterator();
                        while (iter.hasNext()) {
                            MethodElement element;
                            E e = iter.next();
                            if (!(e instanceof MethodElement)) continue;
                            String guid = ((MethodElement)e).getGuid();
                            ILibraryManager manager = LibraryService.getInstance().getCurrentLibraryManager();
                            if (manager == null || (element = manager.getMethodElement(guid)) == null) continue;
                            elements.add(element);
                        }
                        if (!elements.isEmpty()) {
                            Viewer viewer = ((IViewerProvider)LibraryViewActionBarContributor.access$1(this.this$1)).getViewer();
                            viewer.setSelection((ISelection)new StructuredSelection(elements), true);
                        }
                    }
                }
            };
            action.setProgressMonitor(this.getActionBars().getStatusLineManager().getProgressMonitor());
            return action;
        }

        protected CutAction createCutAction() {
            return new LibraryViewCutAction(this){
                final /* synthetic */ LibraryViewActionBarContributor this$1;
                {
                    this.this$1 = libraryViewActionBarContributor;
                }

                public boolean updateSelection(IStructuredSelection selection) {
                    if (LibraryViewActionBarContributor.access$0(this.this$1)) {
                        return false;
                    }
                    return super.updateSelection(selection);
                }
            };
        }

        protected CopyAction createCopyAction() {
            return new LibraryViewCopyAction();
        }

        protected PasteAction createPasteAction() {
            LibraryViewPasteAction action = new LibraryViewPasteAction(this){
                final /* synthetic */ LibraryViewActionBarContributor this$1;
                {
                    this.this$1 = libraryViewActionBarContributor;
                }

                public boolean updateSelection(IStructuredSelection selection) {
                    if (LibraryViewActionBarContributor.access$0(this.this$1)) {
                        return false;
                    }
                    return super.updateSelection(selection);
                }
            };
            action.setProgressMonitor(this.getActionBars().getStatusLineManager().getProgressMonitor());
            return action;
        }

        private void checkLocked() {
            if (LibraryView.this.selection instanceof IStructuredSelection) {
                boolean wasLocked = this.locked;
                this.locked = ViewHelper.isLocked((IStructuredSelection)LibraryView.this.selection);
                if (wasLocked != this.locked) {
                    this.deleteAction.setEnabled(this.deleteAction.updateSelection((IStructuredSelection)LibraryView.this.selection));
                    this.cutAction.setEnabled(this.cutAction.updateSelection((IStructuredSelection)LibraryView.this.selection));
                    this.pasteAction.setEnabled(this.pasteAction.updateSelection((IStructuredSelection)LibraryView.this.selection));
                    boolean enabled = !this.locked;
                    this.renameAction.setEnabled(enabled);
                    this.moveAction.setEnabled(enabled);
                }
            }
        }

        void updateSelection(ISelection selection) {
            IStructuredSelection sel = (IStructuredSelection)selection;
            this.locked = ViewHelper.isLocked(sel);
            boolean enabled = !this.locked;
            this.renameAction.setEnabled(enabled);
            this.moveAction.setEnabled(enabled);
            this.canRename = this.canRename(sel);
            this.canMove = this.canMove(sel);
            if (!this.locked && sel.size() == 1 && sel.getFirstElement() instanceof ProcessComponent) {
                this.replaceAction.setEnabled(true);
            } else {
                this.replaceAction.setEnabled(false);
            }
            if (sel.size() == 1) {
                Object obj = TngUtil.unwrap((Object)((IStructuredSelection)selection).getFirstElement());
                this.openVariabilityDialogAction.setEnabled(obj instanceof VariabilityElement && !TngUtil.isPredefined((MethodElement)((MethodElement)obj)));
                this.showInResourceNavigatorAction.setEnabled(obj instanceof MethodElement);
            }
        }

        public void enableGlobalEditMenu() {
        }

        protected void addGlobalActions(IMenuManager menuManager) {
            super.addGlobalActions(menuManager);
            menuManager.insertAfter("fixed-additions", this.newPluginAction);
        }

        private boolean canMove(IStructuredSelection selection) {
            Iterator iter = selection.iterator();
            while (iter.hasNext()) {
                Object element = iter.next();
                if (!(element instanceof MethodElement) || element instanceof ContentCategory || element instanceof MethodPlugin || element instanceof MethodConfiguration || TngUtil.isPredefined((MethodElement)((MethodElement)element))) continue;
                return true;
            }
            return false;
        }

        public void menuAboutToShow(IMenuManager menuManager) {
            this.checkLocked();
            menuManager.add((IContributionItem)new Separator("fixed-additions"));
            menuManager.add((IContributionItem)new Separator("fixed-additions-end"));
            menuManager.add((IContributionItem)new Separator("edit"));
            menuManager.add((IContributionItem)new ActionContributionItem((IAction)this.libraryViewEditAction));
            menuManager.add((IContributionItem)new ActionContributionItem((IAction)this.copyAction));
            menuManager.add((IContributionItem)new ActionContributionItem((IAction)this.pasteAction));
            menuManager.add((IContributionItem)new Separator());
            menuManager.add((IContributionItem)new ActionContributionItem((IAction)this.deleteAction));
            if (this.canRename) {
                menuManager.add((IContributionItem)new ActionContributionItem(this.renameAction));
            }
            if (this.canMove) {
                menuManager.add((IContributionItem)new ActionContributionItem(this.moveAction));
            }
            menuManager.add((IContributionItem)new Separator("view"));
            if (this.openVariabilityDialogAction.isEnabled()) {
                menuManager.add((IContributionItem)new ActionContributionItem(this.openVariabilityDialogAction));
            }
            if (this.showInResourceNavigatorAction.isEnabled()) {
                menuManager.add((IContributionItem)new ActionContributionItem(this.showInResourceNavigatorAction));
            }
            menuManager.add((IContributionItem)new Separator());
            menuManager.add((IContributionItem)new Separator("additions"));
            menuManager.add((IContributionItem)new Separator("additions-end"));
            this.addGlobalActions(menuManager);
            if (!this.locked) {
                MenuManager submenuManager = null;
                submenuManager = new MenuManager(AuthoringUIResources._UI_CreateChild_menu_item);
                this.populateManager((IContributionManager)submenuManager, this.createChildActions, null);
                menuManager.insertBefore("fixed-additions", (IContributionItem)submenuManager);
            }
        }

        private boolean canRename(IStructuredSelection selection) {
            if (selection.size() > 1) {
                return false;
            }
            Object element = TngUtil.unwrap((Object)selection.getFirstElement());
            return element instanceof NamedElement && !TngUtil.isPredefined((MethodElement)((MethodElement)element));
        }

        protected void refreshViewer(Viewer viewer) {
            if (viewer == LibraryView.this.getViewer()) {
                IRunnableWithProgress runnable = new IRunnableWithProgress(this){
                    final /* synthetic */ LibraryViewActionBarContributor this$1;
                    {
                        this.this$1 = libraryViewActionBarContributor;
                    }

                    /*
                     * Enabled aggressive block sorting
                     * Enabled unnecessary exception pruning
                     * Enabled aggressive exception aggregation
                     */
                    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                        monitor.beginTask("", 3);
                        monitor.subTask(AuthoringUIResources._UI_RefreshViewer_menu_item);
                        monitor.worked(1);
                        try {
                            ILibraryManager manager = LibraryService.getInstance().getCurrentLibraryManager();
                            if (manager != null) {
                                ResourceSet resourceSet = manager.getEditingDomain().getResourceSet();
                                ArrayList<Resource> removedResources = new ArrayList<Resource>();
                                ArrayList<Resource> changedResources = new ArrayList<Resource>();
                                Iterator<E> iter = new ArrayList<E>(resourceSet.getResources()).iterator();
                                while (iter.hasNext()) {
                                    Resource resource = (Resource)iter.next();
                                    String loc = resource.getURI().toFileString();
                                    IResource wsRes = FileManager.getResourceForLocation((String)loc);
                                    if (wsRes == null) {
                                        removedResources.add(resource);
                                        continue;
                                    }
                                    if (wsRes.isSynchronized(0)) continue;
                                    changedResources.add(resource);
                                }
                                monitor.worked(2);
                                LibraryView.access$2(LibraryViewActionBarContributor.access$2(this.this$1), removedResources, changedResources, null, false);
                            }
                            Object var10_12 = null;
                        }
                        catch (Throwable throwable) {
                            Object var10_11 = null;
                            monitor.done();
                            throw throwable;
                        }
                        monitor.done();
                    }
                };
                ProgressMonitorDialog context = new ProgressMonitorDialog(LibraryView.this.getSite().getShell());
                try {
                    LibraryView.this.getSite().getWorkbenchWindow().getWorkbench().getProgressService().runInUI((IRunnableContext)context, runnable, null);
                }
                catch (Exception e) {
                    AuthoringUIPlugin.getDefault().getLogger().logError((Throwable)e);
                    String title = AuthoringUIResources.ProcessEditor_refreshErrorTitle;
                    AuthoringUIPlugin.getDefault().getMsgDialog().displayError(title, e.toString(), (Throwable)e);
                }
                return;
            }
            super.refreshViewer(viewer);
        }

        static /* synthetic */ boolean access$0(LibraryViewActionBarContributor libraryViewActionBarContributor) {
            return libraryViewActionBarContributor.locked;
        }

        static /* synthetic */ IViewPart access$1(LibraryViewActionBarContributor libraryViewActionBarContributor) {
            return libraryViewActionBarContributor.activeViewPart;
        }

        static /* synthetic */ LibraryView access$2(LibraryViewActionBarContributor libraryViewActionBarContributor) {
            return libraryViewActionBarContributor.LibraryView.this;
        }
    }

    private static abstract class StatusWorkspaceModifyOperation
    extends WorkspaceModifyOperation {
        protected String errMsg;

        private StatusWorkspaceModifyOperation() {
        }

        public String getErrorMessage() {
            return this.errMsg;
        }
    }
}

