/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.common.serviceability;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.eclipse.epf.common.serviceability.EPFVersion;
import org.osgi.framework.Version;

public class EPFVersions {
    public static final String TOOL_ID = "epf";
    private static EPFVersion EPF_10;
    private static EPFVersion currentVersion;

    static {
        currentVersion = EPF_10 = new EPFVersion("1.0", "1.0.3.0", "1.0.0");
    }

    public EPFVersion getCurrentVersion() {
        return currentVersion;
    }

    public EPFVersion getVersion(String toolVersion) {
        if (toolVersion != null) {
            Iterator iter = this.getAllVersions().iterator();
            while (iter.hasNext()) {
                EPFVersion ver = (EPFVersion)iter.next();
                if (!ver.getToolVersion().equals((Object)new Version(toolVersion))) continue;
                return ver;
            }
        }
        return null;
    }

    public Collection getAllVersions() {
        ArrayList<EPFVersion> versions = new ArrayList<EPFVersion>();
        versions.add(EPF_10);
        return versions;
    }

    public EPFVersion getMinToolVersionForLibraryVersion(Version libraryVersion) {
        Iterator iter = this.getAllVersions().iterator();
        while (iter.hasNext()) {
            EPFVersion versionInfo = (EPFVersion)iter.next();
            if (versionInfo.getLibraryVersion().compareTo((Object)libraryVersion) != 0) continue;
            return versionInfo;
        }
        return null;
    }

    public EPFVersion getMinToolVersionForCurrentLibraryVersion() {
        Version libraryVersion = this.getCurrentVersion().getLibraryVersion();
        return this.getMinToolVersionForLibraryVersion(libraryVersion);
    }

    public EPFVersion getMinToolVersionForXMLSchemaVersion(Version xmlSchemaVersion) {
        Iterator iter = this.getAllVersions().iterator();
        while (iter.hasNext()) {
            EPFVersion versionInfo = (EPFVersion)iter.next();
            if (versionInfo.getXMLSchemaVersion().compareTo((Object)xmlSchemaVersion) != 0) continue;
            return versionInfo;
        }
        return null;
    }

    public EPFVersion getMinToolVersionForCurrentXMLSchemaVersion() {
        Version xmlSchemaVersion = this.getCurrentVersion().getXMLSchemaVersion();
        return this.getMinToolVersionForXMLSchemaVersion(xmlSchemaVersion);
    }
}

