/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.diagram.model.util;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.epf.diagram.model.Diagram;
import org.eclipse.epf.diagram.model.util.GraphicalDataHelper;
import org.eclipse.epf.diagram.model.util.IDiagramChangeListener;
import org.eclipse.epf.library.edit.ICommandListener;
import org.eclipse.epf.library.edit.util.ProcessUtil;
import org.eclipse.epf.uma.Activity;
import org.eclipse.epf.uma.BreakdownElement;
import org.eclipse.epf.uma.Dimension;
import org.eclipse.epf.uma.GraphConnector;
import org.eclipse.epf.uma.GraphEdge;
import org.eclipse.epf.uma.GraphNode;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.Point;
import org.eclipse.epf.uma.ProcessPackage;
import org.eclipse.epf.uma.SemanticModelBridge;
import org.eclipse.epf.uma.UMASemanticModelBridge;
import org.eclipse.epf.uma.UmaFactory;
import org.eclipse.epf.uma.VariabilityElement;
import org.eclipse.epf.uma.VariabilityType;
import org.eclipse.epf.uma.WorkOrder;
import org.eclipse.epf.uma.WorkProductDescriptor;
import org.eclipse.epf.uma.util.UmaUtil;

public final class GraphicalDataManager {
    private static final String[] diagramPresentations = new String[]{"Workflow", "Work Product Dependency", "Activity Detail"};
    private static final Class[] childTypes;
    private static final Class[] diagramChangeListenerClasses;
    private static GraphicalDataManager instance;
    private List commandListeners;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;
    static /* synthetic */ Class class$5;
    static /* synthetic */ Class class$6;
    static /* synthetic */ Class class$7;

    static {
        Class[] classArray = new Class[3];
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.epf.uma.Activity");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[0] = clazz;
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("org.eclipse.epf.uma.WorkProductDescriptor");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[1] = clazz2;
        Class<?> clazz3 = class$2;
        if (clazz3 == null) {
            try {
                clazz3 = class$2 = Class.forName("org.eclipse.epf.uma.Descriptor");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[2] = clazz3;
        childTypes = classArray;
        Class[] classArray2 = new Class[3];
        Class<?> clazz4 = class$3;
        if (clazz4 == null) {
            try {
                clazz4 = class$3 = Class.forName("org.eclipse.epf.diagram.model.util.IActivityDiagramChangeListener");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray2[0] = clazz4;
        Class<?> clazz5 = class$4;
        if (clazz5 == null) {
            try {
                clazz5 = class$4 = Class.forName("org.eclipse.epf.diagram.model.util.IWPDDiagramChangeListener");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray2[1] = clazz5;
        Class<?> clazz6 = class$5;
        if (clazz6 == null) {
            try {
                clazz6 = class$5 = Class.forName("org.eclipse.epf.diagram.model.util.IActivityDetailDiagramChangeListener");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray2[2] = clazz6;
        diagramChangeListenerClasses = classArray2;
        instance = null;
    }

    private GraphicalDataManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static GraphicalDataManager getInstance() {
        if (instance != null) return instance;
        Class<?> clazz = class$6;
        if (clazz == null) {
            try {
                clazz = class$6 = Class.forName("org.eclipse.epf.diagram.model.util.GraphicalDataManager");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Class<?> clazz2 = clazz;
        synchronized (clazz) {
            if (instance != null) return instance;
            instance = new GraphicalDataManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public GraphNode getGraphNode(org.eclipse.epf.uma.Diagram diagram, MethodElement methodElement) {
        if (diagram == null) {
            return this.createGraphNode(methodElement);
        }
        GraphNode node = GraphicalDataManager.findGraphNode(diagram, methodElement);
        if (node == null) {
            node = this.createGraphNode(methodElement);
            this.createGraphConnectors(node, diagram);
            diagram.getContained().add(node);
        }
        return node;
    }

    public static GraphNode findGraphNode(org.eclipse.epf.uma.Diagram diagram, Object methodElement) {
        Iterator iter = diagram.getContained().iterator();
        while (iter.hasNext()) {
            GraphNode element = (GraphNode)iter.next();
            if (!(element.getSemanticModel() instanceof UMASemanticModelBridge) || methodElement != ((UMASemanticModelBridge)element.getSemanticModel()).getElement()) continue;
            return element;
        }
        return null;
    }

    private org.eclipse.epf.uma.Diagram createDiagram(Activity act, int diagramType) {
        org.eclipse.epf.uma.Diagram baseDiagram;
        if (ProcessUtil.isExtendingOrLocallyContributing((BreakdownElement)act) && (baseDiagram = this.getUMADiagram((Activity)act.getVariabilityBasedOnElement(), diagramType, false)) != null) {
            org.eclipse.epf.uma.Diagram copy = GraphicalDataHelper.copyDiagram(baseDiagram);
            UMASemanticModelBridge modelBridge = (UMASemanticModelBridge)copy.getSemanticModel();
            modelBridge.setElement((MethodElement)act);
            return copy;
        }
        org.eclipse.epf.uma.Diagram diagram = UmaFactory.eINSTANCE.createDiagram();
        UMASemanticModelBridge modelBridge = UmaFactory.eINSTANCE.createUMASemanticModelBridge();
        modelBridge.setElement((MethodElement)act);
        modelBridge.setPresentation(diagramPresentations[diagramType]);
        diagram.setSemanticModel((SemanticModelBridge)modelBridge);
        this.populateDiagram(diagram, act, diagramType);
        return diagram;
    }

    private void populateDiagram(org.eclipse.epf.uma.Diagram diagram, Activity act, int diagramType) {
        ArrayList<GraphNode> nodes = new ArrayList<GraphNode>();
        Iterator iter = act.getBreakdownElements().iterator();
        while (iter.hasNext()) {
            Object element = iter.next();
            if (!childTypes[diagramType].isInstance(element)) continue;
            GraphNode node = this.createGraphNode((MethodElement)element);
            diagram.getContained().add(node);
            nodes.add(node);
        }
        iter = nodes.iterator();
        while (iter.hasNext()) {
            GraphNode node = (GraphNode)iter.next();
            this.createGraphConnectors(node, diagram, diagramType);
        }
    }

    public IDiagramChangeListener getDiagramChangeListener(Activity act, int diagramType) {
        Iterator iter = act.eAdapters().iterator();
        while (iter.hasNext()) {
            Object element = iter.next();
            if (!diagramChangeListenerClasses[diagramType].isInstance(element)) continue;
            return (IDiagramChangeListener)element;
        }
        return null;
    }

    private GraphNode createGraphNode(MethodElement element) {
        GraphNode graphNode = UmaFactory.eINSTANCE.createGraphNode();
        UMASemanticModelBridge modelBridge = UmaFactory.eINSTANCE.createUMASemanticModelBridge();
        modelBridge.setElement(element);
        graphNode.setSemanticModel((SemanticModelBridge)modelBridge);
        Point point = UmaFactory.eINSTANCE.createPoint();
        point.setX(new Double(-1.0));
        point.setY(new Double(-1.0));
        graphNode.setPosition(point);
        Dimension dim = UmaFactory.eINSTANCE.createDimension();
        dim.setWidth(new Double(-1.0));
        dim.setHeight(new Double(-1.0));
        graphNode.setSize(dim);
        return graphNode;
    }

    public GraphEdge addGraphConnectorPair(org.eclipse.epf.uma.Diagram diagram, GraphNode graphNode, WorkOrder element) {
        GraphConnector srcConnector = UmaFactory.eINSTANCE.createGraphConnector();
        graphNode.getAnchorage().add(srcConnector);
        GraphEdge edge = UmaFactory.eINSTANCE.createGraphEdge();
        UMASemanticModelBridge bridge = UmaFactory.eINSTANCE.createUMASemanticModelBridge();
        bridge.setElement((MethodElement)element);
        edge.setSemanticModel((SemanticModelBridge)bridge);
        graphNode.getContained().add(edge);
        edge.getAnchor().add(srcConnector);
        GraphNode succNode = this.getGraphNode(diagram, (MethodElement)UmaUtil.getOwningActivity((WorkOrder)element));
        GraphConnector targetConnector = UmaFactory.eINSTANCE.createGraphConnector();
        succNode.getAnchorage().add(targetConnector);
        edge.getAnchor().add(targetConnector);
        return edge;
    }

    public GraphEdge addGraphConnectorPair(GraphNode srcNode, GraphNode targetNode) {
        GraphConnector srcConnector = UmaFactory.eINSTANCE.createGraphConnector();
        srcNode.getAnchorage().add(srcConnector);
        GraphEdge edge = UmaFactory.eINSTANCE.createGraphEdge();
        srcNode.getContained().add(edge);
        edge.getAnchor().add(srcConnector);
        GraphConnector targetConnector = UmaFactory.eINSTANCE.createGraphConnector();
        targetNode.getAnchorage().add(targetConnector);
        edge.getAnchor().add(targetConnector);
        return edge;
    }

    public void removeGraphEdge(GraphEdge edge) {
        EcoreUtil.remove((EObject)edge);
        Iterator iter = edge.getAnchor().iterator();
        while (iter.hasNext()) {
            GraphConnector conn = (GraphConnector)iter.next();
            EcoreUtil.remove((EObject)conn);
        }
    }

    public void removeGraphConnectionPair(GraphNode graphNode, WorkOrder workOrder) {
        Iterator iter = graphNode.getAnchorage().iterator();
        while (iter.hasNext()) {
            GraphConnector conn2;
            SemanticModelBridge bridge;
            GraphConnector conn = (GraphConnector)iter.next();
            GraphEdge edge = (GraphEdge)conn.getGraphEdge().get(0);
            if (edge.eContainer() != graphNode || !((bridge = (conn2 = (GraphConnector)edge.getAnchor().get(1)).getGraphElement().getSemanticModel()) instanceof UMASemanticModelBridge) || ((UMASemanticModelBridge)bridge).getElement() != UmaUtil.getOwningActivity((WorkOrder)workOrder)) continue;
            conn2.getGraphElement().getAnchorage().remove(conn2);
            iter.remove();
            graphNode.getContained().remove(edge);
            return;
        }
    }

    private void createGraphConnectors(GraphNode graphNode, org.eclipse.epf.uma.Diagram diagram) {
        this.createGraphConnectors(graphNode, diagram, this.getDiagramType(diagram));
    }

    int getDiagramType(org.eclipse.epf.uma.Diagram diagram) {
        String typeStr = diagram.getSemanticModel().getPresentation();
        int i = 0;
        while (i < diagramPresentations.length) {
            if (diagramPresentations[i].equals(typeStr)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private void createGraphConnectors(GraphNode graphNode, org.eclipse.epf.uma.Diagram diagram, int diagramType) {
        MethodElement e = ((UMASemanticModelBridge)graphNode.getSemanticModel()).getElement();
        switch (diagramType) {
            case 0: {
                if (!(e instanceof Activity)) break;
                Activity act = (Activity)e;
                Iterator iter = act.getLinkToPredecessor().iterator();
                while (iter.hasNext()) {
                    WorkOrder workOrder = (WorkOrder)iter.next();
                    GraphNode srcNode = GraphicalDataManager.findGraphNode(diagram, workOrder.getPred());
                    if (srcNode == null) continue;
                    this.addGraphConnectorPair(srcNode, graphNode);
                }
                break;
            }
            case 1: {
                if (!(e instanceof WorkProductDescriptor)) break;
                WorkProductDescriptor descriptor = (WorkProductDescriptor)e;
                Iterator iter = descriptor.getImpacts().iterator();
                while (iter.hasNext()) {
                    WorkProductDescriptor impactedDescriptor = (WorkProductDescriptor)iter.next();
                    GraphNode targetNode = GraphicalDataManager.findGraphNode(diagram, impactedDescriptor);
                    if (targetNode == null) continue;
                    this.addGraphConnectorPair(graphNode, targetNode);
                }
                break;
            }
        }
    }

    public org.eclipse.epf.uma.Diagram getUMADiagram(Activity e, int diagramType, boolean create) {
        org.eclipse.epf.uma.Diagram diagram = null;
        EObject container = e.eContainer();
        if (container != null) {
            ProcessPackage pkg = (ProcessPackage)container;
            Iterator iter = pkg.getDiagrams().iterator();
            while (iter.hasNext()) {
                diagram = (org.eclipse.epf.uma.Diagram)iter.next();
                SemanticModelBridge modelBridge = diagram.getSemanticModel();
                if (modelBridge == null || !(modelBridge instanceof UMASemanticModelBridge) || e != ((UMASemanticModelBridge)modelBridge).getElement() || !diagramPresentations[diagramType].equals(((UMASemanticModelBridge)modelBridge).getPresentation())) continue;
                return diagram;
            }
        }
        if (create) {
            diagram = this.createDiagram(e, diagramType);
            if (container != null) {
                ((ProcessPackage)container).getDiagrams().add(diagram);
            }
            return diagram;
        }
        return null;
    }

    public Diagram getDiagram(Activity act, int diagramType) {
        IDiagramChangeListener listener = this.getDiagramChangeListener(act, diagramType);
        return listener == null ? null : listener.getDiagram();
    }

    public List getCommandListeners() {
        if (this.commandListeners == null) {
            this.commandListeners = new ArrayList();
        }
        this.commandListeners.add(new ICommandListener(){

            public void notifyExecuted(Command command) {
                Activity act = (Activity)command.getResult().iterator().next();
                Activity base = (Activity)act.getVariabilityBasedOnElement();
                if (base != null) {
                    UMASemanticModelBridge bridge;
                    GraphNode graphNode;
                    Activity parentAct = act.getSuperActivities();
                    org.eclipse.epf.uma.Diagram diagram = GraphicalDataManager.this.getUMADiagram(parentAct, 0, false);
                    if (diagram != null && (graphNode = GraphicalDataManager.findGraphNode(diagram, base)) != null && (bridge = (UMASemanticModelBridge)graphNode.getSemanticModel()).getElement() != act) {
                        bridge.setElement((MethodElement)act);
                    }
                    if (act.getVariabilityType() == VariabilityType.LOCAL_CONTRIBUTION_LITERAL) {
                        int i = 0;
                        while (i < GraphicalDataHelper.DIAGRAM_TYPES.length) {
                            int diagramType = GraphicalDataHelper.DIAGRAM_TYPES[i];
                            diagram = GraphicalDataManager.this.getUMADiagram(base, diagramType, false);
                            if (diagram != null) {
                                org.eclipse.epf.uma.Diagram copy = GraphicalDataManager.this.getUMADiagram(act, diagramType, true);
                                copy.setSuppressed(diagram.getSuppressed());
                            }
                            ++i;
                        }
                    }
                }
            }

            public Class getCommandType() {
                Class<?> clazz = class$7;
                if (clazz == null) {
                    try {
                        clazz = class$7 = Class.forName("org.eclipse.epf.library.edit.process.command.VaryActivityCommand");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                return clazz;
            }

            public void preUndo(Command command) {
                UMASemanticModelBridge bridge;
                GraphNode graphNode;
                Activity parentAct;
                org.eclipse.epf.uma.Diagram diagram;
                Activity act = (Activity)command.getResult().iterator().next();
                VariabilityElement baseAct = act.getVariabilityBasedOnElement();
                if (baseAct != null && (diagram = GraphicalDataManager.this.getUMADiagram(parentAct = act.getSuperActivities(), 0, false)) != null && (graphNode = GraphicalDataManager.findGraphNode(diagram, act)) != null && (bridge = (UMASemanticModelBridge)graphNode.getSemanticModel()).getElement() != baseAct) {
                    bridge.setElement((MethodElement)baseAct);
                }
            }

            public void preExecute(Command command) {
            }
        });
        return this.commandListeners;
    }
}

