/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.xmi.internal.migration;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.util.EContentsEList;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.epf.common.serviceability.MsgBox;
import org.eclipse.epf.library.edit.TngAdapterFactory;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.library.xmi.XMILibraryPlugin;
import org.eclipse.epf.library.xmi.XMILibraryResources;
import org.eclipse.epf.library.xmi.internal.migration.SelectionDialog;
import org.eclipse.epf.persistence.migration.IMigrator;
import org.eclipse.epf.persistence.migration.MigrationUtil;
import org.eclipse.epf.persistence.util.PersistenceUtil;
import org.eclipse.epf.uma.Activity;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.MethodLibrary;
import org.eclipse.epf.uma.MethodPlugin;
import org.eclipse.epf.uma.UmaPackage;
import org.eclipse.epf.uma.VariabilityType;
import org.eclipse.epf.uma.ecore.impl.MultiResourceEObject;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.widgets.Composite;

public class Migrator102
implements IMigrator {
    private Collection proxiesToRemove = new ArrayList();
    private Map proxyToFileMap = new HashMap();
    private HashMap proxyToFileWithLoadErrorMap = new HashMap();
    private ArrayList notFoundProxies = new ArrayList();
    private ArrayList proxiesWithUnnormalizedURI = new ArrayList();
    private MethodLibrary lib;
    private static final String FILE_PATH = XMILibraryResources.filePath;

    private static void updateStatus(IProgressMonitor monitor, String msg) {
        if (monitor != null) {
            monitor.subTask(msg);
            monitor.worked(1);
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException interruptedException) {}
        } else {
            System.out.println(msg);
        }
    }

    /*
     * Exception decompiling
     */
    public void migrate(String libPath, IProgressMonitor monitor) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 2[TRYBLOCK] [2 : 248->252)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void checkModifiedResources() {
        block2: {
            MultiStatus status;
            String msg;
            String title;
            ErrorDialog errDlg;
            do {
                ResourceSet resourceSet = this.lib.eResource().getResourceSet();
                ArrayList<Resource> readOnlyResources = new ArrayList<Resource>();
                String pluginId = XMILibraryPlugin.getDefault().getId();
                status = new MultiStatus(pluginId, 0, XMILibraryResources.cannotWriteToFiles, null);
                Iterator iter = resourceSet.getResources().iterator();
                while (iter.hasNext()) {
                    Resource resource = (Resource)iter.next();
                    File file = new File(resource.getURI().toFileString());
                    if (!file.exists() || file.canWrite()) continue;
                    readOnlyResources.add(resource);
                    status.add((IStatus)new Status(4, pluginId, 0, file.toString(), null));
                }
                if (status.isOK()) break block2;
                title = XMILibraryResources.readOnlyFiles_title;
                msg = XMILibraryResources.readOnlyFiles_msg;
            } while ((errDlg = new ErrorDialog(MsgBox.getDefaultShell(), title, msg, (IStatus)status, 7){

                protected void createButtonsForButtonBar(Composite parent) {
                    this.createButton(parent, 0, IDialogConstants.RETRY_LABEL, true);
                    this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
                    this.createDetailsButton(parent);
                }

                public int open() {
                    this.showDetailsArea();
                    return super.open();
                }
            }).open() != 1);
            throw new OperationCanceledException();
        }
    }

    private void removeUnresolvedReferences(IProgressMonitor monitor) {
        if (this.proxiesToRemove.isEmpty()) {
            return;
        }
        HashSet<String> GUIDs = new HashSet<String>();
        TreeIterator iter = this.proxiesToRemove.iterator();
        while (iter.hasNext()) {
            InternalEObject proxy = (InternalEObject)iter.next();
            GUIDs.add(proxy.eProxyURI().fragment());
            EcoreUtil.remove((EObject)proxy);
        }
        iter = this.lib.eAllContents();
        while (iter.hasNext()) {
            EObject element = (EObject)iter.next();
            EContentsEList.FeatureIterator iterator = (EContentsEList.FeatureIterator)element.eCrossReferences().iterator();
            while (iterator.hasNext()) {
                EStructuralFeature feature;
                InternalEObject obj = (InternalEObject)iterator.next();
                if (!obj.eIsProxy() || !GUIDs.contains(obj.eProxyURI().fragment()) || !(feature = iterator.feature()).isChangeable() || feature.isDerived()) continue;
                if (feature.isMany()) {
                    ((List)element.eGet(feature)).remove(obj);
                    continue;
                }
                element.eSet(feature, null);
            }
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void verify() {
        Object var9_9;
        Iterator iter;
        Object[] objs;
        SelectionDialog dlg;
        String msg;
        AdapterFactoryLabelProvider labelProvider;
        ArrayList list;
        this.notFoundProxies.clear();
        this.proxiesToRemove.clear();
        this.proxyToFileMap.clear();
        this.proxyToFileWithLoadErrorMap.clear();
        this.proxiesWithUnnormalizedURI.clear();
        Collection proxies = PersistenceUtil.getProxies((EObject)this.lib);
        if (!proxies.isEmpty()) {
            ResourceSet resourceSet = this.lib.eResource().getResourceSet();
            URIConverter uriConverter = resourceSet.getURIConverter();
            Iterator iter2 = proxies.iterator();
            while (iter2.hasNext()) {
                InternalEObject proxy = (InternalEObject)iter2.next();
                URI uri = proxy.eProxyURI();
                URI normalizedURI = uriConverter.normalize(uri);
                if (normalizedURI == null) {
                    this.proxiesWithUnnormalizedURI.add(proxy);
                    continue;
                }
                File file = new File(normalizedURI.toFileString());
                if (!file.exists()) {
                    this.proxyToFileMap.put(proxy, file);
                    continue;
                }
                try {
                    Resource resource = resourceSet.getResource(normalizedURI.trimFragment(), true);
                    if (resource.getEObject(normalizedURI.fragment()) != null) continue;
                    this.notFoundProxies.add(proxy);
                }
                catch (Exception e) {
                    String errMsg = e.getMessage() != null ? e.getMessage() : e.toString();
                    this.proxyToFileWithLoadErrorMap.put(proxy, new Object[]{file, errMsg});
                }
            }
        }
        if (!this.proxyToFileMap.isEmpty()) {
            list = new ArrayList(this.proxyToFileMap.keySet());
            String ELEMENT_PATH = XMILibraryResources.elementPath;
            labelProvider = new AdapterFactoryLabelProvider((AdapterFactory)TngAdapterFactory.INSTANCE.getNavigatorView_ComposedAdapterFactory()){

                public String getText(Object object) {
                    File file = (File)Migrator102.this.proxyToFileMap.get(object);
                    return String.valueOf(file.getAbsolutePath()) + " (" + TngUtil.getLabelWithPath((Object)object) + ')';
                }

                public String getColumnText(Object object, int columnIndex) {
                    switch (columnIndex) {
                        case 0: {
                            return Migrator102.this.proxyToFileMap.get(object).toString();
                        }
                        case 1: {
                            return TngUtil.getLabelWithPath((Object)object);
                        }
                    }
                    return null;
                }
            };
            try {
                msg = XMILibraryResources.promptRemoveReferencesToMissingFiles_msg;
                dlg = new SelectionDialog(MsgBox.getDefaultShell(), list, (ILabelProvider)labelProvider, msg);
                dlg.setTitle(XMILibraryResources.missingFiles_title);
                dlg.setBlockOnOpen(true);
                dlg.setInitialElementSelections(list);
                dlg.setColumnProperties(new String[]{FILE_PATH, ELEMENT_PATH});
                if (dlg.open() == 1) {
                    throw new OperationCanceledException();
                }
                objs = dlg.getResult();
                if (objs == null) {
                    throw new OperationCanceledException();
                }
                iter = list.iterator();
                while (iter.hasNext()) {
                    this.proxiesToRemove.add(iter.next());
                }
            }
            catch (Throwable throwable) {
                var9_9 = null;
                labelProvider.dispose();
                throw throwable;
            }
            {
                var9_9 = null;
            }
            labelProvider.dispose();
        }
        if (!this.proxyToFileWithLoadErrorMap.isEmpty()) {
            list = new ArrayList(this.proxyToFileWithLoadErrorMap.keySet());
            String LOAD_ERROR = XMILibraryResources.loadError;
            labelProvider = new AdapterFactoryLabelProvider((AdapterFactory)TngAdapterFactory.INSTANCE.getNavigatorView_ComposedAdapterFactory()){

                public String getColumnText(Object object, int columnIndex) {
                    Object[] arr = (Object[])Migrator102.this.proxyToFileMap.get(object);
                    if (columnIndex < 2) {
                        return arr[columnIndex].toString();
                    }
                    return null;
                }
            };
            try {
                msg = XMILibraryResources.promptRemoveReferencesToFilesWithLoadErrors_msg;
                dlg = new SelectionDialog(MsgBox.getDefaultShell(), list, (ILabelProvider)labelProvider, msg);
                dlg.setTitle(XMILibraryResources.filesWithLoadErrors_title);
                dlg.setBlockOnOpen(true);
                dlg.setInitialElementSelections(list);
                dlg.setColumnProperties(new String[]{FILE_PATH, LOAD_ERROR});
                if (dlg.open() == 1) {
                    throw new OperationCanceledException();
                }
                objs = dlg.getResult();
                if (objs == null) {
                    throw new OperationCanceledException();
                }
                iter = list.iterator();
                while (iter.hasNext()) {
                    this.proxiesToRemove.add(iter.next());
                }
            }
            catch (Throwable throwable) {
                var9_9 = null;
                labelProvider.dispose();
                throw throwable;
            }
            {
                var9_9 = null;
            }
            labelProvider.dispose();
        }
        ArrayList proxiesToRetain = new ArrayList();
        proxies.addAll(this.proxyToFileMap.keySet());
        proxies.addAll(this.proxyToFileWithLoadErrorMap.keySet());
        proxies.removeAll(this.proxiesToRemove);
        if (proxiesToRetain.isEmpty()) {
            this.proxiesToRemove.addAll(this.notFoundProxies);
            this.proxiesToRemove.addAll(this.proxiesWithUnnormalizedURI);
        }
        String msg2 = "Summary of unresolved proxies:";
        msg2 = String.valueOf(msg2) + "\n  Not found proxies: " + this.notFoundProxies;
        msg2 = String.valueOf(msg2) + "\n  Proxies with unnormalized URI: " + this.proxiesWithUnnormalizedURI;
        XMILibraryPlugin.getDefault().getLogger().logInfo(msg2);
    }

    private void removeOldDefaultValues() {
        MultiResourceEObject.removeDefaultValue((EStructuralFeature)UmaPackage.eINSTANCE.getMethodPlugin_UserChangeable());
    }

    private void adjustToNewDefaultValues(MethodElement e) {
        if (e instanceof MethodPlugin) {
            ((MultiResourceEObject)e).removeFeatureWithOverridenDefaultValue((EStructuralFeature)UmaPackage.eINSTANCE.getMethodPlugin_UserChangeable());
        }
    }

    private void setOldDefaultValues() {
        MultiResourceEObject.setDefaultValue((EStructuralFeature)UmaPackage.eINSTANCE.getMethodPlugin_UserChangeable(), (Object)Boolean.FALSE);
    }

    private void update(MethodElement e, IProgressMonitor monitor) throws Exception {
        this.adjustToNewDefaultValues(e);
        if (e instanceof Activity) {
            Activity act = (Activity)e;
            VariabilityType type = act.getVariabilityType();
            if (type == VariabilityType.CONTRIBUTES_LITERAL) {
                act.setVariabilityType(VariabilityType.LOCAL_CONTRIBUTION_LITERAL);
            } else if (type == VariabilityType.REPLACES_LITERAL) {
                act.setVariabilityType(VariabilityType.LOCAL_REPLACEMENT_LITERAL);
            }
        }
        MigrationUtil.formatValue((MethodElement)e);
    }
}

