/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.project;

import java.io.File;
import java.util.Arrays;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.epf.library.LibraryPlugin;
import org.eclipse.epf.library.project.MethodLibraryProjectNature;
import org.eclipse.epf.uma.MethodLibrary;

public class MethodLibraryProject {
    public static IProject createProject(String path, String projectName, IProgressMonitor monitor) throws CoreException {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IProject project = workspace.getRoot().getProject(projectName);
        if (project.exists()) {
            project.delete(9, monitor);
        }
        IProjectDescription description = workspace.newProjectDescription(project.getName());
        description.setNatureIds(MethodLibraryProjectNature.NATURE_IDS);
        Path projectPath = new Path(path);
        if (!Platform.getLocation().isPrefixOf((IPath)projectPath)) {
            description.setLocation((IPath)projectPath);
        }
        project.create(description, monitor);
        return project;
    }

    public static IProject createProject(String path, IProgressMonitor monitor) throws CoreException {
        IProject project = MethodLibraryProject.findProject(path);
        if (project != null) {
            project.delete(9, monitor);
        }
        File libraryPath = new File(path);
        String projectPath = libraryPath.getAbsolutePath();
        String projectName = libraryPath.getName();
        return MethodLibraryProject.createProject(projectPath, projectName, monitor);
    }

    /*
     * Exception decompiling
     */
    public static boolean isMethodLibraryProject(IProject project) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 4[TRYBLOCK] [4 : 111->114)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static IProject findProject(String path) {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IProject[] projects = workspace.getRoot().getProjects();
        try {
            int i = 0;
            while (i < projects.length) {
                IProject project = projects[i];
                if (new File(path).compareTo(project.getLocation().toFile()) == 0 && MethodLibraryProject.isMethodLibraryProject(project)) {
                    return project;
                }
                if (new File(path).compareTo(project.getLocation().toFile()) == 0) {
                    return project;
                }
                ++i;
            }
        }
        catch (Exception e) {
            LibraryPlugin.getDefault().getLogger().logError((Throwable)e);
        }
        return null;
    }

    public static IProject findProject(MethodLibrary library) {
        return MethodLibraryProject.findProject(MethodLibraryProject.getLibraryPath(library));
    }

    public static IProject openProject(String path, IProgressMonitor monitor) throws CoreException {
        String[] natureIds;
        IProjectDescription description;
        Path projectPath = new Path(String.valueOf(path) + File.separator + ".project");
        try {
            description = ResourcesPlugin.getWorkspace().loadProjectDescription((IPath)projectPath);
        }
        catch (CoreException coreException) {
            description = null;
        }
        IProject project = null;
        if (description == null) {
            project = MethodLibraryProject.createProject(path, monitor);
        } else {
            project = ResourcesPlugin.getWorkspace().getRoot().getProject(description.getName());
            if (!project.exists()) {
                project = MethodLibraryProject.createProject(path, project.getName(), monitor);
            } else if (new File(path).compareTo(project.getLocation().toFile()) != 0) {
                project = MethodLibraryProject.createProject(path, monitor);
            }
        }
        if (!project.isOpen()) {
            project.open(128, monitor);
        }
        if (description == null) {
            description = project.getDescription();
        }
        if (!Arrays.asList(natureIds = description.getNatureIds()).contains(MethodLibraryProjectNature.NATURE_ID)) {
            description.setNatureIds(MethodLibraryProjectNature.NATURE_IDS);
            project.setDescription(description, 3, monitor);
        }
        return project;
    }

    public static void closeProject(String path, IProgressMonitor monitor) throws CoreException {
        IProject project = MethodLibraryProject.findProject(path);
        if (project != null && project.isOpen()) {
            project.close(monitor);
        }
    }

    public static void closeProject(MethodLibrary library, IProgressMonitor monitor) throws CoreException {
        MethodLibraryProject.closeProject(MethodLibraryProject.getLibraryPath(library), monitor);
    }

    public static boolean deleteProject(String path, IProgressMonitor monitor) {
        IProject project = MethodLibraryProject.findProject(path);
        if (project != null) {
            try {
                if (monitor == null) {
                    monitor = new NullProgressMonitor();
                }
                project.delete(9, monitor);
            }
            catch (CoreException e) {
                LibraryPlugin.getDefault().getLogger().logError((Throwable)e);
                return false;
            }
        }
        return true;
    }

    public static boolean deleteProject(MethodLibrary library, IProgressMonitor monitor) {
        return MethodLibraryProject.deleteProject(MethodLibraryProject.getLibraryPath(library), monitor);
    }

    private static String getLibraryPath(MethodLibrary library) {
        return new File(library.eResource().getURI().toFileString()).getParent();
    }
}

