/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.util;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.epf.common.serviceability.MsgBox;
import org.eclipse.epf.common.utils.StrUtil;
import org.eclipse.epf.library.LibraryPlugin;
import org.eclipse.epf.library.LibraryResources;
import org.eclipse.epf.library.LibraryService;
import org.eclipse.epf.library.edit.IFilter;
import org.eclipse.epf.library.edit.LibraryEditPlugin;
import org.eclipse.epf.library.edit.LibraryEditResources;
import org.eclipse.epf.library.edit.command.DeleteMethodElementCommand;
import org.eclipse.epf.library.edit.ui.UserInteractionHelper;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.library.edit.validation.IValidator;
import org.eclipse.epf.library.edit.validation.internal.ContentElementNameValidator;
import org.eclipse.epf.library.edit.validation.internal.ValidatorFactory;
import org.eclipse.epf.library.util.ContentResourceScanner;
import org.eclipse.epf.library.util.TypeConverter;
import org.eclipse.epf.persistence.MethodLibraryPersister;
import org.eclipse.epf.uma.ContentDescription;
import org.eclipse.epf.uma.ContentElement;
import org.eclipse.epf.uma.ContentPackage;
import org.eclipse.epf.uma.DescribableElement;
import org.eclipse.epf.uma.Guidance;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.UmaFactory;
import org.eclipse.epf.uma.UmaPackage;
import org.eclipse.epf.uma.util.ContentDescriptionFactory;
import org.eclipse.epf.uma.util.IMethodLibraryPersister;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.ListDialog;

public class ConvertGuidanceType {
    static IValidator validator;
    private static int[] compatibleGuidances;
    private static List compatibleGuidancesList;

    static {
        compatibleGuidances = new int[]{72, 75, 78};
        compatibleGuidancesList = new ArrayList();
        int i = 0;
        while (i < compatibleGuidances.length) {
            compatibleGuidancesList.add(new Integer(compatibleGuidances[i]));
            ++i;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Guidance convertGuidance(Guidance oldGuidance, Shell shell, DeleteMethodElementCommand command) {
        Guidance guidance;
        if (shell == null) {
            shell = Display.getCurrent().getActiveShell();
        }
        ListDialog dlg = new ListDialog(shell);
        dlg.setHeightInChars(5);
        dlg.setContentProvider((IStructuredContentProvider)new ArrayContentProvider());
        dlg.setLabelProvider((ILabelProvider)new LabelProvider(){

            public String getText(Object element) {
                switch ((Integer)element) {
                    case 72: {
                        return LibraryResources.concept_text;
                    }
                    case 73: {
                        return LibraryResources.checklist_text;
                    }
                    case 74: {
                        return LibraryResources.example_text;
                    }
                    case 75: {
                        return LibraryResources.guideline_text;
                    }
                    case 83: {
                        return LibraryResources.estimationConsiderations_text;
                    }
                    case 76: {
                        return LibraryResources.report_text;
                    }
                    case 77: {
                        return LibraryResources.template_text;
                    }
                    case 78: {
                        return LibraryResources.supportingMaterial_text;
                    }
                    case 79: {
                        return LibraryResources.toolMentor_text;
                    }
                    case 80: {
                        return LibraryResources.whitepaper_text;
                    }
                    case 81: {
                        return LibraryResources.termDefinition_text;
                    }
                    case 82: {
                        return LibraryResources.practice_text;
                    }
                    case 84: {
                        return LibraryResources.reusableAsset_text;
                    }
                }
                return LibraryResources.unknownGuidance_text;
            }
        });
        List newGuidanceTypeList = ConvertGuidanceType.getValidNewGuidanceTypes(oldGuidance);
        if (newGuidanceTypeList == null) {
            LibraryPlugin.getDefault().getMsgDialog().displayError(LibraryResources.convertGuidanceError_title, LibraryResources.unsupportedGuidanceTypeError_msg, NLS.bind((String)LibraryResources.unsupportedGuidanceTypeError_reason, (Object)StrUtil.toLower((String)TngUtil.getTypeText((EObject)oldGuidance))));
            return null;
        }
        dlg.setInput((Object)newGuidanceTypeList);
        dlg.setTitle(LibraryResources.convertGuidanceDialog_title);
        dlg.setMessage(LibraryResources.convertGuidanceDialog_text);
        if (dlg.open() == 1) {
            return null;
        }
        Object[] selectionResult = dlg.getResult();
        if (selectionResult == null) {
            return null;
        }
        int chosenGuidance = (Integer)selectionResult[0];
        EClass newType = ConvertGuidanceType.getGuidanceType(chosenGuidance);
        if (newType == null) {
            return null;
        }
        TypeConverter.TypeConversionCommand cmd = TypeConverter.createTypeConversionCommand((EObject)oldGuidance, newType, null, null);
        try {
            block25: {
                block23: {
                    IStatus status;
                    if (!cmd.getIllegalReferencers().isEmpty()) {
                        MultiStatus multiStatus = new MultiStatus(LibraryEditPlugin.INSTANCE.getSymbolicName(), 0, "", null);
                        Iterator iter = cmd.getIllegalReferencers().iterator();
                        while (true) {
                            if (!iter.hasNext()) {
                                if (multiStatus.getChildren().length <= 0 || LibraryPlugin.getDefault().getMsgDialog().displayConfirmation(LibraryResources.convertGuidanceDialog_title, LibraryEditResources.confirm_remove_references_text, (IStatus)multiStatus) != 1) break;
                                break block23;
                            }
                            MethodElement e = (MethodElement)iter.next();
                            if (TngUtil.isPredefined((MethodElement)e)) continue;
                            String msg = NLS.bind((String)LibraryEditResources.elementType_text, (Object)e.eClass().getName(), (Object)TngUtil.getLabelWithPath((Object)e));
                            Status status2 = new Status(1, LibraryEditPlugin.INSTANCE.getSymbolicName(), 0, msg, null);
                            multiStatus.add((IStatus)status2);
                        }
                    }
                    if ((status = UserInteractionHelper.checkModify((Collection)cmd.getModifiedResources(), (Shell)shell)).isOK()) break block25;
                    LibraryPlugin.getDefault().getMsgDialog().display(LibraryResources.convertGuidanceDialog_title, status);
                }
                Object var14_15 = null;
                if (cmd == null) return null;
                try {
                    cmd.dispose();
                    return null;
                }
                catch (Exception exception) {}
                return null;
            }
            cmd.execute();
            Guidance newGuidance = (Guidance)cmd.getResult().iterator().next();
            IMethodLibraryPersister.FailSafeMethodLibraryPersister persister = ContentDescriptionFactory.getMethodLibraryPersister().getFailSafePersister();
            try {
                Iterator iter = cmd.getModifiedResources().iterator();
                while (true) {
                    if (!iter.hasNext()) {
                        persister.commit();
                        if (ContentDescriptionFactory.hasPresentation((MethodElement)newGuidance)) {
                            persister.adjustLocation(newGuidance.getPresentation().eResource());
                        }
                        cmd.copyResources();
                        break;
                    }
                    Resource resource = (Resource)iter.next();
                    persister.save(resource);
                }
            }
            catch (Exception e) {
                persister.rollback();
                LibraryPlugin.getDefault().getMsgDialog().displayError(LibraryResources.convertGuidanceError_title, NLS.bind((String)LibraryResources.saveConvertedGuidanceError_msg, (Object)newGuidance.getName()), LibraryResources.error_reason, (Throwable)e);
            }
            guidance = newGuidance;
            Object var14_16 = null;
            if (cmd == null) return guidance;
        }
        catch (Throwable throwable) {
            Object var14_17 = null;
            if (cmd == null) throw throwable;
            try {}
            catch (Exception exception) {
                throw throwable;
            }
            cmd.dispose();
            throw throwable;
        }
        try {}
        catch (Exception exception) {}
        cmd.dispose();
        return guidance;
    }

    private static Guidance doConvert(Guidance oldGuidance, int newGuidanceType, DeleteMethodElementCommand command) {
        ContentPackage oldGuidanceContainer;
        String oldGuidanceGuid;
        Guidance newGuidance;
        block15: {
            newGuidance = null;
            File oldGuidancePathFile = new File(LibraryService.getInstance().getCurrentMethodLibraryPath(), MethodLibraryPersister.getElementPath((MethodElement)oldGuidance));
            newGuidance = ConvertGuidanceType.createNewGuidance(newGuidanceType);
            Iterator iter = oldGuidance.eClass().getEAllStructuralFeatures().iterator();
            while (iter.hasNext()) {
                EStructuralFeature feature = (EStructuralFeature)iter.next();
                Object o = oldGuidance.eGet(feature);
                if (feature.getFeatureID() == 7 || feature.getFeatureID() == 1) continue;
                newGuidance.eSet(feature, o);
            }
            oldGuidanceGuid = oldGuidance.getGuid();
            oldGuidanceContainer = (ContentPackage)oldGuidance.eContainer();
            try {
                String name = ConvertGuidanceType.checkName(oldGuidance, newGuidance);
                if (name != null) {
                    newGuidance.setName(name);
                }
            }
            catch (Exception exception) {
                return null;
            }
            oldGuidanceContainer.getContentElements().add(newGuidance);
            ContentDescription newContentDesc = ContentDescriptionFactory.createContentDescription((DescribableElement)newGuidance);
            newGuidance.setPresentation(newContentDesc);
            File newGuidancePathFile = new File(LibraryService.getInstance().getCurrentMethodLibraryPath(), MethodLibraryPersister.getElementPath((MethodElement)newGuidance));
            ContentResourceScanner scanner = new ContentResourceScanner(oldGuidancePathFile);
            scanner.setTargetRootPath(newGuidancePathFile);
            ContentDescription oldContentDesc = oldGuidance.getPresentation();
            iter = oldContentDesc.eClass().getEAllAttributes().iterator();
            while (iter.hasNext()) {
                EAttribute attrib = (EAttribute)iter.next();
                Object o = oldContentDesc.eGet((EStructuralFeature)attrib);
                if (o instanceof String && ((String)o).trim().length() > 0) {
                    scanner.resolveResources((MethodElement)newGuidance, (String)o, "");
                }
                newContentDesc.eSet((EStructuralFeature)attrib, o);
            }
            command.execute();
            if (command.executed && !command.failed) break block15;
            oldGuidanceContainer.getContentElements().remove(newGuidance);
            newGuidance = null;
            newContentDesc = null;
            return null;
        }
        try {
            newGuidance.setGuid(oldGuidanceGuid);
            IMethodLibraryPersister.FailSafeMethodLibraryPersister persister = ContentDescriptionFactory.getMethodLibraryPersister().getFailSafePersister();
            try {
                if (newGuidance.eResource() != null) {
                    persister.save(newGuidance.eResource());
                }
                if (newGuidance.getPresentation().eResource() != null) {
                    persister.save(newGuidance.getPresentation().eResource());
                }
                if (oldGuidanceContainer.eResource() != null) {
                    persister.save(oldGuidanceContainer.eResource());
                }
                persister.commit();
            }
            catch (Exception e) {
                persister.rollback();
                command.undo();
                LibraryPlugin.getDefault().getMsgDialog().displayError(LibraryResources.convertGuidanceError_title, NLS.bind((String)LibraryResources.saveConvertedGuidanceError_msg, (Object)newGuidance.getName()), LibraryResources.error_reason, (Throwable)e);
                newGuidance = null;
            }
        }
        catch (Exception ex) {
            command.undo();
            LibraryPlugin.getDefault().getMsgDialog().displayError(LibraryResources.convertGuidanceError_title, NLS.bind((String)LibraryResources.convertGuidanceError_msg, (Object)newGuidance.getName()), LibraryResources.error_reason, (Throwable)ex);
            newGuidance = null;
        }
        return newGuidance;
    }

    private static String checkName(Guidance oldGuidance, Guidance newGuidance) {
        validator = new ContentElementNameValidator(oldGuidance.eContainer(), (EStructuralFeature)UmaPackage.eINSTANCE.getContentPackage_ContentElements(), (ContentElement)newGuidance, (IFilter)new ValidatorFactory.TypeFilter((EObject)newGuidance));
        String msg = validator.isValid(newGuidance.getName());
        if (msg != null) {
            String featureTxt = TngUtil.getFeatureText((EStructuralFeature)UmaPackage.eINSTANCE.getNamedElement_Name());
            String title = LibraryEditResources.resolveNameConflictDialog_title;
            String dlgMsg = NLS.bind((String)LibraryEditResources.resolveNameConflictDialog_text, (Object)StrUtil.toLower((String)featureTxt), (Object)newGuidance.getName());
            String currentValue = (String)newGuidance.eGet((EStructuralFeature)UmaPackage.eINSTANCE.getNamedElement_Name());
            IInputValidator inputValidator = new IInputValidator(){

                public String isValid(String newText) {
                    return validator.isValid(newText);
                }
            };
            InputDialog inputDlg = new InputDialog(MsgBox.getDefaultShell(), title, dlgMsg, currentValue, inputValidator);
            if (inputDlg.open() == 1) {
                throw new OperationCanceledException();
            }
            return inputDlg.getValue();
        }
        return null;
    }

    private static EClass getGuidanceType(int newGuidanceType) {
        switch (newGuidanceType) {
            case 72: {
                return UmaPackage.Literals.CONCEPT;
            }
            case 73: {
                return UmaPackage.Literals.CHECKLIST;
            }
            case 74: {
                return UmaPackage.Literals.EXAMPLE;
            }
            case 75: {
                return UmaPackage.Literals.GUIDELINE;
            }
            case 83: {
                return UmaPackage.Literals.ESTIMATION_CONSIDERATIONS;
            }
            case 76: {
                return UmaPackage.Literals.REPORT;
            }
            case 77: {
                return UmaPackage.Literals.TEMPLATE;
            }
            case 78: {
                return UmaPackage.Literals.SUPPORTING_MATERIAL;
            }
            case 79: {
                return UmaPackage.Literals.TOOL_MENTOR;
            }
            case 80: {
                return UmaPackage.Literals.WHITEPAPER;
            }
            case 81: {
                return UmaPackage.Literals.TERM_DEFINITION;
            }
            case 82: {
                return UmaPackage.Literals.PRACTICE;
            }
            case 84: {
                return UmaPackage.Literals.REUSABLE_ASSET;
            }
        }
        return null;
    }

    private static Guidance createNewGuidance(int newGuidanceType) {
        switch (newGuidanceType) {
            case 72: {
                return UmaFactory.eINSTANCE.createConcept();
            }
            case 73: {
                return UmaFactory.eINSTANCE.createChecklist();
            }
            case 74: {
                return UmaFactory.eINSTANCE.createExample();
            }
            case 75: {
                return UmaFactory.eINSTANCE.createGuideline();
            }
            case 83: {
                return UmaFactory.eINSTANCE.createEstimationConsiderations();
            }
            case 76: {
                return UmaFactory.eINSTANCE.createReport();
            }
            case 77: {
                return UmaFactory.eINSTANCE.createTemplate();
            }
            case 78: {
                return UmaFactory.eINSTANCE.createSupportingMaterial();
            }
            case 79: {
                return UmaFactory.eINSTANCE.createToolMentor();
            }
            case 80: {
                return UmaFactory.eINSTANCE.createWhitepaper();
            }
            case 81: {
                return UmaFactory.eINSTANCE.createTermDefinition();
            }
            case 82: {
                return UmaFactory.eINSTANCE.createPractice();
            }
            case 84: {
                return UmaFactory.eINSTANCE.createReusableAsset();
            }
        }
        return null;
    }

    public static List getValidNewGuidanceTypes(Guidance oldGuidance) {
        if (oldGuidance == null) {
            return null;
        }
        Integer oldGuidanceClassID = new Integer(oldGuidance.eClass().getClassifierID());
        if (!compatibleGuidancesList.contains(oldGuidanceClassID)) {
            return null;
        }
        ArrayList<Integer> guidanceList = new ArrayList<Integer>();
        int i = 0;
        while (i < compatibleGuidances.length) {
            Integer compatibleGuidanceTypeClassID = new Integer(compatibleGuidances[i]);
            if (!oldGuidanceClassID.equals(compatibleGuidanceTypeClassID)) {
                guidanceList.add(compatibleGuidanceTypeClassID);
            }
            ++i;
        }
        return guidanceList;
    }
}

