/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.publishing.services.index;

import com.ibm.icu.util.StringTokenizer;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Hashtable;
import org.eclipse.epf.common.utils.FileUtil;
import org.eclipse.epf.publishing.services.index.Def;
import org.eclipse.epf.publishing.services.index.HelpMessages;
import org.eclipse.epf.publishing.services.index.IO;

public class MiscStatic {
    public static Hashtable twoValueFile = null;
    public static String topDir = null;
    public static int topDirL = 0;
    public static boolean speccharfound = false;
    public static boolean tmpspeccharfound = false;
    public static long diff;

    public static boolean readTwoValueFile(String file, String characterSet) {
        IO.printDebug("readTwoValueFile ");
        if (file == null) {
            System.err.println("MiscStatic:readTwoValueFile" + HelpMessages.INPUT_PARAMETER_NULL);
            return false;
        }
        IO.printDebug("before loadfile " + file);
        String infile = MiscStatic.loadFile(file, characterSet);
        IO.printDebug("after loadfile");
        if (!infile.equals(Def.None)) {
            if (infile.charAt(0) == '\"') {
                StringTokenizer parser = new StringTokenizer(infile, "\n");
                twoValueFile = new Hashtable();
                while (parser.hasMoreTokens()) {
                    String line = parser.nextToken();
                    int firstFnutt = MiscStatic.getIndex(line, "\"", 0);
                    int secondFnutt = MiscStatic.getIndex(line, "\"", firstFnutt + 1);
                    int thirdFnutt = MiscStatic.getIndex(line, "\"", secondFnutt + 1);
                    int forthFnutt = MiscStatic.getIndex(line, "\"", thirdFnutt + 1);
                    if (firstFnutt == -1 || secondFnutt == -1 || thirdFnutt == -1 || forthFnutt == -1) {
                        return false;
                    }
                    String def = line.substring(firstFnutt + 1, secondFnutt);
                    String text = line.substring(thirdFnutt + 1, forthFnutt);
                    twoValueFile.put(def, text);
                }
            } else {
                StringTokenizer parser = new StringTokenizer(infile, "\t\n");
                twoValueFile = new Hashtable();
                while (parser.hasMoreTokens()) {
                    twoValueFile.put(parser.nextToken().trim(), parser.nextToken().trim());
                }
            }
            return true;
        }
        return false;
    }

    public static String getTitle(String realString) {
        int titleEnd;
        int titleStartEndT;
        if (realString == null) {
            System.err.println("MiscStatic:getTitle" + HelpMessages.INPUT_PARAMETER_NULL);
            return null;
        }
        String upperString = realString.toUpperCase();
        int titleStart = MiscStatic.getIndex(upperString, "TITLE", 0);
        if (titleStart != -1 && (titleStartEndT = MiscStatic.getIndex(upperString, ">", titleStart)) != -1 && (titleEnd = MiscStatic.getIndex(upperString, "</TITLE", titleStartEndT + 1)) != -1) {
            String title = realString.substring(titleStartEndT + 1, titleEnd).trim();
            return title;
        }
        return null;
    }

    public static int getIndex(String str, String match, int start) {
        if (str == null) {
            System.err.println("MiscStatic:getIndex\n" + HelpMessages.INPUT_PARAMETER_NULL);
            return -1;
        }
        if (match == null) {
            System.err.println("MiscStatic:getIndex\n" + HelpMessages.INPUT_PARAMETER_NULL);
            return -1;
        }
        int found = str.indexOf(match.toUpperCase(), start);
        if (found == -1) {
            found = str.indexOf(match.toLowerCase(), start);
        }
        if (found == -1) {
            found = str.indexOf(match, start);
        }
        return found;
    }

    public static boolean print(OutputStreamWriter outP, String str) {
        if (outP == null) {
            System.err.println("MiscStatic:print\n" + HelpMessages.BAD_OUTPUT_STREAM);
            return false;
        }
        if (str == null) {
            System.err.println("MiscStatic:print\n" + HelpMessages.INPUT_PARAMETER_NULL);
            return false;
        }
        try {
            outP.write(str, 0, str.length());
            return true;
        }
        catch (Exception e) {
            System.err.println("MiscStatic:print" + HelpMessages.WRITE_EXCEPTION + e.toString());
            return false;
        }
    }

    public static boolean printUTF(DataOutputStream outP, String str) {
        if (outP == null) {
            System.err.println("MiscStatic:printUTF\n" + HelpMessages.BAD_OUTPUT_STREAM);
            return false;
        }
        if (str == null) {
            System.err.println("MiscStatic:printUTF\n" + HelpMessages.INPUT_PARAMETER_NULL);
            return false;
        }
        try {
            outP.writeUTF(str);
            return true;
        }
        catch (Exception e) {
            System.err.println("MiscStatic:printUTF" + HelpMessages.WRITE_EXCEPTION + e.toString());
            return false;
        }
    }

    public static void printSpace(OutputStreamWriter outP, int noOfSpace) {
        int i = 0;
        while (i < noOfSpace) {
            try {
                outP.write("&nbsp;", 0, 6);
            }
            catch (Exception e) {
                System.err.println("MiscStatic:printSpace" + HelpMessages.WRITE_EXCEPTION + e.toString());
            }
            ++i;
        }
    }

    public static String loadFile(String fileName, String characterset) {
        try {
            return FileUtil.readFile((File)new File(fileName), (String)characterset).toString();
        }
        catch (Exception exception) {
            return "";
        }
    }

    public static void specChar(String in, String out, String characterset) {
        if (in == null) {
            System.err.println("MiscStatic:specChar\n" + HelpMessages.INPUT_PARAMETER_NULL);
            return;
        }
        if (out == null) {
            System.err.println("MiscStatic:specChar\n" + HelpMessages.INPUT_PARAMETER_NULL);
            return;
        }
        String tmpFile = "13d84.hwr";
        String infile = null;
        String tmpInfile = MiscStatic.loadFile(in, characterset);
        boolean writeResult = true;
        try {
            OutputStreamWriter outP = characterset != null ? new OutputStreamWriter((OutputStream)new FileOutputStream(tmpFile), characterset) : new OutputStreamWriter(new FileOutputStream(tmpFile));
            writeResult = MiscStatic.print(outP, tmpInfile);
            if (!writeResult) {
                System.err.println("MiscStatic:specChar" + HelpMessages.WRITE_EXCEPTION + in);
            }
            outP.close();
        }
        catch (Exception e) {
            System.err.println("MiscStatic:specChar" + HelpMessages.WRITE_EXCEPTION + e);
        }
        infile = writeResult ? MiscStatic.loadFile(tmpFile, characterset) : null;
        if (infile != null) {
            try {
                StringBuffer resultfile = new StringBuffer();
                int i = 0;
                while (i < infile.length()) {
                    tmpspeccharfound = false;
                    char t = infile.charAt(i);
                    if (t != '&') {
                        if (t > 'a' && t < 'z' || t > 'A' && t < 'Z' || t > '0' && t < '9' || t == '<' || t == '>' || t == '/' || t == '.' || t == '=' || t == '-' || t == '%' || t == '@') {
                            resultfile.append(t);
                        } else {
                            resultfile.append(MiscStatic.toSpecChar(t));
                        }
                    } else {
                        char t2 = infile.charAt(i + 1);
                        if (t2 == ' ' || t2 == '\n') {
                            resultfile.append("&amp;");
                            tmpspeccharfound = true;
                        } else {
                            resultfile.append(MiscStatic.toSpecChar(t));
                        }
                    }
                    if (tmpspeccharfound) {
                        speccharfound = true;
                    }
                    ++i;
                }
                if (speccharfound) {
                    System.out.println(String.valueOf(HelpMessages.WRITE_FILE) + out);
                    OutputStreamWriter outP = characterset != null ? new OutputStreamWriter((OutputStream)new FileOutputStream(out), characterset) : new OutputStreamWriter(new FileOutputStream(out));
                    MiscStatic.print(outP, resultfile.toString());
                    outP.close();
                }
                speccharfound = false;
            }
            catch (Exception e) {
                System.err.println("MiscStatic:specChar" + HelpMessages.WRITE_EXCEPTION + e);
            }
            File tmp = new File(tmpFile);
            tmp.delete();
        }
    }

    public static String toSpecChar(char token) {
        tmpspeccharfound = true;
        if (token == '\ufffd') {
            return "&aring;";
        }
        if (token == '\ufffd') {
            return "&Aring;";
        }
        if (token == '\ufffd') {
            return "&Auml;";
        }
        if (token == '\ufffd') {
            return "&auml;";
        }
        if (token == '\ufffd') {
            return "&Ouml;";
        }
        if (token == '\ufffd') {
            return "&ouml;";
        }
        if (token == '\ufffd') {
            return "&Eacute;";
        }
        if (token == '\ufffd') {
            return "&Egrave;";
        }
        if (token == '\ufffd') {
            return "&Uuml;";
        }
        if (token == '\ufffd') {
            return "&aacute;";
        }
        if (token == '\ufffd') {
            return "&Aacute;";
        }
        if (token == '\ufffd') {
            return "&agrave;";
        }
        if (token == '\ufffd') {
            return "&eacute;";
        }
        if (token == '\ufffd') {
            return "&egrave;";
        }
        if (token == '\ufffd') {
            return "&iacute;";
        }
        if (token == '\ufffd') {
            return "&igrave;";
        }
        if (token == '\ufffd') {
            return "&euml;";
        }
        if (token == '\ufffd') {
            return "&oacute;";
        }
        if (token == '\ufffd') {
            return "&ograve;";
        }
        if (token == '\ufffd') {
            return "&uacute;";
        }
        if (token == '\ufffd') {
            return "&ugrave;";
        }
        if (token == '\ufffd') {
            return "&uuml;";
        }
        if (token == '\ufffd') {
            return "&yuml;";
        }
        if (token == '\ufffd') {
            return "&acirc;";
        }
        if (token == '\ufffd') {
            return "&Acirc;";
        }
        if (token == '\ufffd') {
            return "&ecirc;";
        }
        if (token == '\ufffd') {
            return "&Ecirc;";
        }
        if (token == '\ufffd') {
            return "&ucirc;";
        }
        if (token == '\ufffd') {
            return "&Ucirc;";
        }
        if (token == '\ufffd') {
            return "&ocirc;";
        }
        if (token == '\ufffd') {
            return "&Ocirc;";
        }
        if (token == '\ufffd') {
            return "&icirc;";
        }
        if (token == '\ufffd') {
            return "&AElig;";
        }
        if (token == '\ufffd') {
            return "&aelig;";
        }
        if (token == '\ufffd') {
            return "&Icirc;";
        }
        if (token == '\ufffd') {
            return "&Agrave;";
        }
        if (token == '\ufffd') {
            return "&Atilde;";
        }
        if (token == '\ufffd') {
            return "&atilde;";
        }
        if (token == '\ufffd') {
            return "&ETH;";
        }
        if (token == '\ufffd') {
            return "&eth;";
        }
        if (token == '\ufffd') {
            return "&Igrave;";
        }
        if (token == '\ufffd') {
            return "&Ntilde;";
        }
        if (token == '\ufffd') {
            return "&ntilde;";
        }
        if (token == '\ufffd') {
            return "&Otilde;";
        }
        if (token == '\ufffd') {
            return "&otilde;";
        }
        if (token == '\ufffd') {
            return "&szlig;";
        }
        if (token == '\ufffd') {
            return "&THORN;";
        }
        if (token == '\ufffd') {
            return "&thorn;";
        }
        if (token == '\ufffd') {
            return "&Oslash;";
        }
        if (token == '\ufffd') {
            return "&oslash;";
        }
        if (token == '\ufffd') {
            return "&Ograve;";
        }
        if (token == '\ufffd') {
            return "&Ugrave;";
        }
        if (token == '\ufffd') {
            return "&iuml;";
        }
        if (token == '\ufffd') {
            return "&Yacute;";
        }
        if (token == '\ufffd') {
            return "&yacute;";
        }
        if (token == '\ufffd') {
            return "&Ccedil;";
        }
        if (token == '\ufffd') {
            return "&ccedil;";
        }
        tmpspeccharfound = false;
        return new Character(token).toString();
    }

    public static String trimQuotes(String str) {
        int len = str.length();
        if (len <= 0) {
            return str;
        }
        if (str.charAt(len - 1) == '\"') {
            str = str.substring(0, len - 1);
        }
        if (str.charAt(0) == '\"') {
            str = str.substring(1);
        }
        return str;
    }
}

