/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.publishing.services.search;

import java.io.File;
import java.io.Reader;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;

public abstract class AbstractDocument {
    public static final String FIELD_URL = "url";
    public static final String FIELD_CONTENTS = "contents";
    public static final String FIELD_SUMMARY = "summary";
    public static final String FIELD_TITLE = "title";
    public static final String FIELD_VALUE_UNDEFINED = "";
    protected String _docTitle = null;
    protected String _docUrl = null;
    protected String _summary = null;
    protected String _contents = null;
    protected Reader _contentReader = null;
    protected Map additionalFields = new HashMap();

    public Document document(File file) {
        this.compileDocument(file);
        if (this._docTitle == null) {
            this._docTitle = FIELD_VALUE_UNDEFINED;
        }
        if (this._docUrl == null) {
            this._docUrl = FIELD_VALUE_UNDEFINED;
        }
        if (this._summary == null) {
            this._summary = FIELD_VALUE_UNDEFINED;
        }
        Document luceneDocument = new Document();
        luceneDocument.add(Field.UnIndexed((String)FIELD_URL, (String)this._docUrl));
        if (this._contents != null) {
            luceneDocument.add(Field.Text((String)FIELD_CONTENTS, (String)this._contents));
        } else {
            luceneDocument.add(Field.Text((String)FIELD_CONTENTS, (Reader)this._contentReader));
        }
        luceneDocument.add(Field.UnIndexed((String)FIELD_SUMMARY, (String)this._summary));
        luceneDocument.add(Field.Text((String)FIELD_TITLE, (String)this._docTitle));
        if (this.additionalFields.size() > 0) {
            Iterator it = this.additionalFields.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                luceneDocument.add(Field.Text((String)((String)entry.getKey()), (String)((String)entry.getValue())));
            }
        }
        return luceneDocument;
    }

    protected void setDocTitle(String title) {
        this._docTitle = title;
    }

    protected void setDocUrl(String url) {
        this._docUrl = url;
    }

    protected void setSummary(String summary) {
        this._summary = summary;
    }

    protected void setContentString(String contents) {
        System.out.println(contents);
        this._contents = contents;
        this._contentReader = null;
    }

    protected void setContentReader(Reader contentReader) {
        this._contentReader = contentReader;
        this._contents = null;
    }

    protected abstract void compileDocument(File var1);
}

