/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.xmi.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.epf.library.edit.util.IOppositeFeatureLoader;
import org.eclipse.epf.persistence.MultiFileResourceSetImpl;
import org.eclipse.epf.uma.MethodElement;

public class XMIOppositeFeatureLoader
implements IOppositeFeatureLoader {
    public void loadOppositeFeatures(Collection elements) {
        HashSet oppositeFeatures = new HashSet();
        HashSet<String> deletedGUIDs = new HashSet<String>();
        MultiFileResourceSetImpl resourceSet = null;
        Iterator iter = elements.iterator();
        while (iter.hasNext()) {
            Object o = iter.next();
            if (!(o instanceof MethodElement)) continue;
            MethodElement e = (MethodElement)o;
            if (resourceSet == null) {
                ResourceSet rset;
                Resource resource = e.eResource();
                if (resource == null || !((rset = resource.getResourceSet()) instanceof MultiFileResourceSetImpl)) continue;
                resourceSet = (MultiFileResourceSetImpl)rset;
            }
            TreeIterator iterator = e.eAllContents();
            while (iterator.hasNext()) {
                Collection features;
                Object element = iterator.next();
                if (!(element instanceof MethodElement) || (features = ((MethodElement)element).getOppositeFeatures()) == null || features.isEmpty()) continue;
                oppositeFeatures.addAll(features);
                deletedGUIDs.add(((MethodElement)element).getGuid());
            }
            Collection features = e.getOppositeFeatures();
            if (features == null || features.isEmpty()) continue;
            oppositeFeatures.addAll(features);
            deletedGUIDs.add(e.getGuid());
        }
        resourceSet.loadOppositeFeatures(new ArrayList(oppositeFeatures), deletedGUIDs);
    }
}

