/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.layout.elements;

import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.epf.library.configuration.ConfigurationHelper;
import org.eclipse.epf.library.layout.ElementLayoutManager;
import org.eclipse.epf.library.layout.IElementLayout;
import org.eclipse.epf.library.layout.elements.DescriptorLayout;
import org.eclipse.epf.library.layout.util.XmlElement;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.UmaPackage;

public class TaskDescriptorLayout
extends DescriptorLayout {
    public void init(ElementLayoutManager layoutManager, MethodElement element) {
        super.__init(layoutManager, element);
    }

    public XmlElement getXmlElement(boolean includeReferences) {
        return super.getXmlElement(includeReferences);
    }

    public void loadReferences(XmlElement elementXml, boolean includeReferences) {
        List properties = this.element.getInstanceProperties();
        if (properties != null) {
            int i = 0;
            while (i < properties.size()) {
                EStructuralFeature feature = (EStructuralFeature)properties.get(i);
                if (feature == UmaPackage.eINSTANCE.getTaskDescriptor_SelectedSteps()) {
                    this.processSteps(elementXml, includeReferences);
                } else if (feature == UmaPackage.eINSTANCE.getWorkBreakdownElement_LinkToPredecessor()) {
                    super.loadWorkOrder(elementXml);
                } else if (feature.getEType() instanceof EClass) {
                    this.loadFeature(feature, elementXml, includeReferences);
                }
                ++i;
            }
        }
        if (this.layoutManager.getValidator().showExtraInfoForDescriptors()) {
            this.elementLayout.loadFeature((EStructuralFeature)UmaPackage.eINSTANCE.getTask_ToolMentors(), elementXml, false);
            this.elementLayout.loadFeature((EStructuralFeature)UmaPackage.eINSTANCE.getContentElement_Assets(), elementXml, false);
            this.elementLayout.loadFeature((EStructuralFeature)UmaPackage.eINSTANCE.getContentElement_Checklists(), elementXml, false);
            this.elementLayout.loadFeature((EStructuralFeature)UmaPackage.eINSTANCE.getContentElement_ConceptsAndPapers(), elementXml, false);
            this.elementLayout.loadFeature((EStructuralFeature)UmaPackage.eINSTANCE.getContentElement_Examples(), elementXml, false);
            this.elementLayout.loadFeature((EStructuralFeature)UmaPackage.eINSTANCE.getContentElement_Guidelines(), elementXml, false);
            this.elementLayout.loadFeature((EStructuralFeature)UmaPackage.eINSTANCE.getContentElement_SupportingMaterials(), elementXml, false);
        }
    }

    private void processSteps(XmlElement elementXml, boolean includeReferences) {
        EReference feature = UmaPackage.eINSTANCE.getTaskDescriptor_SelectedSteps();
        List items = ConfigurationHelper.calc0nFeatureValue(this.element, (EStructuralFeature)feature, this.getLayoutMgr().getElementRealizer());
        XmlElement stepXml = elementXml.newChild("referenceList").setAttribute("name", feature.getName());
        if (items != null && items.size() > 0) {
            Iterator it = items.iterator();
            while (it.hasNext()) {
                IElementLayout l;
                MethodElement me;
                Object e = it.next();
                if (!(e instanceof MethodElement) || (e = ConfigurationHelper.getCalculatedElement(me = (MethodElement)e, this.layoutManager.getConfiguration())) == null || (l = this.layoutManager.getLayout(me, true)) == null) continue;
                l.setContentTarget(this.element);
                stepXml.addChild(l.getXmlElement(ConfigurationHelper.isDescriptionElement(me) ? true : includeReferences));
            }
        }
    }
}

