/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.ui;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.CommonPlugin;
import org.eclipse.epf.common.serviceability.MsgDialog;
import org.eclipse.epf.common.serviceability.VersionUtil;
import org.eclipse.epf.library.LibraryService;
import org.eclipse.epf.library.services.SafeUpdateController;
import org.eclipse.epf.library.ui.LibraryUIPlugin;
import org.eclipse.epf.library.ui.LibraryUIResources;
import org.eclipse.epf.library.ui.actions.ConfigurationContributionItem;
import org.eclipse.epf.library.ui.dialogs.OpenLibraryDialog;
import org.eclipse.epf.library.ui.dialogs.SelectLibraryDirectoryDialog;
import org.eclipse.epf.library.ui.preferences.LibraryUIPreferences;
import org.eclipse.epf.library.ui.wizards.LibraryBackupUtil;
import org.eclipse.epf.library.xmi.XMILibraryUtil;
import org.eclipse.epf.persistence.MultiFileResourceSetImpl;
import org.eclipse.epf.persistence.migration.MappingUtil;
import org.eclipse.epf.uma.MethodLibrary;
import org.eclipse.jface.action.CoolBarManager;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.ToolBarContributionItem;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.window.ApplicationWindow;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.WorkspaceModifyOperation;

public class LibraryUIManager {
    private static final String TOOLBAR_CONFIG_CONTRIBUTION_ID = "toolbar.config.contribution";
    private static LibraryUIManager instance = null;
    private static String cmdLineLibPath = null;
    private static String cmdLineDefaultLibPath = null;
    private static String appName = "composer";
    static /* synthetic */ Class class$0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static LibraryUIManager getInstance() {
        if (instance != null) return instance;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.epf.library.ui.LibraryUIManager");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Class<?> clazz2 = clazz;
        synchronized (clazz) {
            if (instance != null) return instance;
            instance = new LibraryUIManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private LibraryUIManager() {
        this.addConfigurationContribution();
    }

    public void promptForMethodLibrary() {
        String libPath = LibraryUIPreferences.getSavedLibraryPath();
        if (cmdLineLibPath != null) {
            libPath = cmdLineLibPath;
        } else if ((libPath == null || libPath.length() == 0) && cmdLineDefaultLibPath != null) {
            libPath = cmdLineDefaultLibPath;
        }
        if (XMILibraryUtil.isValidLibrary((String)libPath, (boolean)true) == Status.OK_STATUS && !LibraryUIPreferences.getPromptForMethodLibraryAtStartup() && !XMILibraryUtil.isMethodLibraryLocked((String)libPath)) {
            this.openLibrary(libPath);
            return;
        }
        if (XMILibraryUtil.isValidLibrary((String)libPath) != Status.OK_STATUS) {
            libPath = LibraryUIPreferences.getDefaultLibraryPath();
        }
        OpenLibraryDialog dialog = new OpenLibraryDialog(null, libPath);
        while (dialog.open() == 0) {
            libPath = dialog.getLibraryPath();
            if (XMILibraryUtil.isValidLibrary((String)(libPath = LibraryUIManager.toAbsoluteLibraryPath(libPath)), (boolean)true) == Status.OK_STATUS) {
                if (XMILibraryUtil.isMethodLibraryLocked((String)libPath) && LibraryUIManager.displayLibraryLockedMessage() != 0) continue;
                VersionUtil.VersionCheckInfo info = VersionUtil.checkLibraryVersion((File)new File(libPath, "library.xmi"));
                if (info != null && info.result > 0) {
                    String message = "";
                    message = info.toolID.equals(VersionUtil.getPrimaryToolID()) ? NLS.bind((String)LibraryUIResources.versionMismatchDialog_text, (Object[])new Object[]{Platform.getProduct().getName(), info.toolVersion}) : NLS.bind((String)LibraryUIResources.versionMismatchDialog_text_unknown, (Object[])new Object[]{Platform.getProduct().getName()});
                    LibraryUIPlugin.getDefault().getMsgDialog().displayError(LibraryUIResources.openLibraryDialog_title, message);
                    continue;
                }
                if (XMILibraryUtil.isMethodLibraryUpgradeRequired((String)libPath) && (!LibraryUIPlugin.getDefault().getMsgDialog().displayConfirmation(LibraryUIResources.openLibraryDialog_title, LibraryUIResources.upgradeLibraryDialog_text) || !LibraryUIManager.upgradeLibrary(libPath))) continue;
                if (this.openLibrary(libPath)) {
                    return;
                }
            } else {
                MsgDialog msgDialog = LibraryUIPlugin.getDefault().getMsgDialog();
                boolean rc = msgDialog.displayConfirmation(LibraryUIResources.openLibraryDialog_title, NLS.bind((String)LibraryUIResources.openLibraryDialog_newLibrary_text, (Object[])new Object[]{libPath}));
                if (!rc) continue;
                if (this.createLibrary(libPath)) {
                    return;
                }
            }
            LibraryUIPlugin.getDefault().getMsgDialog().displayError(LibraryUIResources.openLibraryDialog_title, LibraryUIResources.invalidLibraryPath_msg, LibraryUIResources.invalidLibraryPath_reason);
        }
        System.exit(0);
    }

    public void openLibrary() {
        SelectLibraryDirectoryDialog dialog = new SelectLibraryDirectoryDialog(Display.getCurrent().getActiveShell());
        String libPath = LibraryUIPreferences.getSavedLibraryPath();
        dialog.setFilterPath(libPath);
        do {
            if ((libPath = dialog.open()) == null) {
                return;
            }
            if (XMILibraryUtil.isValidLibrary((String)libPath, (boolean)true) == Status.OK_STATUS) {
                if (XMILibraryUtil.isMethodLibraryLocked((String)libPath) && LibraryUIManager.displayLibraryLockedMessage() != 0) continue;
                VersionUtil.VersionCheckInfo info = VersionUtil.checkLibraryVersion((File)new File(libPath, "library.xmi"));
                if (info != null && info.result > 0) {
                    String message = "";
                    message = info.toolID.equals(VersionUtil.getPrimaryToolID()) ? NLS.bind((String)LibraryUIResources.versionMismatchDialog_text, (Object[])new Object[]{Platform.getProduct().getName(), info.toolVersion}) : NLS.bind((String)LibraryUIResources.versionMismatchDialog_text_unknown, (Object[])new Object[]{Platform.getProduct().getName()});
                    LibraryUIPlugin.getDefault().getMsgDialog().displayError(LibraryUIResources.openLibraryDialog_title, message);
                    return;
                }
                if (XMILibraryUtil.isMethodLibraryUpgradeRequired((String)libPath)) {
                    if (!LibraryUIPlugin.getDefault().getMsgDialog().displayConfirmation(LibraryUIResources.openLibraryDialog_title, LibraryUIResources.upgradeLibraryDialog_text)) {
                        return;
                    }
                    if (!LibraryUIManager.upgradeLibrary(libPath)) {
                        return;
                    }
                }
                if (this.openLibrary(libPath)) {
                    return;
                }
            }
            MsgDialog msgDialog = LibraryUIPlugin.getDefault().getMsgDialog();
            msgDialog.displayError(LibraryUIResources.openLibraryDialog_title, LibraryUIResources.invalidLibraryPath_msg, LibraryUIResources.invalidLibraryPath_reason);
        } while (libPath != null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean openLibrary(final String path) {
        Shell shell = Display.getCurrent().getActiveShell();
        final ArrayList errors = new ArrayList();
        WorkspaceModifyOperation operation = new WorkspaceModifyOperation(){

            /*
             * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void execute(IProgressMonitor monitor) {
                String taskName = LibraryUIResources.openingLibraryTask_name;
                monitor.beginTask(taskName, 2);
                try {
                    try {
                        monitor.setTaskName(taskName);
                        monitor.worked(1);
                        LibraryService.getInstance().closeCurrentMethodLibrary();
                        MethodLibrary library = XMILibraryUtil.openMethodLibrary((String)path);
                        LibraryService.getInstance().setCurrentMethodLibrary(library);
                        LibraryUIPreferences.setSavedLibraryPath(path);
                        MultiFileResourceSetImpl resourceSet = (MultiFileResourceSetImpl)LibraryService.getInstance().getCurrentLibraryManager().getEditingDomain().getResourceSet();
                        if (resourceSet.getMarkerMananger().hasUnresolvedProxy()) {
                            SafeUpdateController.asyncExec((Runnable)new Runnable(this){
                                final /* synthetic */ 1 this$1;
                                {
                                    this.this$1 = var1_1;
                                }

                                public void run() {
                                    try {
                                        PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("org.eclipse.ui.views.ProblemView", null, 2);
                                    }
                                    catch (Exception exception) {}
                                }
                            });
                        }
                    }
                    catch (Exception e) {
                        if (!(e instanceof IOException) || !e.getMessage().startsWith("###")) {
                            LibraryUIPlugin.getDefault().getLogger().logError((Throwable)e);
                        }
                        errors.add(e);
                    }
                }
                catch (Throwable throwable) {
                    Object var5_7 = null;
                    monitor.done();
                    throw throwable;
                }
                {
                    Object var5_8 = null;
                }
                monitor.done();
            }
        };
        try {
            String message;
            Exception e;
            ProgressMonitorDialog dialog = new ProgressMonitorDialog(shell){

                protected void configureShell(Shell shell) {
                    super.configureShell(shell);
                    shell.setText(LibraryUIResources.openLibraryDialog_title);
                }
            };
            dialog.run(true, false, (IRunnableWithProgress)operation);
            if (errors.isEmpty()) {
                IWorkbenchWindow workbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                if (workbenchWindow == null) return true;
                IWorkbenchPage activePage = workbenchWindow.getActivePage();
                if (activePage == null) return true;
                activePage.closeAllEditors(false);
                return true;
            }
            Iterator iter = errors.iterator();
            do {
                if (iter.hasNext()) continue;
                return false;
            } while (!((e = (Exception)iter.next()) instanceof IOException) || !(message = e.getMessage()).startsWith("###"));
            String projectFileName = message.substring(3);
            String prompt = LibraryUIResources.bind(LibraryUIResources.readOnlyProjectFile_text, projectFileName);
            String[] buttonLabels = new String[]{LibraryUIResources.retryButton_text, LibraryUIResources.cancelButton_text};
            MessageDialog msgBox = new MessageDialog(Display.getCurrent().getActiveShell(), LibraryUIResources.openLibraryDialog_title, null, prompt, 4, buttonLabels, 0);
            if (msgBox.open() != 0) return true;
            return this.openLibrary(path);
        }
        catch (Exception e) {
            LibraryUIPlugin.getDefault().getLogger().logError((Throwable)e);
        }
        return false;
    }

    public boolean createLibrary(String path) {
        try {
            File libraryPath = new File(path);
            if (!libraryPath.exists()) {
                libraryPath.mkdirs();
            }
            XMILibraryUtil.createMethodLibrary((String)libraryPath.getName(), (String)path);
            LibraryUIPreferences.setSavedLibraryPath(path);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public void addConfigurationContribution() {
        IWorkbenchWindow window;
        IWorkbench workbench = LibraryUIPlugin.getDefault().getWorkbench();
        if (workbench != null && (window = workbench.getActiveWorkbenchWindow()) != null && window instanceof ApplicationWindow) {
            CoolBarManager coolBar = ((ApplicationWindow)window).getCoolBarManager();
            IContributionItem marker = null;
            IContributionItem coolBarItem = coolBar.find(TOOLBAR_CONFIG_CONTRIBUTION_ID);
            if (coolBarItem != null) {
                if (coolBarItem.isVisible()) {
                    return;
                }
                IContributionItem[] items = coolBar.getItems();
                int i = 0;
                while (i < items.length) {
                    if (items[i] == coolBarItem) {
                        coolBar.remove(TOOLBAR_CONFIG_CONTRIBUTION_ID);
                        if (i + 1 < items.length) {
                            marker = items[i + 1];
                        }
                    }
                    ++i;
                }
            }
            ToolBarManager toolbarMgr = new ToolBarManager(0x804000);
            ConfigurationContributionItem testItem = new ConfigurationContributionItem(null);
            toolbarMgr.add((IContributionItem)testItem);
            ToolBarContributionItem contribItem = new ToolBarContributionItem((IToolBarManager)toolbarMgr, TOOLBAR_CONFIG_CONTRIBUTION_ID);
            if (marker != null) {
                coolBar.insertBefore(marker.getId(), (IContributionItem)contribItem);
            } else {
                coolBar.add((IContributionItem)contribItem);
            }
        }
    }

    public static boolean upgradeLibrary(final String libDir) {
        StringBuffer errMsg;
        block4: {
            Shell shell = Display.getCurrent().getActiveShell();
            LibraryBackupUtil.promptBackupLibrary(shell, new File(libDir));
            errMsg = new StringBuffer();
            final boolean[] cancelFlagHolder = new boolean[1];
            WorkspaceModifyOperation operation = new WorkspaceModifyOperation(){

                /*
                 * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                public void execute(IProgressMonitor monitor) {
                    monitor.beginTask(LibraryUIResources.upgradingLibraryTask_name, 10);
                    monitor.worked(1);
                    try {
                        try {
                            MappingUtil.migrate((String)(String.valueOf(libDir) + "/" + "library.xmi"), (IProgressMonitor)monitor);
                        }
                        catch (OperationCanceledException operationCanceledException) {
                            cancelFlagHolder[0] = true;
                        }
                        catch (Exception e) {
                            CommonPlugin.INSTANCE.log((Object)e);
                            e.printStackTrace();
                            String msg = e.getMessage();
                            if (msg == null) {
                                msg = LibraryUIResources.upgradeLibraryError_msg;
                            }
                            errMsg.append(msg);
                        }
                    }
                    catch (Throwable throwable) {
                        Object var4_5 = null;
                        monitor.done();
                        throw throwable;
                    }
                    {
                        Object var4_6 = null;
                    }
                    monitor.done();
                }
            };
            try {
                new ProgressMonitorDialog(shell).run(true, false, (IRunnableWithProgress)operation);
                if (!cancelFlagHolder[0]) break block4;
                return false;
            }
            catch (Exception e) {
                LibraryUIPlugin.getDefault().getLogger().logError((Throwable)e);
                e.printStackTrace();
                LibraryUIPlugin.getDefault().getMsgDialog().displayError(LibraryUIResources.upgradeLibraryDialog_title, LibraryUIResources.upgradeLibraryError_msg);
                return false;
            }
        }
        if (errMsg.length() > 0) {
            LibraryUIPlugin.getDefault().getMsgDialog().displayError(LibraryUIResources.upgradeLibraryDialog_title, errMsg.toString());
            return false;
        }
        return true;
    }

    public static String getCommandLineLibraryPath() {
        return cmdLineLibPath;
    }

    public static void setCommandLineLibraryPath(String libPath) {
        cmdLineLibPath = libPath;
        IPath path = Path.fromOSString((String)libPath);
        if (!path.isAbsolute()) {
            cmdLineLibPath = String.valueOf(System.getProperty("user.dir")) + File.separator + libPath;
        }
        if (XMILibraryUtil.isValidLibrary((String)cmdLineLibPath, (boolean)true) != Status.OK_STATUS) {
            cmdLineLibPath = null;
        }
    }

    public static void setCommandLineDefaultLibraryPath(String libPath) {
        IPath path = Path.fromOSString((String)libPath);
        if (!path.isAbsolute()) {
            cmdLineDefaultLibPath = String.valueOf(System.getProperty("user.dir")) + File.separator + libPath;
        }
        if (XMILibraryUtil.isValidLibrary((String)cmdLineDefaultLibPath, (boolean)true) != Status.OK_STATUS) {
            cmdLineDefaultLibPath = null;
        }
    }

    public static String toAbsoluteLibraryPath(String libPath) {
        String absPath = libPath;
        IPath ecPath = Path.fromOSString((String)libPath);
        if (!ecPath.isAbsolute()) {
            absPath = String.valueOf(System.getProperty("user.dir")) + File.separator + "Method Libraries" + File.separator + libPath;
        }
        return absPath;
    }

    private static int displayLibraryLockedMessage() {
        Shell shell = null;
        Image image = null;
        try {
            shell = LibraryUIPlugin.getDefault().getWorkbench().getDisplay().getActiveShell();
            image = shell.getImage();
        }
        catch (Exception exception) {}
        MessageDialog msgDlg = new MessageDialog(shell, LibraryUIResources.openLibraryDialog_title, image, LibraryUIResources.libraryLocked_msg, 1, new String[]{LibraryUIResources.libraryLocked_openButton_text, IDialogConstants.CANCEL_LABEL}, 1);
        return msgDlg.open();
    }

    public static String getAppName() {
        return appName;
    }

    public static void setAppName(String appName) {
        LibraryUIManager.appName = appName;
    }
}

