/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.authoring.ui.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.epf.authoring.ui.AuthoringUIPlugin;
import org.eclipse.epf.authoring.ui.AuthoringUIResources;
import org.eclipse.epf.authoring.ui.editors.AbstractDiagramEditor;
import org.eclipse.epf.authoring.ui.editors.BreakdownElementEditorInput;
import org.eclipse.epf.common.serviceability.MsgBox;
import org.eclipse.epf.common.utils.StrUtil;
import org.eclipse.epf.library.edit.IFilter;
import org.eclipse.epf.library.edit.LibraryEditResources;
import org.eclipse.epf.library.edit.process.BreakdownElementWrapperItemProvider;
import org.eclipse.epf.library.edit.util.MethodElementUtil;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.library.edit.validation.IValidator;
import org.eclipse.epf.library.edit.validation.internal.ContentElementNameValidator;
import org.eclipse.epf.library.edit.validation.internal.ValidatorFactory;
import org.eclipse.epf.library.ui.LibraryUIText;
import org.eclipse.epf.uma.Activity;
import org.eclipse.epf.uma.ContentElement;
import org.eclipse.epf.uma.Deliverable;
import org.eclipse.epf.uma.Guidance;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.Practice;
import org.eclipse.epf.uma.UmaPackage;
import org.eclipse.epf.uma.VariabilityElement;
import org.eclipse.epf.uma.WorkProduct;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;

public class UIHelper {
    public static void setItems(Table table, ArrayList items) {
        table.removeAll();
        int i = 0;
        while (i < items.size()) {
            TableItem item = new TableItem(table, 0);
            item.setText((String)items.get(i));
            ++i;
        }
    }

    public static org.eclipse.swt.widgets.List createList(FormToolkit toolkit, Composite parent, int style) {
        org.eclipse.swt.widgets.List list = new org.eclipse.swt.widgets.List(parent, style);
        toolkit.adapt((Control)list, true, true);
        return list;
    }

    public static Object[] getSelectedGuidances(ContentElement contentElement) {
        List list = MethodElementUtil.getSelectedGuidances((EObject)contentElement);
        Iterator it = list.iterator();
        while (it.hasNext()) {
            Object obj = it.next();
            if (!(obj instanceof Practice)) continue;
            it.remove();
        }
        return list.toArray();
    }

    private static String getFormPageTitlePrefixFor(MethodElement methodElement) {
        String elementLabel = LibraryUIText.getUIText((MethodElement)methodElement);
        if (methodElement instanceof WorkProduct) {
            return String.valueOf(LibraryUIText.TEXT_WORK_PRODUCT) + " (" + elementLabel + ")";
        }
        if (methodElement instanceof Guidance) {
            return String.valueOf(LibraryUIText.TEXT_GUIDANCE) + " (" + elementLabel + ")";
        }
        return elementLabel;
    }

    public static void setFormText(ScrolledForm form, MethodElement element) {
        if (form != null && !form.isDisposed()) {
            StringBuffer str = new StringBuffer();
            str.append(UIHelper.getFormPageTitlePrefixFor(element));
            str.append(AuthoringUIResources.editor_title_colon_with_spaces);
            if (element instanceof VariabilityElement) {
                str.append(TngUtil.getLabel((VariabilityElement)((VariabilityElement)element), (String)"", (boolean)true));
            } else if (element.getName() != null) {
                str.append(element.getName());
            }
            form.setText(str.toString());
        }
    }

    public static boolean checkCircularDeliverables(Deliverable toBePart, Deliverable deliverable) {
        List deliverables = toBePart.getDeliveredWorkProducts();
        if (deliverables != null && deliverables.size() > 0) {
            if (deliverables.contains(deliverable)) {
                return false;
            }
            Iterator iterator = deliverables.iterator();
            while (iterator.hasNext()) {
                Object obj = iterator.next();
                if (!(obj instanceof Deliverable)) continue;
                return UIHelper.checkCircularDeliverables((Deliverable)obj, deliverable);
            }
        }
        return true;
    }

    public static void deliverablePartsChain(Deliverable e, List roots) {
        List list = e.getDeliveredWorkProducts();
        if (list != null && list.size() > 0) {
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                Object obj = iterator.next();
                if (!(obj instanceof Deliverable)) continue;
                roots.add(obj);
                UIHelper.deliverablePartsChain((Deliverable)obj, roots);
            }
        }
    }

    public static String resolveContentElementNameConflict(EObject container, MethodElement element, EReference reference) {
        ContentElementNameValidator validator = new ContentElementNameValidator(container, (EStructuralFeature)reference, (ContentElement)element, (IFilter)new ValidatorFactory.TypeFilter((EObject)element));
        String msg = validator.isValid(element.getName());
        if (msg != null) {
            String featureTxt = TngUtil.getFeatureText((EStructuralFeature)UmaPackage.eINSTANCE.getNamedElement_Name());
            String title = LibraryEditResources.resolveNameConflictDialog_title;
            String dlgMsg = NLS.bind((String)LibraryEditResources.resolveNameConflictDialog_text, (Object)StrUtil.toLower((String)featureTxt), (Object)element.getName());
            String currentValue = (String)element.eGet((EStructuralFeature)UmaPackage.eINSTANCE.getNamedElement_Name());
            IInputValidator inputValidator = new IInputValidator((IValidator)validator){
                private final /* synthetic */ IValidator val$validator;
                {
                    this.val$validator = iValidator;
                }

                public String isValid(String newText) {
                    return this.val$validator.isValid(newText);
                }
            };
            InputDialog inputDlg = new InputDialog(MsgBox.getDefaultShell(), title, dlgMsg, currentValue, inputValidator);
            if (inputDlg.open() == 1) {
                throw new OperationCanceledException();
            }
            return inputDlg.getValue();
        }
        return null;
    }

    public static void refreshOpenDiagramEditors(Object refreshElement, List openEditorRefs) {
        openEditorRefs = new ArrayList<IEditorReference>();
        IWorkbenchPage workbenchPage = AuthoringUIPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getActivePage();
        IEditorReference[] editorReferences = workbenchPage.getEditorReferences();
        int i = 0;
        while (i < editorReferences.length) {
            IEditorReference reference = editorReferences[i];
            IEditorPart editor = reference.getEditor(true);
            if (editor != null) {
                IEditorInput input = editor.getEditorInput();
                BreakdownElementWrapperItemProvider element = null;
                if (input instanceof BreakdownElementEditorInput) {
                    BreakdownElementEditorInput binput = (BreakdownElementEditorInput)input;
                    if (binput.getWrapper() != null) {
                        Object parent;
                        element = binput.getWrapper();
                        if (element instanceof BreakdownElementWrapperItemProvider && (parent = element.getParent(null)) instanceof BreakdownElementWrapperItemProvider && element.equals(refreshElement)) {
                            UIHelper.refreshOpenDiagramEditors(parent, openEditorRefs);
                        }
                    } else {
                        element = binput.getMethodElement();
                    }
                }
                if (element != null) {
                    Collection c;
                    if (element instanceof Activity) {
                        if (((Activity)element).getBreakdownElements().contains(refreshElement)) {
                            openEditorRefs.add(reference);
                        } else if (refreshElement instanceof BreakdownElementWrapperItemProvider && ((BreakdownElementWrapperItemProvider)refreshElement).getOwner() != null && ((BreakdownElementWrapperItemProvider)refreshElement).getOwner().equals(element)) {
                            openEditorRefs.add(reference);
                            if (((BreakdownElementWrapperItemProvider)refreshElement).getOwner() instanceof BreakdownElementWrapperItemProvider && ((BreakdownElementWrapperItemProvider)((BreakdownElementWrapperItemProvider)refreshElement).getOwner()).getOwner().equals(element)) {
                                openEditorRefs.add(reference);
                            }
                        }
                    } else if (element instanceof BreakdownElementWrapperItemProvider && (c = element.getChildren((Object)element)) != null && c.contains(refreshElement)) {
                        openEditorRefs.add(reference);
                    }
                }
            }
            ++i;
        }
        int size = openEditorRefs.size();
        int i2 = 0;
        while (i2 < size) {
            IEditorReference reference = (IEditorReference)openEditorRefs.get(i2);
            IEditorPart editor = reference.getEditor(true);
            if (editor instanceof AbstractDiagramEditor) {
                ((AbstractDiagramEditor)editor).refreshDiagram();
            }
            ++i2;
        }
    }
}

