/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.persistence;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.Map;
import org.eclipse.emf.common.CommonPlugin;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.AbstractTreeIterator;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceImpl;
import org.eclipse.emf.ecore.util.EContentsEList;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.xmi.XMLHelper;
import org.eclipse.emf.ecore.xmi.XMLLoad;
import org.eclipse.emf.ecore.xmi.XMLSave;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceImpl;
import org.eclipse.epf.common.utils.FileUtil;
import org.eclipse.epf.persistence.FileManager;
import org.eclipse.epf.persistence.MethodLibraryPersister;
import org.eclipse.epf.persistence.MultiFileIOException;
import org.eclipse.epf.persistence.MultiFileResourceSetImpl;
import org.eclipse.epf.persistence.MultiFileSaveUtil;
import org.eclipse.epf.persistence.MultiFileURIConverter;
import org.eclipse.epf.persistence.MultiFileXMIHelperImpl;
import org.eclipse.epf.persistence.MultiFileXMILoadImpl;
import org.eclipse.epf.persistence.MultiFileXMISaveImpl;
import org.eclipse.epf.persistence.refresh.RefreshJob;
import org.eclipse.epf.persistence.util.PersistenceResources;
import org.eclipse.epf.persistence.util.PersistenceUtil;
import org.eclipse.epf.resourcemanager.ResourceDescriptor;
import org.eclipse.epf.resourcemanager.ResourceManager;
import org.eclipse.epf.uma.ContentDescription;
import org.eclipse.epf.uma.MethodConfiguration;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.MethodLibrary;
import org.eclipse.epf.uma.ecore.impl.MultiResourceEObject;
import org.eclipse.epf.uma.ecore.util.OppositeFeatureNotification;
import org.eclipse.osgi.util.NLS;

public class MultiFileXMIResourceImpl
extends XMIResourceImpl {
    private static String tempDir;
    private URI finalURI;
    private URI oldURI;
    private String backupFile;
    private String currentTxID;
    private long lastLoadTimeStamp;
    private ResourceDescriptor resourceDescriptor;
    private boolean isUnloading;
    private long fileLastModified;
    private static boolean testResourceLoaded;
    private static final String testResourceURIStr = "file:/C:/temp/OpenUP/openup_basic/plugin.xmi";

    public MultiFileXMIResourceImpl(URI uri) {
        super(uri);
        this.setIntrinsicIDToEObjectMap(new HashMap());
    }

    protected XMLLoad createXMLLoad() {
        return new MultiFileXMILoadImpl(this.createXMLHelper());
    }

    protected XMLSave createXMLSave() {
        return new MultiFileXMISaveImpl(this.createXMLHelper());
    }

    protected XMLHelper createXMLHelper() {
        return new MultiFileXMIHelperImpl(this);
    }

    public String getID(EObject eObject) {
        String id = MultiFileSaveUtil.getGuid(eObject);
        if (id != null) {
            return id;
        }
        return super.getID(eObject);
    }

    public void setID(EObject eObject, String id) {
        Object oldID = id != null ? this.getEObjectToIDMap().put(eObject, id) : this.getEObjectToIDMap().remove(eObject);
        Map guidToMethodElementMap = ((MultiFileResourceSetImpl)this.getResourceSet()).getGuidToMethodElementMap();
        if (oldID != null) {
            this.getIDToEObjectMap().remove(oldID);
            if (eObject instanceof MethodElement) {
                if (eObject.eIsProxy()) {
                    EObject obj = (EObject)guidToMethodElementMap.get(id);
                    if (obj != null && obj.eIsProxy()) {
                        guidToMethodElementMap.remove(id);
                    }
                } else {
                    guidToMethodElementMap.remove(id);
                }
            }
        }
        if (id != null) {
            this.getIDToEObjectMap().put(id, eObject);
            if (eObject instanceof MethodElement) {
                guidToMethodElementMap.put(id, eObject);
                MethodElement e = (MethodElement)eObject;
                if (!e.getGuid().equals(id)) {
                    e.setGuid(id);
                }
            }
        }
    }

    protected boolean useUUIDs() {
        return true;
    }

    public String getURIFragment(EObject eObject) {
        try {
            String id = this.getID(eObject);
            if (id != null) {
                return id;
            }
            ArrayList<String> uriFragmentPath = new ArrayList<String>();
            EObject container = eObject.eContainer();
            while (container != null && container.eResource() == this) {
                uriFragmentPath.add(((InternalEObject)container).eURIFragmentSegment(eObject.eContainingFeature(), eObject));
                eObject = container;
                container = eObject.eContainer();
            }
            StringBuffer result = new StringBuffer("/");
            result.append(this.getURIFragmentRootSegment(eObject));
            ListIterator i = uriFragmentPath.listIterator(uriFragmentPath.size());
            while (i.hasPrevious()) {
                result.append('/');
                result.append((String)i.previous());
            }
            return result.toString();
        }
        catch (RuntimeException e) {
            System.err.println("Error getting URI fragment for " + eObject);
            throw e;
        }
    }

    protected void attachedHelper(EObject eObject) {
        String id;
        super.attachedHelper(eObject);
        if (this.useIDs() && (id = this.getID(eObject)) != null) {
            this.getEObjectToIDMap().put(eObject, id);
            if (eObject instanceof MethodElement) {
                ((MultiFileResourceSetImpl)this.getResourceSet()).getGuidToMethodElementMap().put(id, eObject);
            }
        }
        if (this.isTrackingModification() && eObject.eResource() != this) {
            eObject.eAdapters().remove((Object)this.modificationTrackingAdapter);
        }
    }

    private void attachedAllWithIDs(EObject eObj) {
        ContentTreeIterator allContents = new ContentTreeIterator(eObj);
        while (allContents.hasNext()) {
            this.attachedHelper((EObject)allContents.next());
        }
    }

    private void basicAttachedAll(EObject eObj) {
        eObj.eAdapters().add((Object)this.modificationTrackingAdapter);
        EList list = eObj.eContents();
        int size = list.size();
        int i = 0;
        while (i < size) {
            EObject o = (EObject)list.get(i);
            if (o.eResource() == this) {
                this.basicAttachedAll(o);
            }
            ++i;
        }
    }

    public void attachedAll(EObject eObj) {
        if (this.useIDs()) {
            this.attachedAllWithIDs(eObj);
        } else {
            this.basicAttachedAll(eObj);
        }
    }

    public void attached(EObject eObject) {
        this.attachedAll(eObject);
    }

    private void detachedAllWithIDs(EObject eObj) {
        ContentTreeIterator allContents = new ContentTreeIterator(eObj);
        while (allContents.hasNext()) {
            this.detachedHelper((EObject)allContents.next());
        }
    }

    private void basicDetachedAll(EObject eObj) {
        eObj.eAdapters().remove((Object)this.modificationTrackingAdapter);
        EList list = eObj.eContents();
        int size = list.size();
        int i = 0;
        while (i < size) {
            EObject o = (EObject)list.get(i);
            if (o.eResource() == this) {
                this.basicDetachedAll(o);
            }
            ++i;
        }
    }

    protected EObject getEObjectByID(String id) {
        InternalEObject eObject;
        Iterator iter = this.getContents().iterator();
        while (iter.hasNext()) {
            EObject element = (EObject)iter.next();
            String guid = MultiFileSaveUtil.getGuid(element);
            if (guid == null || !guid.equals(id)) continue;
            return element;
        }
        if (this.idToEObjectMap != null && (eObject = (InternalEObject)this.idToEObjectMap.get(id)) != null && !eObject.eIsProxy()) {
            return eObject;
        }
        return null;
    }

    public void load(Map options) throws IOException {
        if (this.isUnloading) {
            return;
        }
        super.load(options);
        this.updateTimeStamps();
        if (MultiFileSaveUtil.DEBUG && this.getURI().toString().equals(testResourceURIStr)) {
            testResourceLoaded = true;
        }
    }

    public long getFileLastModified() {
        return this.fileLastModified;
    }

    synchronized boolean reload(Collection proxies) throws IOException {
        if (this.isLoaded) {
            Notification notification = this.setLoaded(false);
            this.doUnload(proxies, false);
            this.isLoaded = false;
            this.contents = null;
            if (notification != null) {
                this.eNotify(notification);
            }
            this.load(this.getResourceSet().getLoadOptions());
            return true;
        }
        return false;
    }

    public final void unloadWithoutRemove() {
        if (this.isLoaded) {
            ResourceDescriptor resDesc = MultiFileSaveUtil.getResourceDescriptor((Resource)this);
            if (resDesc != null) {
                this.setResourceDescriptor(resDesc);
            }
            Notification notification = this.setLoaded(false);
            this.doUnload(null, false);
            if (notification != null) {
                this.eNotify(notification);
            }
        }
    }

    protected void doUnload() {
        this.doUnload(null, true);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void doUnload(Collection proxies, boolean remove) {
        this.isUnloading = true;
        try {
            Iterator<Object> iter;
            TreeIterator allContents = this.getAllProperContents(new ArrayList(this.getContents()));
            if (!this.getContents().isEmpty()) {
                if (remove) {
                    this.getContents().clear();
                } else {
                    this.contents = null;
                }
            }
            this.getErrors().clear();
            this.getWarnings().clear();
            ArrayList<InternalEObject> unloadedObjects = new ArrayList<InternalEObject>();
            try {
                while (allContents.hasNext()) {
                    try {
                        InternalEObject o = (InternalEObject)allContents.next();
                        this.unloaded(o);
                        unloadedObjects.add(o);
                    }
                    catch (Exception e) {
                        CommonPlugin.INSTANCE.log((Object)e);
                    }
                }
            }
            catch (Exception e) {
                CommonPlugin.INSTANCE.log((Object)e);
            }
            if (proxies != null && !unloadedObjects.isEmpty()) {
                proxies.addAll(unloadedObjects);
            }
            if (remove) {
                iter = unloadedObjects.iterator();
                while (iter.hasNext()) {
                    EObject object = (EObject)iter.next();
                    EcoreUtil.remove((EObject)object);
                }
            }
            if (this.idToEObjectMap != null) {
                iter = this.idToEObjectMap.keySet().iterator();
                while (true) {
                    if (!iter.hasNext()) {
                        this.idToEObjectMap.clear();
                        break;
                    }
                    ((MultiFileResourceSetImpl)this.getResourceSet()).getGuidToMethodElementMap().remove(iter.next());
                }
            }
            if (this.eObjectToIDMap != null) {
                this.eObjectToIDMap.clear();
            }
            if (this.eObjectToExtensionMap != null) {
                this.eObjectToExtensionMap.clear();
            }
            if (this.intrinsicIDToEObjectMap != null) {
                this.intrinsicIDToEObjectMap.clear();
            }
        }
        catch (Throwable throwable) {
            Object var7_10 = null;
            this.isUnloading = false;
            throw throwable;
        }
        {
            Object var7_11 = null;
            this.isUnloading = false;
            return;
        }
    }

    protected void unloaded(InternalEObject internalEObject) {
        String guid = MultiFileSaveUtil.getGuid(internalEObject);
        if (guid != null) {
            URI uri = this.resourceDescriptor != null ? MultiFileURIConverter.createURI(this.resourceDescriptor.getId()) : this.getURI();
            internalEObject.eSetProxyURI(uri.appendFragment(guid));
        }
        internalEObject.eAdapters().clear();
        if (internalEObject instanceof MultiResourceEObject) {
            MultiResourceEObject multiResourceEObject = (MultiResourceEObject)internalEObject;
            Map oppositeFeatureMap = multiResourceEObject.basicGetOppositeFeatureMap();
            if (oppositeFeatureMap != null) {
                oppositeFeatureMap.clear();
            }
            multiResourceEObject.removeFromAllOppositeFeatures();
        }
    }

    public void detachedAll(EObject eObj) {
        if (this.useIDs()) {
            this.detachedAllWithIDs(eObj);
        } else {
            this.basicDetachedAll(eObj);
        }
    }

    public void detached(EObject eObject) {
        this.detachedAll(eObject);
    }

    protected Adapter createModificationTrackingAdapter() {
        return new ResourceImpl.ModificationTrackingAdapter((ResourceImpl)this){

            public void notifyChanged(Notification notification) {
                if (notification instanceof OppositeFeatureNotification) {
                    return;
                }
                super.notifyChanged(notification);
            }
        };
    }

    public void setModified(boolean isModified) {
        super.setModified(isModified);
        if (MultiFileSaveUtil.DEBUG && testResourceLoaded && this.getURI().toString().equals(testResourceURIStr)) {
            System.out.println("isModified=" + isModified);
        }
    }

    public boolean eDeliver() {
        ResourceSet resourceSet = this.getResourceSet();
        if (resourceSet != null && !resourceSet.eDeliver()) {
            return false;
        }
        return super.eDeliver();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void save(Map options) throws IOException {
        Object var7_8;
        if (options == null) {
            options = MultiFileResourceSetImpl.DEFAULT_SAVE_OPTIONS;
        }
        super.save(options);
        MethodElement e = PersistenceUtil.getMethodElement((Resource)this);
        if (!(e instanceof MethodLibrary)) return;
        MethodLibrary lib = (MethodLibrary)e;
        ResourceManager resMgr = MultiFileSaveUtil.getResourceManager((Resource)this);
        if (resMgr != null) {
            Iterator iter = lib.getPredefinedConfigurations().iterator();
            while (iter.hasNext()) {
                MethodConfiguration config = (MethodConfiguration)iter.next();
                ResourceDescriptor resDesc = resMgr.getResourceDescriptor(config.getGuid());
                if (resDesc == null) continue;
                EcoreUtil.remove((EObject)resDesc);
            }
        }
        ArrayList configs = new ArrayList(lib.getPredefinedConfigurations());
        boolean oldDeliver = lib.eDeliver();
        try {
            lib.eSetDeliver(false);
            lib.getPredefinedConfigurations().clear();
            super.save(options);
        }
        catch (Throwable throwable) {
            var7_8 = null;
            lib.getPredefinedConfigurations().addAll(configs);
            lib.eSetDeliver(oldDeliver);
            throw throwable;
        }
        {
            var7_8 = null;
            lib.getPredefinedConfigurations().addAll(configs);
        }
        lib.eSetDeliver(oldDeliver);
    }

    public URI getFinalURI() {
        if (this.finalURI != null) {
            return this.finalURI;
        }
        return this.getURI();
    }

    public void setFinalURI(URI uri) {
        this.finalURI = uri;
    }

    public void backUpURI() {
        this.oldURI = this.getURI();
    }

    public boolean hasTempURI() {
        if (this.currentTxID != null) {
            return this.createTempURI().equals((Object)this.getURI());
        }
        return false;
    }

    private URI createTempURI() {
        MethodElement e = PersistenceUtil.getMethodElement((Resource)this);
        return URI.createFileURI((String)(MultiFileXMIResourceImpl.getTempDir() + File.separator + this.currentTxID + "new" + e.getGuid()));
    }

    private static String getTempDir() {
        if (tempDir == null) {
            tempDir = new File(FileManager.getTempDir(), "EPF").getAbsolutePath();
        }
        return tempDir;
    }

    public void setTempURI(String txID) {
        if (this.finalURI == null) {
            this.finalURI = this.oldURI = this.getURI();
            this.currentTxID = txID;
            URI tempURI = this.createTempURI();
            this.setURI(tempURI);
            MultiFileResourceSetImpl resourceSet = (MultiFileResourceSetImpl)this.getResourceSet();
            resourceSet.getURIToTempURIMap().put(this.oldURI, tempURI);
        }
    }

    private void restoreURI() {
        if (this.oldURI != null) {
            this.setURI(this.oldURI);
        }
    }

    public boolean txStarted() {
        return this.moveStarted() || this.saveStarted();
    }

    protected void updateTimeStamps() {
        this.lastLoadTimeStamp = System.currentTimeMillis();
        this.fileLastModified = new File(this.getURI().toFileString()).lastModified();
    }

    public void txFinished(boolean successful) {
        MultiFileResourceSetImpl resourceSet;
        boolean wasMove;
        boolean bl = wasMove = !this.oldURI.equals((Object)this.finalURI);
        if (successful) {
            this.setURI(this.finalURI);
            this.setModified(false);
            this.updateTimeStamps();
            FileManager.getInstance().refresh((Resource)this);
            if (!wasMove && (resourceSet = (MultiFileResourceSetImpl)this.getResourceSet()) != null) {
                resourceSet.getUnresolvedProxyMarkerManager().validateMarkers((Resource)this);
            }
        } else {
            this.restoreURI();
            if (wasMove) {
                MultiFileSaveUtil.updateURIMappings(this, this.oldURI, null, true);
            }
        }
        if (this.oldURI != null) {
            resourceSet = (MultiFileResourceSetImpl)this.getResourceSet();
            if (resourceSet != null) {
                resourceSet.getURIToTempURIMap().remove(this.oldURI);
            }
            this.oldURI = null;
        }
        this.currentTxID = null;
        this.finalURI = null;
    }

    public void deleteBackup() {
        block3: {
            if (this.backupFile != null) {
                try {
                    new File(this.backupFile).delete();
                    this.backupFile = null;
                }
                catch (Throwable e) {
                    CommonPlugin.INSTANCE.log((Object)e);
                    if (!MultiFileSaveUtil.DEBUG) break block3;
                    e.printStackTrace();
                }
            }
        }
    }

    public boolean restore() {
        File src = null;
        File dest = null;
        boolean moved = false;
        if (this.backupFile != null) {
            src = new File(this.backupFile);
            dest = new File(this.getFinalURI().toFileString());
        } else {
            boolean bl = moved = this.oldURI != null && !this.oldURI.equals((Object)this.finalURI);
            if (moved) {
                File file = new File(this.getFinalURI().toFileString());
                dest = new File(this.oldURI.toFileString());
                boolean bl2 = moved = file.exists() && !dest.exists();
                if (moved) {
                    src = file;
                }
            }
        }
        if (src != null) {
            boolean success;
            if (dest.exists()) {
                FileUtil.moveFile((File)dest, (File)new File(this.getURI().toFileString()));
            }
            if (!(success = moved ? MultiFileSaveUtil.move((Resource)this, src, dest) : FileUtil.moveFile((File)src, (File)dest))) {
                throw new MultiFileIOException(NLS.bind((String)PersistenceResources.restoreResourceError_msg, (Object)((Object)this)));
            }
            return true;
        }
        return false;
    }

    URI getOldURI() {
        return this.oldURI;
    }

    boolean moveStarted() {
        return this.oldURI != null && !this.oldURI.equals((Object)this.getFinalURI());
    }

    boolean saveStarted() {
        return this.currentTxID != null;
    }

    public void commit() {
        if (this.finalURI != null && !this.getContents().isEmpty()) {
            boolean wasMove;
            File finalFile = new File(this.finalURI.toFileString());
            boolean bl = wasMove = !this.oldURI.equals((Object)this.finalURI);
            if (wasMove) {
                MethodElement e = PersistenceUtil.getMethodElement((Resource)this);
                if (e instanceof ContentDescription && finalFile.exists()) {
                    this.finalURI = URI.createFileURI((String)MethodLibraryPersister.getNextAvailableFileName(String.valueOf(finalFile.getParent()) + File.separator, (ContentDescription)e));
                    finalFile = new File(this.finalURI.toFileString());
                }
            } else {
                String backup = this.getBackupFilePath();
                File bakFile = new File(backup);
                if (bakFile.exists()) {
                    bakFile.delete();
                }
                if (finalFile.exists()) {
                    if (FileUtil.moveFile((File)finalFile, (File)bakFile)) {
                        this.backupFile = backup;
                    } else {
                        String msg = NLS.bind((String)PersistenceResources.renameError_msg, (Object)finalFile, (Object)backup);
                        throw new MultiFileIOException(msg);
                    }
                }
            }
            File currentFile = new File(wasMove ? this.oldURI.toFileString() : this.getURI().toFileString());
            boolean success = false;
            success = wasMove ? MultiFileSaveUtil.move((Resource)this, currentFile, finalFile) : FileUtil.moveFile((File)currentFile, (File)finalFile);
            if (!success) {
                String msg = NLS.bind((String)PersistenceResources.renameError_msg, (Object)currentFile, (Object)finalFile);
                throw new MultiFileIOException(msg);
            }
            if (wasMove) {
                ResourceDescriptor desc;
                Object iter;
                ResourceDescriptor resDesc = MultiFileSaveUtil.getResourceDescriptor((Resource)this);
                if (resDesc != null) {
                    resDesc.clearResolvedURI();
                } else {
                    String msg = "FATAL ERROR: no ResourceDescriptor found in parent resource for " + (Object)((Object)this);
                    CommonPlugin.INSTANCE.log((Object)msg);
                    System.err.println(msg);
                }
                HashMap<URI, ResourceDescriptor> oldURIToResourceDescriptorMap = null;
                ResourceManager resMgr = MultiFileSaveUtil.getResourceManager((Resource)this);
                if (resMgr != null) {
                    oldURIToResourceDescriptorMap = new HashMap<URI, ResourceDescriptor>();
                    iter = resMgr.eAllContents();
                    while (iter.hasNext()) {
                        Object obj = iter.next();
                        if (!(obj instanceof ResourceDescriptor)) continue;
                        desc = (ResourceDescriptor)obj;
                        oldURIToResourceDescriptorMap.put(desc.getResolvedURI(), desc);
                        desc.clearResolvedURI();
                    }
                }
                if (oldURIToResourceDescriptorMap != null) {
                    iter = this.getResourceSet().getResources().iterator();
                    while (iter.hasNext()) {
                        Resource res = (Resource)iter.next();
                        desc = (ResourceDescriptor)oldURIToResourceDescriptorMap.get(res.getURI());
                        if (desc == null) continue;
                        res.setURI(desc.getResolvedURI());
                    }
                }
            }
            RefreshJob.getInstance().resourceSaved((Resource)this);
        }
    }

    public String getBackupFilePath() {
        String backupFile = MultiFileXMIResourceImpl.getTempDir() + File.separator + this.currentTxID + "old" + PersistenceUtil.getMethodElement((Resource)this).getGuid();
        return backupFile;
    }

    public long getLastLoadTimeStamp() {
        return this.lastLoadTimeStamp;
    }

    static void clearDetachedEObjectToIDMap() {
        DETACHED_EOBJECT_TO_ID_MAP.clear();
    }

    void setResourceDescriptor(ResourceDescriptor resDesc) {
        this.resourceDescriptor = resDesc;
    }

    private final class ContentTreeIterator
    extends AbstractTreeIterator {
        private static final long serialVersionUID = 1L;

        private ContentTreeIterator(Object object) {
            super(object);
        }

        protected Iterator getChildren(Object object) {
            if (object instanceof EObject) {
                ArrayList<EObject> children = new ArrayList<EObject>();
                EContentsEList contents = new EContentsEList(this, (EObject)object){
                    final /* synthetic */ ContentTreeIterator this$1;
                    {
                        this.this$1 = contentTreeIterator;
                    }

                    protected boolean resolve() {
                        return false;
                    }
                };
                Iterator iter = contents.basicIterator();
                while (iter.hasNext()) {
                    EObject o = (EObject)iter.next();
                    if (o.eResource() != MultiFileXMIResourceImpl.this && !o.eIsProxy()) continue;
                    children.add(o);
                }
                return children.iterator();
            }
            return Collections.EMPTY_LIST.iterator();
        }
    }
}

