/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.common.serviceability;

import java.io.File;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.epf.common.CommonPlugin;
import org.eclipse.epf.common.serviceability.EPFVersion;
import org.eclipse.epf.common.serviceability.EPFVersions;
import org.eclipse.epf.common.serviceability.ILibraryExtensionVersionCheck;
import org.eclipse.epf.common.utils.FileUtil;
import org.eclipse.epf.common.utils.StrUtil;
import org.osgi.framework.Bundle;
import org.osgi.framework.Version;

public class VersionUtil {
    public static final String EXTENSION_POINT_NAMESPACE;
    public static final String EXTENSION_POINT_NAME = "version";
    public static final String EXTENSION_VERSIONS_INFO = "versions";
    public static final String EXTENSION_LIB_EXTENSION_CHECK = "libraryExtensionVersionCheck";
    private static final String DEFAULT_TOOL_ID = "epf";
    public static Map versions;
    public static Map libExtCheckers;
    protected static boolean versionCheckingEnabled;
    private static String primaryToolID;
    public static final Pattern p_XMIVersionPattern;
    public static final Pattern p_XMLVersionAttributePattern;
    public static final Pattern p_XMI_ELEMENT_START_TAG;
    public static final String XML_ELEMENT_END_TAG = ">";
    public static final String XMI_ATTRIBUTE_TAG = "xmi";
    public static final String XML_ELEMENT_START_TAG = "<uma:MethodLibrary";
    public static final String XML_VERSIONS_SEPARATOR = ";";
    public static final String XML_TOOL_VERSION_SEPARATOR = "=";
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.epf.common.CommonPlugin");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        EXTENSION_POINT_NAMESPACE = clazz.getPackage().getName();
        versions = new LinkedHashMap();
        libExtCheckers = new LinkedHashMap();
        versionCheckingEnabled = true;
        primaryToolID = DEFAULT_TOOL_ID;
        try {
            Class<?> clazz2 = class$1;
            if (clazz2 == null) {
                try {
                    clazz2 = class$1 = Class.forName("org.eclipse.epf.common.serviceability.VersionUtil");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            ResourceBundle resourceBundle = ResourceBundle.getBundle(String.valueOf(clazz2.getPackage().getName()) + ".VersionUtil");
            versionCheckingEnabled = Boolean.valueOf(resourceBundle.getString("versionCheckingEnabled"));
        }
        catch (MissingResourceException missingResourceException) {
            versionCheckingEnabled = true;
        }
        IExtensionRegistry extensionRegistry = Platform.getExtensionRegistry();
        IExtensionPoint extensionPoint = extensionRegistry.getExtensionPoint(EXTENSION_POINT_NAMESPACE, EXTENSION_POINT_NAME);
        if (extensionPoint != null) {
            IExtension[] extensions = extensionPoint.getExtensions();
            int i = 0;
            while (i < extensions.length) {
                IExtension extension = extensions[i];
                VersionUtil.initExtension(extension);
                ++i;
            }
        }
        p_XMIVersionPattern = Pattern.compile("(\\w+?):version=\"(.+?)\"", 32);
        p_XMLVersionAttributePattern = Pattern.compile("tool=\"(.*?)\"", 32);
        p_XMI_ELEMENT_START_TAG = Pattern.compile("<?xml version=\".+?\" encoding=\".+?\"?>");
    }

    protected static void initExtension(IExtension extension) {
        String extensionID = extension.getSimpleIdentifier();
        String pluginId = extension.getNamespaceIdentifier();
        Bundle bundle = Platform.getBundle((String)pluginId);
        IConfigurationElement[] configElements = extension.getConfigurationElements();
        int j = 0;
        while (j < configElements.length) {
            IConfigurationElement configElement = configElements[j];
            try {
                String className;
                if (EXTENSION_VERSIONS_INFO.equals(configElement.getName()) && (className = configElement.getAttribute("class")) != null) {
                    versions.put(extensionID, (EPFVersions)bundle.loadClass(className).newInstance());
                    break;
                }
                if (EXTENSION_LIB_EXTENSION_CHECK.equals(configElement.getName()) && (className = configElement.getAttribute("class")) != null) {
                    libExtCheckers.put(extensionID, (ILibraryExtensionVersionCheck)bundle.loadClass(className).newInstance());
                    break;
                }
            }
            catch (Exception e) {
                CommonPlugin.getDefault().getLogger().logError(e);
            }
            ++j;
        }
    }

    public static Map getVersionsMap() {
        return Collections.unmodifiableMap(versions);
    }

    public static Set getAllToolIDs() {
        return Collections.unmodifiableSet(versions.keySet());
    }

    public static EPFVersions getVersions(String toolID) {
        return (EPFVersions)versions.get(toolID);
    }

    public static boolean isVersionCheckingEnabled() {
        return versionCheckingEnabled;
    }

    protected static Map readVersionsFromXMLFile(File xmlFile) {
        String toolsAttribute;
        String rootElement;
        Matcher mAttribute;
        int xmiElementEndIdx;
        int xmiElementStartIdx;
        LinkedHashMap<String, String> versions = new LinkedHashMap<String, String>();
        StringBuffer buf = null;
        try {
            buf = FileUtil.readFile(xmlFile, "UTF-8");
        }
        catch (Exception ex) {
            CommonPlugin.getDefault().getLogger().logError(ex);
        }
        if (buf != null && (xmiElementStartIdx = buf.indexOf(XML_ELEMENT_START_TAG)) != -1 && (xmiElementEndIdx = buf.indexOf(XML_ELEMENT_END_TAG, xmiElementStartIdx + XML_ELEMENT_START_TAG.length())) != -1 && (mAttribute = p_XMLVersionAttributePattern.matcher(rootElement = buf.substring(xmiElementStartIdx, xmiElementEndIdx))).find() && (toolsAttribute = mAttribute.group(1)) != null && toolsAttribute.length() > 0) {
            String[] versionsArray = StrUtil.split(toolsAttribute, XML_VERSIONS_SEPARATOR);
            int i = 0;
            while (i < versionsArray.length) {
                String[] versionInfoArray;
                if (versionsArray[i] != null && versionsArray[i].length() > 0 && (versionInfoArray = StrUtil.split(versionsArray[i], XML_TOOL_VERSION_SEPARATOR)).length == 2) {
                    String toolID = versionInfoArray[0];
                    String toolVersion = versionInfoArray[1];
                    if (toolID != null && toolID.trim().length() > 0 && toolVersion != null && toolVersion.trim().length() > 0) {
                        versions.put(toolID, toolVersion);
                    }
                }
                ++i;
            }
        }
        if (versions.size() == 0) {
            return null;
        }
        return versions;
    }

    protected static Map readVersionsFromXMIFile(File xmiFile) {
        int docHeaderEndIdx;
        int xmiElementEndIdx;
        Matcher docStartMatcher;
        LinkedHashMap<String, String> versions = new LinkedHashMap<String, String>();
        StringBuffer buf = null;
        try {
            buf = FileUtil.readFile(xmiFile, "UTF-8");
        }
        catch (Exception ex) {
            CommonPlugin.getDefault().getLogger().logError(ex);
        }
        if (buf != null && (docStartMatcher = p_XMI_ELEMENT_START_TAG.matcher(buf)).find() && (xmiElementEndIdx = buf.indexOf(XML_ELEMENT_END_TAG, docHeaderEndIdx = docStartMatcher.end())) != -1) {
            String rootElement = buf.substring(docHeaderEndIdx, xmiElementEndIdx + 1);
            Matcher m = p_XMIVersionPattern.matcher(rootElement);
            while (m.find()) {
                String toolID = m.group(1);
                if (toolID.equals(XMI_ATTRIBUTE_TAG)) continue;
                String toolVersion = m.group(2);
                if (toolID == null || toolID.trim().length() <= 0 || toolVersion == null || toolVersion.trim().length() <= 0) continue;
                versions.put(toolID, toolVersion);
            }
        }
        if (versions.size() == 0) {
            return null;
        }
        return versions;
    }

    public static Map readVersionsFromFile(File file) {
        if (file.getName().toUpperCase().endsWith("XMI")) {
            return VersionUtil.readVersionsFromXMIFile(file);
        }
        if (file.getName().toUpperCase().endsWith("XML")) {
            return VersionUtil.readVersionsFromXMLFile(file);
        }
        Map versions = VersionUtil.readVersionsFromXMIFile(file);
        if (versions != null) {
            return versions;
        }
        versions = VersionUtil.readVersionsFromXMLFile(file);
        if (versions != null) {
            return versions;
        }
        return null;
    }

    public static VersionCheckInfo checkXMLVersion(File file) {
        String defaultToolVersion;
        String primaryToolVersion;
        Map versionMap = VersionUtil.readVersionsFromFile(file);
        if (versionMap == null) {
            return null;
        }
        VersionCheckInfo vci = null;
        if (versionMap.get(primaryToolID) != null && (vci = VersionUtil._checkXMLVersion(primaryToolID, primaryToolVersion = (String)versionMap.get(primaryToolID))) != null) {
            return vci;
        }
        if (!DEFAULT_TOOL_ID.equals(primaryToolID) && versionMap.get(DEFAULT_TOOL_ID) != null && (vci = VersionUtil._checkXMLVersion(DEFAULT_TOOL_ID, defaultToolVersion = (String)versionMap.get(DEFAULT_TOOL_ID))) != null) {
            return vci;
        }
        return null;
    }

    private static VersionCheckInfo _checkXMLVersion(String toolID, String toolVersion) {
        EPFVersions versions = VersionUtil.getVersions(toolID);
        if (versions != null) {
            EPFVersion minCurrVersion = versions.getMinToolVersionForCurrentXMLSchemaVersion();
            int result = minCurrVersion.compareToolVersionTo(new Version(toolVersion));
            String currentMinToolVersion = minCurrVersion.getToolVersion().toString();
            return new VersionCheckInfo(toolID, toolVersion, currentMinToolVersion, -result);
        }
        return null;
    }

    public static VersionCheckInfo checkLibraryVersion(File file) {
        String defaultToolVersion;
        String primaryToolVersion;
        Map versionMap;
        if (file.getName().equals("library.xmi")) {
            ILibraryExtensionVersionCheck extCheck;
            VersionCheckInfo vci;
            if (libExtCheckers.get(primaryToolID) != null) {
                vci = null;
                extCheck = (ILibraryExtensionVersionCheck)libExtCheckers.get(primaryToolID);
                vci = extCheck.checkLibraryVersion(file.getParentFile());
                if (vci != null) {
                    return vci;
                }
            }
            if (!DEFAULT_TOOL_ID.equals(primaryToolID) && libExtCheckers.get(DEFAULT_TOOL_ID) != null) {
                vci = null;
                extCheck = (ILibraryExtensionVersionCheck)libExtCheckers.get(DEFAULT_TOOL_ID);
                vci = extCheck.checkLibraryVersion(file.getParentFile());
                if (vci != null) {
                    return vci;
                }
            }
        }
        if ((versionMap = VersionUtil.readVersionsFromFile(file)) == null) {
            return null;
        }
        VersionCheckInfo vci = null;
        if (versionMap.get(primaryToolID) != null && (vci = VersionUtil._checkLibVersion(primaryToolID, primaryToolVersion = (String)versionMap.get(primaryToolID))) != null) {
            return vci;
        }
        if (!DEFAULT_TOOL_ID.equals(primaryToolID) && versionMap.get(DEFAULT_TOOL_ID) != null && (vci = VersionUtil._checkLibVersion(DEFAULT_TOOL_ID, defaultToolVersion = (String)versionMap.get(DEFAULT_TOOL_ID))) != null) {
            return vci;
        }
        return null;
    }

    private static VersionCheckInfo _checkLibVersion(String toolID, String toolVersion) {
        EPFVersions versions = VersionUtil.getVersions(toolID);
        if (versions != null) {
            EPFVersion minCurrVersion = versions.getMinToolVersionForCurrentLibraryVersion();
            int result = minCurrVersion.compareToolVersionTo(new Version(toolVersion));
            String currentMinToolVersion = minCurrVersion.getToolVersion().toString();
            return new VersionCheckInfo(toolID, toolVersion, currentMinToolVersion, -result);
        }
        return null;
    }

    public static String getPrimaryToolID() {
        return primaryToolID;
    }

    public static void setPrimaryToolID(String primaryToolID) {
        VersionUtil.primaryToolID = primaryToolID;
    }

    public static class VersionCheckInfo {
        public String toolID;
        public String toolVersion;
        public String currentMinToolVersion;
        public int result;

        public VersionCheckInfo(String id, String toolVersion, String currentMinToolVersion, int result) {
            this.toolID = id;
            this.toolVersion = toolVersion;
            this.currentMinToolVersion = currentMinToolVersion;
            this.result = result;
        }
    }
}

