/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.authoring.ui.actions;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.command.PasteFromClipboardCommand;
import org.eclipse.emf.edit.ui.action.PasteAction;
import org.eclipse.epf.authoring.ui.AuthoringUIPlugin;
import org.eclipse.epf.authoring.ui.actions.ILibraryAction;
import org.eclipse.epf.authoring.ui.actions.LibraryLockingOperationRunner;
import org.eclipse.epf.common.serviceability.MsgBox;
import org.eclipse.epf.library.edit.ui.UserInteractionHelper;
import org.eclipse.epf.uma.MethodPlugin;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;

public class LibraryViewPasteAction
extends PasteAction
implements ILibraryAction {
    private IProgressMonitor progressMonitor;

    public void run() {
        LibraryLockingOperationRunner runner = new LibraryLockingOperationRunner();
        runner.setProgressMonitor(this.getProgressMonitor());
        runner.run(new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                LibraryViewPasteAction.this.performPaste();
            }
        });
    }

    protected void performPaste() {
        if (this.command instanceof PasteFromClipboardCommand) {
            IStatus status;
            PasteFromClipboardCommand cmd = (PasteFromClipboardCommand)this.command;
            Object owner = cmd.getOwner();
            if (owner instanceof Adapter) {
                owner = ((Adapter)owner).getTarget();
            }
            if (owner instanceof EObject && !(status = UserInteractionHelper.checkModify((EObject)((EObject)owner), (Shell)MsgBox.getDefaultShell())).isOK()) {
                AuthoringUIPlugin.getDefault().getMsgDialog().displayError(this.getText(), null, status);
                return;
            }
        }
        if (this.command == null) {
            return;
        }
        super.run();
    }

    public boolean updateSelection(IStructuredSelection selection) {
        if (selection.size() < 1) {
            return false;
        }
        Object[] objs = selection.toArray();
        int i = 0;
        while (i < objs.length) {
            if (objs[i] instanceof MethodPlugin) {
                return false;
            }
            ++i;
        }
        return super.updateSelection(selection);
    }

    public void notifyPropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    public void setProgressMonitor(IProgressMonitor monitor) {
        this.progressMonitor = monitor;
    }

    protected IProgressMonitor getProgressMonitor() {
        if (this.progressMonitor == null) {
            this.progressMonitor = new NullProgressMonitor();
        }
        return this.progressMonitor;
    }
}

