/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.authoring.ui.dialogs;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.epf.authoring.ui.AuthoringUIPlugin;
import org.eclipse.epf.authoring.ui.AuthoringUIResources;
import org.eclipse.epf.authoring.ui.views.ViewHelper;
import org.eclipse.epf.common.serviceability.MsgDialog;
import org.eclipse.epf.library.LibraryService;
import org.eclipse.epf.library.edit.TngAdapterFactory;
import org.eclipse.epf.library.edit.TransientGroupItemProvider;
import org.eclipse.epf.library.edit.category.StandardCategoriesItemProvider;
import org.eclipse.epf.library.edit.command.MethodElementAddCommand;
import org.eclipse.epf.library.edit.ui.UserInteractionHelper;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.uma.ContentCategory;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.wizard.ProgressMonitorPart;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class MoveDialog
extends Dialog
implements ISelectionChangedListener {
    private TreeViewer treeViewer;
    private Collection elements;
    private boolean lockedUI = false;
    private ProgressMonitorPart progressMonitorPart;
    private EditingDomain editingDomain;
    private Object destination;
    private Cursor waitCursor;
    private boolean moving;

    public MoveDialog(Shell parentShell, Collection elementsToMove, EditingDomain editingDomain) {
        super(parentShell);
        this.editingDomain = editingDomain;
        this.elements = new ArrayList();
        Iterator iter = elementsToMove.iterator();
        while (iter.hasNext()) {
            Object element = iter.next();
            Object e = TngUtil.unwrap(element);
            if (e instanceof MethodElement && TngUtil.isPredefined((MethodElement)((MethodElement)e))) continue;
            this.elements.add(element);
        }
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        GridLayout layout = (GridLayout)composite.getLayout();
        layout.marginWidth = 10;
        layout.marginHeight = 10;
        Label label = new Label(composite, 0);
        label.setText(AuthoringUIResources.MoveDialog_destination_text);
        GridData layoutData = new GridData(1);
        label.setLayoutData((Object)layoutData);
        this.treeViewer = new TreeViewer(composite, 2820);
        ComposedAdapterFactory adapterFactory = TngAdapterFactory.INSTANCE.getNavigatorView_ComposedAdapterFactory();
        this.treeViewer.setLabelProvider((IBaseLabelProvider)new AdapterFactoryLabelProvider((AdapterFactory)adapterFactory));
        this.treeViewer.setContentProvider((IContentProvider)new AdapterFactoryContentProvider((AdapterFactory)adapterFactory));
        this.treeViewer.addSelectionChangedListener((ISelectionChangedListener)this);
        GridData spec = new GridData(1808);
        spec.widthHint = 300;
        spec.heightHint = 300;
        this.treeViewer.getControl().setLayoutData((Object)spec);
        this.treeViewer.setInput((Object)LibraryService.getInstance().getCurrentMethodLibrary());
        GridLayout pmlayout = new GridLayout();
        pmlayout.numColumns = 1;
        this.progressMonitorPart = this.createProgressMonitorPart(composite, pmlayout);
        this.progressMonitorPart.setLayoutData((Object)new GridData(768));
        this.progressMonitorPart.setVisible(false);
        this.waitCursor = parent.getShell().getDisplay().getSystemCursor(1);
        return composite;
    }

    protected ProgressMonitorPart createProgressMonitorPart(Composite composite, GridLayout pmlayout) {
        return new ProgressMonitorPart(composite, (Layout)pmlayout, -1){
            String currentTask = null;

            public void setBlocked(IStatus reason) {
                super.setBlocked(reason);
                if (!MoveDialog.this.lockedUI) {
                    MoveDialog.getBlockedHandler().showBlocked(this.getShell(), (IProgressMonitor)this, reason, this.currentTask);
                }
            }

            public void clearBlocked() {
                super.clearBlocked();
                if (!MoveDialog.this.lockedUI) {
                    MoveDialog.getBlockedHandler().clearBlocked();
                }
            }

            public void beginTask(String name, int totalWork) {
                super.beginTask(name, totalWork);
                this.currentTask = name;
            }

            public void setTaskName(String name) {
                super.setTaskName(name);
                this.currentTask = name;
            }

            public void subTask(String name) {
                super.subTask(name);
                if (this.currentTask == null) {
                    this.currentTask = name;
                }
            }
        };
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(AuthoringUIResources.MoveDialog_move_text);
    }

    public void selectionChanged(SelectionChangedEvent event) {
        this.destination = TngUtil.unwrap((Object)((IStructuredSelection)event.getSelection()).getFirstElement());
    }

    protected void okPressed() {
        if (this.doMove()) {
            super.okPressed();
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean isValidDestination() {
        boolean result;
        if (this.destination instanceof ContentCategory) {
            return false;
        }
        if (this.destination instanceof StandardCategoriesItemProvider) {
            return false;
        }
        Command addCommand = AddCommand.create((EditingDomain)this.editingDomain, (Object)this.destination, null, (Collection)this.elements);
        try {
            result = addCommand.canExecute();
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            addCommand.dispose();
            throw throwable;
        }
        {
            Object var3_5 = null;
        }
        addCommand.dispose();
        if (!result) {
            return false;
        }
        if (this.destination instanceof TransientGroupItemProvider) {
            this.destination = ((TransientGroupItemProvider)this.destination).getTarget();
        }
        return true;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean doMove() {
        IStatus status;
        if (this.destination == null) {
            String title = AuthoringUIResources.errorDialog_title;
            String problem = AuthoringUIResources.MoveDialog_nomove_destination_problem_msg;
            String msg = AuthoringUIResources.MoveDialog_selectdestination_text;
            MsgDialog dialog = AuthoringUIPlugin.getDefault().getMsgDialog();
            dialog.displayError(title, problem, msg);
            return false;
        }
        if (!this.isValidDestination()) {
            String title = AuthoringUIResources.errorDialog_title;
            String problem = AuthoringUIResources.MoveDialog_invalid_move_destination_problem_msg;
            String msg = AuthoringUIResources.MoveDialog_validdestination_text;
            MsgDialog dialog = AuthoringUIPlugin.getDefault().getMsgDialog();
            dialog.displayError(title, problem, msg);
            return false;
        }
        IStatus status2 = UserInteractionHelper.checkModify((EObject)((EObject)this.destination), (Shell)this.getShell());
        if (!status2.isOK()) {
            String title = AuthoringUIResources.errorDialog_title;
            String msg = AuthoringUIResources.MoveDialog_cannotModifyDestination;
            MsgDialog dialog = AuthoringUIPlugin.getDefault().getMsgDialog();
            dialog.displayError(title, msg, status2);
            return false;
        }
        this.moving = true;
        Shell shell = this.getShell();
        shell.setCursor(this.waitCursor);
        this.getButton(0).setEnabled(false);
        this.getButton(1).setEnabled(false);
        this.treeViewer.getControl().setEnabled(false);
        this.progressMonitorPart.setVisible(true);
        this.progressMonitorPart.beginTask(AuthoringUIResources.MoveDialog_moving_text, -1);
        MethodElementAddCommand.MoveOperation moveOp = null;
        try {
            Command command = AddCommand.create((EditingDomain)this.editingDomain, (Object)this.destination, null, (Collection)this.elements);
            moveOp = new MethodElementAddCommand.MoveOperation(command, (IProgressMonitor)this.progressMonitorPart, shell);
            moveOp.run();
        }
        catch (Throwable throwable) {
            Object dialog = null;
            this.moving = false;
            this.progressMonitorPart.done();
            if (shell != null && !shell.isDisposed()) {
                shell.setCursor(null);
            }
            throw throwable;
        }
        {
            Object dialog = null;
            this.moving = false;
        }
        this.progressMonitorPart.done();
        if (shell != null && !shell.isDisposed()) {
            shell.setCursor(null);
        }
        if (moveOp != null && !(status = moveOp.getStatus()).isOK()) {
            String title = AuthoringUIResources.dialogs_MoveDialog_errorTitle;
            String message = AuthoringUIResources.dialogs_MoveDialog_errorMessage;
            AuthoringUIPlugin.getDefault().getMsgDialog().displayError(title, message, status);
            if (moveOp.reloadNeeded()) {
                ViewHelper.reloadCurrentLibrary(shell, null);
            }
        }
        return true;
    }

    public boolean close() {
        if (this.moving) {
            return false;
        }
        return super.close();
    }
}

