/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.authoring.ui.properties;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.ItemProviderAdapter;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.epf.authoring.ui.AuthoringUIPlugin;
import org.eclipse.epf.authoring.ui.properties.OBSRelationSection;
import org.eclipse.epf.authoring.ui.properties.PropertiesResources;
import org.eclipse.epf.common.serviceability.MsgDialog;
import org.eclipse.epf.library.edit.TngAdapterFactory;
import org.eclipse.epf.library.edit.process.RoleDescriptorWrapperItemProvider;
import org.eclipse.epf.library.edit.util.ProcessUtil;
import org.eclipse.epf.uma.Activity;
import org.eclipse.epf.uma.BreakdownElement;
import org.eclipse.epf.uma.CompositeRole;
import org.eclipse.epf.uma.Role;
import org.eclipse.epf.uma.RoleDescriptor;
import org.eclipse.epf.uma.TeamProfile;
import org.eclipse.epf.uma.UmaPackage;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ListSelectionDialog;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;

public class RoleDescriptorTeamSection
extends OBSRelationSection {
    private Image titleImage = null;
    static /* synthetic */ Class class$0;

    public void createControls(Composite parent, TabbedPropertySheetPage tabbedPropertySheetPage) {
        super.createControls(parent, tabbedPropertySheetPage);
    }

    protected void initContentProvider() {
        this.contentProvider = new AdapterFactoryContentProvider((AdapterFactory)TngAdapterFactory.INSTANCE.getNavigatorView_ComposedAdapterFactory()){

            public Object[] getElements(Object object) {
                return RoleDescriptorTeamSection.this.getSelectedTeams((EObject)RoleDescriptorTeamSection.this.element).toArray();
            }
        };
        this.viewer.setContentProvider((IContentProvider)this.contentProvider);
    }

    protected void init() {
        super.init();
        this.element = (RoleDescriptor)this.element;
        this.setTabData(PropertiesResources.RoleDescriptor_Team_SectionTitle, PropertiesResources.RoleDescriptor_Team_SectionDescription, PropertiesResources.RoleDescriptor_Team_Table1);
    }

    public void refresh() {
        try {
            if (this.getElement() instanceof RoleDescriptor) {
                super.refresh();
                this.element = (RoleDescriptor)this.getElement();
                this.viewer.refresh();
            }
        }
        catch (Exception ex) {
            this.logger.logError("Error refreshing Role Descriptor team section ", (Throwable)ex);
        }
    }

    private void add(Object[] items) {
        if (items != null) {
            int i = 0;
            while (i < items.length) {
                TeamProfile team = (TeamProfile)items[i];
                if (this.element instanceof CompositeRole) {
                    CompositeRole compRole = ProcessUtil.createCompositeRole((CompositeRole)((CompositeRole)this.element));
                    this.actionMgr.doAction(3, (EObject)team, (EStructuralFeature)UmaPackage.eINSTANCE.getTeamProfile_TeamRoles(), (Object)compRole, -1);
                } else if (this.element instanceof RoleDescriptor) {
                    Role role = ((RoleDescriptor)this.element).getRole();
                    if (role != null) {
                        if (!this.isPartOfTeam(role, team)) {
                            RoleDescriptor roleDesc = ProcessUtil.createRoleDescriptor((Role)role);
                            this.actionMgr.doAction(3, (EObject)team, (EStructuralFeature)UmaPackage.eINSTANCE.getTeamProfile_TeamRoles(), (Object)roleDesc, -1);
                        }
                    } else {
                        MessageFormat mf = new MessageFormat(PropertiesResources.Process_TeamAssignError);
                        Object[] args = new Object[]{this.element.getName(), team.getName()};
                        String message = mf.format(args);
                        String title = this.getEditor().getTitle();
                        MsgDialog dialog = AuthoringUIPlugin.getDefault().getMsgDialog();
                        dialog.displayError(title, message, "");
                        return;
                    }
                }
                this.actionMgr.doAction(3, (EObject)team, (EStructuralFeature)UmaPackage.eINSTANCE.getTeamProfile_TeamRoles(), (Object)this.element, -1);
                ++i;
            }
        }
    }

    protected void remove(ArrayList rmItems) {
        if (!rmItems.isEmpty()) {
            Iterator itor = rmItems.iterator();
            while (itor.hasNext()) {
                TeamProfile team = (TeamProfile)itor.next();
                Role role = ((RoleDescriptor)this.element).getRole();
                this.actionMgr.doAction(4, (EObject)team, (EStructuralFeature)UmaPackage.eINSTANCE.getTeamProfile_TeamRoles(), (Object)this.element, -1);
                List teamRoles = team.getTeamRoles();
                ArrayList<RoleDescriptor> roleDescList = new ArrayList<RoleDescriptor>();
                int i = 0;
                while (i < teamRoles.size()) {
                    RoleDescriptor roleDesc = (RoleDescriptor)teamRoles.get(i);
                    if (roleDesc.getRole().equals(role)) {
                        roleDescList.add(roleDesc);
                    }
                    ++i;
                }
                if (roleDescList.size() != 1) continue;
                this.actionMgr.doAction(4, (EObject)team, (EStructuralFeature)UmaPackage.eINSTANCE.getTeamProfile_TeamRoles(), (Object)((RoleDescriptor)roleDescList.get(0)), -1);
            }
        }
    }

    private boolean isPartOfTeam(Role role, TeamProfile team) {
        List teamRoles = team.getTeamRoles();
        ArrayList<Role> roles = new ArrayList<Role>();
        Iterator itor = teamRoles.iterator();
        while (itor.hasNext()) {
            RoleDescriptor roleDesc = (RoleDescriptor)itor.next();
            roles.add(roleDesc.getRole());
        }
        return roles.contains(role);
    }

    protected void openAddDialog() {
        AdapterFactoryContentProvider teamContentProvider = new AdapterFactoryContentProvider((AdapterFactory)TngAdapterFactory.INSTANCE.getNavigatorView_ComposedAdapterFactory()){

            public Object[] getElements(Object object) {
                List items = RoleDescriptorTeamSection.this.getTeams();
                items.removeAll(RoleDescriptorTeamSection.this.getSelectedTeams((EObject)RoleDescriptorTeamSection.this.element));
                return items.toArray();
            }
        };
        AdapterFactoryLabelProvider teamLabelProvider = new AdapterFactoryLabelProvider((AdapterFactory)TngAdapterFactory.INSTANCE.getOBS_ComposedAdapterFactory());
        ListSelectionDialog dlg = new ListSelectionDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (Object)this.element, (IStructuredContentProvider)teamContentProvider, (ILabelProvider)teamLabelProvider, PropertiesResources.Process_TeamDialogMessage);
        this.titleImage = Display.getCurrent().getActiveShell().getImage();
        ListSelectionDialog.setDefaultImage((Image)this.titleImage);
        dlg.setTitle(PropertiesResources.Process_TeamDialogTitle);
        dlg.setBlockOnOpen(true);
        dlg.open();
        this.add(dlg.getResult());
    }

    public void dispose() {
        super.dispose();
        if (this.contentProvider != null) {
            this.contentProvider.dispose();
        }
    }

    protected Object getParent(BreakdownElement element) {
        ComposedAdapterFactory aFactory = TngAdapterFactory.INSTANCE.getOBS_ComposedAdapterFactory();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.emf.edit.provider.ITreeItemContentProvider");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ItemProviderAdapter adapter = (ItemProviderAdapter)aFactory.adapt((Notifier)element, (Object)clazz);
        Object parent = adapter.getParent((Object)element);
        return parent;
    }

    private List getTeams() {
        ArrayList<TeamProfile> items = new ArrayList<TeamProfile>();
        Object parent = this.getParent(this.element);
        while (parent != null) {
            if (parent instanceof Activity) {
                Activity act = (Activity)parent;
                List breakdownElements = act.getBreakdownElements();
                Iterator it = breakdownElements.iterator();
                while (it.hasNext()) {
                    BreakdownElement element = (BreakdownElement)it.next();
                    if (!(element instanceof TeamProfile)) continue;
                    TeamProfile team = (TeamProfile)element;
                    items.add(team);
                    List subTeams = team.getSubTeam();
                    items.addAll(subTeams);
                }
            }
            parent = this.getParent((BreakdownElement)parent);
        }
        return items;
    }

    private List getSelectedTeams(EObject object) {
        Object input = this.getInput();
        if (input instanceof RoleDescriptorWrapperItemProvider) {
            return ProcessUtil.getTeamProfiles((RoleDescriptorWrapperItemProvider)((RoleDescriptorWrapperItemProvider)input));
        }
        RoleDescriptor roleDesc = (RoleDescriptor)object;
        return ProcessUtil.getTeamProfiles((RoleDescriptor)roleDesc, (AdapterFactory)this.getAdapterFactory());
    }
}

