/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.authoring.ui.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.epf.authoring.ui.AuthoringUIPlugin;
import org.eclipse.epf.authoring.ui.AuthoringUIResources;
import org.eclipse.epf.authoring.ui.editors.MethodElementEditor;
import org.eclipse.epf.authoring.ui.views.ConfigurationView;
import org.eclipse.epf.authoring.ui.views.LibraryView;
import org.eclipse.epf.library.ILibraryManager;
import org.eclipse.epf.library.LibraryService;
import org.eclipse.epf.persistence.refresh.IRefreshHandler;
import org.eclipse.epf.persistence.refresh.RefreshJob;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.dialogs.ListSelectionDialog;

public class RefreshHandler
implements IRefreshHandler {
    private LibraryView libView;

    public void refresh(final IProgressMonitor monitor) {
        this.libView = LibraryView.getView();
        Viewer viewer = this.libView != null ? this.libView.getViewer() : null;
        Control ctrl = viewer.getControl();
        if (ctrl == null || ctrl.isDisposed()) {
            return;
        }
        if (ctrl.getDisplay().getThread() == Thread.currentThread()) {
            this.doRefresh(monitor);
        } else {
            ctrl.getDisplay().asyncExec(new Runnable(){

                public void run() {
                    RefreshHandler.this.doRefresh(monitor);
                }
            });
        }
    }

    private void doRefresh(IProgressMonitor monitor) {
        if (!RefreshJob.getInstance().getRemovedResources().isEmpty()) {
            ArrayList removedResources = new ArrayList(RefreshJob.getInstance().getRemovedResources());
            this.handleRemovedResources(removedResources);
            RefreshJob.getInstance().getRemovedResources().removeAll(removedResources);
        }
        if (!RefreshJob.getInstance().getChangedResources().isEmpty()) {
            ArrayList changedResources = new ArrayList(RefreshJob.getInstance().getChangedResources());
            this.handleChangedResources(changedResources);
            RefreshJob.getInstance().getChangedResources().removeAll(changedResources);
        }
    }

    private Collection handleRemovedResources(Collection removedResources) {
        return removedResources;
    }

    private Collection handleChangedResources(Collection changedResources) {
        Control ctrl = this.libView.getViewer().getControl();
        if (ctrl == null || ctrl.isDisposed()) {
            return Collections.EMPTY_LIST;
        }
        IWorkbenchPage workbenchPage = this.libView.getSite().getPage();
        Shell shell = AuthoringUIPlugin.getDefault().getWorkbench().getDisplay().getActiveShell();
        IEditorReference[] editorReferences = workbenchPage.getEditorReferences();
        ArrayList<IEditorPart> dirtyEditorsWithConflict = new ArrayList<IEditorPart>();
        ArrayList changedResourceList = new ArrayList(changedResources);
        int i = 0;
        while (i < editorReferences.length) {
            IEditorReference reference = editorReferences[i];
            IEditorPart editor = reference.getEditor(true);
            if (editor instanceof MethodElementEditor && editor.isDirty()) {
                Collection usedResources = ((MethodElementEditor)editor).getUsedResources();
                int j = 0;
                while (j < changedResourceList.size()) {
                    Resource resource = (Resource)changedResourceList.get(j);
                    if (usedResources.contains(resource)) {
                        dirtyEditorsWithConflict.add(editor);
                        break;
                    }
                    ++j;
                }
            }
            ++i;
        }
        final ArrayList<Object> editorsToRefresh = new ArrayList<Object>();
        if (!dirtyEditorsWithConflict.isEmpty()) {
            Object editor;
            IStructuredContentProvider contentProvider = new IStructuredContentProvider(){
                List fContents;

                public Object[] getElements(Object inputElement) {
                    if (this.fContents != null && this.fContents == inputElement) {
                        return this.fContents.toArray();
                    }
                    return new Object[0];
                }

                public void dispose() {
                }

                public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
                    this.fContents = newInput instanceof List ? (List)newInput : null;
                }
            };
            LabelProvider labelProvider = new LabelProvider(){

                public String getText(Object element) {
                    if (element instanceof IEditorPart) {
                        return ((IEditorPart)element).getTitle();
                    }
                    return super.getText(element);
                }

                public Image getImage(Object element) {
                    if (element instanceof IEditorPart) {
                        return ((IEditorPart)element).getTitleImage();
                    }
                    return super.getImage(element);
                }
            };
            String title = AuthoringUIResources._UI_FileConflict_label;
            String msg = AuthoringUIResources._WARN_FileConflict;
            ListSelectionDialog dlg = new ListSelectionDialog(shell, dirtyEditorsWithConflict, contentProvider, (ILabelProvider)labelProvider, msg);
            dlg.setTitle(title);
            dlg.setBlockOnOpen(true);
            dlg.open();
            Object[] result = dlg.getResult();
            int i2 = 0;
            while (i2 < result.length) {
                editor = result[i2];
                editorsToRefresh.add(editor);
                dirtyEditorsWithConflict.remove(editor);
                ++i2;
            }
            i2 = 0;
            while (i2 < dirtyEditorsWithConflict.size()) {
                editor = (MethodElementEditor)((Object)dirtyEditorsWithConflict.get(i2));
                Collection usedResources = ((MethodElementEditor)((Object)editor)).getUsedResources();
                changedResourceList.removeAll(usedResources);
                ++i2;
            }
        }
        if (!changedResourceList.isEmpty()) {
            int i3 = 0;
            while (i3 < editorReferences.length) {
                IEditorReference reference = editorReferences[i3];
                IEditorPart editor = reference.getEditor(true);
                if (editor instanceof MethodElementEditor && !editor.isDirty()) {
                    Collection usedResources = ((MethodElementEditor)editor).getUsedResources();
                    int j = 0;
                    while (j < changedResourceList.size()) {
                        Resource resource = (Resource)changedResourceList.get(j);
                        if (usedResources.contains(resource)) {
                            editorsToRefresh.add(editor);
                            break;
                        }
                        ++j;
                    }
                }
                ++i3;
            }
            ILibraryManager manager = LibraryService.getInstance().getCurrentLibraryManager();
            if (manager != null) {
                manager.reloadResources(changedResourceList);
            }
            this.libView.getViewer().refresh();
            ConfigurationView configView = ConfigurationView.getView();
            if (configView != null && (ctrl = configView.getViewer().getControl()) != null && !ctrl.isDisposed()) {
                configView.getViewer().refresh();
            }
        }
        if (!editorsToRefresh.isEmpty()) {
            shell.getDisplay().asyncExec(new Runnable(){

                public void run() {
                    int i = 0;
                    while (i < editorsToRefresh.size()) {
                        MethodElementEditor editor = (MethodElementEditor)((Object)editorsToRefresh.get(i));
                        editor.refresh();
                        ++i;
                    }
                }
            });
        }
        return changedResourceList;
    }
}

