/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.publishing.services;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.library.layout.util.XmlElement;
import org.eclipse.epf.library.util.ResourceHelper;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.TermDefinition;

public class GlossaryList {
    private TreeMap itemMap = new TreeMap();

    public void clear() {
        this.itemMap.clear();
    }

    public void add(TermDefinition element) {
        String name = TngUtil.getPresentationName((Object)element);
        String group = "" + name.charAt(0);
        this.getItemList(group).add(element);
    }

    private List getItemList(String group) {
        ArrayList l = (ArrayList)this.itemMap.get(group = group.toUpperCase());
        if (l == null) {
            l = new ArrayList();
            this.itemMap.put(group, l);
        }
        return l;
    }

    public StringBuffer getXml() {
        XmlElement xe = new XmlElement("Glossary");
        Iterator it = this.itemMap.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            String group = (String)entry.getKey();
            List items = (List)entry.getValue();
            xe.newChild("item").setAttribute("name", group).setAttribute("presentationName", group).setAttribute("navigation-mark", "true").setAttribute("content", "");
            Iterator itItem = items.iterator();
            while (itItem.hasNext()) {
                TermDefinition element = (TermDefinition)itItem.next();
                String name = element.getName();
                String presentationName = TngUtil.getPresentationName((Object)element);
                String content = element.getPresentation().getMainDescription();
                content = ResourceHelper.fixContentUrlPath((String)content, (String)ResourceHelper.getElementPath((MethodElement)element), (String)"./../");
                xe.newChild("item").setAttribute("name", name).setAttribute("presentationName", presentationName).setAttribute("content", content);
            }
        }
        return xe.toXml();
    }
}

