/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.layout.util;

import java.util.Iterator;
import java.util.Map;
import org.eclipse.epf.common.utils.FileUtil;
import org.eclipse.epf.common.utils.XMLUtil;

public class XmlHelper {
    public static final String XML_HEADER = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>" + FileUtil.LINE_SEP;

    public static String validName(String elementName) {
        return XMLUtil.escape((String)elementName.replace(' ', '-'));
    }

    public static String quote(String str) {
        return "\"" + str + "\"";
    }

    public static String validate(String s) {
        return s == null ? "" : s;
    }

    public static String beginElement(String elementName, Map attributes) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("<" + XmlHelper.validName(elementName));
        if (attributes != null && attributes.size() > 0) {
            Iterator it = attributes.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                String key = (String)entry.getKey();
                String value = XmlHelper.quote(XMLUtil.escape((String)XmlHelper.validate((String)entry.getValue()), (boolean)true));
                buffer.append(" " + XmlHelper.validName(key) + "=" + value);
            }
        }
        buffer.append(">");
        return buffer.toString();
    }

    public static String endElement(String elementName) {
        return "</" + XmlHelper.validName(elementName) + ">";
    }

    public static String getElement(String elementName, String elementValue, Map attributes) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(XmlHelper.beginElement(elementName, attributes)).append(XMLUtil.escape((String)XmlHelper.validate(elementValue), (boolean)true)).append(XmlHelper.endElement(elementName));
        return buffer.toString();
    }
}

