/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.services;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.epf.library.ILibraryManager;
import org.eclipse.epf.library.ILibraryServiceListener;
import org.eclipse.epf.library.LibraryPlugin;
import org.eclipse.epf.library.LibraryService;
import org.eclipse.epf.library.events.ILibraryChangeListener;
import org.eclipse.epf.library.services.GeneralReference;
import org.eclipse.epf.library.services.PackageDependency;
import org.eclipse.epf.library.services.PackageReference;
import org.eclipse.epf.library.services.VariabilityElementReference;
import org.eclipse.epf.library.util.LibraryUtil;
import org.eclipse.epf.uma.ContentElement;
import org.eclipse.epf.uma.MethodConfiguration;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.MethodLibrary;

public class DependencyManager {
    protected static boolean debug = LibraryPlugin.getDefault().isDebugging();
    protected MethodLibrary library;
    protected ILibraryManager libraryManager;
    protected Map dependencyMap = new HashMap();
    private ILibraryServiceListener libSvcListener = null;
    private ILibraryChangeListener libListener = null;

    public DependencyManager(MethodLibrary library) {
        this.library = library;
        this.libraryManager = LibraryService.getInstance().getLibraryManager(library);
        this.init();
    }

    protected void init() {
        this.libSvcListener = new ILibraryServiceListener(){

            public void configurationSet(MethodConfiguration config) {
                System.out.println("configuration set: " + LibraryUtil.getTypeName((MethodElement)config));
            }

            public void libraryClosed(MethodLibrary library) {
                System.out.println("Library closed: " + LibraryUtil.getTypeName((MethodElement)library));
            }

            public void libraryCreated(MethodLibrary library) {
                System.out.println("Library created: " + LibraryUtil.getTypeName((MethodElement)library));
            }

            public void libraryOpened(MethodLibrary library) {
                System.out.println("Library opened: " + LibraryUtil.getTypeName((MethodElement)library));
            }

            public void libraryReopened(MethodLibrary library) {
                System.out.println("Library reopened: " + LibraryUtil.getTypeName((MethodElement)library));
            }

            public void librarySet(MethodLibrary library) {
                System.out.println("Library set: " + LibraryUtil.getTypeName((MethodElement)library));
            }
        };
        LibraryService.getInstance().addListener(this.libSvcListener);
        this.libListener = new ILibraryChangeListener(){

            public void libraryChanged(int option, Collection changedItems) {
                if (option == 16) {
                    DependencyManager.this.handleDeletedElement(changedItems);
                } else if ((option == 8 || option == 32) && changedItems != null && changedItems.size() > 0) {
                    Iterator it = changedItems.iterator();
                    while (it.hasNext()) {
                        try {
                            Object e = it.next();
                            if (e instanceof MethodElement) {
                                DependencyManager.this.buildDependencyFor((MethodElement)e);
                                continue;
                            }
                            if (!debug) continue;
                            System.out.println(e + " is not a method element");
                        }
                        catch (Exception e) {
                            if (!debug) continue;
                            e.printStackTrace();
                        }
                    }
                }
            }
        };
        this.libraryManager.addListener(this.libListener);
    }

    public PackageDependency getDependency(MethodElement element) {
        if (!LibraryUtil.selectable((EObject)element)) {
            return null;
        }
        PackageDependency dependency = this.getDependency((EObject)element, false);
        if (dependency == null || !dependency.isLoaded()) {
            this.buildDependency(element);
        }
        return this.getDependency((EObject)element, false);
    }

    public void printDependency() {
        Iterator it = this.dependencyMap.values().iterator();
        while (it.hasNext()) {
            ((PackageDependency)it.next()).print();
        }
    }

    private void buildDependency(MethodElement element) {
        block5: {
            if (element == null) {
                return;
            }
            try {
                PackageDependency dependency = this.buildDependencyFor(element);
                EList elements = element.eContents();
                if (elements != null) {
                    Iterator it = elements.iterator();
                    while (it.hasNext()) {
                        MethodElement methodElement = (MethodElement)it.next();
                        if (methodElement == null || LibraryUtil.selectable((EObject)methodElement)) continue;
                        this.buildDependencyFor(methodElement);
                    }
                }
                dependency.setLoaded(true);
            }
            catch (Exception e) {
                if (!debug) break block5;
                e.printStackTrace();
            }
        }
    }

    private PackageDependency buildDependencyFor(MethodElement element) {
        EList references;
        EObject selectableBase;
        if (element == null) {
            return null;
        }
        EObject selectableElement = LibraryUtil.getSelectable((EObject)element);
        if (selectableElement == null) {
            return null;
        }
        PackageDependency dependency = this.getDependency(selectableElement, true);
        dependency.removeReference(element);
        ContentElement baseElement = null;
        if (element instanceof ContentElement && (baseElement = (ContentElement)((ContentElement)element).getVariabilityBasedOnElement()) != null && (selectableBase = LibraryUtil.getSelectable((EObject)baseElement)) != null) {
            PackageReference pkgRef = dependency.getReference(selectableBase, true);
            if (!pkgRef.hasReference(element, baseElement)) {
                VariabilityElementReference ref = new VariabilityElementReference(element, baseElement);
                pkgRef.addReference(ref);
            }
            this.getDependency(selectableBase, true).addDependent(selectableElement);
        }
        if ((references = element.eCrossReferences()) != null && references.size() > 0) {
            Iterator it = references.iterator();
            while (it.hasNext()) {
                EObject refElement = (EObject)it.next();
                EObject selectableRef = LibraryUtil.getSelectable(refElement);
                if (selectableRef == null) continue;
                PackageReference pkgRef = dependency.getReference(selectableRef, true);
                if (element == selectableElement && refElement == selectableRef) continue;
                if (!pkgRef.hasReference(element, refElement)) {
                    GeneralReference ref = new GeneralReference(element, refElement);
                    pkgRef.addReference(ref);
                }
                this.getDependency(selectableRef, true).addDependent(selectableElement);
            }
        }
        return dependency;
    }

    private PackageDependency getDependency(EObject element, boolean create) {
        if (!LibraryUtil.selectable(element)) {
            if (debug) {
                System.out.println("Error, Selectable element required: " + element);
            }
            return null;
        }
        PackageDependency dependency = (PackageDependency)this.dependencyMap.get(element);
        if (dependency == null && create) {
            dependency = new PackageDependency(element);
            this.dependencyMap.put(element, dependency);
        }
        return dependency;
    }

    private void handleDeletedElement(Collection changedItems) {
        Iterator it = changedItems.iterator();
        while (it.hasNext()) {
            Object element = it.next();
            if (!(element instanceof MethodElement)) continue;
            this.removeReference((MethodElement)element);
        }
    }

    private void removeReference(MethodElement element) {
        PackageDependency dependency = null;
        MethodElement pkg = (MethodElement)LibraryUtil.getSelectable((EObject)element);
        if (pkg == null || (dependency = this.getDependency((EObject)pkg, false)) == null) {
            return;
        }
        dependency.removeReference(element);
    }
}

