/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.services;

import java.util.Collection;
import java.util.Iterator;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.epf.library.LibraryPlugin;
import org.eclipse.epf.library.LibraryResources;
import org.eclipse.epf.library.LibraryService;
import org.eclipse.epf.library.edit.command.ActionManager;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.uma.UmaPackage;
import org.eclipse.epf.uma.util.ContentDescriptionFactory;
import org.eclipse.epf.uma.util.IMethodLibraryPersister;
import org.eclipse.osgi.util.NLS;

public class LibraryModificationHelper {
    ActionManager actionMgr = null;

    public ActionManager getActionManager() {
        if (this.actionMgr != null) {
            return this.actionMgr;
        }
        this.actionMgr = new ActionManager(){

            public boolean doAction(int actionType, EObject object, EStructuralFeature feature, Object value, int index) {
                if (LibraryModificationHelper.canUpdate(object)) {
                    return super.doAction(actionType, object, feature, value, index);
                }
                return false;
            }

            protected void save(Resource resource) {
            }
        };
        return this.actionMgr;
    }

    public void dispose() {
        if (this.actionMgr != null) {
            this.actionMgr.dispose();
            this.actionMgr = null;
        }
    }

    public static boolean canUpdate(EObject object) {
        IStatus status = TngUtil.checkEdit((EObject)object, null);
        if (status.isOK()) {
            return true;
        }
        String msg = NLS.bind((String)LibraryResources.LibraryModificationHelper_cannotUpdate, (Object)TngUtil.getTypeText((EObject)object), (Object)object.eGet((EStructuralFeature)UmaPackage.eINSTANCE.getNamedElement_Name()));
        LibraryPlugin.getDefault().getMsgDialog().displayWarning(LibraryResources.warningDlg_title, msg, TngUtil.getMessage((IStatus)status));
        return false;
    }

    public boolean isSaveNeeded() {
        return this.actionMgr != null && this.actionMgr.isSaveNeeded();
    }

    public void save() {
        if (this.actionMgr == null) {
            return;
        }
        IMethodLibraryPersister.FailSafeMethodLibraryPersister persister = this.getPersister();
        try {
            Collection modifiedResources = this.actionMgr.getModifiedResources();
            Iterator iter = modifiedResources.iterator();
            while (iter.hasNext()) {
                Resource resource = (Resource)iter.next();
                try {
                    persister.save(resource);
                }
                catch (Exception e) {
                    String msg = NLS.bind((String)LibraryResources.errorDlg_saveError, (Object)resource.getURI().toFileString());
                    LibraryPlugin.getDefault().getMsgDialog().displayError(LibraryResources.errorDlg_title, msg, (Throwable)e);
                }
            }
            try {
                persister.commit();
                this.actionMgr.saveIsDone();
            }
            catch (Exception e) {
                try {
                    persister.rollback();
                }
                catch (Throwable throwable) {
                    try {
                        LibraryService.getInstance().reopenCurrentMethodLibrary();
                    }
                    catch (RuntimeException e1) {
                        e1.printStackTrace();
                    }
                }
                e.printStackTrace();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public IMethodLibraryPersister.FailSafeMethodLibraryPersister getPersister() {
        return ContentDescriptionFactory.getMethodLibraryPersister().getFailSafePersister();
    }
}

