/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.persistence;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.util.BasicExtendedMetaData;
import org.eclipse.epf.persistence.MultiFileXMIResourceImpl;
import org.eclipse.epf.resourcemanager.ResourceDescriptor;
import org.eclipse.epf.resourcemanager.ResourceManager;
import org.eclipse.epf.resourcemanager.ResourcemanagerFactory;
import org.eclipse.epf.resourcemanager.ResourcemanagerPackage;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.UmaPackage;

public class Recoverer {
    private static final FilenameFilter filenameFilter = new FilenameFilter(){

        public boolean accept(File arg0, String arg1) {
            if (new File(arg0, arg1).isDirectory()) {
                return true;
            }
            return arg1.toLowerCase().endsWith(".xmi");
        }
    };
    private static final Map LOAD_OPTIONS = new HashMap();
    private static final Map SAVE_OPTIONS = new HashMap();

    static {
        LOAD_OPTIONS.put("ENCODING", "UTF-8");
        BasicExtendedMetaData extMetaData = new BasicExtendedMetaData();
        extMetaData.putPackage("http:///com/ibm/uma/resourcemanager.ecore", (EPackage)ResourcemanagerPackage.eINSTANCE);
        extMetaData.putPackage("http:///com/ibm/uma.ecore", (EPackage)UmaPackage.eINSTANCE);
        LOAD_OPTIONS.put("EXTENDED_META_DATA", extMetaData);
        SAVE_OPTIONS.put("ENCODING", "UTF-8");
    }

    public static final void recover(String libDirPath) throws IOException {
        File libDir = new File(libDirPath);
        MultiFileXMIResourceImpl resMgrResource = new MultiFileXMIResourceImpl(URI.createFileURI((String)(String.valueOf(libDirPath) + File.separator + "resmgr.xmi")));
        resMgrResource.load(LOAD_OPTIONS);
        ResourceManager resMgr = (ResourceManager)resMgrResource.getContents().get(0);
        Recoverer.addToResourceManager(resMgr, libDir);
        resMgrResource.save(SAVE_OPTIONS);
    }

    private static void addToResourceManager(ResourceManager resMgr, File file) {
        if (file.isDirectory()) {
            File[] files = file.listFiles(filenameFilter);
            int i = 0;
            while (i < files.length) {
                Recoverer.addToResourceManager(resMgr, files[i]);
                ++i;
            }
        } else {
            String guid;
            MethodElement e = null;
            try {
                Object obj;
                MultiFileXMIResourceImpl resource = new MultiFileXMIResourceImpl(URI.createFileURI((String)file.getAbsolutePath()));
                resource.load(LOAD_OPTIONS);
                if (!resource.getContents().isEmpty() && (obj = resource.getContents().get(0)) instanceof MethodElement) {
                    e = (MethodElement)obj;
                }
            }
            catch (IOException iOException) {}
            if (e != null && (guid = e.getGuid()) != null && guid.trim().length() != 0) {
                Iterator iter = resMgr.getResourceDescriptors().iterator();
                while (iter.hasNext()) {
                    ResourceDescriptor resDescriptor = (ResourceDescriptor)iter.next();
                    if (!resDescriptor.getId().equals(guid)) continue;
                    return;
                }
                ResourceDescriptor resDescriptor = ResourcemanagerFactory.eINSTANCE.createResourceDescriptor();
                resDescriptor.setId(guid);
                resDescriptor.setUri(URI.createFileURI((String)file.getAbsolutePath()).deresolve(resMgr.eResource().getURI()).toString());
                resMgr.getResourceDescriptors().add(resDescriptor);
                System.out.println("added '" + resDescriptor.getUri() + "'");
            }
        }
    }

    public static void main(String[] args) {
        String libDir = args[0];
        try {
            Recoverer.recover(libDir);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

