/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.export.wizards;

import java.io.File;
import org.eclipse.epf.authoring.ui.preferences.LibraryLocationData;
import org.eclipse.epf.common.utils.FileUtil;
import org.eclipse.epf.common.utils.StrUtil;
import org.eclipse.epf.export.ExportResources;
import org.eclipse.epf.library.ui.preferences.LibraryUIPreferences;
import org.eclipse.epf.library.ui.wizards.BaseWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;

public class DestinationCommonPage
extends BaseWizardPage
implements Listener {
    private static final String pageTitle = ExportResources.DestinationCommonPage_title;
    private static final String pageDesc = ExportResources.DestinationCommonPage_desc;
    private static final String nameLabel = ExportResources.DestinationCommonPage_label_name;
    protected Composite container;
    protected Text ctrl_name;
    protected Text ctrl_exportPath;
    protected Button ctrl_browse_button;
    protected Button ctrl_default_checkbox;
    private Text ctrlInEditing;
    private String parentDir;
    protected LibraryLocationData llData;

    public DestinationCommonPage(String pageName, LibraryLocationData llData) {
        super(pageName);
        this.setTitle(pageTitle);
        this.setDescription(pageDesc);
        this.llData = llData;
    }

    protected Label createLabel(Composite parent, String text, int nCol) {
        Label label = new Label(parent, 0);
        label.setText(text);
        GridData gridData = new GridData(1);
        gridData.horizontalSpan = nCol;
        label.setLayoutData((Object)gridData);
        return label;
    }

    public void createControl(Composite parent) {
        this.container = new Composite(parent, 0);
        this.container.setLayout((Layout)new GridLayout(3, false));
        this.createLabel(this.container, nameLabel);
        this.ctrl_name = this.createEditableText(this.container, "", 360, 1);
        this.createLabel(this.container, "");
        this.createLabel(this.container, ExportResources.DestinationCommonPage_label_dir);
        this.ctrl_exportPath = this.createEditableText(this.container, "", 420, 1);
        this.ctrl_browse_button = new Button(this.container, 0);
        this.ctrl_browse_button.setText(ExportResources.DestinationCommonPage_label_browse);
        this.ctrl_browse_button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DestinationCommonPage.this.openDirectoryDialog();
            }
        });
        this.createLabel(this.container, "");
        this.ctrl_default_checkbox = new Button(this.container, 32);
        this.ctrl_default_checkbox.setText(ExportResources.DestinationCommonPage_label_default_dir);
        this.ctrl_default_checkbox.setSelection(true);
        this.ctrl_exportPath.setText(this.getDefaultExportPath());
        this.ctrl_exportPath.setEditable(false);
        this.ctrl_browse_button.setEnabled(false);
        this.addListeners();
        this.setControl((Control)this.container);
        this.setPageComplete(false);
    }

    private void addListeners() {
        this.ctrl_name.addListener(24, (Listener)this);
        this.ctrl_name.addListener(15, (Listener)this);
        this.ctrl_name.addListener(16, (Listener)this);
        this.ctrl_exportPath.addListener(15, (Listener)this);
        this.ctrl_exportPath.addListener(24, (Listener)this);
        this.ctrl_exportPath.addListener(16, (Listener)this);
        this.ctrl_default_checkbox.addListener(13, (Listener)this);
    }

    public void setVisible(boolean visible) {
        Display display;
        super.setVisible(visible);
        if (visible && (display = this.container.getDisplay()) != null && !display.isDisposed()) {
            display.asyncExec(new Runnable(){

                public void run() {
                    DestinationCommonPage.this.ctrl_name.setFocus();
                }
            });
        }
    }

    public void handleEvent(Event event) {
        int idx;
        Wizard wizard = (Wizard)this.getWizard();
        if (event.widget == this.ctrl_name && event.type == 15) {
            this.parentDir = this.ctrl_exportPath.getText();
            String currentName = StrUtil.makeValidFileName((String)this.ctrl_name.getText().trim());
            if (!currentName.equals(this.ctrl_name.getText())) {
                this.ctrl_name.setText(currentName);
            }
            if (currentName.length() > 0 && this.parentDir.endsWith(String.valueOf(File.separator) + currentName)) {
                idx = this.parentDir.lastIndexOf(String.valueOf(File.separator) + currentName);
                this.parentDir = this.parentDir.substring(0, idx);
            }
            if (!this.parentDir.endsWith(File.separator)) {
                this.parentDir = String.valueOf(this.parentDir) + File.separator;
            }
            this.ctrlInEditing = this.ctrl_name;
        }
        if (event.widget == this.ctrl_name && this.ctrlInEditing == this.ctrl_name) {
            this.ctrl_exportPath.setText(String.valueOf(this.parentDir) + StrUtil.makeValidFileName((String)this.ctrl_name.getText()));
        }
        if (event.widget == this.ctrl_name && event.type == 16) {
            this.ctrlInEditing = null;
        }
        if (event.widget == this.ctrl_exportPath && event.type == 15) {
            this.ctrlInEditing = this.ctrl_exportPath;
        }
        if (event.widget == this.ctrl_exportPath && this.ctrlInEditing == this.ctrl_exportPath) {
            String parentLibPath = this.ctrl_exportPath.getText();
            idx = parentLibPath.lastIndexOf(File.separator);
            String libName = parentLibPath.substring(idx + 1);
            this.ctrl_name.setText(libName);
        }
        if (event.widget == this.ctrl_exportPath && event.type == 16) {
            this.ctrlInEditing = null;
        }
        if (event.widget == this.ctrl_default_checkbox) {
            if (!this.ctrl_default_checkbox.getSelection()) {
                this.ctrl_name.setText("");
                this.ctrl_exportPath.setText(this.getDefaultExportPath());
                this.ctrl_exportPath.setEditable(true);
                this.ctrl_browse_button.setEnabled(true);
                this.ctrl_name.setEditable(true);
                this.ctrl_name.setEnabled(true);
            } else {
                this.ctrl_name.setText("");
                this.ctrl_exportPath.setText(this.getDefaultExportPath());
                this.ctrl_exportPath.setEditable(false);
                this.ctrl_browse_button.setEnabled(false);
                this.ctrl_name.setEditable(true);
                this.ctrl_name.setEnabled(true);
            }
            this.appendNemeToPath();
        }
        this.setPageComplete(this.isPageComplete());
        wizard.getContainer().updateButtons();
    }

    private String getDefaultExportPath() {
        String defExportPPath = String.valueOf(System.getProperty("user.home")) + FileUtil.FILE_SEP + LibraryUIPreferences.getApplicationShortName() + FileUtil.FILE_SEP + "Export";
        return defExportPPath;
    }

    private void appendNemeToPath() {
        String libName = this.ctrl_name.getText().trim();
        String libPath = this.ctrl_exportPath.getText().trim();
        if (libName.length() > 0) {
            if (!libPath.endsWith(File.separator)) {
                libPath = String.valueOf(libPath) + File.separator;
            }
            this.ctrl_exportPath.setText(String.valueOf(libPath) + libName);
        }
    }

    protected void saveToDataModel() {
        this.llData.setLibName(this.ctrl_name.getText());
        this.llData.setParentFolder(this.ctrl_exportPath.getText());
    }

    private void openDirectoryDialog() {
        try {
            DirectoryDialog dd = new DirectoryDialog(this.container.getShell(), 0);
            dd.setFilterPath(this.ctrl_exportPath.getText());
            String destination = dd.open();
            if (destination != null) {
                this.ctrl_exportPath.setText(destination);
                File destinationFile = new File(destination);
                this.ctrl_name.setText(destinationFile.getName());
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

