/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.core.streams;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import org.eclipse.core.runtime.OperationCanceledException;

public class SizeConstrainedInputStream
extends FilterInputStream {
    private boolean discardOnClose;
    private long bytesRemaining;

    public SizeConstrainedInputStream(InputStream in, long size, boolean discardOnClose) {
        super(in);
        this.bytesRemaining = size;
        this.discardOnClose = discardOnClose;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void close() throws IOException {
        try {
            try {
                if (this.discardOnClose) {
                    while (this.bytesRemaining != 0L && this.skip(this.bytesRemaining) != 0L) {
                    }
                }
            }
            catch (OperationCanceledException operationCanceledException) {}
        }
        catch (Throwable throwable) {
            Object var1_2 = null;
            this.bytesRemaining = 0L;
            throw throwable;
        }
        {
            Object var1_3 = null;
            this.bytesRemaining = 0L;
            return;
        }
    }

    public int available() throws IOException {
        int amount = this.in.available();
        if ((long)amount > this.bytesRemaining) {
            amount = (int)this.bytesRemaining;
        }
        return amount;
    }

    public int read() throws IOException {
        if (this.bytesRemaining == 0L) {
            return -1;
        }
        int b = this.in.read();
        if (b != -1) {
            --this.bytesRemaining;
        }
        return b;
    }

    public int read(byte[] buffer, int offset, int length) throws IOException {
        if ((long)length > this.bytesRemaining) {
            if (this.bytesRemaining == 0L) {
                return -1;
            }
            length = (int)this.bytesRemaining;
        }
        try {
            int count = this.in.read(buffer, offset, length);
            if (count != -1) {
                this.bytesRemaining -= (long)count;
            }
            return count;
        }
        catch (InterruptedIOException e) {
            this.bytesRemaining -= (long)e.bytesTransferred;
            throw e;
        }
    }

    public long skip(long amount) throws IOException {
        if (amount > this.bytesRemaining) {
            amount = this.bytesRemaining;
        }
        try {
            long count = this.in.skip(amount);
            this.bytesRemaining -= count;
            return count;
        }
        catch (InterruptedIOException e) {
            this.bytesRemaining -= (long)e.bytesTransferred;
            throw e;
        }
    }

    public boolean markSupported() {
        return false;
    }
}

