/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.importing.services;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.taskdefs.Copy;
import org.apache.tools.ant.types.FileSet;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.epf.authoring.ui.views.LibraryView;
import org.eclipse.epf.common.plugin.AbstractPlugin;
import org.eclipse.epf.common.serviceability.MsgDialog;
import org.eclipse.epf.common.utils.FileUtil;
import org.eclipse.epf.common.utils.XMLUtil;
import org.eclipse.epf.export.services.LibraryDocument;
import org.eclipse.epf.importing.ImportPlugin;
import org.eclipse.epf.importing.ImportResources;
import org.eclipse.epf.importing.services.ConfigurationImportService;
import org.eclipse.epf.importing.services.DirCopy;
import org.eclipse.epf.importing.services.FileModifyChecker;
import org.eclipse.epf.importing.services.PluginImportData;
import org.eclipse.epf.library.LibraryService;
import org.eclipse.epf.library.LibraryServiceUtil;
import org.eclipse.epf.library.services.SafeUpdateController;
import org.eclipse.epf.library.util.ResourceHelper;
import org.eclipse.epf.library.util.ResourceUtil;
import org.eclipse.epf.persistence.MultiFileSaveUtil;
import org.eclipse.epf.persistence.util.PersistenceUtil;
import org.eclipse.epf.resourcemanager.ResourceManager;
import org.eclipse.epf.uma.MethodConfiguration;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.MethodLibrary;
import org.eclipse.epf.uma.MethodPlugin;
import org.eclipse.epf.uma.NamedElement;
import org.eclipse.epf.uma.util.ContentDescriptionFactory;
import org.eclipse.epf.uma.util.IMethodLibraryPersister;
import org.eclipse.osgi.util.NLS;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class PluginImportingService {
    private static boolean newMergeScheme = true;
    private PluginImportData data;
    LibraryDocument importingLibDoc;
    LibraryDocument targetLibDoc;
    IStatus fileCheckedOutStatus = null;

    public PluginImportingService(PluginImportData data) {
        this.data = data;
    }

    public void validate(IProgressMonitor monitor) {
        try {
            if (monitor != null) {
                monitor.setTaskName(ImportResources.PluginImportingService_MSG0);
            }
            if (this.data == null) {
                return;
            }
            this.data.clear();
            File importingLibPath = new File(String.valueOf(this.data.llData.getParentFolder()) + File.separator + "export.xmi");
            if (!importingLibPath.exists()) {
                this.data.getErrorInfo().addError(NLS.bind((String)ImportResources.PluginImportingService_MSG1, (Object)importingLibPath.toString()));
                return;
            }
            String versionError = ConfigurationImportService.versionCheck(importingLibPath.getAbsolutePath(), ImportResources.importPluginsWizard_title);
            if (versionError != null) {
                this.data.getErrorInfo().addError(versionError);
                return;
            }
            this.importingLibDoc = new LibraryDocument(importingLibPath);
            File libFile = new File(LibraryService.getInstance().getCurrentMethodLibrary().eResource().getURI().toFileString());
            this.targetLibDoc = new LibraryDocument(libFile);
            this.scanLibraryFile(this.importingLibDoc);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    /*
     * Exception decompiling
     */
    public void performImport(IProgressMonitor monitor) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 1[TRYBLOCK] [1 : 48->52)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void __doImport(IProgressMonitor monitor) {
        try {
            if (monitor != null) {
                monitor.setTaskName(ImportResources.PluginImportingService_MSG3);
            }
            List unlockedPlugins = this.unlockPlugins();
            File libFile = this.targetLibDoc.getFile();
            if (newMergeScheme) {
                this.merge(this.targetLibDoc);
                if (unlockedPlugins.size() > 0) {
                    this.lockUnlockedPlugins(unlockedPlugins);
                    LibraryService.getInstance().saveCurrentMethodLibrary();
                    LibraryService.getInstance().reopenCurrentMethodLibrary();
                }
                MethodLibrary lib = LibraryService.getInstance().getCurrentMethodLibrary();
                ResourceUtil.refreshResources((MethodLibrary)lib, (IProgressMonitor)monitor);
                return;
            }
            if (this.importEntries(this.targetLibDoc)) {
                this.targetLibDoc.save();
                this.fixLibraryGuid(libFile.getParentFile(), this.importingLibDoc.getLibraryGuid(), this.targetLibDoc.getLibraryGuid());
                LibraryService.getInstance().reopenCurrentMethodLibrary();
                if (unlockedPlugins.size() > 0) {
                    this.lockUnlockedPlugins(unlockedPlugins);
                    LibraryService.getInstance().saveCurrentMethodLibrary();
                }
            }
            LibraryService.getInstance().reopenCurrentMethodLibrary();
            MethodLibrary lib = LibraryService.getInstance().getCurrentMethodLibrary();
            ResourceUtil.refreshResources((MethodLibrary)lib, (IProgressMonitor)monitor);
        }
        catch (Exception e) {
            ImportPlugin.getDefault().getLogger().logError((Throwable)e);
        }
    }

    private List unlockPlugins() {
        ArrayList<String> pluginIds = new ArrayList<String>();
        Iterator it = this.data.getPlugins().iterator();
        while (it.hasNext()) {
            PluginImportData.PluginInfo info = (PluginImportData.PluginInfo)it.next();
            if (info.existingPlugin == null || !info.selected || info.existingPlugin.getUserChangeable().booleanValue()) continue;
            info.existingPlugin.setUserChangeable(new Boolean(true));
            pluginIds.add(info.existingPlugin.getGuid());
        }
        return pluginIds;
    }

    private void lockUnlockedPlugins(List unlockedPlugins) {
        List plugins = LibraryService.getInstance().getCurrentMethodLibrary().getMethodPlugins();
        Iterator it = plugins.iterator();
        while (it.hasNext()) {
            MethodPlugin plugin = (MethodPlugin)it.next();
            if (!unlockedPlugins.contains(plugin.getGuid())) continue;
            plugin.setUserChangeable(new Boolean(false));
        }
    }

    private boolean importEntries(LibraryDocument targetLibDoc) {
        ArrayList<String> importList = new ArrayList<String>();
        ArrayList<String> newList = new ArrayList<String>();
        Iterator it = this.data.getPlugins().iterator();
        while (it.hasNext()) {
            PluginImportData.PluginInfo info = (PluginImportData.PluginInfo)it.next();
            if (!info.selected) continue;
            if (info.existingPlugin == null) {
                newList.add(info.guid);
            }
            importList.add(info.guid);
        }
        Iterator it2 = this.data.getConfigs().iterator();
        while (it2.hasNext()) {
            PluginImportData.ConfiguarationInfo cinfo = (PluginImportData.ConfiguarationInfo)it2.next();
            if (!cinfo.selected) continue;
            if (cinfo.existingConfig == null) {
                newList.add(cinfo.guid);
            }
            importList.add(cinfo.guid);
        }
        if (!newMergeScheme) {
            this.importLibEntries(targetLibDoc, newList);
        } else {
            MethodLibrary lib = LibraryService.getInstance().getCurrentMethodLibrary();
            this.ensureUniqueNames(lib.getMethodPlugins());
            this.ensureUniqueNames(lib.getPredefinedConfigurations());
        }
        return this.copyFiles(targetLibDoc, importList, newList);
    }

    private void importLibEntries(LibraryDocument targetLibDoc, List newList) {
        String guid;
        Element node;
        if (newList == null || newList.size() == 0) {
            return;
        }
        NodeList nodes = this.importingLibDoc.getPlugins();
        int i = 0;
        while (i < nodes.getLength()) {
            node = (Element)nodes.item(i);
            guid = LibraryDocument.getGuid((Element)node);
            if (newList.contains(guid)) {
                targetLibDoc.addPlugin(node);
            }
            ++i;
        }
        nodes = this.importingLibDoc.getConfigurations();
        i = 0;
        while (i < nodes.getLength()) {
            node = (Element)nodes.item(i);
            guid = LibraryDocument.getGuid((Element)node);
            if (newList.contains(guid)) {
                targetLibDoc.addConfiguration(node);
            }
            ++i;
        }
        nodes = this.importingLibDoc.getResourceDescriptors();
        i = 0;
        while (i < nodes.getLength()) {
            node = (Element)nodes.item(i);
            guid = node.getAttribute("id");
            if (newList.contains(guid)) {
                targetLibDoc.addResource(node);
            }
            ++i;
        }
        nodes = this.importingLibDoc.getResourceSubManagers();
        i = 0;
        while (i < nodes.getLength()) {
            node = (Element)nodes.item(i);
            guid = LibraryDocument.getSubManagerBaseGuid((String)node.getAttribute("href"));
            if (newList.contains(guid)) {
                targetLibDoc.addResource(node);
            }
            ++i;
        }
    }

    private boolean copyFiles(LibraryDocument targetLibDoc, List importList, List newList) {
        Iterator it = importList.iterator();
        while (it.hasNext()) {
            String guid = (String)it.next();
            String src_uri = this.importingLibDoc.getResourceUri(guid);
            if (src_uri == null || src_uri.length() == 0) continue;
            String target_uri = src_uri;
            final File src_file = this.importingLibDoc.getFileFromUri(src_uri);
            if (!src_file.exists()) continue;
            final File target_file = targetLibDoc.getFileFromUri(target_uri);
            if (this.data.getPluginInfo(guid) != null) {
                if (target_file.exists()) {
                    SafeUpdateController.syncExec((Runnable)new Runnable(){

                        public void run() {
                            DirCopy copy = new DirCopy(src_file.getParentFile(), target_file.getParentFile());
                            PluginImportingService.this.fileCheckedOutStatus = copy.execute();
                        }
                    });
                } else {
                    PluginImportingService.copyDir(src_file.getParentFile(), target_file.getParentFile());
                }
            } else if (this.data.getConfigInfo(guid) != null && DirCopy.needCopy(src_file, target_file)) {
                final ArrayList<String> files = new ArrayList<String>();
                if (target_file.exists()) {
                    files.add(target_file.getAbsolutePath());
                    SafeUpdateController.syncExec((Runnable)new Runnable(){

                        public void run() {
                            PluginImportingService.this.fileCheckedOutStatus = FileModifyChecker.checkModify(files);
                        }
                    });
                }
                if (this.fileCheckedOutStatus == null || this.fileCheckedOutStatus.isOK()) {
                    ResourceHelper.copyFile((File)src_file, (File)target_file);
                }
            }
            if (this.fileCheckedOutStatus == null || this.fileCheckedOutStatus.isOK()) continue;
            SafeUpdateController.syncExec((Runnable)new Runnable(){

                public void run() {
                    String title = ImportResources.importPluginsWizard_title;
                    String msg = ImportResources.importPluginsWizard_ERR_Import_plugin;
                    new MsgDialog((AbstractPlugin)ImportPlugin.getDefault()).displayError(title, msg, PluginImportingService.this.fileCheckedOutStatus);
                }
            });
            return false;
        }
        return true;
    }

    public static void copyDir(File fromDir, File toDir) {
        Copy cp = new Copy();
        cp.setOverwrite(true);
        FileSet set = new FileSet();
        set.setDir(fromDir);
        cp.addFileset(set);
        cp.setTodir(toDir);
        cp.setProject(new Project());
        cp.execute();
    }

    public String validateSelection() {
        this.data.getErrorInfo().clear();
        MethodLibrary library = LibraryService.getInstance().getCurrentMethodLibrary();
        List plugins = library == null ? new ArrayList() : library.getMethodPlugins();
        ArrayList<String> pluginids = new ArrayList<String>();
        Iterator it = plugins.iterator();
        while (it.hasNext()) {
            pluginids.add(((MethodPlugin)it.next()).getGuid());
        }
        ArrayList basePlugins = new ArrayList();
        ArrayList<String> newPlugins = new ArrayList<String>();
        Iterator it2 = this.data.getPlugins().iterator();
        while (it2.hasNext()) {
            PluginImportData.PluginInfo info = (PluginImportData.PluginInfo)it2.next();
            if (!info.selected || info.existingPlugin != null) continue;
            newPlugins.add(info.guid);
            Iterator itb = info.usedPlugins.iterator();
            while (itb.hasNext()) {
                Object base = itb.next();
                if (basePlugins.contains(base)) continue;
                basePlugins.add(base);
            }
        }
        if (newPlugins.size() > 0) {
            it2 = basePlugins.iterator();
            while (it2.hasNext()) {
                String guid = (String)it2.next();
                String uri = (String)this.data.basePluginUrlMap.get(guid);
                if (newPlugins.contains(guid) || pluginids.contains(guid)) continue;
                String message = uri != null && uri.length() > 0 ? NLS.bind((String)ImportResources.PluginImportingService_MSG5, (Object)uri) : ImportResources.PluginImportingService_MSG6;
                this.data.getErrorInfo().addError(message);
                if (uri == null || uri.length() == 0) break;
            }
        }
        return this.data.getErrorInfo().getError();
    }

    private void scanLibraryFile(LibraryDocument document) {
        this.visitLibTag(document);
        this.visitResourceTag(document);
        this.data.validatePlugins();
        Iterator it = this.data.getPlugins().iterator();
        while (it.hasNext()) {
            PluginImportData.PluginInfo info = (PluginImportData.PluginInfo)it.next();
            if (info.existingPlugin != null) continue;
            Iterator itbase = info.usedPlugins.iterator();
            while (itbase.hasNext()) {
                String guid = (String)itbase.next();
                if (this.data.basePluginUrlMap.containsKey(guid)) continue;
                this.data.basePluginUrlMap.put(guid, "");
            }
        }
    }

    private void visitLibTag(LibraryDocument document) {
        NodeList nodes = document.getPlugins();
        int i = 0;
        while (i < nodes.getLength()) {
            Element node = (Element)nodes.item(i);
            PluginImportData.PluginInfo pi = this.data.new PluginImportData.PluginInfo();
            pi.guid = LibraryDocument.getGuid((Element)node);
            this.data.getPlugins().add(pi);
            this.loadExistingPluginInfo(pi);
            ++i;
        }
        this.buildConfigInfoFromFiles();
    }

    private void visitResourceTag(LibraryDocument document) {
        NodeList nodes = document.getResourceDescriptors();
        int i = 0;
        while (i < nodes.getLength()) {
            Element node = (Element)nodes.item(i);
            String guid = node.getAttribute("id");
            String uri = node.getAttribute("uri");
            File file = document.getFileFromUri(uri);
            PluginImportData.PluginInfo pi = this.data.getPluginInfo(guid);
            if (pi != null) {
                if (file.exists()) {
                    this.loadPluginInfo(file, pi);
                } else {
                    this.data.removePluginInfo(guid);
                }
            } else {
                PluginImportData.ConfiguarationInfo ci = this.data.getConfigInfo(guid);
                if (ci != null && file.exists()) {
                    this.loadConfigInfo(file, ci);
                }
            }
            ++i;
        }
    }

    protected void loadConfigInfo(File source, PluginImportData.ConfiguarationInfo info) {
        try {
            Document document = XMLUtil.loadXml((File)source);
            Element root = document.getDocumentElement();
            Element configTag = null;
            if (root.getTagName().equals("org.eclipse.epf.uma:MethodConfiguration")) {
                configTag = root;
            } else {
                NodeList nodes = root.getElementsByTagName("org.eclipse.epf.uma:MethodConfiguration");
                if (nodes.getLength() > 0) {
                    configTag = (Element)nodes.item(0);
                }
            }
            if (configTag != null) {
                info.name = configTag.getAttribute("name");
            }
        }
        catch (Exception e) {
            ImportPlugin.getDefault().getLogger().logError((Throwable)e);
        }
    }

    protected void loadPluginInfo(File source, PluginImportData.PluginInfo info) {
        try {
            NodeList nodes;
            Document document = XMLUtil.loadXml((File)source);
            Element root = document.getDocumentElement();
            Element pluginTag = null;
            if (root.getTagName().equals("org.eclipse.epf.uma:MethodPlugin")) {
                pluginTag = root;
            } else {
                nodes = root.getElementsByTagName("org.eclipse.epf.uma:MethodPlugin");
                if (nodes.getLength() > 0) {
                    pluginTag = (Element)nodes.item(0);
                }
            }
            if (pluginTag != null) {
                info.name = pluginTag.getAttribute("name");
                info.version = LibraryDocument.getChildValue((Element)pluginTag, (String)"version");
                info.brief_desc = LibraryDocument.getChildValue((Element)pluginTag, (String)"briefDescription");
                info.authors = LibraryDocument.getChildValue((Element)pluginTag, (String)"authors");
                info.changeDate = LibraryDocument.getChildValue((Element)pluginTag, (String)"changeDate");
                info.url = source.toString();
                nodes = pluginTag.getElementsByTagName("bases");
                int i = 0;
                while (i < nodes.getLength()) {
                    Element node = (Element)nodes.item(i);
                    String guid = node.getAttribute("href");
                    int indx = guid.indexOf("#");
                    if (indx > 0) {
                        guid = guid.substring(indx + 1);
                    } else {
                        indx = guid.indexOf("uma://");
                        if (indx >= 0) {
                            guid = guid.substring(indx + 6);
                        }
                    }
                    info.usedPlugins.add(guid);
                    ++i;
                }
            }
        }
        catch (Exception e) {
            ImportPlugin.getDefault().getLogger().logError((Throwable)e);
        }
    }

    private void loadExistingPluginInfo(PluginImportData.PluginInfo info) {
        MethodLibrary library = LibraryService.getInstance().getCurrentMethodLibrary();
        List plugins = library == null ? new ArrayList() : library.getMethodPlugins();
        Iterator it = plugins.iterator();
        while (it.hasNext()) {
            MethodPlugin plugin = (MethodPlugin)it.next();
            if (!plugin.getGuid().equals(info.guid)) continue;
            info.existingPlugin = plugin;
        }
    }

    private void loadExistingConfigInfo(PluginImportData.ConfiguarationInfo info) {
        MethodConfiguration[] configs = LibraryServiceUtil.getMethodConfigurations((MethodLibrary)LibraryService.getInstance().getCurrentMethodLibrary());
        if (configs == null || configs.length == 0) {
            return;
        }
        int i = 0;
        while (i < configs.length) {
            MethodConfiguration config = configs[i];
            if (config.getGuid().equals(info.guid)) {
                info.existingConfig = config;
            }
            ++i;
        }
    }

    private void fixLibraryGuid(File path, String oldGuid, String newGuid) {
        if (!path.isDirectory()) {
            return;
        }
        File[] files = path.listFiles(new FileFilter(){

            public boolean accept(File f) {
                if (f.isDirectory()) {
                    return true;
                }
                String name = f.getName();
                return name.equals("library.xmi") || name.equals("plugin.xmi") || name.equals("model.xmi");
            }
        });
        if (files == null || files.length == 0) {
            return;
        }
        int i = 0;
        while (i < files.length) {
            if (files[i].isDirectory()) {
                this.fixLibraryGuid(files[i], oldGuid, newGuid);
            } else {
                try {
                    String source = FileUtil.readFile((File)files[i], (String)"UTF-8").toString();
                    if (source.indexOf(oldGuid) >= 0) {
                        source = source.replaceAll(oldGuid, newGuid);
                        FileUtil.writeUTF8File((String)files[i].getAbsolutePath(), (String)source);
                    }
                }
                catch (IOException e) {
                    ImportPlugin.getDefault().getLogger().logError((Throwable)e);
                }
            }
            ++i;
        }
    }

    private void merge(LibraryDocument targetLibDoc) throws Exception {
        this.importEntries(targetLibDoc);
        MethodLibrary lib = LibraryService.getInstance().getCurrentMethodLibrary();
        Resource res0 = lib.eResource();
        ResourceManager resMgr0 = MultiFileSaveUtil.getResourceManager((Resource)res0);
        ResourceSet resSet = res0.getResourceSet();
        this.mergePlugins(targetLibDoc, lib, resMgr0, resSet);
        this.mergeConfigs(targetLibDoc, lib, resMgr0, resSet);
        lib.eResource().setModified(true);
        IMethodLibraryPersister.FailSafeMethodLibraryPersister persister = ContentDescriptionFactory.getMethodLibraryPersister().getFailSafePersister();
        try {
            persister.save(lib.eResource());
            persister.commit();
        }
        catch (Exception e) {
            persister.rollback();
            e.printStackTrace();
        }
        LibraryService.getInstance().reopenCurrentMethodLibrary();
    }

    private void mergePlugins(LibraryDocument targetLibDoc, MethodLibrary lib, ResourceManager resMgr0, ResourceSet resSet) {
        ArrayList<String> existingPluginGuids = null;
        Iterator it = this.data.getPlugins().iterator();
        while (it.hasNext()) {
            PluginImportData.PluginInfo info = (PluginImportData.PluginInfo)it.next();
            if (!info.selected || info.existingPlugin == null) continue;
            if (existingPluginGuids == null) {
                existingPluginGuids = new ArrayList<String>();
            }
            existingPluginGuids.add(info.guid);
        }
        Map pgToRgMap = this.importingLibDoc.buildPluginGuidToResMgrGuidMap(existingPluginGuids);
        Iterator it2 = this.data.getPlugins().iterator();
        while (it2.hasNext()) {
            PluginImportData.PluginInfo info = (PluginImportData.PluginInfo)it2.next();
            if (info.selected && info.existingPlugin == null) {
                this.mergeElement(info.guid, targetLibDoc, lib, resMgr0, resSet, lib.getMethodPlugins());
                continue;
            }
            if (!info.selected || pgToRgMap == null) continue;
            Resource res = info.existingPlugin.eResource();
            ResourceManager resMgr = MultiFileSaveUtil.getResourceManager((Resource)res);
            String existingGuid = resMgr.getGuid();
            String importedGuid = (String)pgToRgMap.get(info.guid);
            if (importedGuid == null || importedGuid.equals(existingGuid)) continue;
            resMgr.setGuid(importedGuid);
        }
    }

    private void mergeConfigs(LibraryDocument targetLibDoc, MethodLibrary lib, ResourceManager resMgr0, ResourceSet resSet) {
        Iterator it = this.data.getConfigs().iterator();
        while (it.hasNext()) {
            PluginImportData.ConfiguarationInfo info = (PluginImportData.ConfiguarationInfo)it.next();
            if (!info.selected || info.existingConfig != null) continue;
            this.mergeElement(info.guid, targetLibDoc, lib, resMgr0, resSet, lib.getPredefinedConfigurations());
        }
    }

    private void mergeElement(String guid, LibraryDocument targetLibDoc, MethodLibrary lib, ResourceManager resMgr0, ResourceSet resSet, List elements) {
        String src_uri = this.importingLibDoc.getResourceUri(guid);
        if (src_uri == null || src_uri.length() == 0) {
            return;
        }
        File target_file = targetLibDoc.getFileFromUri(src_uri);
        String path = target_file.getAbsolutePath();
        URI uri = URI.createFileURI((String)path);
        Resource res = resSet.getResource(uri, true);
        MethodElement element = PersistenceUtil.getMethodElement((Resource)res);
        elements.add(element);
        MultiFileSaveUtil.registerWithResourceManager((ResourceManager)resMgr0, (Object)element, (URI)uri);
        ResourceManager resMgr = MultiFileSaveUtil.getResourceManager((Resource)res);
        if (resMgr != null) {
            resMgr0.getSubManagers().add(resMgr);
        }
    }

    private void buildConfigInfoFromFiles() {
        File importingLibPath = new File(String.valueOf(this.data.llData.getParentFolder()) + File.separator + "export.xmi");
        File configDir = new File(importingLibPath.getParent(), "configurations");
        LibraryDocument.ConfigDocVisitor visitor = new LibraryDocument.ConfigDocVisitor(){

            public void visit(File file, Element node) {
                PluginImportData.ConfiguarationInfo ci = PluginImportingService.this.data.new PluginImportData.ConfiguarationInfo();
                ci.guid = node.getAttribute("guid");
                ci.name = node.getAttribute("name");
                String uri = "configurations" + File.separator + file.getName();
                PluginImportingService.this.importingLibDoc.addToGuidToUriMap(ci.guid, uri);
                PluginImportingService.this.data.getConfigs().add(ci);
                PluginImportingService.this.loadExistingConfigInfo(ci);
                if (ci.existingConfig != null) {
                    URI resUri = ci.existingConfig.eResource().getURI();
                    uri = "configurations" + File.separator + resUri.lastSegment();
                    uri = PluginImportingService.this.targetLibDoc.decodeUri(uri);
                    PluginImportingService.this.targetLibDoc.addToGuidToUriMap(ci.guid, uri);
                }
            }
        };
        LibraryDocument.visitConfigFiles((File)configDir, (LibraryDocument.ConfigDocVisitor)visitor);
    }

    private void ensureUniqueNames(List elements) {
        Object info;
        Iterator it;
        if (elements.isEmpty()) {
            return;
        }
        HashMap<String, MethodElement> nameMap = new HashMap<String, MethodElement>();
        int i = 0;
        while (i < elements.size()) {
            MethodElement elem = (MethodElement)elements.get(i);
            nameMap.put(elem.getName(), elem);
            ++i;
        }
        ArrayList<String> importedList = new ArrayList<String>();
        ArrayList<Object> importedExistList = new ArrayList<Object>();
        if (elements.get(0) instanceof MethodPlugin) {
            it = this.data.getPlugins().iterator();
            while (it.hasNext()) {
                info = (PluginImportData.PluginInfo)it.next();
                if (!((PluginImportData.PluginInfo)info).selected || ((PluginImportData.PluginInfo)info).existingPlugin != null && ((PluginImportData.PluginInfo)info).existingPlugin.getName().equals(((PluginImportData.PluginInfo)info).name)) continue;
                importedList.add(((PluginImportData.PluginInfo)info).name);
                if (((PluginImportData.PluginInfo)info).existingPlugin == null) continue;
                importedExistList.add(info);
            }
        } else {
            it = this.data.getConfigs().iterator();
            while (it.hasNext()) {
                info = (PluginImportData.ConfiguarationInfo)it.next();
                if (!((PluginImportData.ConfiguarationInfo)info).selected || ((PluginImportData.ConfiguarationInfo)info).existingConfig != null && ((PluginImportData.ConfiguarationInfo)info).existingConfig.getName().equals(((PluginImportData.ConfiguarationInfo)info).name)) continue;
                importedList.add(((PluginImportData.ConfiguarationInfo)info).name);
                if (((PluginImportData.ConfiguarationInfo)info).existingConfig == null) continue;
                importedExistList.add(info);
            }
        }
        int i2 = 0;
        while (i2 < importedList.size()) {
            String name;
            String renamed = name = (String)importedList.get(i2);
            while (nameMap.containsKey(renamed)) {
                renamed = String.valueOf(renamed) + "_renamed";
            }
            if (renamed != name) {
                MethodElement elem = (MethodElement)nameMap.get(name);
                LibraryView.runRename((NamedElement)elem, (String)renamed);
            }
            ++i2;
        }
        i2 = 0;
        while (i2 < importedExistList.size()) {
            info = importedExistList.get(i2);
            MethodPlugin elem = info instanceof PluginImportData.PluginInfo ? ((PluginImportData.PluginInfo)info).existingPlugin : ((PluginImportData.ConfiguarationInfo)info).existingConfig;
            String newName = info instanceof PluginImportData.PluginInfo ? ((PluginImportData.PluginInfo)info).name : ((PluginImportData.ConfiguarationInfo)info).name;
            LibraryView.runRename((NamedElement)elem, (String)newName);
            ++i2;
        }
    }
}

