/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.configuration;

import java.util.List;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.epf.library.configuration.ConfigurationHelper;
import org.eclipse.epf.library.edit.IFilter;
import org.eclipse.epf.library.util.LibraryUtil;
import org.eclipse.epf.uma.MethodConfiguration;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.RoleDescriptor;
import org.eclipse.epf.uma.Task;
import org.eclipse.epf.uma.TaskDescriptor;
import org.eclipse.epf.uma.VariabilityElement;
import org.eclipse.epf.uma.WorkProductDescriptor;

public abstract class ElementRealizer {
    protected MethodConfiguration config;
    private boolean discardContributor = false;
    private boolean resolveContributor = true;
    private boolean resolveReplacer = true;
    protected IFilter filter = null;

    public ElementRealizer(MethodConfiguration config) {
        this(config, true, true);
    }

    public ElementRealizer(MethodConfiguration config, boolean resolveContributor, boolean resolveReplacer) {
        this.config = config;
        this.resolveContributor = resolveContributor;
        this.resolveReplacer = resolveReplacer;
    }

    public void setDiscardContributor(boolean discardContributor) {
        this.discardContributor = discardContributor;
    }

    public void setResolveContributor(boolean resolveContributor) {
        this.resolveContributor = resolveContributor;
    }

    public void setResolveReplacer(boolean resolveReplacer) {
        this.resolveReplacer = resolveReplacer;
    }

    public void setFilter(IFilter filter) {
        this.filter = filter;
    }

    public MethodConfiguration getConfiguration() {
        return this.config;
    }

    public MethodElement realize(MethodElement element) {
        if (element == null || !ConfigurationHelper.inConfig(element, this.config)) {
            return null;
        }
        Task linkedElement = null;
        if (element instanceof TaskDescriptor) {
            linkedElement = ((TaskDescriptor)element).getTask();
        } else if (element instanceof WorkProductDescriptor) {
            linkedElement = ((WorkProductDescriptor)element).getWorkProduct();
        } else if (element instanceof RoleDescriptor) {
            linkedElement = ((RoleDescriptor)element).getRole();
        }
        if (linkedElement != null && !ConfigurationHelper.inConfig((MethodElement)linkedElement, this.config)) {
            return null;
        }
        if (this.config == null) {
            return element;
        }
        if (element instanceof VariabilityElement) {
            VariabilityElement e;
            VariabilityElement ve = (VariabilityElement)element;
            if (this.discardContributor && ConfigurationHelper.isContributor(ve)) {
                return null;
            }
            if (this.resolveContributor) {
                while (ConfigurationHelper.isContributor(ve)) {
                    e = ve.getVariabilityBasedOnElement();
                    if (ConfigurationHelper.inConfig((MethodElement)e, this.config)) {
                        ve = e;
                        continue;
                    }
                    System.out.println("Configuration closure error: Base element '" + LibraryUtil.getTypeName((MethodElement)ve) + "' not in configuration");
                    break;
                }
            }
            if (this.resolveReplacer) {
                e = ConfigurationHelper.getReplacer(ve, this.config);
                if (e != null) {
                    return e;
                }
            } else if (!ConfigurationHelper.inConfig((MethodElement)ve, this.config)) {
                return null;
            }
            e = ve;
            while (e != null && ConfigurationHelper.isReplacer(e)) {
                if (!ConfigurationHelper.isContributor(e = e.getVariabilityBasedOnElement())) continue;
                return this.realize((MethodElement)e);
            }
            if (ConfigurationHelper.canShow((MethodElement)ve, this.config)) {
                return ve;
            }
            return null;
        }
        if (ConfigurationHelper.canShow(element, this.config)) {
            return element;
        }
        return null;
    }

    public abstract List realize(MethodElement var1, EStructuralFeature var2, List var3);
}

