/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.authoring.ui.actions;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.epf.authoring.ui.AuthoringUIPlugin;
import org.eclipse.epf.authoring.ui.AuthoringUIResources;
import org.eclipse.epf.authoring.ui.PerspectiveListUtil;
import org.eclipse.epf.authoring.ui.UIActionDispatcher;
import org.eclipse.epf.authoring.ui.editors.EditorChooser;
import org.eclipse.epf.authoring.ui.preferences.LibraryLocationData;
import org.eclipse.epf.authoring.ui.wizards.NewConfigurationWizard;
import org.eclipse.epf.library.LibraryService;
import org.eclipse.epf.library.edit.LibraryEditPlugin;
import org.eclipse.epf.library.edit.ui.UserInteractionHelper;
import org.eclipse.epf.uma.MethodConfiguration;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.MethodLibrary;
import org.eclipse.epf.uma.util.ContentDescriptionFactory;
import org.eclipse.epf.uma.util.IMethodLibraryPersister;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.eclipse.ui.PlatformUI;

public class NewConfigurationAction
extends Action
implements IWorkbenchWindowActionDelegate {
    public void init(IWorkbenchWindow window) {
    }

    public void run(IAction action) {
        Display.getCurrent().asyncExec(new Runnable(){

            public void run() {
                MethodLibrary targetLib = LibraryService.getInstance().getCurrentMethodLibrary();
                if (targetLib == null) {
                    AuthoringUIPlugin.getDefault().getMsgDialog().displayError(AuthoringUIResources.AuthoringUIPlugin_newConfigurationWizard_title, AuthoringUIResources.noOpenLibraryError_msg);
                    return;
                }
                Shell shell = Display.getCurrent().getActiveShell();
                IStatus status = UserInteractionHelper.checkModify((EObject)targetLib, (Shell)shell);
                if (!status.isOK()) {
                    AuthoringUIPlugin.getDefault().getMsgDialog().display(AuthoringUIResources.AuthoringUIPlugin_newConfigurationWizard_title, AuthoringUIResources.newConfigurationWirazd_createError, status);
                    return;
                }
                MethodConfiguration config = NewConfigurationAction.this.createConfiguration();
                if (config == null) {
                    return;
                }
                if (!PerspectiveListUtil.isAuthoringPerspective()) {
                    UIActionDispatcher.openAuthoringPerspective();
                }
                IMethodLibraryPersister.FailSafeMethodLibraryPersister persister = ContentDescriptionFactory.getMethodLibraryPersister().getFailSafePersister();
                try {
                    persister.save((MethodElement)config);
                }
                catch (Exception e) {
                    LibraryEditPlugin.getDefault().getLogger().logError((Throwable)e);
                }
                EditorChooser.getInstance().openEditor(config);
            }
        });
    }

    public void run() {
        this.run(null);
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }

    public void dispose() {
    }

    private MethodConfiguration createConfiguration() {
        LibraryLocationData llData;
        IWorkbenchPage activePage;
        MethodConfiguration config;
        block4: {
            config = null;
            activePage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
            llData = new LibraryLocationData();
            llData.setOkPressed(false);
            NewConfigurationWizard wizard = new NewConfigurationWizard(llData);
            WizardDialog dialog = new WizardDialog(Display.getCurrent().getActiveShell(), (IWizard)wizard);
            dialog.create();
            dialog.open();
            if (llData.isOkPressed()) break block4;
            return null;
        }
        try {
            String configName = llData.getLibName().trim();
            if (activePage != null && configName != null) {
                config = LibraryService.getInstance().createMethodConfiguration(configName, LibraryService.getInstance().getCurrentMethodLibrary());
                config.setBriefDescription(llData.getLibBriefDescription());
            }
        }
        catch (Exception e) {
            AuthoringUIPlugin.getDefault().getMsgDialog().displayError(AuthoringUIResources.AuthoringUIPlugin_newConfigurationWizard_title, AuthoringUIResources.internalError_msg, (Throwable)e);
        }
        return config;
    }
}

