/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.export.msp.ui.internal;

import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.epf.export.msp.ExportMSPPlugin;
import org.eclipse.epf.export.msp.ui.wizards.ExportOptionContribution;
import org.eclipse.epf.export.msp.ui.wizards.IExportMSPWizardExtender;

public class ExportMSPWizardExtensionManager {
    public static final String EXTENSION_POINT_NAMESPACE = "org.eclipse.epf.export.msp";
    public static final String EXTENSION_POINT_NAME = "exportMSPWizard";
    private IExportMSPWizardExtender wizardExtender;
    private static ExportMSPWizardExtensionManager instance = new ExportMSPWizardExtensionManager();

    private ExportMSPWizardExtensionManager() {
        this.processExtensionPoint();
    }

    public static ExportMSPWizardExtensionManager getInstance() {
        return instance;
    }

    protected void processExtensionPoint() {
        IExtensionRegistry extensionRegistry = Platform.getExtensionRegistry();
        IExtensionPoint extensionPoint = extensionRegistry.getExtensionPoint(EXTENSION_POINT_NAMESPACE, EXTENSION_POINT_NAME);
        if (extensionPoint != null) {
            IExtension[] extensions = extensionPoint.getExtensions();
            int i = 0;
            while (i < extensions.length) {
                IExtension extension = extensions[i];
                IConfigurationElement[] configElements = extension.getConfigurationElements();
                int j = 0;
                while (j < configElements.length) {
                    IConfigurationElement configElement = configElements[j];
                    try {
                        IExportMSPWizardExtender extender = (IExportMSPWizardExtender)configElement.createExecutableExtension("class");
                        if (this.wizardExtender == null) {
                            this.wizardExtender = extender;
                            IConfigurationElement[] childConfigElements = configElement.getChildren("exportOption");
                            int k = 0;
                            while (k < childConfigElements.length) {
                                IConfigurationElement childConfigElement = childConfigElements[k];
                                String name = childConfigElement.getAttribute("name");
                                String description = childConfigElement.getAttribute("description");
                                String defaultSelectionAttr = childConfigElement.getAttribute("defaultSelection");
                                boolean defaultSelection = Boolean.getBoolean(defaultSelectionAttr);
                                if (name != null && name.length() > 0 && description != null && description.length() > 0) {
                                    this.wizardExtender.addExportOptionContribution(new ExportOptionContribution(name, description, defaultSelection));
                                }
                                ++k;
                            }
                            return;
                        }
                    }
                    catch (Exception e) {
                        ExportMSPPlugin.getDefault().getLogger().logError((Throwable)e);
                    }
                    ++j;
                }
                ++i;
            }
        }
    }

    public IExportMSPWizardExtender getWizardExtender() {
        return this.wizardExtender;
    }
}

